/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.progress.util.RelayUiToDelegateIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceAlternativeResolveTracker;
import com.intellij.openapi.project.DumbServiceAppIconProgress;
import com.intellij.openapi.project.DumbServiceBalloon;
import com.intellij.openapi.project.DumbServiceGuiTaskQueue;
import com.intellij.openapi.project.DumbServiceHeavyActivities;
import com.intellij.openapi.project.DumbServiceMergingTaskQueue;
import com.intellij.openapi.project.DumbServiceSyncTaskQueue;
import com.intellij.openapi.project.DumbServiceVfsBatchListener;
import com.intellij.openapi.project.DumbUnawareHider;
import com.intellij.openapi.project.IndexingStatisticsCollector;
import com.intellij.openapi.project.NoAccessDuringPsiEvents;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.TrackedEdtActivityService;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.ui.DeprecationStripePanel;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public class DumbServiceImpl
extends DumbService
implements Disposable,
ModificationTracker,
DumbServiceBalloon.Service {
    private static final ExtensionPointName<StartupActivity.RequiredForSmartMode> REQUIRED_FOR_SMART_MODE_STARTUP_ACTIVITY = new ExtensionPointName("com.intellij.requiredForSmartModeStartupActivity");
    public static final boolean ALWAYS_SMART = SystemProperties.getBooleanProperty((String)"idea.no.dumb.mode", (boolean)false);
    private static final Logger LOG = Logger.getInstance(DumbServiceImpl.class);
    private final AtomicReference<State> myState;
    private volatile Throwable myDumbEnterTrace;
    private volatile Throwable myDumbStart;
    private final DumbService.DumbModeListener myPublisher;
    private long myModificationCount;
    private final Deque<Runnable> myRunWhenSmartQueue;
    private final Project myProject;
    private final TrackedEdtActivityService myTrackedEdtActivityService;
    private final DumbServiceMergingTaskQueue myTaskQueue;
    private final DumbServiceGuiTaskQueue myGuiDumbTaskRunner;
    private final DumbServiceSyncTaskQueue mySyncDumbTaskRunner;
    private final DumbServiceHeavyActivities myHeavyActivities;
    private final DumbServiceAlternativeResolveTracker myAlternativeResolveTracker;
    private final DumbServiceBalloon myBalloon;
    @Nullable
    private volatile Thread myWaitIntolerantThread;

    public DumbServiceImpl(@NotNull Project project) {
        if (project == null) {
            DumbServiceImpl.$$$reportNull$$$0(0);
        }
        this.myRunWhenSmartQueue = new ArrayDeque<Runnable>(5);
        this.myProject = project;
        this.myTrackedEdtActivityService = new TrackedEdtActivityService(project);
        this.myTaskQueue = new DumbServiceMergingTaskQueue();
        this.myGuiDumbTaskRunner = new DumbServiceGuiTaskQueue(this.myProject, this.myTaskQueue);
        this.mySyncDumbTaskRunner = new DumbServiceSyncTaskQueue(this.myTaskQueue);
        this.myPublisher = (DumbService.DumbModeListener)project.getMessageBus().syncPublisher(DUMB_MODE);
        this.myHeavyActivities = new DumbServiceHeavyActivities();
        new DumbServiceVfsBatchListener(this.myProject, this.myHeavyActivities);
        this.myBalloon = new DumbServiceBalloon(project, this);
        this.myAlternativeResolveTracker = new DumbServiceAlternativeResolveTracker();
        this.myState = new AtomicReference<State>(project.isDefault() ? State.SMART : State.WAITING_PROJECT_SMART_MODE_STARTUP_TASKS);
        project.getMessageBus().simpleConnect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                DumbServiceImpl.this.myRunWhenSmartQueue.removeIf(runnable2 -> {
                    ClassLoader classLoader;
                    if (runnable2 instanceof RunnableDelegate) {
                        runnable2 = ((RunnableDelegate)runnable2).task;
                    }
                    return (classLoader = runnable2.getClass().getClassLoader()) instanceof PluginAwareClassLoader && ((PluginAwareClassLoader)classLoader).getPluginId().equals((Object)pluginDescriptor.getPluginId());
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/openapi/project/DumbServiceImpl$1", "beforePluginUnload"));
            }
        });
    }

    void queueStartupActivitiesRequiredForSmartMode() {
        boolean changed2 = this.myState.compareAndSet(State.WAITING_PROJECT_SMART_MODE_STARTUP_TASKS, State.RUNNING_PROJECT_SMART_MODE_STARTUP_TASKS);
        LOG.assertTrue(changed2, (Object)("actual state: " + (Object)((Object)this.myState.get()) + ", project " + this.getProject()));
        List activities2 = REQUIRED_FOR_SMART_MODE_STARTUP_ACTIVITY.getExtensionList();
        if (activities2.isEmpty()) {
            this.myState.set(State.SMART);
        } else {
            for (StartupActivity.RequiredForSmartMode activity : activities2) {
                activity.runActivity(this.getProject());
            }
            if (DumbServiceImpl.isSynchronousTaskExecution()) {
                this.myState.set(State.SMART);
            }
        }
    }

    public static DumbServiceImpl getInstance(@NotNull Project project) {
        if (project == null) {
            DumbServiceImpl.$$$reportNull$$$0(1);
        }
        return (DumbServiceImpl)DumbService.getInstance((Project)project);
    }

    public void cancelTask(@NotNull DumbModeTask task2) {
        if (task2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(2);
        }
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("cancel " + task2);
        }
        this.myTaskQueue.cancelTask(task2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ApplicationManager.getApplication().assertIsWriteThread();
        this.myBalloon.dispose();
        Deque<Runnable> deque = this.myRunWhenSmartQueue;
        synchronized (deque) {
            this.myRunWhenSmartQueue.clear();
        }
        this.myTaskQueue.disposePendingTasks();
        this.myHeavyActivities.disposeSuspender();
    }

    public Project getProject() {
        return this.myProject;
    }

    public boolean isAlternativeResolveEnabled() {
        return this.myAlternativeResolveTracker.isAlternativeResolveEnabled();
    }

    public void suspendIndexingAndRun(@NotNull String activityName, @NotNull Runnable activity) {
        if (activityName == null) {
            DumbServiceImpl.$$$reportNull$$$0(3);
        }
        if (activity == null) {
            DumbServiceImpl.$$$reportNull$$$0(4);
        }
        this.myHeavyActivities.suspendIndexingAndRun(activityName, activity);
    }

    public boolean isSuspendedDumbMode() {
        boolean suspended = this.myHeavyActivities.isSuspended();
        return this.isDumb() && suspended;
    }

    public void setAlternativeResolveEnabled(boolean enabled) {
        this.myAlternativeResolveTracker.setAlternativeResolveEnabled(enabled);
    }

    public ModificationTracker getModificationTracker() {
        return this;
    }

    @Override
    public boolean isDumb() {
        if (ALWAYS_SMART) {
            return true;
        }
        if (!ApplicationManager.getApplication().isReadAccessAllowed() && Registry.is((String)"ide.check.is.dumb.contract")) {
            LOG.error("To avoid race conditions isDumb method should be used only under read action or in EDT thread.", (Throwable)new IllegalStateException());
        }
        return this.myState.get() != State.SMART;
    }

    @TestOnly
    public void setDumb(boolean dumb) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (dumb) {
            this.myState.set(State.RUNNING_DUMB_TASKS);
            this.myPublisher.enteredDumbMode();
        } else {
            this.myState.set(State.WAITING_FOR_FINISH);
            this.updateFinished();
        }
    }

    @TestOnly
    public void runInDumbMode(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(5);
        }
        this.setDumb(true);
        try {
            runnable2.run();
        }
        finally {
            this.setDumb(false);
        }
    }

    @Override
    public void runWhenSmart(@Async.Schedule @NotNull Runnable runnable2) {
        if (runnable2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(6);
        }
        StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> this.doUnsafeRunWhenSmart(runnable2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUnsafeRunWhenSmart(@NotNull Runnable runnable2) {
        Application app2;
        if (runnable2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(7);
        }
        if (!ALWAYS_SMART) {
            Deque<Runnable> deque = this.myRunWhenSmartQueue;
            synchronized (deque) {
                if (this.isDumb()) {
                    Runnable executor = ClientId.decorateRunnable((Runnable)runnable2);
                    this.myRunWhenSmartQueue.addLast(executor == runnable2 ? runnable2 : new RunnableDelegate(runnable2, it -> executor.run()));
                    return;
                }
            }
        }
        if ((app2 = ApplicationManager.getApplication()).isDispatchThread()) {
            runnable2.run();
        } else {
            app2.invokeLater(() -> this.doUnsafeRunWhenSmart(runnable2), ModalityState.NON_MODAL, this.myProject.getDisposed());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsafeRunWhenSmart(@NotNull @Async.Schedule Runnable runnable2) {
        Application app2;
        if (runnable2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(8);
        }
        if (!ALWAYS_SMART) {
            Deque<Runnable> deque = this.myRunWhenSmartQueue;
            synchronized (deque) {
                if (this.isDumb()) {
                    this.myRunWhenSmartQueue.addLast(ClientId.decorateRunnable((Runnable)runnable2));
                    return;
                }
            }
        }
        if ((app2 = ApplicationManager.getApplication()).isDispatchThread()) {
            runnable2.run();
        } else {
            app2.invokeLater(() -> this.unsafeRunWhenSmart(runnable2), ModalityState.NON_MODAL, this.myProject.getDisposed());
        }
    }

    public void queueTask(@NotNull DumbModeTask task2) {
        if (task2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(9);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduling task " + task2);
        }
        if (this.myProject.isDefault()) {
            LOG.error("No indexing tasks should be created for default project: " + task2);
        }
        if (DumbServiceImpl.isSynchronousTaskExecution()) {
            this.mySyncDumbTaskRunner.runTaskSynchronously(task2);
            return;
        }
        Throwable trace = new Throwable();
        ModalityState modality = ModalityState.defaultModalityState();
        Runnable runnable2 = () -> this.queueTaskOnEdt(task2, modality, trace);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable2.run();
        } else {
            this.myTrackedEdtActivityService.submitTransaction(runnable2);
        }
    }

    private void queueTaskOnEdt(@NotNull DumbModeTask task2, @NotNull ModalityState modality, @NotNull Throwable trace) {
        if (task2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(10);
        }
        if (modality == null) {
            DumbServiceImpl.$$$reportNull$$$0(11);
        }
        if (trace == null) {
            DumbServiceImpl.$$$reportNull$$$0(12);
        }
        this.myTaskQueue.addTask(task2);
        State state = this.myState.get();
        if (state == State.SMART || state == State.WAITING_FOR_FINISH || state == State.RUNNING_PROJECT_SMART_MODE_STARTUP_TASKS) {
            this.enterDumbMode(modality, trace);
            this.myTrackedEdtActivityService.invokeLaterIfProjectNotDisposed(this::startBackgroundProcess);
        }
    }

    private void enterDumbMode(@NotNull ModalityState modality, @NotNull Throwable trace) {
        if (modality == null) {
            DumbServiceImpl.$$$reportNull$$$0(13);
        }
        if (trace == null) {
            DumbServiceImpl.$$$reportNull$$$0(14);
        }
        boolean wasSmart = !this.isDumb();
        WriteAction.run(() -> {
            Deque<Runnable> deque = this.myRunWhenSmartQueue;
            synchronized (deque) {
                this.myState.set(State.SCHEDULED_TASKS);
            }
            this.myDumbStart = trace;
            this.myDumbEnterTrace = new Throwable();
            this.myTrackedEdtActivityService.setDumbStartModality(modality);
            ++this.myModificationCount;
        });
        if (wasSmart) {
            try {
                this.myPublisher.enteredDumbMode();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    private void queueUpdateFinished() {
        if (this.myState.compareAndSet(State.RUNNING_DUMB_TASKS, State.WAITING_FOR_FINISH)) {
            this.myHeavyActivities.resetCurrentSuspender();
            this.myTrackedEdtActivityService.invokeLaterAfterProjectInitialized(this::updateFinished);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean switchToSmartMode() {
        Deque<Runnable> deque = this.myRunWhenSmartQueue;
        synchronized (deque) {
            if (!this.myState.compareAndSet(State.WAITING_FOR_FINISH, State.SMART)) {
                return false;
            }
        }
        this.myDumbEnterTrace = null;
        this.myDumbStart = null;
        ++this.myModificationCount;
        return !this.myProject.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFinished() {
        if (!((Boolean)WriteAction.compute(this::switchToSmartMode)).booleanValue()) {
            return;
        }
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("updateFinished");
        }
        try {
            this.myPublisher.exitDumbMode();
            FileEditorManagerEx.getInstanceEx(this.myProject).refreshIcons();
        }
        finally {
            while (!this.isDumb()) {
                Runnable runnable2;
                Deque<Runnable> deque = this.myRunWhenSmartQueue;
                synchronized (deque) {
                    runnable2 = this.myRunWhenSmartQueue.pollFirst();
                    if (runnable2 == null) {
                        break;
                    }
                }
                DumbServiceImpl.doRun(runnable2);
            }
        }
    }

    private static void doRun(@Async.Execute Runnable runnable2) {
        try {
            runnable2.run();
        }
        catch (ProcessCanceledException e) {
            LOG.error("Task canceled: " + runnable2, new Attachment[]{new Attachment("pce", (Throwable)e)});
        }
        catch (Throwable e) {
            LOG.error("Error executing task " + runnable2, e);
        }
    }

    public void showDumbModeNotification(@NotNull @NlsContexts.PopupContent String message2) {
        if (message2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(15);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            StatusBarEx statusBar2;
            IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(this.myProject);
            if (ideFrame != null && (statusBar2 = (StatusBarEx)ideFrame.getStatusBar()) != null) {
                statusBar2.notifyProgressByBalloon(MessageType.WARNING, message2);
            }
        });
    }

    public void showDumbModeActionBalloon(@NotNull @NlsContexts.PopupContent String balloonText, @NotNull Runnable runWhenSmartAndBalloonStillShowing) {
        if (balloonText == null) {
            DumbServiceImpl.$$$reportNull$$$0(16);
        }
        if (runWhenSmartAndBalloonStillShowing == null) {
            DumbServiceImpl.$$$reportNull$$$0(17);
        }
        this.myBalloon.showDumbModeActionBalloon(balloonText, runWhenSmartAndBalloonStillShowing);
    }

    public void cancelAllTasksAndWait() {
        Application application = ApplicationManager.getApplication();
        if (!application.isWriteThread() || application.isWriteAccessAllowed()) {
            throw new AssertionError((Object)"Must be called on write thread without write action");
        }
        while (this.myState.get() != State.SMART && this.myState.get() != State.WAITING_PROJECT_SMART_MODE_STARTUP_TASKS && !this.myProject.isDisposed()) {
            PingProgress.interactWithEdtProgress();
            LockSupport.parkNanos(50000000L);
            this.myTrackedEdtActivityService.executeAllQueuedActivities();
            this.myTaskQueue.cancelAllTasks();
            this.myHeavyActivities.resumeProgressIfPossible();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSmartMode() {
        CountDownLatch switched;
        if (ALWAYS_SMART) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed() || application.isDispatchThread()) {
            throw new AssertionError((Object)"Don't invoke waitForSmartMode from inside read action in dumb mode");
        }
        if (this.myWaitIntolerantThread == Thread.currentThread()) {
            throw new AssertionError((Object)"Don't invoke waitForSmartMode from a background startup activity");
        }
        Deque<Runnable> deque = this.myRunWhenSmartQueue;
        synchronized (deque) {
            if (!this.isDumb()) {
                return;
            }
            switched = new CountDownLatch(1);
            this.myRunWhenSmartQueue.addLast(() -> switched.countDown());
        }
        while (this.myState.get() != State.SMART && !this.myProject.isDisposed()) {
            try {
                switched.await(50L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ProgressManager.checkCanceled();
        }
    }

    public JComponent wrapGently(@NotNull JComponent dumbUnawareContent, @NotNull Disposable parentDisposable) {
        if (dumbUnawareContent == null) {
            DumbServiceImpl.$$$reportNull$$$0(18);
        }
        if (parentDisposable == null) {
            DumbServiceImpl.$$$reportNull$$$0(19);
        }
        final DumbUnawareHider wrapper2 = new DumbUnawareHider(dumbUnawareContent);
        wrapper2.setContentVisible(!this.isDumb());
        this.getProject().getMessageBus().connect(parentDisposable).subscribe(DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                wrapper2.setContentVisible(false);
            }

            public void exitDumbMode() {
                wrapper2.setContentVisible(true);
            }
        });
        return wrapper2;
    }

    public JComponent wrapWithSpoiler(@NotNull JComponent dumbAwareContent, final @NotNull Runnable updateRunnable, @NotNull Disposable parentDisposable) {
        if (dumbAwareContent == null) {
            DumbServiceImpl.$$$reportNull$$$0(20);
        }
        if (updateRunnable == null) {
            DumbServiceImpl.$$$reportNull$$$0(21);
        }
        if (parentDisposable == null) {
            DumbServiceImpl.$$$reportNull$$$0(22);
        }
        final DeprecationStripePanel stripePanel = new DeprecationStripePanel(IdeBundle.message((String)"dumb.mode.results.might.be.incomplete", (Object[])new Object[0]), AllIcons.General.Warning).withAlternativeAction(IdeBundle.message((String)"dumb.mode.spoiler.wrapper.reload.text", (Object[])new Object[0]), (AnAction)new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                updateRunnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/project/DumbServiceImpl$3", "actionPerformed"));
            }
        });
        stripePanel.setVisible(this.isDumb());
        this.getProject().getMessageBus().connect(parentDisposable).subscribe(DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                stripePanel.setVisible(true);
                updateRunnable.run();
            }

            public void exitDumbMode() {
                stripePanel.setVisible(false);
                updateRunnable.run();
            }
        });
        return stripePanel.wrap(dumbAwareContent);
    }

    public void smartInvokeLater(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(23);
        }
        this.smartInvokeLater(runnable2, ModalityState.defaultModalityState());
    }

    public void smartInvokeLater(@NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        if (runnable2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(24);
        }
        if (modalityState == null) {
            DumbServiceImpl.$$$reportNull$$$0(25);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isDumb()) {
                this.runWhenSmart(() -> this.smartInvokeLater(runnable2, modalityState));
            } else {
                runnable2.run();
            }
        }, modalityState, this.myProject.getDisposed());
    }

    public void completeJustSubmittedTasks() {
        ApplicationManager.getApplication().assertIsWriteThread();
        assert (this.myProject.isInitialized());
        if (this.myState.get() != State.SCHEDULED_TASKS) {
            return;
        }
        while (this.isDumb()) {
            this.assertState(State.SCHEDULED_TASKS);
            this.showModalProgress();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void showModalProgress() {
        NoAccessDuringPsiEvents.checkCallContext("modal indexing");
        try {
            ((ApplicationImpl)ApplicationManager.getApplication()).executeSuspendingWriteAction(this.myProject, IndexingBundle.message((String)"progress.indexing.title", (Object[])new Object[0]), () -> {
                this.assertState(State.SCHEDULED_TASKS);
                this.runBackgroundProcess(ProgressManager.getInstance().getProgressIndicator());
                this.assertState(State.SMART, State.WAITING_FOR_FINISH);
            });
            this.assertState(State.SMART, State.WAITING_FOR_FINISH);
            if (this.myState.get() == State.SMART) return;
        }
        catch (Throwable throwable) {
            if (this.myState.get() == State.SMART) throw throwable;
            this.assertState(State.WAITING_FOR_FINISH);
            this.updateFinished();
            this.assertState(State.SMART, State.SCHEDULED_TASKS);
            throw throwable;
        }
        this.assertState(State.WAITING_FOR_FINISH);
        this.updateFinished();
        this.assertState(State.SMART, State.SCHEDULED_TASKS);
    }

    private void assertState(State ... expected) {
        State state = this.myState.get();
        List<State> expectedList = Arrays.asList(expected);
        if (!expectedList.contains((Object)state)) {
            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
            if (this.myDumbEnterTrace != null) {
                attachments.add(new Attachment("indexingStart", this.myDumbEnterTrace));
            }
            attachments.add(new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString()));
            throw new RuntimeExceptionWithAttachments("Internal error, please include thread dump attachment. Expected " + expectedList + ", but was " + state.toString(), attachments.toArray(Attachment.EMPTY_ARRAY));
        }
    }

    private void startBackgroundProcess() {
        try {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, IndexingBundle.message((String)"progress.indexing", (Object[])new Object[0]), false){

                public void run(@NotNull ProgressIndicator visibleIndicator) {
                    if (visibleIndicator == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    DumbServiceImpl.this.runBackgroundProcess(visibleIndicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleIndicator", "com/intellij/openapi/project/DumbServiceImpl$5", "run"));
                }
            });
        }
        catch (Throwable e) {
            this.queueUpdateFinished();
            LOG.error("Failed to start background index update task", e);
        }
    }

    private void runBackgroundProcess(@NotNull ProgressIndicator visibleIndicator) {
        if (visibleIndicator == null) {
            DumbServiceImpl.$$$reportNull$$$0(26);
        }
        ((ProgressManagerImpl)ProgressManager.getInstance()).markProgressSafe((UserDataHolder)visibleIndicator);
        if (!this.myState.compareAndSet(State.SCHEDULED_TASKS, State.RUNNING_DUMB_TASKS)) {
            return;
        }
        try (ProgressSuspender suspender = ProgressSuspender.markSuspendable(visibleIndicator, IdeBundle.message((String)"progress.text.indexing.paused", (Object[])new Object[0]));){
            this.myHeavyActivities.setCurrentSuspenderAndSuspendIfRequested(suspender);
            StructuredIdeActivity activity = IndexingStatisticsCollector.INDEXING_ACTIVITY.started(this.myProject);
            ShutDownTracker.getInstance().executeWithStopperThread(Thread.currentThread(), () -> {
                try {
                    DumbServiceAppIconProgress.registerForProgress(this.myProject, (ProgressIndicatorEx)visibleIndicator);
                    RelayUiToDelegateIndicator relayToVisibleIndicator = new RelayUiToDelegateIndicator(visibleIndicator);
                    this.myGuiDumbTaskRunner.processTasksWithProgress(activity, taskIndicator -> {
                        suspender.attachToProgress((ProgressIndicatorEx)taskIndicator);
                        taskIndicator.addStateDelegate(relayToVisibleIndicator);
                    }, taskIndicator -> ((AbstractProgressIndicatorExBase)taskIndicator).removeStateDelegate(relayToVisibleIndicator));
                }
                catch (Throwable unexpected) {
                    LOG.error(unexpected);
                }
                finally {
                    this.myHeavyActivities.resetCurrentSuspender();
                    this.queueUpdateFinished();
                    activity.finished();
                }
            });
        }
    }

    public void runWithWaitForSmartModeDisabled(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(27);
        }
        try {
            this.myWaitIntolerantThread = Thread.currentThread();
            runnable2.run();
        }
        finally {
            this.myWaitIntolerantThread = null;
        }
    }

    public long getModificationCount() {
        return this.myModificationCount;
    }

    @Nullable
    public Throwable getDumbModeStartTrace() {
        return this.myDumbStart;
    }

    private static boolean isSynchronousTaskExecution() {
        Application application = ApplicationManager.getApplication();
        return (application.isUnitTestMode() || application.isHeadlessEnvironment()) && !Boolean.parseBoolean(System.getProperty("idea.force.dumb.queue.tasks", "false"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 23: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "balloonText";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runWhenSmartAndBalloonStillShowing";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumbUnawareContent";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumbAwareContent";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateRunnable";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleIndicator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/project/DumbServiceImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "suspendIndexingAndRun";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "runInDumbMode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "runWhenSmart";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doUnsafeRunWhenSmart";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "unsafeRunWhenSmart";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "queueTask";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "queueTaskOnEdt";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "enterDumbMode";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "showDumbModeNotification";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "showDumbModeActionBalloon";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapGently";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapWithSpoiler";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "smartInvokeLater";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "runBackgroundProcess";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "runWithWaitForSmartModeDisabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum State {
        SMART,
        SCHEDULED_TASKS,
        RUNNING_DUMB_TASKS,
        WAITING_FOR_FINISH,
        WAITING_PROJECT_SMART_MODE_STARTUP_TASKS,
        RUNNING_PROJECT_SMART_MODE_STARTUP_TASKS;

    }

    private static final class RunnableDelegate
    implements Runnable {
        final Runnable task;
        @NotNull
        private final Consumer<? super Runnable> executor;

        private RunnableDelegate(@NotNull Runnable task2, @NotNull Consumer<? super Runnable> executor) {
            if (task2 == null) {
                RunnableDelegate.$$$reportNull$$$0(0);
            }
            if (executor == null) {
                RunnableDelegate.$$$reportNull$$$0(1);
            }
            this.task = task2;
            this.executor = executor;
        }

        @Override
        public void run() {
            this.executor.accept(this.task);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "task";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "executor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/project/DumbServiceImpl$RunnableDelegate";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

