/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.messages;

import com.intellij.BundleBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.mac.touchbar.Touchbar;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.EditorKit;
import javax.swing.text.View;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001LBk\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0013J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\fH\u0002J\u0013\u00103\u001a\b\u0012\u0004\u0012\u0002040\nH\u0014\u00a2\u0006\u0002\u00105J\b\u00106\u001a\u00020\u001bH\u0014J\b\u00107\u001a\u000208H\u0014J\n\u00109\u001a\u0004\u0018\u00010\u001bH\u0014J\u0010\u0010:\u001a\u00020\u00162\u0006\u0010;\u001a\u00020<H\u0014J\u0010\u0010=\u001a\u00020\u00162\u0006\u0010>\u001a\u000204H\u0014J\b\u0010?\u001a\u00020@H\u0014J\u001f\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020B2\r\u0010D\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\bEH\u0002J\b\u0010F\u001a\u000201H\u0016J\n\u0010G\u001a\u0004\u0018\u00010\u0007H\u0014J\b\u0010H\u001a\u00020IH\u0016J\n\u0010J\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010K\u001a\u00020%H\u0016R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010!R\u0010\u0010'\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\n\n\u0002\u0010*\u001a\u0004\b(\u0010)R\u0012\u0010+\u001a\u00060,R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010!R\u0010\u0010/\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/intellij/openapi/ui/messages/AlertDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "myMessage", "", "myTitle", "myOptions", "", "myDefaultOptionIndex", "", "myFocusedOptionIndex", "icon", "Ljavax/swing/Icon;", "doNotAskOption", "Lcom/intellij/openapi/ui/DoNotAskOption;", "myHelpId", "(Lcom/intellij/openapi/project/Project;Ljava/awt/Component;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;IILjavax/swing/Icon;Lcom/intellij/openapi/ui/DoNotAskOption;Ljava/lang/String;)V", "myButtons", "Ljava/util/ArrayList;", "Ljavax/swing/JButton;", "Lkotlin/collections/ArrayList;", "myButtonsPanel", "Ljavax/swing/JPanel;", "myCloseButton", "Ljavax/swing/JComponent;", "getMyDefaultOptionIndex", "()I", "getMyFocusedOptionIndex", "myHelpButton", "getMyHelpId", "()Ljava/lang/String;", "myIconComponent", "Ljavax/swing/JLabel;", "myIsTitleComponent", "", "getMyMessage", "myMessageComponent", "getMyOptions", "()[Ljava/lang/String;", "[Ljava/lang/String;", "myRootLayout", "Lcom/intellij/openapi/ui/messages/AlertDialog$RootLayout;", "mySouthPanel", "getMyTitle", "myTitleComponent", "configureMessageWidth", "", "width", "createActions", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "createContentPaneBorder", "Ljavax/swing/border/Border;", "createDoNotAskCheckbox", "createHelpButton", "insets", "Ljava/awt/Insets;", "createJButtonForAction", "action", "createRootLayout", "Ljava/awt/LayoutManager;", "createTextComponent", "Ljavax/swing/JTextPane;", "component", "message", "Lorg/jetbrains/annotations/Nls;", "doCancelAction", "getHelpId", "getInitialSize", "Ljava/awt/Dimension;", "getPreferredFocusedComponent", "toBeShown", "RootLayout", "intellij.platform.ide.impl"})
final class AlertDialog
extends DialogWrapper {
    private final boolean myIsTitleComponent;
    private final RootLayout myRootLayout;
    private final JLabel myIconComponent;
    private JComponent myTitleComponent;
    private JComponent myMessageComponent;
    private final JPanel mySouthPanel;
    private final JPanel myButtonsPanel;
    private final JComponent myCloseButton;
    private final ArrayList<JButton> myButtons;
    private JButton myHelpButton;
    @Nullable
    private final String myMessage;
    @Nullable
    private final String myTitle;
    @NotNull
    private final String[] myOptions;
    private final int myDefaultOptionIndex;
    private final int myFocusedOptionIndex;
    @Nullable
    private final String myHelpId;

    @NotNull
    public Dimension getInitialSize() {
        int buttonsWidth = this.myButtonsPanel.getPreferredSize().width;
        if (buttonsWidth > JBUI.scale((int)348)) {
            int n = JBUI.scale((int)450);
            boolean bl = false;
            this.configureMessageWidth(Math.min(buttonsWidth, n));
            Dimension dimension = this.getPreferredSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"preferredSize");
            return dimension;
        }
        int width = JBUI.scale((int)(buttonsWidth <= JBUI.scale((int)278) && StringUtil.length((CharSequence)this.myMessage) <= 130 ? 370 : 440));
        this.configureMessageWidth(width - this.myRootLayout.getWidthWithoutMessageComponent());
        return new Dimension(width, this.getPreferredSize().height);
    }

    private final void configureMessageWidth(int width) {
        JScrollPane scrollPane = ComponentUtil.getScrollPane((Component)this.myMessageComponent);
        if (scrollPane == null) {
            JComponent jComponent = this.myMessageComponent;
            Intrinsics.checkNotNull((Object)jComponent);
            jComponent.putClientProperty("parent.width", width);
        } else {
            scrollPane.setPreferredSize(new Dimension(width, scrollPane.getPreferredSize().height));
        }
    }

    @NotNull
    protected Border createContentPaneBorder() {
        Insets insets = new JButton().getInsets();
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)(this.myIsTitleComponent ? 20 : 14), (int)20, (int)(18 - insets.bottom), (int)(20 - insets.right));
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"JBUI.Borders.empty(if (m\u2026ottom, 20 - insets.right)");
        return (Border)jBEmptyBorder;
    }

    @NotNull
    protected LayoutManager createRootLayout() {
        return this.myRootLayout;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    protected JComponent createCenterPanel() {
        dialogPanel = new JPanel(new BorderLayout(JBUI.scale((int)20), 0));
        iconPanel = new JPanel(new BorderLayout());
        iconPanel.add((Component)this.myIconComponent, "North");
        dialogPanel.add((Component)iconPanel, "West");
        textPanel = new JPanel(new BorderLayout(0, JBUI.scale((int)8)));
        dialogPanel.add(textPanel);
        if (this.myIsTitleComponent && !StringUtil.isEmpty((String)this.myTitle)) {
            v0 = this.myTitle;
            Intrinsics.checkNotNull((Object)v0);
            v1 = UIUtil.replaceMnemonicAmpersand((String)v0);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"UIUtil.replaceMnemonicAmpersand(myTitle!!)");
            v2 = BundleBase.MNEMONIC_STRING;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"BundleBase.MNEMONIC_STRING");
            title = StringsKt.replace$default((String)v1, (String)v2, (String)"", (boolean)false, (int)4, null);
            titleComponent = this.createTextComponent(new JTextPane(), title);
            titleComponent.setFont((Font)JBFont.h4());
            this.myTitleComponent = (JComponent)titleComponent;
            textPanel.add((Component)titleComponent, "North");
        }
        if (!StringUtil.isEmpty((String)this.myMessage)) {
            v3 = new JTextPane(){

                @NotNull
                public Dimension getPreferredSize() {
                    Object parentWidth = this.getClientProperty("parent.width");
                    if (parentWidth instanceof Integer) {
                        View view = this.getUI().getRootView(this);
                        view.setSize(((Number)parentWidth).intValue(), Integer.MAX_VALUE);
                        return new Dimension(((Number)parentWidth).intValue(), (int)view.getPreferredSpan(1));
                    }
                    Dimension dimension = super.getPreferredSize();
                    Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"super.getPreferredSize()");
                    return dimension;
                }
            };
            v4 = this.myMessage;
            Intrinsics.checkNotNull((Object)v4);
            titleComponent = v4;
            var6_7 = "(\r\n|\n)";
            var7_10 = false;
            var6_7 = new Regex(var6_7);
            var7_11 = "<br/>";
            var8_13 = false;
            messageComponent = this.createTextComponent(v3, var6_7.replace((CharSequence)titleComponent, var7_11));
            messageComponent.setFont((Font)JBFont.regular());
            this.myMessageComponent = messageComponent;
            lines = this.myMessage.length() / 100;
            v5 = Messages.wrapToScrollPaneIfNeeded((JComponent)messageComponent, (int)100, (int)15, (int)(lines < 4 ? 4 : lines));
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"Messages.wrapToScrollPan\u2026(lines < 4) 4 else lines)");
            scrollPane = v5;
            if (scrollPane instanceof JScrollPane) {
                ((JScrollPane)scrollPane).setOpaque(false);
                v6 = ((JScrollPane)scrollPane).getViewport();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"scrollPane.viewport");
                v6.setOpaque(false);
            }
            textPanel.add((Component)new Wrapper(scrollPane, scrollPane){
                final /* synthetic */ JComponent $scrollPane;

                public void setBounds(int x, int y, int width, int height) {
                    int n = JBUI.scale((int)450);
                    boolean bl = false;
                    super.setBounds(x, y, Math.min(width, n), height);
                }
                {
                    this.$scrollPane = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            });
        }
        textPanel.add((Component)this.mySouthPanel, "South");
        this.createSouthPanel();
        if (this.myButtons.size() > 0) {
            v7 = this.myButtons.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"myButtons[0]");
            v8 = v7.getInsets();
        } else {
            v8 = buttonInsets = new Insets(0, 0, 0, 0);
        }
        if (this.myCheckBoxDoNotShowDialog == null) ** GOTO lbl-1000
        v9 = this.myCheckBoxDoNotShowDialog;
        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"myCheckBoxDoNotShowDialog");
        if (!v9.isVisible()) lbl-1000:
        // 2 sources

        {
            this.myButtonsPanel.setBorder((Border)JBUI.Borders.emptyTop((int)(14 - buttonInsets.top)));
        } else {
            v10 = this.myCheckBoxDoNotShowDialog;
            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"myCheckBoxDoNotShowDialog");
            v10.setFont((Font)JBFont.regular());
            wrapper = new Wrapper((JComponent)this.myCheckBoxDoNotShowDialog);
            v11 = this.myCheckBoxDoNotShowDialog;
            Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"myCheckBoxDoNotShowDialog");
            checkBoxLeftOffset = v11.getInsets().left;
            wrapper.setBorder((Border)JBUI.Borders.emptyTop((int)4));
            for (Component child : UIUtil.uiChildren((Component)textPanel)) {
                if (!(Intrinsics.areEqual((Object)child, (Object)this.mySouthPanel) ^ true)) continue;
                v12 = child;
                if (v12 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type javax.swing.JComponent");
                }
                ((JComponent)v12).setBorder((Border)JBUI.Borders.emptyLeft((int)checkBoxLeftOffset));
            }
            v13 = dialogPanel.getLayout();
            if (v13 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.awt.BorderLayout");
            }
            v14 = (BorderLayout)v13;
            v14.setHgap(v14.getHgap() - checkBoxLeftOffset);
            v15 = this.mySouthPanel.getLayout();
            if (v15 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.awt.BorderLayout");
            }
            ((BorderLayout)v15).setVgap(JBUI.scale((int)(22 - buttonInsets.top)));
            this.mySouthPanel.add((Component)wrapper, "North");
        }
        this.myButtonsPanel.setLayout((LayoutManager)new HorizontalLayout(JBUI.scale((int)(12 - buttonInsets.left - buttonInsets.right))));
        checkBoxLeftOffset = this.myButtons.iterator();
        while (checkBoxLeftOffset.hasNext()) {
            v16 = button = checkBoxLeftOffset.next();
            Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"button");
            v16.getParent().remove(button);
            this.myButtonsPanel.add((Component)button, "RIGHT");
        }
        if (SystemInfoRt.isMac) {
            block15: {
                v17 = this.getButtonMap();
                Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"buttonMap");
                buttonMap = v17;
                buttonMap.clear();
                $this$forEach$iv = this.myButtons;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (JButton)element$iv;
                    $i$a$-forEach-AlertDialog$createCenterPanel$2 = false;
                    buttonMap.put(it.getAction(), it);
                }
                var6_9 = this.myButtons;
                var16_21 = this.myButtons;
                var15_22 = null;
                var14_23 = this.myButtonsPanel;
                var7_12 = false;
                var8_15 = var6_9;
                var9_17 = false;
                var10_18 = var8_15.iterator();
                while (var10_18.hasNext()) {
                    var11_20 = var10_18.next();
                    b = (JButton)var11_20;
                    $i$a$-find-AlertDialog$createCenterPanel$3 = false;
                    if (!(b.getAction().getValue("DefaultAction") != null)) continue;
                    v18 = var11_20;
                    break block15;
                }
                v18 = null;
            }
            var17_26 = v18;
            Touchbar.setButtonActions((JComponent)var14_23, var15_22, (Collection)var16_21, (JButton)var17_26);
        }
        this.mySouthPanel.add(this.myButtonsPanel);
        return dialogPanel;
    }

    private final JTextPane createTextComponent(JTextPane component2, String message2) {
        component2.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        component2.setContentType("text/html");
        component2.setOpaque(false);
        component2.setFocusable(false);
        component2.setBorder(null);
        UIUtil.JBWordWrapHtmlEditorKit kit = new UIUtil.JBWordWrapHtmlEditorKit();
        kit.getStyleSheet().addRule("a {color: " + ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED) + "}");
        component2.setEditorKit((EditorKit)kit);
        component2.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        if (BasicHTML.isHTMLString(message2)) {
            String string = message2;
            Intrinsics.checkNotNull((Object)string);
            component2.putClientProperty("AccessibleName", StringUtil.unescapeXmlEntities((String)StringUtil.stripHtml((String)string, (String)" ")));
        }
        component2.setText(message2);
        component2.setEditable(false);
        if (component2.getCaret() != null) {
            component2.setCaretPosition(0);
        }
        return component2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Action[] createActions() {
        List actions2 = new ArrayList();
        int n = 0;
        int n2 = this.myOptions.length;
        while (n < n2) {
            void i2;
            String option2 = this.myOptions[i2];
            Action action2 = new AbstractAction(this, (int)i2, option2, UIUtil.replaceMnemonicAmpersand((String)option2)){
                final /* synthetic */ AlertDialog this$0;
                final /* synthetic */ int $i;
                final /* synthetic */ String $option;

                public void actionPerformed(@NotNull ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.this$0.close(this.$i, true);
                }
                {
                    this.this$0 = this$0;
                    this.$i = $captured_local_variable$1;
                    this.$option = $captured_local_variable$2;
                    super($super_call_param$3);
                }
            };
            if (i2 == this.myDefaultOptionIndex) {
                action2.putValue("DefaultAction", Boolean.TRUE);
            }
            if (i2 == this.myFocusedOptionIndex) {
                action2.putValue("FocusedAction", Boolean.TRUE);
            }
            UIUtil.assignMnemonic((String)option2, (Action)action2);
            actions2.add(action2);
            ++i2;
        }
        if (this.getHelpId() != null) {
            Action action3 = this.getHelpAction();
            Intrinsics.checkNotNullExpressionValue((Object)action3, (String)"helpAction");
            actions2.add(action3);
        }
        Collection $this$toTypedArray$iv = actions2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Action[] actionArray = thisCollection$iv.toArray(new Action[0]);
        if (actionArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return actionArray;
    }

    @NotNull
    protected JButton createJButtonForAction(@NotNull Action action2) {
        JButton button4;
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        JButton jButton = button4 = super.createJButtonForAction(action2);
        Intrinsics.checkNotNullExpressionValue((Object)jButton, (String)"button");
        Dimension size = jButton.getPreferredSize();
        Insets insets = button4.getInsets();
        int width = JBUI.scale((int)72) + insets.left + insets.right;
        if (size.width < width) {
            size.width = width;
        } else {
            int diffWidth = JBUI.scale((int)20) - UIUtil.getButtonTextHorizontalOffset((AbstractButton)button4, (Dimension)size, null);
            if (diffWidth > 0) {
                size.width += 2 * diffWidth;
            }
        }
        int height = JBUI.scale((int)24) + insets.top + insets.bottom;
        if (size.height < height) {
            size.height = height;
        }
        button4.setPreferredSize(size);
        if (SystemInfoRt.isMac) {
            this.myButtons.add(0, button4);
        } else {
            this.myButtons.add(button4);
        }
        return button4;
    }

    @Nullable
    protected JComponent createDoNotAskCheckbox() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (!SystemInfoRt.isMac) {
            return null;
        }
        if (this.myPreferredFocusedComponent != null) {
            return this.myPreferredFocusedComponent;
        }
        int size = this.myButtons.size();
        if (size > 0) {
            ArrayList<JButton> arrayList;
            boolean bl;
            if (SystemInfoRt.isMac) {
                ArrayList arrayList2 = new ArrayList(this.myButtons);
                bl = false;
                boolean bl2 = false;
                ArrayList it = arrayList2;
                boolean bl3 = false;
                CollectionsKt.reverse((List)it);
                arrayList = arrayList2;
            } else {
                arrayList = this.myButtons;
            }
            ArrayList<JButton> buttons = arrayList;
            String cancelButton = Messages.getCancelButton();
            bl = false;
            for (JButton button4 : (Iterable)buttons) {
                void index2;
                if (index2 != this.myDefaultOptionIndex && (size < 3 || Intrinsics.areEqual((Object)cancelButton, (Object)button4.getText()) ^ true)) {
                    return button4;
                }
                ++index2;
            }
        }
        return null;
    }

    public void doCancelAction() {
        this.close(-1);
    }

    @NotNull
    protected JButton createHelpButton(@NotNull Insets insets) {
        JButton helpButton2;
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        JButton jButton = super.createHelpButton(insets);
        Intrinsics.checkNotNullExpressionValue((Object)jButton, (String)"super.createHelpButton(insets)");
        this.myHelpButton = helpButton2 = jButton;
        return helpButton2;
    }

    @Nullable
    protected String getHelpId() {
        return this.myHelpId;
    }

    public boolean toBeShown() {
        return super.toBeShown();
    }

    @Nullable
    public final String getMyMessage() {
        return this.myMessage;
    }

    @Nullable
    public final String getMyTitle() {
        return this.myTitle;
    }

    @NotNull
    public final String[] getMyOptions() {
        return this.myOptions;
    }

    public final int getMyDefaultOptionIndex() {
        return this.myDefaultOptionIndex;
    }

    public final int getMyFocusedOptionIndex() {
        return this.myFocusedOptionIndex;
    }

    @Nullable
    public final String getMyHelpId() {
        return this.myHelpId;
    }

    public AlertDialog(@Nullable Project project, @Nullable Component parentComponent, @NlsContexts.DialogMessage @Nullable String myMessage, @NlsContexts.DialogTitle @Nullable String myTitle, @NotNull String[] myOptions, int myDefaultOptionIndex, int myFocusedOptionIndex, @NotNull Icon icon2, @Nullable DoNotAskOption doNotAskOption, @Nullable String myHelpId) {
        Intrinsics.checkNotNullParameter((Object)myOptions, (String)"myOptions");
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        super(project, parentComponent, false, DialogWrapper.IdeModalityType.IDE, false);
        this.myMessage = myMessage;
        this.myTitle = myTitle;
        this.myOptions = myOptions;
        this.myDefaultOptionIndex = myDefaultOptionIndex;
        this.myFocusedOptionIndex = myFocusedOptionIndex;
        this.myHelpId = myHelpId;
        this.myIsTitleComponent = SystemInfoRt.isMac || !Registry.is((String)"ide.message.dialogs.as.swing.alert.show.title.bar", (boolean)false);
        this.myRootLayout = new RootLayout();
        this.myIconComponent = new JLabel(icon2);
        this.mySouthPanel = new JPanel(new BorderLayout());
        this.myButtonsPanel = new JPanel();
        this.myButtons = new ArrayList();
        this.setTitle(this.myTitle);
        this.setDoNotAskOption(doNotAskOption);
        if (this.myIsTitleComponent && !SystemInfoRt.isMac) {
            this.myCloseButton = (JComponent)new InplaceButton(new IconButton(null, AllIcons.Windows.CloseActive, null, null), new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent it) {
                    this.doCancelAction();
                }
            }){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void paintHover(@NotNull Graphics g) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Graphics graphics = g.create();
                    if (graphics == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
                    }
                    Graphics2D g2 = (Graphics2D)graphics;
                    try {
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                        g2.setColor(JBUI.CurrentTheme.ActionButton.hoverBorder());
                        Rectangle rect = new Rectangle(this.getSize());
                        JBInsets.removeFrom((Rectangle)rect, (Insets)this.getInsets());
                        float arc = JBUIScale.scale((float)JBUI.getInt((String)"Button.arc", (int)6));
                        g2.fill(new RoundRectangle2D.Float(rect.x, rect.y, rect.width, rect.height, arc, arc));
                    }
                    finally {
                        g2.dispose();
                    }
                }
            };
            ((Object)this.myCloseButton).setPreferredSize((Dimension)new JBDimension(22, 22));
        } else {
            this.myCloseButton = null;
        }
        if (SystemInfoRt.isMac) {
            this.setInitialLocationCallback(new Computable(){

                public final Point compute() {
                    JRootPane rootPane;
                    Window window = this.getWindow();
                    Intrinsics.checkNotNullExpressionValue((Object)window, (String)"window");
                    JRootPane jRootPane = SwingUtilities.getRootPane(window.getParent());
                    if (jRootPane == null) {
                        Window window2 = this.getWindow();
                        Intrinsics.checkNotNullExpressionValue((Object)window2, (String)"window");
                        jRootPane = rootPane = SwingUtilities.getRootPane(window2.getOwner());
                    }
                    if (rootPane == null) {
                        return null;
                    }
                    Point location = rootPane.getLocationOnScreen();
                    int n = location.x;
                    int n2 = rootPane.getWidth();
                    Window window3 = this.getWindow();
                    Intrinsics.checkNotNullExpressionValue((Object)window3, (String)"window");
                    return new Point(n + (n2 - window3.getWidth()) / 2, (int)((double)location.y + (double)rootPane.getHeight() * 0.25));
                }
            });
        }
        this.init();
        if (this.myHelpButton != null) {
            JButton jButton = this.myHelpButton;
            Intrinsics.checkNotNull((Object)jButton);
            JButton helpButton2 = jButton;
            helpButton2.getParent().remove(helpButton2);
            this.myRootLayout.addAdditionalComponent(helpButton2);
        }
        if (this.myCloseButton != null) {
            this.myRootLayout.addAdditionalComponent(this.myCloseButton);
        }
        if (this.myIsTitleComponent) {
            this.setUndecorated(true);
            JRootPane jRootPane = this.getRootPane();
            Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"rootPane");
            jRootPane.setWindowDecorationStyle(0);
            JRootPane jRootPane2 = this.getRootPane();
            Intrinsics.checkNotNullExpressionValue((Object)jRootPane2, (String)"rootPane");
            jRootPane2.setBorder((Border)PopupBorder.Factory.create((boolean)true, (boolean)true));
            Container container = this.getContentPane();
            if (container == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.swing.JComponent");
            }
            new MouseDragHelper<JComponent>(this.myDisposable, (JComponent)container){
                @Nullable
                private Point myLocation;

                @Nullable
                public final Point getMyLocation() {
                    return this.myLocation;
                }

                public final void setMyLocation(@Nullable Point point) {
                    this.myLocation = point;
                }

                protected boolean canStartDragging(@NotNull JComponent dragComponent, @NotNull Point dragComponentPoint) {
                    Intrinsics.checkNotNullParameter((Object)dragComponent, (String)"dragComponent");
                    Intrinsics.checkNotNullParameter((Object)dragComponentPoint, (String)"dragComponentPoint");
                    Component target2 = dragComponent.findComponentAt(dragComponentPoint);
                    return target2 == null || Intrinsics.areEqual((Object)target2, (Object)dragComponent) || Intrinsics.areEqual((Object)target2, (Object)myTitleComponent) || target2 instanceof JPanel;
                }

                protected void processDrag(@NotNull MouseEvent event, @NotNull Point dragToScreenPoint, @NotNull Point startScreenPoint) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter((Object)dragToScreenPoint, (String)"dragToScreenPoint");
                    Intrinsics.checkNotNullParameter((Object)startScreenPoint, (String)"startScreenPoint");
                    if (this.myLocation == null) {
                        Window window = this.getWindow();
                        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"window");
                        this.myLocation = window.getLocation();
                    }
                    Window window = this.getWindow();
                    Intrinsics.checkNotNullExpressionValue((Object)window, (String)"window");
                    Point point = this.myLocation;
                    Intrinsics.checkNotNull((Object)point);
                    int n = point.x + dragToScreenPoint.x - startScreenPoint.x;
                    Point point2 = this.myLocation;
                    Intrinsics.checkNotNull((Object)point2);
                    window.setLocation(new Point(n, point2.y + dragToScreenPoint.y - startScreenPoint.y));
                }

                protected void processDragCancel() {
                    this.myLocation = null;
                }

                protected void processDragFinish(@NotNull MouseEvent event, boolean willDragOutStart) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.myLocation = null;
                }

                protected void processDragOutFinish(@NotNull MouseEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.myLocation = null;
                }

                protected void processDragOutCancel() {
                    this.myLocation = null;
                }

                protected void processDragOut(@NotNull MouseEvent event, @NotNull Point dragToScreenPoint, @NotNull Point startScreenPoint, boolean justStarted) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter((Object)dragToScreenPoint, (String)"dragToScreenPoint");
                    Intrinsics.checkNotNullParameter((Object)startScreenPoint, (String)"startScreenPoint");
                    super.processDragOut(event, dragToScreenPoint, startScreenPoint, justStarted);
                    this.myLocation = null;
                }
            }.start();
        }
    }

    public static final /* synthetic */ void access$setMyHelpButton$p(AlertDialog $this, JButton jButton) {
        $this.myHelpButton = jButton;
    }

    public static final /* synthetic */ void access$setMyTitleComponent$p(AlertDialog $this, JComponent jComponent) {
        $this.myTitleComponent = jComponent;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0004H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/ui/messages/AlertDialog$RootLayout;", "Ljava/awt/BorderLayout;", "(Lcom/intellij/openapi/ui/messages/AlertDialog;)V", "myParent", "Ljava/awt/Container;", "addAdditionalComponent", "", "component", "Ljava/awt/Component;", "addLayoutComponent", "name", "", "comp", "getWidthWithoutMessageComponent", "", "layoutContainer", "target", "intellij.platform.ide.impl"})
    private final class RootLayout
    extends BorderLayout {
        private Container myParent;

        public final int getWidthWithoutMessageComponent() {
            Container container = this.myParent;
            Intrinsics.checkNotNull((Object)container);
            Insets insets = container.getInsets();
            Container container2 = AlertDialog.this.myIconComponent.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)container2, (String)"myIconComponent.parent");
            Container container3 = container2.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)container3, (String)"myIconComponent.parent.parent");
            LayoutManager layoutManager = container3.getLayout();
            if (layoutManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.awt.BorderLayout");
            }
            BorderLayout layout = (BorderLayout)layoutManager;
            return insets.left + ((AlertDialog)AlertDialog.this).myIconComponent.getPreferredSize().width + layout.getHgap() + insets.right;
        }

        public final void addAdditionalComponent(@NotNull Component component2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Container container = this.myParent;
            Intrinsics.checkNotNull((Object)container);
            container.add(component2, 0);
        }

        @Override
        public void addLayoutComponent(@Nullable String name2, @NotNull Component comp) {
            Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
            if (this.myParent == null) {
                this.myParent = comp.getParent();
            }
            if (Intrinsics.areEqual((Object)comp, (Object)AlertDialog.this.myCloseButton) ^ true && Intrinsics.areEqual((Object)comp, (Object)AlertDialog.this.myHelpButton) ^ true) {
                super.addLayoutComponent(name2, comp);
            }
        }

        @Override
        public void layoutContainer(@NotNull Container target2) {
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            super.layoutContainer(target2);
            if (AlertDialog.this.myCloseButton != null) {
                int offset = JBUI.scale((int)24);
                Dimension size = AlertDialog.this.myCloseButton.getPreferredSize();
                AlertDialog.this.myCloseButton.setBounds(target2.getWidth() - offset, offset - size.height, size.width, size.height);
            }
            if (AlertDialog.this.myHelpButton != null) {
                JButton jButton = AlertDialog.this.myHelpButton;
                Intrinsics.checkNotNull((Object)jButton);
                JButton helpButton2 = jButton;
                Object e = AlertDialog.this.myButtons.get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"myButtons[0]");
                JButton firstButton = (JButton)e;
                Point iconPoint = SwingUtilities.convertPoint(AlertDialog.this.myIconComponent, 0, 0, target2);
                Point buttonPoint = SwingUtilities.convertPoint(firstButton, 0, 0, target2);
                Dimension iconSize = AlertDialog.this.myIconComponent.getPreferredSize();
                Dimension helpSize = helpButton2.getPreferredSize();
                Dimension buttonSize = firstButton.getPreferredSize();
                helpButton2.setBounds(iconPoint.x + (iconSize.width - helpSize.width) / 2, buttonPoint.y + (buttonSize.height - helpSize.height) / 2, helpSize.width, helpSize.height);
            }
        }
    }
}

