/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.messages;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.messages.AlertDialog;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.AppIcon;
import com.intellij.ui.mac.MacMessages;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Window;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0002J,\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016Js\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\t2\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u001bJe\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\u001dJ,\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001f\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016JX\u0010 \u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u0016JP\u0010$\u001a\u00020%2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010&\u001a\u0004\u0018\u00010\u00192\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006("}, d2={"Lcom/intellij/openapi/ui/messages/AlertMessagesManager;", "Lcom/intellij/ui/mac/MacMessages;", "()V", "getIcon", "Ljavax/swing/Icon;", "icon", "showErrorDialog", "", "title", "", "message", "okButton", "window", "Ljava/awt/Window;", "showMessageDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "options", "", "defaultOptionIndex", "focusedOptionIndex", "doNotAskOption", "Lcom/intellij/openapi/ui/DoNotAskOption;", "helpId", "(Lcom/intellij/openapi/project/Project;Ljava/awt/Component;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;IILjavax/swing/Icon;Lcom/intellij/openapi/ui/DoNotAskOption;Ljava/lang/String;)I", "buttons", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/awt/Window;IILcom/intellij/openapi/ui/DoNotAskOption;Ljavax/swing/Icon;Ljava/lang/String;)I", "showOkMessageDialog", "okText", "showYesNoCancelDialog", "yesText", "noText", "cancelText", "showYesNoDialog", "", "doNotAskDialogOption", "Companion", "intellij.platform.ide.impl"})
public final class AlertMessagesManager
extends MacMessages {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public int showYesNoCancelDialog(@NotNull String title2, @NotNull String message2, @NotNull String yesText, @NotNull String noText, @NotNull String cancelText, @Nullable Window window, @Nullable DoNotAskOption doNotAskOption, @Nullable Icon icon2, @Nullable String helpId) {
        int exitCode;
        block4: {
            int n;
            Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)yesText, (String)"yesText");
            Intrinsics.checkNotNullParameter((Object)noText, (String)"noText");
            Intrinsics.checkNotNullParameter((Object)cancelText, (String)"cancelText");
            AlertDialog dialog2 = new AlertDialog(null, window, message2, title2, new String[]{yesText, cancelText, noText}, 0, -1, this.getIcon(icon2), doNotAskOption, helpId);
            AppIcon.getInstance().requestAttention(null, true);
            dialog2.show();
            switch (dialog2.getExitCode()) {
                case 0: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = 1;
                    break;
                }
                default: {
                    n = 2;
                }
            }
            exitCode = n;
            DoNotAskOption doNotAskOption2 = doNotAskOption;
            if (doNotAskOption2 == null) break block4;
            doNotAskOption2.setToBeShown(dialog2.toBeShown(), exitCode);
        }
        return exitCode;
    }

    public void showOkMessageDialog(@NotNull String title2, @Nullable String message2, @NotNull String okText, @Nullable Window window) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)okText, (String)"okText");
        this.showMessageDialog(null, window, message2, title2, new String[]{okText}, 0, -1, null, null, null);
    }

    public boolean showYesNoDialog(@NotNull String title2, @NotNull String message2, @NotNull String yesText, @NotNull String noText, @Nullable Window window, @Nullable DoNotAskOption doNotAskDialogOption, @Nullable Icon icon2, @Nullable String helpId) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)yesText, (String)"yesText");
        Intrinsics.checkNotNullParameter((Object)noText, (String)"noText");
        return this.showMessageDialog(null, window, message2, title2, new String[]{yesText, noText}, 0, -1, icon2, doNotAskDialogOption, null) == 0;
    }

    public void showErrorDialog(@NotNull String title2, @Nullable String message2, @NotNull String okButton, @Nullable Window window) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)okButton, (String)"okButton");
        this.showMessageDialog(null, window, message2, title2, new String[]{okButton}, 0, -1, Messages.getErrorIcon(), null, null);
    }

    public int showMessageDialog(@NotNull String title2, @Nullable String message2, @NotNull String[] buttons, @Nullable Window window, int defaultOptionIndex, int focusedOptionIndex, @Nullable DoNotAskOption doNotAskOption, @Nullable Icon icon2, @Nullable String helpId) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)buttons, (String)"buttons");
        return this.showMessageDialog(null, window, message2, title2, buttons, defaultOptionIndex, focusedOptionIndex, icon2, doNotAskOption, helpId);
    }

    public final int showMessageDialog(@Nullable Project project, @Nullable Component parentComponent, @NlsContexts.DialogMessage @Nullable String message2, @NlsContexts.DialogTitle @Nullable String title2, @NotNull String[] options2, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon2, @Nullable DoNotAskOption doNotAskOption, @Nullable String helpId) {
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        AlertDialog dialog2 = new AlertDialog(project, parentComponent, message2, title2, options2, defaultOptionIndex, focusedOptionIndex, this.getIcon(icon2), doNotAskOption, helpId);
        AppIcon.getInstance().requestAttention(project, true);
        dialog2.show();
        return dialog2.getExitCode();
    }

    private final Icon getIcon(Icon icon2) {
        if (Intrinsics.areEqual((Object)icon2, (Object)UIUtil.getInformationIcon()) || icon2 == null) {
            Icon icon3 = AllIcons.General.InformationDialog;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"AllIcons.General.InformationDialog");
            return icon3;
        }
        if (Intrinsics.areEqual((Object)icon2, (Object)UIUtil.getQuestionIcon())) {
            Icon icon4 = AllIcons.General.QuestionDialog;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"AllIcons.General.QuestionDialog");
            return icon4;
        }
        if (Intrinsics.areEqual((Object)icon2, (Object)UIUtil.getWarningIcon())) {
            Icon icon5 = AllIcons.General.WarningDialog;
            Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"AllIcons.General.WarningDialog");
            return icon5;
        }
        if (Intrinsics.areEqual((Object)icon2, (Object)UIUtil.getErrorIcon())) {
            Icon icon6 = AllIcons.General.ErrorDialog;
            Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"AllIcons.General.ErrorDialog");
            return icon6;
        }
        return icon2;
    }

    @JvmStatic
    public static final boolean isEnabled() {
        return Companion.isEnabled();
    }

    @JvmStatic
    @NotNull
    public static final AlertMessagesManager instance() {
        return Companion.instance();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/ui/messages/AlertMessagesManager$Companion;", "", "()V", "instance", "Lcom/intellij/openapi/ui/messages/AlertMessagesManager;", "isEnabled", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        public final boolean isEnabled() {
            Application app2 = ApplicationManager.getApplication();
            return app2 != null && !app2.isUnitTestMode() && !app2.isHeadlessEnvironment() && Registry.is((String)"ide.message.dialogs.as.swing.alert", (boolean)true);
        }

        @JvmStatic
        @NotNull
        public final AlertMessagesManager instance() {
            Object object = ApplicationManager.getApplication().getService(AlertMessagesManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026sagesManager::class.java)");
            return (AlertMessagesManager)((Object)object);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

