/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.playback.PlaybackCommand;
import com.intellij.openapi.ui.playback.PlaybackContext;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class AbstractCommand
implements PlaybackCommand {
    private static final Logger LOG = Logger.getInstance(AbstractCommand.class);
    @NonNls
    public static final String CMD_PREFIX = "%";
    @NonNls
    @NotNull
    private final String myText;
    private final int myLine;
    private final boolean myExecuteInAwt;
    @Nullable
    private File myScriptDir;

    public String extractCommandArgument(String prefix) {
        if (this.myText.startsWith(prefix)) {
            return this.myText.substring(prefix.length()).trim();
        }
        return this.myText;
    }

    public AbstractCommand(@NotNull String text2, int line) {
        if (text2 == null) {
            AbstractCommand.$$$reportNull$$$0(0);
        }
        this(text2, line, false);
    }

    public AbstractCommand(@NotNull String text2, int line, boolean executeInAwt) {
        if (text2 == null) {
            AbstractCommand.$$$reportNull$$$0(1);
        }
        this.myExecuteInAwt = executeInAwt;
        this.myText = text2;
        this.myLine = line;
    }

    @NonNls
    @NotNull
    public final String getText() {
        String string = this.myText;
        if (string == null) {
            AbstractCommand.$$$reportNull$$$0(2);
        }
        return string;
    }

    public final int getLine() {
        return this.myLine;
    }

    @Override
    @Nullable
    public final File getScriptDir() {
        return this.myScriptDir;
    }

    public final void setScriptDir(@Nullable File scriptDir) {
        this.myScriptDir = scriptDir;
    }

    @Override
    public boolean canGoFurther() {
        return true;
    }

    @Override
    @NotNull
    public final Promise<Object> execute(@NotNull PlaybackContext context2) {
        AsyncPromise asyncPromise;
        if (context2 == null) {
            AbstractCommand.$$$reportNull$$$0(3);
        }
        try {
            if (this.isToDumpCommand()) {
                context2.code(this.getText(), this.getLine());
            }
            AsyncPromise result2 = new AsyncPromise();
            Runnable runnable2 = () -> {
                try {
                    this._execute(context2).processed((Promise)result2);
                }
                catch (Throwable e) {
                    LOG.error(e);
                    this.dumpError(context2, e.getMessage());
                    result2.setError(e);
                }
            };
            Application application = ApplicationManager.getApplication();
            if (this.myExecuteInAwt) {
                application.invokeLater(runnable2);
            } else {
                application.executeOnPooledThread(runnable2);
            }
            asyncPromise = result2;
        }
        catch (Throwable e) {
            this.dumpError(context2, e.getMessage());
            Promise promise = Promises.rejectedPromise((Throwable)e);
            if (promise == null) {
                AbstractCommand.$$$reportNull$$$0(5);
            }
            return promise;
        }
        if (asyncPromise == null) {
            AbstractCommand.$$$reportNull$$$0(4);
        }
        return asyncPromise;
    }

    protected boolean isToDumpCommand() {
        return true;
    }

    @NotNull
    protected abstract Promise<Object> _execute(@NotNull PlaybackContext var1);

    protected final void dumpError(@NotNull PlaybackContext context2, @NotNull String text2) {
        if (context2 == null) {
            AbstractCommand.$$$reportNull$$$0(6);
        }
        if (text2 == null) {
            AbstractCommand.$$$reportNull$$$0(7);
        }
        context2.error(text2, this.getLine());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/playback/commands/AbstractCommand";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/playback/commands/AbstractCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dumpError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

