/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import java.io.File;
import java.io.IOException;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class CdCommand
extends AbstractCommand {
    public static final String PREFIX = "%cd";
    private final String myDir;

    public CdCommand(String text2, int line) {
        super(text2, line);
        this.myDir = text2.substring(PREFIX.length()).trim();
    }

    @Override
    protected Promise<Object> _execute(PlaybackContext context2) {
        File file2 = context2.getPathMacro().resolveFile(this.myDir, context2.getBaseDir());
        if (!file2.exists()) {
            context2.message("Cannot cd, directory doesn't exist: " + file2.getAbsoluteFile(), this.getLine());
            return Promises.rejectedPromise();
        }
        try {
            context2.setBaseDir(file2.getCanonicalFile());
        }
        catch (IOException e) {
            context2.setBaseDir(file2);
        }
        context2.message("{base.dir} set to " + context2.getBaseDir().getAbsolutePath(), this.getLine());
        return Promises.resolvedPromise();
    }
}

