/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.NlsContexts;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0017J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\bH\u0016J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/updateSettings/UpdateStrategyCustomization;", "", "()V", "canBeUsedForIntermediatePatches", "", "updateChannel", "Lcom/intellij/openapi/updateSettings/impl/UpdateChannel;", "selectedChannel", "Lcom/intellij/openapi/updateSettings/impl/ChannelStatus;", "changeDefaultChannel", "currentChannel", "forceEapUpdateChannelForEapBuilds", "getChannelSelectionLockedMessage", "", "haveSameMajorVersion", "build1", "Lcom/intellij/openapi/util/BuildNumber;", "build2", "isChannelActive", "channel", "isChannelApplicableForUpdates", "isNewerVersion", "candidateBuild", "currentBuild", "Companion", "intellij.platform.ide.impl"})
public class UpdateStrategyCustomization {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean forceEapUpdateChannelForEapBuilds() {
        return true;
    }

    @Nullable
    public ChannelStatus changeDefaultChannel(@NotNull ChannelStatus currentChannel) {
        Intrinsics.checkNotNullParameter((Object)((Object)currentChannel), (String)"currentChannel");
        return null;
    }

    public boolean isChannelActive(@NotNull ChannelStatus channel2) {
        Intrinsics.checkNotNullParameter((Object)((Object)channel2), (String)"channel");
        return channel2 != ChannelStatus.MILESTONE && channel2 != ChannelStatus.BETA;
    }

    public boolean haveSameMajorVersion(@NotNull BuildNumber build1, @NotNull BuildNumber build2) {
        Intrinsics.checkNotNullParameter((Object)build1, (String)"build1");
        Intrinsics.checkNotNullParameter((Object)build2, (String)"build2");
        return build1.getBaselineVersion() == build2.getBaselineVersion();
    }

    public boolean isNewerVersion(@NotNull BuildNumber candidateBuild, @NotNull BuildNumber currentBuild) {
        Intrinsics.checkNotNullParameter((Object)candidateBuild, (String)"candidateBuild");
        Intrinsics.checkNotNullParameter((Object)currentBuild, (String)"currentBuild");
        return candidateBuild.compareTo(currentBuild) > 0;
    }

    public boolean isChannelApplicableForUpdates(@NotNull UpdateChannel updateChannel, @NotNull ChannelStatus selectedChannel) {
        Intrinsics.checkNotNullParameter((Object)updateChannel, (String)"updateChannel");
        Intrinsics.checkNotNullParameter((Object)((Object)selectedChannel), (String)"selectedChannel");
        return updateChannel.getStatus().compareTo((Enum)selectedChannel) >= 0;
    }

    public boolean canBeUsedForIntermediatePatches(@NotNull UpdateChannel updateChannel, @NotNull ChannelStatus selectedChannel) {
        Intrinsics.checkNotNullParameter((Object)updateChannel, (String)"updateChannel");
        Intrinsics.checkNotNullParameter((Object)((Object)selectedChannel), (String)"selectedChannel");
        return true;
    }

    @NlsContexts.DetailedDescription
    @Nullable
    public String getChannelSelectionLockedMessage() {
        ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"ApplicationInfoEx.getInstanceEx()");
        return applicationInfoEx.isMajorEAP() && this.forceEapUpdateChannelForEapBuilds() ? IdeBundle.message((String)"updates.settings.channel.locked", (Object[])new Object[0]) : null;
    }

    @JvmStatic
    @NotNull
    public static final UpdateStrategyCustomization getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/updateSettings/UpdateStrategyCustomization$Companion;", "", "()V", "getInstance", "Lcom/intellij/openapi/updateSettings/UpdateStrategyCustomization;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final UpdateStrategyCustomization getInstance() {
            boolean $i$f$service = false;
            Class<UpdateStrategyCustomization> serviceClass$iv = UpdateStrategyCustomization.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            return (UpdateStrategyCustomization)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

