/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginHeaderPanel;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponent;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.OrderPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DetectedPluginsPanel
extends OrderPanel<PluginDownloader> {
    private final PluginDetailsPageComponent myDetailsComponent;
    private final PluginHeaderPanel myHeader = new PluginHeaderPanel();
    private final HashSet<PluginId> mySkippedPlugins = new HashSet();

    public DetectedPluginsPanel(@Nullable Project project) {
        super(PluginDownloader.class);
        MyPluginModel pluginModel = new MyPluginModel(project);
        this.myDetailsComponent = new PluginDetailsPageComponent(pluginModel, (LinkListener<Object>)((LinkListener)(aSource, aLinkData) -> {}), true);
        final JTable entryTable = this.getEntryTable();
        entryTable.setTableHeader(null);
        entryTable.setDefaultRenderer(PluginDownloader.class, (TableCellRenderer)new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, Object value2, boolean selected2, boolean hasFocus, int row2, int column2) {
                String version2;
                String oldPluginName;
                if (table == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.setBorder(null);
                if (!(value2 instanceof PluginDownloader)) {
                    return;
                }
                PluginDownloader downloader = (PluginDownloader)value2;
                String pluginName = downloader.getPluginName();
                this.append(pluginName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                IdeaPluginDescriptor installedPlugin = PluginManagerCore.getPlugin(downloader.getId());
                String string = oldPluginName = installedPlugin != null ? installedPlugin.getName() : null;
                if (oldPluginName != null && !Comparing.strEqual((String)pluginName, (String)oldPluginName)) {
                    this.append(" - " + oldPluginName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
                String installedVersion = installedPlugin != null ? installedPlugin.getVersion() : null;
                String availableVersion = downloader.getPluginVersion();
                String string2 = version2 = installedVersion != null && availableVersion != null ? StringUtil.join((String[])new String[]{installedVersion, UIUtil.rightArrow(), availableVersion}, (String)"") : StringUtil.defaultIfEmpty((String)installedVersion, (String)availableVersion);
                if (StringUtil.isNotEmpty((String)version2)) {
                    this.append(" " + version2, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/openapi/updateSettings/impl/DetectedPluginsPanel$1", "customizeCellRenderer"));
            }
        });
        entryTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = entryTable.getSelectedRow();
                if (selectedRow != -1) {
                    IdeaPluginDescriptor plugin2 = ((PluginDownloader)DetectedPluginsPanel.this.getValueAt(selectedRow)).getDescriptor();
                    DetectedPluginsPanel.this.myHeader.setPlugin(plugin2);
                    DetectedPluginsPanel.this.myDetailsComponent.setOnlyUpdateMode();
                    DetectedPluginsPanel.this.myDetailsComponent.showPluginImpl(plugin2, null);
                }
            }
        });
        this.removeAll();
        OnePixelSplitter splitter2 = new OnePixelSplitter(false);
        splitter2.setFirstComponent((JComponent)DetectedPluginsPanel.wrapWithPane(entryTable, 1, 0));
        splitter2.setSecondComponent((JComponent)DetectedPluginsPanel.wrapWithPane(this.myDetailsComponent, 0, 1));
        this.add((Component)splitter2, "Center");
    }

    @NotNull
    private static JScrollPane wrapWithPane(@NotNull JComponent c, int left, int right) {
        if (c == null) {
            DetectedPluginsPanel.$$$reportNull$$$0(0);
        }
        JScrollPane pane2 = ScrollPaneFactory.createScrollPane((Component)c);
        pane2.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)1, (int)left, (int)1, (int)right));
        JScrollPane jScrollPane = pane2;
        if (jScrollPane == null) {
            DetectedPluginsPanel.$$$reportNull$$$0(1);
        }
        return jScrollPane;
    }

    public void addAll(@NotNull Collection<? extends PluginDownloader> orderEntries, @Nullable PluginDownloader selectedPlugin) {
        if (orderEntries == null) {
            DetectedPluginsPanel.$$$reportNull$$$0(2);
        }
        if (selectedPlugin != null) {
            for (PluginDownloader pluginDownloader : orderEntries) {
                if (pluginDownloader == selectedPlugin) continue;
                this.mySkippedPlugins.add(pluginDownloader.getId());
            }
        }
        super.addAll(orderEntries);
        TableUtil.ensureSelectionExists((JTable)this.getEntryTable());
    }

    public boolean isChecked(@NotNull PluginDownloader downloader) {
        if (downloader == null) {
            DetectedPluginsPanel.$$$reportNull$$$0(3);
        }
        return !this.mySkippedPlugins.contains(downloader.getId());
    }

    public void setChecked(@NotNull PluginDownloader downloader, boolean checked) {
        if (downloader == null) {
            DetectedPluginsPanel.$$$reportNull$$$0(4);
        }
        PluginId pluginId = downloader.getId();
        if (checked) {
            this.mySkippedPlugins.remove(pluginId);
        } else {
            this.mySkippedPlugins.add(pluginId);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/DetectedPluginsPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntries";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/DetectedPluginsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithPane";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isChecked";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setChecked";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

