/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="UnknownFeatures", storages={@Storage(value="$WORKSPACE_FILE$")})
@Service
public final class UnknownFeaturesCollector
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String FEATURE_ID = "featureType";
    @NonNls
    private static final String IMPLEMENTATION_NAME = "implementationName";
    private final Set<UnknownFeature> myUnknownFeatures = new HashSet<UnknownFeature>();
    private final Set<UnknownFeature> myIgnoredUnknownFeatures = new HashSet<UnknownFeature>();

    public static UnknownFeaturesCollector getInstance(Project project) {
        return (UnknownFeaturesCollector)project.getService(UnknownFeaturesCollector.class);
    }

    public void registerUnknownFeature(@NonNls @NotNull String featureType, @NonNls @NotNull String implementationName, @Nls @NotNull String featureDisplayName) {
        if (featureType == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(0);
        }
        if (implementationName == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(1);
        }
        if (featureDisplayName == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(2);
        }
        this.registerUnknownFeature(featureType, featureDisplayName, implementationName, null);
    }

    public void registerUnknownFeature(@NonNls @NotNull String featureType, @Nls @NotNull String featureDisplayName, @NonNls @NotNull String implementationName, @Nls @Nullable String implementationDisplayName) {
        UnknownFeature feature;
        if (featureType == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(3);
        }
        if (featureDisplayName == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(4);
        }
        if (implementationName == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(5);
        }
        if (!this.isIgnored(feature = new UnknownFeature(featureType, featureDisplayName, implementationName, implementationDisplayName))) {
            this.myUnknownFeatures.add(feature);
        }
    }

    public boolean isIgnored(@NotNull UnknownFeature feature) {
        if (feature == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(6);
        }
        return this.myIgnoredUnknownFeatures.contains(feature);
    }

    public void ignoreFeature(@NotNull UnknownFeature feature) {
        if (feature == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(7);
        }
        this.myIgnoredUnknownFeatures.add(feature);
    }

    @NotNull
    public Set<UnknownFeature> getUnknownFeatures() {
        Set<UnknownFeature> set2 = Collections.unmodifiableSet(this.myUnknownFeatures);
        if (set2 == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(8);
        }
        return set2;
    }

    @Nullable
    public Element getState() {
        if (this.myIgnoredUnknownFeatures.isEmpty()) {
            return null;
        }
        Element ignored = new Element("ignored");
        for (UnknownFeature feature : this.myIgnoredUnknownFeatures) {
            Element option2 = new Element("option");
            option2.setAttribute(FEATURE_ID, feature.getFeatureType());
            option2.setAttribute(IMPLEMENTATION_NAME, feature.getImplementationName());
            ignored.addContent(option2);
        }
        return ignored;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(9);
        }
        this.myIgnoredUnknownFeatures.clear();
        for (Element element2 : state.getChildren()) {
            String implementationName;
            String featureType = element2.getAttributeValue(FEATURE_ID);
            if (featureType == null || (implementationName = element2.getAttributeValue(IMPLEMENTATION_NAME)) == null) continue;
            this.myIgnoredUnknownFeatures.add(new UnknownFeature(featureType, implementationName));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = FEATURE_ID;
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = IMPLEMENTATION_NAME;
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureDisplayName";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/UnknownFeaturesCollector";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/UnknownFeaturesCollector";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnknownFeatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerUnknownFeature";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "ignoreFeature";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

