/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.editor.impl.TabCharacterPaintMode;
import com.intellij.openapi.options.advanced.AdvancedSettingBean;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.registry.Registry;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010\n\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/util/registry/RegistryToAdvancedSettingsMigration;", "Lcom/intellij/openapi/startup/StartupActivity$DumbAware;", "()V", "migrateEditorTabPainting", "", "userProperties", "", "", "setting", "Lcom/intellij/openapi/options/advanced/AdvancedSettingBean;", "migrateVcsIgnoreProcessing", "runActivity", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
public final class RegistryToAdvancedSettingsMigration
implements StartupActivity.DumbAware {
    public void runActivity(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String propertyName = "registry.to.advanced.settings.migration.build";
        String lastMigratedVersion = PropertiesComponent.getInstance().getValue(propertyName);
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        String string = applicationInfo.getBuild().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ApplicationInfo.getInstance().build.asString()");
        String currentVersion = string;
        if (Intrinsics.areEqual((Object)currentVersion, (Object)lastMigratedVersion) ^ true) {
            Registry registry = Registry.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"Registry.getInstance()");
            Map map2 = registry.getUserProperties();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"Registry.getInstance().userProperties");
            Map userProperties = map2;
            for (AdvancedSettingBean setting2 : (AdvancedSettingBean[])AdvancedSettingBean.EP_NAME.getExtensions()) {
                if (Intrinsics.areEqual((Object)setting2.id, (Object)"editor.tab.painting")) {
                    AdvancedSettingBean advancedSettingBean = setting2;
                    Intrinsics.checkNotNullExpressionValue((Object)advancedSettingBean, (String)"setting");
                    this.migrateEditorTabPainting(userProperties, advancedSettingBean);
                    continue;
                }
                if (Intrinsics.areEqual((Object)setting2.id, (Object)"vcs.process.ignored")) {
                    AdvancedSettingBean advancedSettingBean = setting2;
                    Intrinsics.checkNotNullExpressionValue((Object)advancedSettingBean, (String)"setting");
                    this.migrateVcsIgnoreProcessing(userProperties, advancedSettingBean);
                    continue;
                }
                if ((String)userProperties.get(setting2.id) == null) {
                    continue;
                }
                try {
                    String userProperty;
                    AdvancedSettings.Companion.getInstance().setSetting(setting2.id, setting2.valueFromString(userProperty), setting2.type());
                    userProperties.remove(setting2.id);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            PropertiesComponent.getInstance().setValue(propertyName, currentVersion);
        }
    }

    private final void migrateEditorTabPainting(Map<String, String> userProperties, AdvancedSettingBean setting2) {
        TabCharacterPaintMode tabCharacterPaintMode;
        if (Intrinsics.areEqual((Object)userProperties.get("editor.old.tab.painting"), (Object)"true")) {
            userProperties.remove("editor.old.tab.painting");
            tabCharacterPaintMode = TabCharacterPaintMode.LONG_ARROW;
        } else if (Intrinsics.areEqual((Object)userProperties.get("editor.arrow.tab.painting"), (Object)"true")) {
            userProperties.remove("editor.arrow.tab.painting");
            tabCharacterPaintMode = TabCharacterPaintMode.ARROW;
        } else {
            return;
        }
        TabCharacterPaintMode mode = tabCharacterPaintMode;
        AdvancedSettings.Companion.getInstance().setSetting(setting2.id, (Object)mode, setting2.type());
    }

    private final void migrateVcsIgnoreProcessing(Map<String, String> userProperties, AdvancedSettingBean setting2) {
        if (Intrinsics.areEqual((Object)userProperties.get("git.process.ignored"), (Object)"false")) {
            userProperties.remove("git.process.ignored");
        } else if (Intrinsics.areEqual((Object)userProperties.get("hg4idea.process.ignored"), (Object)"false")) {
            userProperties.remove("hg4idea.process.ignored");
        } else if (Intrinsics.areEqual((Object)userProperties.get("p4.process.ignored"), (Object)"false")) {
            userProperties.remove("p4.process.ignored");
        } else {
            return;
        }
        AdvancedSettings.Companion.getInstance().setSetting(setting2.id, (Object)false, setting2.type());
    }
}

