/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsNotifier {
    public static final NotificationGroup NOTIFICATION_GROUP_ID = NotificationGroupManager.getInstance().getNotificationGroup("Vcs Messages");
    public static final NotificationGroup IMPORTANT_ERROR_NOTIFICATION = NotificationGroupManager.getInstance().getNotificationGroup("Vcs Important Messages");
    public static final NotificationGroup STANDARD_NOTIFICATION = NotificationGroupManager.getInstance().getNotificationGroup("Vcs Notifications");
    public static final NotificationGroup SILENT_NOTIFICATION = NotificationGroupManager.getInstance().getNotificationGroup("Vcs Silent Notifications");
    @NotNull
    private final Project myProject;

    public static VcsNotifier getInstance(@NotNull Project project) {
        if (project == null) {
            VcsNotifier.$$$reportNull$$$0(0);
        }
        return (VcsNotifier)project.getService(VcsNotifier.class);
    }

    public VcsNotifier(@NotNull Project project) {
        if (project == null) {
            VcsNotifier.$$$reportNull$$$0(1);
        }
        this.myProject = project;
    }

    @NotNull
    public Notification notify(@NotNull Notification notification) {
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(2);
        }
        notification.notify(this.myProject);
        Notification notification2 = notification;
        if (notification2 == null) {
            VcsNotifier.$$$reportNull$$$0(3);
        }
        return notification2;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.4")
    @NotNull
    public Notification notifyError(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(4);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(5);
        }
        Notification notification = this.notifyError(null, title2, message2, (NotificationListener)null);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(6);
        }
        return notification;
    }

    @NotNull
    public Notification notifyError(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(7);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(8);
        }
        Notification notification = this.notifyError(displayId, title2, message2, (NotificationListener)null);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(9);
        }
        return notification;
    }

    public Notification notifyError(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2, boolean showDetailsAction) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(10);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(11);
        }
        Notification notification = VcsNotifier.createNotification(IMPORTANT_ERROR_NOTIFICATION, displayId, title2, message2, NotificationType.ERROR, null);
        if (showDetailsAction) {
            VcsNotifier.addShowDetailsAction(this.myProject, notification);
        }
        return this.notify(notification);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.4")
    @NotNull
    public Notification notifyError(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(12);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(13);
        }
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, null, title2, message2, NotificationType.ERROR, listener2);
    }

    @NotNull
    public Notification notifyError(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(14);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(15);
        }
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, displayId, title2, message2, NotificationType.ERROR, listener2);
    }

    @NotNull
    public Notification notifyError(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2, NotificationAction ... actions2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(16);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(17);
        }
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, displayId, title2, message2, NotificationType.ERROR, actions2);
    }

    @NotNull
    public Notification notifyError(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2, @Nullable Collection<? extends Exception> errors2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(18);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(19);
        }
        Notification notification = this.notifyError(displayId, title2, VcsNotifier.buildNotificationMessage(message2, errors2));
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(20);
        }
        return notification;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.4")
    @NotNull
    public Notification notifyWeakError(@NlsContexts.NotificationContent @NotNull String message2) {
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(21);
        }
        return this.notify(NOTIFICATION_GROUP_ID, null, "", message2, NotificationType.ERROR, new NotificationAction[0]);
    }

    @NotNull
    public Notification notifyWeakError(@NonNls @Nullable String displayId, @NlsContexts.NotificationContent @NotNull String message2) {
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(22);
        }
        return this.notify(NOTIFICATION_GROUP_ID, displayId, "", message2, NotificationType.ERROR, new NotificationAction[0]);
    }

    @NotNull
    public Notification notifyWeakError(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(23);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(24);
        }
        return this.notify(NOTIFICATION_GROUP_ID, displayId, title2, message2, NotificationType.ERROR, new NotificationAction[0]);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.4")
    @NotNull
    public Notification notifySuccess(@NlsContexts.NotificationContent @NotNull String message2) {
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(25);
        }
        return this.notify(NOTIFICATION_GROUP_ID, null, "", message2, NotificationType.INFORMATION, new NotificationAction[0]);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.4")
    @NotNull
    public Notification notifySuccess(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(26);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(27);
        }
        return this.notify(NOTIFICATION_GROUP_ID, null, title2, message2, NotificationType.INFORMATION, new NotificationAction[0]);
    }

    @NotNull
    public Notification notifySuccess(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(28);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(29);
        }
        return this.notify(NOTIFICATION_GROUP_ID, displayId, title2, message2, NotificationType.INFORMATION, new NotificationAction[0]);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.4")
    @NotNull
    public Notification notifySuccess(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(30);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(31);
        }
        return this.notify(NOTIFICATION_GROUP_ID, null, title2, message2, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifySuccess(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(32);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(33);
        }
        return this.notify(NOTIFICATION_GROUP_ID, displayId, title2, message2, NotificationType.INFORMATION, listener2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.4")
    @NotNull
    public Notification notifyImportantInfo(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(34);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(35);
        }
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, null, title2, message2, NotificationType.INFORMATION, (NotificationListener)null);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.4")
    @NotNull
    public Notification notifyImportantInfo(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(36);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(37);
        }
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, null, title2, message2, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifyImportantInfo(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(38);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(39);
        }
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, displayId, title2, message2, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifyImportantInfo(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(40);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(41);
        }
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, displayId, title2, message2, NotificationType.INFORMATION, new NotificationAction[0]);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.4")
    @NotNull
    public Notification notifyInfo(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(42);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(43);
        }
        Notification notification = this.notifyInfo(null, title2, message2, null);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(44);
        }
        return notification;
    }

    @NotNull
    public Notification notifyInfo(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(45);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(46);
        }
        Notification notification = this.notifyInfo(displayId, title2, message2, null);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(47);
        }
        return notification;
    }

    @NotNull
    public Notification notifyInfo(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(48);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(49);
        }
        return this.notify(NOTIFICATION_GROUP_ID, displayId, title2, message2, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifyMinorWarning(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(50);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(51);
        }
        Notification notification = this.notifyMinorWarning(displayId, title2, message2, null);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(52);
        }
        return notification;
    }

    @NotNull
    public Notification notifyMinorWarning(@NonNls @Nullable String displayId, @NlsContexts.NotificationContent @NotNull String message2) {
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(53);
        }
        return this.notify(STANDARD_NOTIFICATION, displayId, "", message2, NotificationType.WARNING, (NotificationListener)null);
    }

    @NotNull
    public Notification notifyMinorWarning(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(54);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(55);
        }
        return this.notify(STANDARD_NOTIFICATION, displayId, title2, message2, NotificationType.WARNING, listener2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.4")
    @NotNull
    public Notification notifyWarning(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(56);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(57);
        }
        return this.notify(NOTIFICATION_GROUP_ID, null, title2, message2, NotificationType.WARNING, new NotificationAction[0]);
    }

    @NotNull
    public Notification notifyWarning(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(58);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(59);
        }
        return this.notify(NOTIFICATION_GROUP_ID, displayId, title2, message2, NotificationType.WARNING, new NotificationAction[0]);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.4")
    @NotNull
    public Notification notifyImportantWarning(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(60);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(61);
        }
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, null, title2, message2, NotificationType.WARNING, new NotificationAction[0]);
    }

    @NotNull
    public Notification notifyImportantWarning(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(62);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(63);
        }
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, displayId, title2, message2, NotificationType.WARNING, new NotificationAction[0]);
    }

    @NotNull
    public Notification notifyImportantWarning(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2, @Nullable Collection<? extends Exception> errors2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(64);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(65);
        }
        Notification notification = this.notifyImportantWarning(displayId, title2, VcsNotifier.buildNotificationMessage(message2, errors2));
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(66);
        }
        return notification;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.4")
    @NotNull
    public Notification notifyImportantWarning(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(67);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(68);
        }
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, null, title2, message2, NotificationType.WARNING, listener2);
    }

    @NotNull
    public Notification notifyImportantWarning(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(69);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(70);
        }
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, displayId, title2, message2, NotificationType.WARNING, listener2);
    }

    @NotNull
    public Notification notifyMinorInfo(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(71);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(72);
        }
        Notification notification = this.notifyMinorInfo(displayId, false, title2, message2, new NotificationAction[0]);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(73);
        }
        return notification;
    }

    @NotNull
    public Notification notifyMinorInfo(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2, NotificationAction ... actions2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(74);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(75);
        }
        return this.notify(STANDARD_NOTIFICATION, displayId, title2, message2, NotificationType.INFORMATION, actions2);
    }

    @NotNull
    public Notification notifyMinorInfo(@NonNls @Nullable String displayId, boolean sticky, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2, NotificationAction ... actions2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(76);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(77);
        }
        return this.notify(sticky ? IMPORTANT_ERROR_NOTIFICATION : STANDARD_NOTIFICATION, displayId, title2, message2, NotificationType.INFORMATION, actions2);
    }

    @NotNull
    public Notification logInfo(@Nullable @NonNls String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(78);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(79);
        }
        return this.notify(SILENT_NOTIFICATION, displayId, title2, message2, NotificationType.INFORMATION, new NotificationAction[0]);
    }

    public void showNotificationAndHideExisting(@NotNull Notification notificationToShow, @NotNull Class<? extends Notification> klass) {
        if (notificationToShow == null) {
            VcsNotifier.$$$reportNull$$$0(80);
        }
        if (klass == null) {
            VcsNotifier.$$$reportNull$$$0(81);
        }
        this.hideAllNotificationsByType(klass);
        notificationToShow.notify(this.myProject);
    }

    public void hideAllNotificationsByType(@NotNull Class<? extends Notification> klass) {
        if (klass == null) {
            VcsNotifier.$$$reportNull$$$0(82);
        }
        NotificationsManager notificationsManager = NotificationsManager.getNotificationsManager();
        for (Notification notification : notificationsManager.getNotificationsOfType(klass, this.myProject)) {
            notification.expire();
        }
    }

    @NotNull
    private static Notification createNotification(@NotNull NotificationGroup notificationGroup, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        if (notificationGroup == null) {
            VcsNotifier.$$$reportNull$$$0(83);
        }
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(84);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(85);
        }
        if (type == null) {
            VcsNotifier.$$$reportNull$$$0(86);
        }
        if (StringUtil.isEmptyOrSpaces((String)message2)) {
            message2 = title2;
            title2 = "";
        }
        Notification notification = notificationGroup.createNotification(title2, message2, type);
        if (displayId != null && !displayId.isEmpty()) {
            notification.setDisplayId(displayId);
        }
        if (listener2 != null) {
            notification.setListener(listener2);
        }
        Notification notification2 = notification;
        if (notification2 == null) {
            VcsNotifier.$$$reportNull$$$0(87);
        }
        return notification2;
    }

    @NotNull
    private Notification notify(@NotNull NotificationGroup notificationGroup, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        if (notificationGroup == null) {
            VcsNotifier.$$$reportNull$$$0(88);
        }
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(89);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(90);
        }
        if (type == null) {
            VcsNotifier.$$$reportNull$$$0(91);
        }
        Notification notification = VcsNotifier.createNotification(notificationGroup, displayId, title2, message2, type, listener2);
        Notification notification2 = this.notify(notification);
        if (notification2 == null) {
            VcsNotifier.$$$reportNull$$$0(92);
        }
        return notification2;
    }

    @NotNull
    private Notification notify(@NotNull NotificationGroup notificationGroup, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2, @NotNull NotificationType type, NotificationAction ... actions2) {
        if (notificationGroup == null) {
            VcsNotifier.$$$reportNull$$$0(93);
        }
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(94);
        }
        if (message2 == null) {
            VcsNotifier.$$$reportNull$$$0(95);
        }
        if (type == null) {
            VcsNotifier.$$$reportNull$$$0(96);
        }
        Notification notification = VcsNotifier.createNotification(notificationGroup, displayId, title2, message2, type, null);
        for (NotificationAction action2 : actions2) {
            notification.addAction((AnAction)action2);
        }
        Notification notification2 = this.notify(notification);
        if (notification2 == null) {
            VcsNotifier.$$$reportNull$$$0(97);
        }
        return notification2;
    }

    public static void addShowDetailsAction(@NotNull Project project, @NotNull Notification notification) {
        if (project == null) {
            VcsNotifier.$$$reportNull$$$0(98);
        }
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(99);
        }
        if (ProjectLevelVcsManager.getInstance((Project)project).isConsoleVisible()) {
            notification.addAction((AnAction)NotificationAction.createSimple((String)VcsBundle.message((String)"notification.showDetailsInConsole", (Object[])new Object[0]), () -> {
                ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)project);
                vcsManager2.showConsole(() -> ((ProjectLevelVcsManager)vcsManager2).scrollConsoleToTheEnd());
            }));
        }
    }

    @Nls
    @NotNull
    private static String buildNotificationMessage(@Nls String message2, @Nullable Collection<? extends Exception> errors2) {
        String string = message2.replace("\n", "<br/>") + VcsNotifier.stringifyErrors(errors2);
        if (string == null) {
            VcsNotifier.$$$reportNull$$$0(100);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String stringifyErrors(@Nullable Collection<? extends Exception> errors2) {
        if (errors2 == null || errors2.isEmpty()) {
            return "";
        }
        @Nls StringBuilder content2 = new StringBuilder();
        for (Exception exception : errors2) {
            if (exception instanceof VcsException) {
                VcsException vcsException = (VcsException)((Object)exception);
                for (String message2 : vcsException.getMessages()) {
                    content2.append(message2.replace("\n", "<br/>")).append("<br/>");
                }
                continue;
            }
            content2.append(exception.getMessage().replace("\n", "<br/>")).append("<br/>");
        }
        String string = content2.toString();
        if (string == null) {
            VcsNotifier.$$$reportNull$$$0(101);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 20: 
            case 44: 
            case 47: 
            case 52: 
            case 66: 
            case 73: 
            case 87: 
            case 92: 
            case 97: 
            case 100: 
            case 101: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 20: 
            case 44: 
            case 47: 
            case 52: 
            case 66: 
            case 73: 
            case 87: 
            case 92: 
            case 97: 
            case 100: 
            case 101: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 20: 
            case 44: 
            case 47: 
            case 52: 
            case 66: 
            case 73: 
            case 87: 
            case 92: 
            case 97: 
            case 100: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/VcsNotifier";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 48: 
            case 50: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 67: 
            case 69: 
            case 71: 
            case 74: 
            case 76: 
            case 78: 
            case 84: 
            case 89: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 46: 
            case 49: 
            case 51: 
            case 53: 
            case 55: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 68: 
            case 70: 
            case 72: 
            case 75: 
            case 77: 
            case 79: 
            case 85: 
            case 90: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationToShow";
                break;
            }
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 83: 
            case 88: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationGroup";
                break;
            }
            case 86: 
            case 91: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/VcsNotifier";
                break;
            }
            case 3: 
            case 92: 
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "notify";
                break;
            }
            case 6: 
            case 9: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyError";
                break;
            }
            case 44: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyInfo";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyMinorWarning";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyImportantWarning";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyMinorInfo";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNotificationMessage";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "stringifyErrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 20: 
            case 44: 
            case 47: 
            case 52: 
            case 66: 
            case 73: 
            case 87: 
            case 92: 
            case 97: 
            case 100: 
            case 101: {
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "notifyError";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "notifyWeakError";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "notifySuccess";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "notifyImportantInfo";
                break;
            }
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "notifyInfo";
                break;
            }
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "notifyMinorWarning";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "notifyWarning";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "notifyImportantWarning";
                break;
            }
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "notifyMinorInfo";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "logInfo";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "showNotificationAndHideExisting";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "hideAllNotificationsByType";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "addShowDetailsAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 20: 
            case 44: 
            case 47: 
            case 52: 
            case 66: 
            case 73: 
            case 87: 
            case 92: 
            case 97: 
            case 100: 
            case 101: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

