/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.actions.ActiveAnnotationGutter;
import com.intellij.openapi.vcs.actions.ColorMode;
import com.intellij.openapi.vcs.actions.ShowAnnotationColorsAction;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.TextAnnotationPresentation;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnnotationFieldGutter
implements ActiveAnnotationGutter {
    @NotNull
    protected final FileAnnotation myAnnotation;
    @NotNull
    private final TextAnnotationPresentation myPresentation;
    @Nullable
    private final Couple<? extends Map<VcsRevisionNumber, Color>> myColorScheme;

    AnnotationFieldGutter(@NotNull FileAnnotation annotation, @NotNull TextAnnotationPresentation presentation2, @Nullable Couple<? extends Map<VcsRevisionNumber, Color>> colorScheme) {
        if (annotation == null) {
            AnnotationFieldGutter.$$$reportNull$$$0(0);
        }
        if (presentation2 == null) {
            AnnotationFieldGutter.$$$reportNull$$$0(1);
        }
        this.myAnnotation = annotation;
        this.myPresentation = presentation2;
        this.myColorScheme = colorScheme;
    }

    @NotNull
    public FileAnnotation getFileAnnotation() {
        FileAnnotation fileAnnotation = this.myAnnotation;
        if (fileAnnotation == null) {
            AnnotationFieldGutter.$$$reportNull$$$0(2);
        }
        return fileAnnotation;
    }

    @NotNull
    public TextAnnotationPresentation getPresentation() {
        TextAnnotationPresentation textAnnotationPresentation = this.myPresentation;
        if (textAnnotationPresentation == null) {
            AnnotationFieldGutter.$$$reportNull$$$0(3);
        }
        return textAnnotationPresentation;
    }

    public boolean isGutterAction() {
        return false;
    }

    @Nullable
    public String getToolTip(int line, Editor editor2) {
        return null;
    }

    public void doAction(int line) {
    }

    public Cursor getCursor(int line) {
        return Cursor.getDefaultCursor();
    }

    public EditorFontType getStyle(int line, Editor editor2) {
        return this.myPresentation.getFontType(line);
    }

    @Nullable
    public ColorKey getColor(int line, Editor editor2) {
        return this.myPresentation.getColor(line);
    }

    public List<AnAction> getPopupActions(int line, Editor editor2) {
        return this.myPresentation.getActions(line);
    }

    public void gutterClosed() {
        this.myPresentation.gutterClosed();
    }

    @Nullable
    public Color getBgColor(int line, Editor editor2) {
        Map colorMap;
        if (this.myColorScheme == null) {
            return null;
        }
        ColorMode type = ShowAnnotationColorsAction.getType();
        Map map2 = colorMap = type == ColorMode.AUTHOR ? (Map)this.myColorScheme.second : (Map)this.myColorScheme.first;
        if (colorMap == null || type == ColorMode.NONE) {
            return null;
        }
        VcsRevisionNumber number = this.myAnnotation.getLineRevisionNumber(line);
        if (number == null) {
            return null;
        }
        return (Color)colorMap.get(number);
    }

    public boolean isShowByDefault() {
        return true;
    }

    public boolean isAvailable() {
        return VcsUtil.isAspectAvailableByDefault((String)this.getID(), (boolean)this.isShowByDefault());
    }

    @NonNls
    @Nullable
    public String getID() {
        return null;
    }

    @NlsContexts.ListItem
    @Nullable
    public String getDisplayName() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/AnnotationFieldGutter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotationFieldGutter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileAnnotation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

