/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.TextAnnotationPresentation;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowAnnotateOperationsPopup
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowAnnotateOperationsPopup.$$$reportNull$$$0(0);
        }
        List<AnAction> actions2 = ShowAnnotateOperationsPopup.getActions(e.getDataContext());
        e.getPresentation().setEnabled(actions2 != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        List<AnAction> actions2;
        if (e == null) {
            ShowAnnotateOperationsPopup.$$$reportNull$$$0(1);
        }
        if ((actions2 = ShowAnnotateOperationsPopup.getActions(e.getDataContext())) == null) {
            return;
        }
        String title2 = this.getTemplatePresentation().getText();
        DefaultActionGroup group2 = new DefaultActionGroup(actions2);
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(title2, (ActionGroup)group2, e.getDataContext(), JBPopupFactory.ActionSelectionAid.NUMBERING, true);
        popup2.showInBestPositionFor(e.getDataContext());
    }

    @Nullable
    private static List<AnAction> getActions(@NotNull DataContext context2) {
        Editor editor2;
        if (context2 == null) {
            ShowAnnotateOperationsPopup.$$$reportNull$$$0(2);
        }
        if ((editor2 = (Editor)context2.getData(CommonDataKeys.EDITOR)) == null) {
            return null;
        }
        TextAnnotationPresentation presentation2 = AnnotateToggleAction.getAnnotationPresentation(editor2);
        if (presentation2 == null) {
            return null;
        }
        int line = editor2.getCaretModel().getLogicalPosition().line;
        List actions2 = presentation2.getActions(line);
        FileAnnotation fileAnnotation = AnnotateToggleAction.getFileAnnotation(editor2);
        if (fileAnnotation != null) {
            int annotationLine = presentation2.getAnnotationLine(line);
            actions2 = ContainerUtil.prepend(actions2, (Object[])new AnAction[]{new ShowAffectedFilesAction(fileAnnotation, annotationLine)});
        }
        return (List)ContainerUtil.nullize(actions2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/ShowAnnotateOperationsPopup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ShowAffectedFilesAction
    extends DumbAwareAction {
        private final FileAnnotation myFileAnnotation;
        private final int myLine;
        private final FileAnnotation.RevisionChangesProvider myChangesProvider;
        private final VcsRevisionNumber myRevisionNumber;
        private final VirtualFile myFile;

        private ShowAffectedFilesAction(@NotNull FileAnnotation fileAnnotation, int line) {
            if (fileAnnotation == null) {
                ShowAffectedFilesAction.$$$reportNull$$$0(0);
            }
            super(VcsBundle.messagePointer((String)"action.ShowAffectedFilesAction.show.affected.files.text", (Object[])new Object[0]), AllIcons.Actions.ListChanges);
            this.myFileAnnotation = fileAnnotation;
            this.myLine = line;
            this.myChangesProvider = fileAnnotation.getRevisionsChangesProvider();
            this.myRevisionNumber = fileAnnotation.getLineRevisionNumber(this.myLine);
            this.myFile = fileAnnotation.getFile();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowAffectedFilesAction.$$$reportNull$$$0(1);
            }
            boolean visible = this.myChangesProvider != null && this.myFile != null;
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && this.myRevisionNumber != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowAffectedFilesAction.$$$reportNull$$$0(2);
            }
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)this.myFile);
            AbstractVcsHelperImpl.loadAndShowCommittedChangesDetails(this.myFileAnnotation.getProject(), this.myRevisionNumber, filePath, () -> this.myChangesProvider.getChangesIn(this.myLine));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileAnnotation";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/actions/ShowAnnotateOperationsPopup$ShowAffectedFilesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Group
    extends ActionGroup
    implements DumbAware {
        public boolean hideIfNoVisibleChildren() {
            return true;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (e == null) {
                if (AnAction.EMPTY_ARRAY == null) {
                    Group.$$$reportNull$$$0(0);
                }
                return AnAction.EMPTY_ARRAY;
            }
            List<AnAction> actions2 = ShowAnnotateOperationsPopup.getActions(e.getDataContext());
            AnAction[] anActionArray = actions2 != null ? actions2.toArray(AnAction.EMPTY_ARRAY) : AnAction.EMPTY_ARRAY;
            if (anActionArray == null) {
                Group.$$$reportNull$$$0(1);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/ShowAnnotateOperationsPopup$Group", "getChildren"));
        }
    }
}

