/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ChangesViewDiffPreviewProcessorKt;
import com.intellij.openapi.vcs.changes.ChangesViewUserObjectTag;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Iterator;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0014J\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0005J\b\u0010\u0011\u001a\u00020\u0005H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewDiffPreviewProcessor;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor;", "changesView", "Lcom/intellij/openapi/vcs/changes/ui/ChangesListView;", "isInEditor", "", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesListView;Z)V", "fireDiffSettingsChanged", "", "getAllChanges", "Ljava/util/stream/Stream;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "getSelectedChanges", "selectChange", "change", "setAllowExcludeFromCommit", "value", "showAllChangesForEmptySelection", "intellij.platform.vcs.impl"})
final class ChangesViewDiffPreviewProcessor
extends ChangeViewDiffRequestProcessor {
    private final ChangesListView changesView;

    @NotNull
    public Stream<ChangeViewDiffRequestProcessor.Wrapper> getSelectedChanges() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        StreamEx streamEx = StreamEx.of((Iterator)this.changesView.getSelectedChangesNodes().iterator());
        Intrinsics.checkNotNullExpressionValue((Object)streamEx, (String)"StreamEx.of(changesView.\u2026dChangesNodes.iterator())");
        Stream stream = (Stream)streamEx;
        StreamEx streamEx2 = StreamEx.of((Iterator)this.changesView.getSelectedUnversionedFiles().iterator());
        Intrinsics.checkNotNullExpressionValue((Object)streamEx2, (String)"StreamEx.of(changesView.\u2026ersionedFiles.iterator())");
        return ChangesViewDiffPreviewProcessorKt.access$wrap(project, stream, (Stream)streamEx2);
    }

    @NotNull
    public Stream<ChangeViewDiffRequestProcessor.Wrapper> getAllChanges() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        StreamEx streamEx = StreamEx.of((Iterator)this.changesView.getChangesNodes().iterator());
        Intrinsics.checkNotNullExpressionValue((Object)streamEx, (String)"StreamEx.of(changesView.changesNodes.iterator())");
        Stream stream = (Stream)streamEx;
        Stream<FilePath> stream2 = this.changesView.getUnversionedFiles();
        Intrinsics.checkNotNullExpressionValue(stream2, (String)"changesView.unversionedFiles");
        return ChangesViewDiffPreviewProcessorKt.access$wrap(project, stream, stream2);
    }

    @Override
    protected boolean showAllChangesForEmptySelection() {
        return false;
    }

    @Override
    protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            Object object = change.getUserObject();
            ChangesBrowserNode.Tag tag2 = change.getTag();
            if (!(tag2 instanceof ChangesViewUserObjectTag)) {
                tag2 = null;
            }
            ChangesViewUserObjectTag changesViewUserObjectTag = (ChangesViewUserObjectTag)tag2;
            TreePath treePath = this.changesView.findNodePathInTree(object, changesViewUserObjectTag != null ? changesViewUserObjectTag.getUserObject() : null);
            if (treePath == null) break block1;
            TreePath treePath2 = treePath;
            boolean bl = false;
            boolean bl2 = false;
            TreePath it = treePath2;
            boolean bl3 = false;
            TreeUtil.selectPath((JTree)((JTree)((Object)this.changesView)), (TreePath)it, (boolean)false);
            this.refresh(false);
        }
    }

    public final void setAllowExcludeFromCommit(boolean value2) {
        if (DiffUtil.isUserDataFlagSet(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, (UserDataHolder)this.getContext()) == value2) {
            return;
        }
        this.getContext().putUserData(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, (Object)value2);
        this.fireDiffSettingsChanged();
    }

    public final void fireDiffSettingsChanged() {
        this.dropCaches();
        this.updateRequest(true);
    }

    public ChangesViewDiffPreviewProcessor(@NotNull ChangesListView changesView2, boolean isInEditor) {
        Intrinsics.checkNotNullParameter((Object)changesView2, (String)"changesView");
        super(changesView2.getProject(), isInEditor ? "Default" : "ChangesView");
        this.changesView = changesView2;
        if (!isInEditor) {
            Wrapper wrapper2 = this.myContentPanel;
            Intrinsics.checkNotNullExpressionValue((Object)wrapper2, (String)"myContentPanel");
            wrapper2.setBorder(IdeBorderFactory.createBorder((int)2));
        }
        this.putContextUserData(DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL, true);
    }
}

