/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class EditAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            EditAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        List files2 = (List)e.getData(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY);
        assert (project != null);
        assert (files2 != null);
        EditAction.editFilesAndShowErrors(project, files2);
    }

    public static void editFilesAndShowErrors(@NotNull Project project, @NotNull List<? extends VirtualFile> files2) {
        if (project == null) {
            EditAction.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            EditAction.$$$reportNull$$$0(2);
        }
        ArrayList exceptions = new ArrayList();
        EditAction.editFiles(project, files2, exceptions);
        if (!exceptions.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, VcsBundle.message((String)"edit.errors", (Object[])new Object[0]));
        }
    }

    public static void editFiles(@NotNull Project project, @NotNull List<? extends VirtualFile> files2, List<? super VcsException> exceptions) {
        if (project == null) {
            EditAction.$$$reportNull$$$0(3);
        }
        if (files2 == null) {
            EditAction.$$$reportNull$$$0(4);
        }
        ChangesUtil.processVirtualFilesByVcs((Project)project, files2, (vcs, items) -> {
            EditFileProvider provider2 = vcs.getEditFileProvider();
            if (provider2 == null) {
                return;
            }
            try {
                provider2.editFiles(VfsUtilCore.toVirtualFileArray((Collection)items));
            }
            catch (VcsException e1) {
                exceptions.add(e1);
            }
            VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
            FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project);
            for (VirtualFile file2 : items) {
                vcsDirtyScopeManager.fileDirty(file2);
                fileStatusManager.fileStatusChanged(file2);
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        List files2;
        if (e == null) {
            EditAction.$$$reportNull$$$0(5);
        }
        boolean enabled = (files2 = (List)e.getData(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY)) != null && !files2.isEmpty();
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/EditAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "editFilesAndShowErrors";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "editFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

