/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.commit.CommitMode;
import com.intellij.vcs.commit.CommitModeManagerKt;
import com.intellij.vcsUtil.RollbackUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/RollbackFilesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "intellij.platform.vcs.impl"})
public final class RollbackFilesAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabledAndVisible(false);
        if (!Companion.isPreferCheckboxesOverSelection()) {
            return;
        }
        if (!(CommitModeManagerKt.getProjectCommitMode(e) instanceof CommitMode.NonModalCommitMode)) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        ChangesListView changesListView = (ChangesListView)e.getData(ChangesListView.DATA_KEY);
        if (changesListView == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)changesListView, (String)"e.getData(ChangesListView.DATA_KEY) ?: return");
        ChangesListView changesView2 = changesListView;
        List list2 = changesView2.getSelectedChanges().take(2).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"changesView.selectedChanges.take(2).toList()");
        List changes = list2;
        Presentation presentation3 = e.getPresentation();
        boolean bl = false;
        boolean bl2 = false;
        Presentation $this$with = presentation3;
        boolean bl3 = false;
        $this$with.setVisible(true);
        Collection collection = changes;
        boolean bl4 = false;
        $this$with.setEnabled(!collection.isEmpty());
        $this$with.setText(VcsBundle.message((String)"action.for.file.with.dialog.text", (Object[])new Object[]{RollbackUtil.getRollbackOperationName(project2), changes.size()}));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!Companion.checkClmActive(e)) {
            return;
        }
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project!!");
        Project project2 = project;
        Object object = e.getData(VcsDataKeys.CHANGES);
        Intrinsics.checkNotNull((Object)object);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getData(VcsDataKeys.CHANGES)!!");
        List changes = ArraysKt.toList((Object[])((Object[])object));
        FileDocumentManager.getInstance().saveAllDocuments();
        RollbackChangesDialog.rollbackChanges(project2, changes);
    }

    @JvmStatic
    public static final boolean checkClmActive(@NotNull AnActionEvent e) {
        return Companion.checkClmActive(e);
    }

    @JvmStatic
    public static final boolean isPreferCheckboxesOverSelection() {
        return Companion.isPreferCheckboxesOverSelection();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/RollbackFilesAction$Companion;", "", "()V", "checkClmActive", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isPreferCheckboxesOverSelection", "intellij.platform.vcs.impl"})
    public static final class Companion {
        @JvmStatic
        public final boolean checkClmActive(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return false");
            Project project2 = project;
            String title2 = Intrinsics.areEqual((Object)"ChangesViewToolbar", (Object)e.getPlace()) ? null : VcsBundle.message((String)"error.cant.perform.operation.now", (Object[])new Object[]{StringUtil.removeEllipsisSuffix((String)UIUtil.removeMnemonic((String)RollbackUtil.getRollbackOperationName(project2)))});
            return !ChangeListManager.getInstance((Project)project2).isFreezedWithNotification(title2);
        }

        @JvmStatic
        public final boolean isPreferCheckboxesOverSelection() {
            return Registry.is((String)"vcs.prefer.checkboxes.over.selection");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

