/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.DiffVcsDataKeys;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.impl.DiffViewerWrapper;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProvider;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffViewerWrapperProvider;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffRequest;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeUtils;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChangeDiffRequestProducer
implements DiffRequestProducer,
ChangeDiffRequestChain.Producer {
    private static final Logger LOG = Logger.getInstance(ChangeDiffRequestProducer.class);
    public static final Key<Change> CHANGE_KEY = Key.create((String)"DiffRequestPresentable.Change");
    public static final Key<Change> TAG_KEY = Key.create((String)"DiffRequestPresentable.Tag");
    @Nullable
    private final Project myProject;
    @NotNull
    private final Change myChange;
    @NotNull
    private final Map<Key<?>, Object> myChangeContext;

    private ChangeDiffRequestProducer(@Nullable Project project, @NotNull Change change, @NotNull Map<Key<?>, Object> changeContext) {
        if (change == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(0);
        }
        if (changeContext == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(1);
        }
        this.myChange = change;
        this.myProject = project;
        this.myChangeContext = changeContext;
    }

    @NotNull
    public Change getChange() {
        Change change = this.myChange;
        if (change == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(2);
        }
        return change;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getName() {
        String string = this.getFilePath().getPath();
        if (string == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public FilePath getFilePath() {
        FilePath filePath = ChangesUtil.getFilePath((Change)this.myChange);
        if (filePath == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(4);
        }
        return filePath;
    }

    @Override
    @NotNull
    public FileStatus getFileStatus() {
        FileStatus fileStatus = this.myChange.getFileStatus();
        if (fileStatus == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(5);
        }
        return fileStatus;
    }

    @Override
    @Nullable
    public ChangesBrowserNode.Tag getTag() {
        return (ChangesBrowserNode.Tag)ObjectUtils.tryCast((Object)this.myChangeContext.get(TAG_KEY), ChangesBrowserNode.Tag.class);
    }

    public static boolean isEquals(@NotNull Change change1, @NotNull Change change2) {
        if (change1 == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(6);
        }
        if (change2 == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(7);
        }
        if (!Comparing.equal((Object)ChangesUtil.getBeforePath((Change)change1), (Object)ChangesUtil.getBeforePath((Change)change2)) || !Comparing.equal((Object)ChangesUtil.getAfterPath((Change)change1), (Object)ChangesUtil.getAfterPath((Change)change2))) {
            return false;
        }
        for (ChangeDiffViewerWrapperProvider changeDiffViewerWrapperProvider : (ChangeDiffViewerWrapperProvider[])ChangeDiffViewerWrapperProvider.EP_NAME.getExtensions()) {
            ThreeState equals2 = changeDiffViewerWrapperProvider.isEquals(change1, change2);
            if (equals2 != ThreeState.NO) continue;
            return false;
        }
        for (ChangeDiffRequestProvider changeDiffRequestProvider : (ChangeDiffRequestProvider[])ChangeDiffRequestProvider.EP_NAME.getExtensions()) {
            ThreeState equals2 = changeDiffRequestProvider.isEquals(change1, change2);
            if (equals2 == ThreeState.YES) {
                return true;
            }
            if (equals2 != ThreeState.NO) continue;
            return false;
        }
        if (!Comparing.equal(change1.getClass(), change2.getClass())) {
            return false;
        }
        if (!Comparing.equal((Object)change1.getFileStatus(), (Object)change2.getFileStatus())) {
            return false;
        }
        if (!ChangeDiffRequestProducer.isEquals(change1.getBeforeRevision(), change2.getBeforeRevision())) {
            return false;
        }
        if (!ChangeDiffRequestProducer.isEquals(change1.getAfterRevision(), change2.getAfterRevision())) {
            return false;
        }
        if (change1 instanceof ChangeListChange || change2 instanceof ChangeListChange) {
            String changelistId2;
            assert (change1 instanceof ChangeListChange && change2 instanceof ChangeListChange);
            String changelistId1 = ((ChangeListChange)change1).getChangeListId();
            if (!Objects.equals(changelistId1, changelistId2 = ((ChangeListChange)change2).getChangeListId())) {
                return false;
            }
        }
        return true;
    }

    private static boolean isEquals(@Nullable ContentRevision revision1, @Nullable ContentRevision revision2) {
        if (Comparing.equal((Object)revision1, (Object)revision2)) {
            return true;
        }
        if (revision1 instanceof CurrentContentRevision && revision2 instanceof CurrentContentRevision) {
            VirtualFile vFile1 = ((CurrentContentRevision)revision1).getVirtualFile();
            VirtualFile vFile2 = ((CurrentContentRevision)revision2).getVirtualFile();
            return Comparing.equal((Object)vFile1, (Object)vFile2);
        }
        return false;
    }

    public static int hashCode(@NotNull Change change) {
        if (change == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(8);
        }
        return ChangeDiffRequestProducer.hashCode(change.getBeforeRevision()) + 31 * ChangeDiffRequestProducer.hashCode(change.getAfterRevision());
    }

    private static int hashCode(@Nullable ContentRevision revision) {
        return revision != null ? revision.getFile().hashCode() : 0;
    }

    @Nullable
    public static ChangeDiffRequestProducer create(@Nullable Project project, @NotNull Change change) {
        if (change == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(9);
        }
        return ChangeDiffRequestProducer.create(project, change, null);
    }

    @Nullable
    public static ChangeDiffRequestProducer create(@Nullable Project project, @NotNull Change change, @Nullable Map<Key<?>, Object> changeContext) {
        if (change == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(10);
        }
        if (!ChangeDiffRequestProducer.canCreate(project, change)) {
            return null;
        }
        return new ChangeDiffRequestProducer(project, change, ContainerUtil.notNullize(changeContext));
    }

    public static boolean canCreate(@Nullable Project project, @NotNull Change change) {
        if (change == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(11);
        }
        for (ChangeDiffViewerWrapperProvider changeDiffViewerWrapperProvider : (ChangeDiffViewerWrapperProvider[])ChangeDiffViewerWrapperProvider.EP_NAME.getExtensions()) {
            if (!changeDiffViewerWrapperProvider.canCreate(project, change)) continue;
            return true;
        }
        for (ChangeDiffRequestProvider changeDiffRequestProvider : (ChangeDiffRequestProvider[])ChangeDiffRequestProvider.EP_NAME.getExtensions()) {
            if (!changeDiffRequestProvider.canCreate(project, change)) continue;
            return true;
        }
        ContentRevision bRev = change.getBeforeRevision();
        ContentRevision aRev = change.getAfterRevision();
        if (bRev == null && aRev == null) {
            return false;
        }
        if (bRev != null && bRev.getFile().isDirectory()) {
            return false;
        }
        return aRev == null || !aRev.getFile().isDirectory();
    }

    @NotNull
    public DiffRequest process(@NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator2) throws DiffRequestProducerException, ProcessCanceledException {
        if (context2 == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(12);
        }
        if (indicator2 == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(13);
        }
        try {
            return this.loadCurrentContents(context2, indicator2);
        }
        catch (DiffRequestProducerException | ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            throw new DiffRequestProducerException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private DiffRequest loadCurrentContents(@NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator2) throws DiffRequestProducerException {
        if (context2 == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(14);
        }
        if (indicator2 == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(15);
        }
        DiffRequestProducerException wrapperException = null;
        DiffRequestProducerException requestException = null;
        DiffViewerWrapper wrapper2 = null;
        try {
            void var8_12;
            ChangeDiffViewerWrapperProvider[] changeDiffViewerWrapperProviderArray = (ChangeDiffViewerWrapperProvider[])ChangeDiffViewerWrapperProvider.EP_NAME.getExtensions();
            int n = changeDiffViewerWrapperProviderArray.length;
            boolean bl = false;
            while (var8_12 < n) {
                ChangeDiffViewerWrapperProvider provider2 = changeDiffViewerWrapperProviderArray[var8_12];
                if (provider2.canCreate(this.myProject, this.myChange)) {
                    wrapper2 = provider2.process(this, context2, indicator2);
                    break;
                }
                ++var8_12;
            }
        }
        catch (DiffRequestProducerException e) {
            wrapperException = e;
        }
        ErrorDiffRequest request2 = null;
        try {
            for (ChangeDiffRequestProvider provider3 : (ChangeDiffRequestProvider[])ChangeDiffRequestProvider.EP_NAME.getExtensions()) {
                if (!provider3.canCreate(this.myProject, this.myChange)) continue;
                request2 = provider3.process(this, context2, indicator2);
                break;
            }
            if (request2 == null) {
                request2 = this.createRequest(this.myProject, this.myChange, context2, indicator2);
            }
        }
        catch (DiffRequestProducerException e) {
            requestException = e;
        }
        if (requestException != null && wrapperException != null) {
            String message2 = requestException.getMessage() + "\n\n" + wrapperException.getMessage();
            throw new DiffRequestProducerException(message2);
        }
        if (requestException != null) {
            request2 = new ErrorDiffRequest(ChangeDiffRequestProducer.getRequestTitle(this.myChange), (Throwable)requestException);
            LOG.info("Request: " + requestException.getMessage());
        }
        if (wrapperException != null) {
            LOG.info("Wrapper: " + wrapperException.getMessage());
        }
        request2.putUserData(CHANGE_KEY, (Object)this.myChange);
        request2.putUserData(DiffViewerWrapper.KEY, wrapper2);
        for (Map.Entry entry2 : this.myChangeContext.entrySet()) {
            request2.putUserData((Key)entry2.getKey(), entry2.getValue());
        }
        DiffUtil.putDataKey((UserDataHolder)request2, VcsDataKeys.CURRENT_CHANGE, this.myChange);
        ErrorDiffRequest errorDiffRequest = request2;
        if (errorDiffRequest == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(16);
        }
        return errorDiffRequest;
    }

    @NotNull
    private DiffRequest createRequest(@Nullable Project project, @NotNull Change change, @NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator2) throws DiffRequestProducerException {
        if (change == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(17);
        }
        if (context2 == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(18);
        }
        if (indicator2 == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(19);
        }
        if (ChangesUtil.isTextConflictingChange((Change)change)) {
            return ChangeDiffRequestProducer.createMergeRequest(project, change, context2);
        }
        SimpleDiffRequest request2 = this.createSimpleRequest(project, change, context2, indicator2);
        LocalChangeListDiffRequest localRequest = ChangeDiffRequestProducer.createLocalChangeListRequest(project, change, (ContentDiffRequest)request2);
        if (localRequest != null) {
            LocalChangeListDiffRequest localChangeListDiffRequest = localRequest;
            if (localChangeListDiffRequest == null) {
                ChangeDiffRequestProducer.$$$reportNull$$$0(20);
            }
            return localChangeListDiffRequest;
        }
        SimpleDiffRequest simpleDiffRequest = request2;
        if (simpleDiffRequest == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(21);
        }
        return simpleDiffRequest;
    }

    @NotNull
    private static DiffRequest createMergeRequest(@Nullable Project project, @NotNull Change change, @NotNull UserDataHolder context2) throws DiffRequestProducerException {
        SimpleDiffRequest simpleDiffRequest;
        FilePath path2;
        VirtualFile file2;
        if (change == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(22);
        }
        if (context2 == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(23);
        }
        if ((file2 = (path2 = ChangesUtil.getFilePath((Change)change)).getVirtualFile()) == null) {
            file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(path2.getPath());
        }
        if (file2 == null) {
            throw new DiffRequestProducerException(DiffBundle.message((String)"error.cant.show.merge.file.not.found", (Object[])new Object[0]));
        }
        if (project == null) {
            throw new DiffRequestProducerException(DiffBundle.message((String)"error.cant.show.merge.project.not.found", (Object[])new Object[0]));
        }
        AbstractVcs vcs = ChangesUtil.getVcsForChange((Change)change, (Project)project);
        if (vcs == null || vcs.getMergeProvider() == null) {
            throw new DiffRequestProducerException(DiffBundle.message((String)"error.cant.show.merge.operation.not.supported", (Object[])new Object[0]));
        }
        try {
            MergeData mergeData = vcs.getMergeProvider().loadRevisions(file2);
            ContentRevision bRev = change.getBeforeRevision();
            ContentRevision aRev = change.getAfterRevision();
            String beforeRevisionTitle = ChangeDiffRequestProducer.getRevisionTitle(bRev, ChangeDiffRequestProducer.getYourVersion());
            String afterRevisionTitle = ChangeDiffRequestProducer.getRevisionTitle(aRev, ChangeDiffRequestProducer.getServerVersion());
            String title2 = DiffRequestFactory.getInstance().getTitle(file2);
            List<String> titles = Arrays.asList(beforeRevisionTitle, ChangeDiffRequestProducer.getBaseVersion(), afterRevisionTitle);
            DiffContentFactory contentFactory = DiffContentFactory.getInstance();
            List<DiffContent> contents = Arrays.asList(contentFactory.createFromBytes(project, mergeData.CURRENT, file2), contentFactory.createFromBytes(project, mergeData.ORIGINAL, file2), contentFactory.createFromBytes(project, mergeData.LAST, file2));
            SimpleDiffRequest request2 = new SimpleDiffRequest(title2, contents, titles);
            MergeUtils.putRevisionInfos((DiffRequest)request2, mergeData);
            simpleDiffRequest = request2;
        }
        catch (VcsException | IOException e) {
            LOG.info(e);
            throw new DiffRequestProducerException(e);
        }
        if (simpleDiffRequest == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(24);
        }
        return simpleDiffRequest;
    }

    @NotNull
    private SimpleDiffRequest createSimpleRequest(@Nullable Project project, @NotNull Change change, @NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator2) throws DiffRequestProducerException {
        if (change == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(25);
        }
        if (context2 == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(26);
        }
        if (indicator2 == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(27);
        }
        ContentRevision bRev = change.getBeforeRevision();
        ContentRevision aRev = change.getAfterRevision();
        if (bRev == null && aRev == null) {
            LOG.warn("Both revision contents are empty");
            throw new DiffRequestProducerException(DiffBundle.message((String)"error.cant.show.diff.content.not.found", (Object[])new Object[0]));
        }
        if (bRev != null) {
            ChangeDiffRequestProducer.checkContentRevision(project, bRev, context2, indicator2);
        }
        if (aRev != null) {
            ChangeDiffRequestProducer.checkContentRevision(project, aRev, context2, indicator2);
        }
        String title2 = ChangeDiffRequestProducer.getRequestTitle(change);
        indicator2.setIndeterminate(true);
        DiffContent content1 = ChangeDiffRequestProducer.createContent(project, bRev, context2, indicator2);
        DiffContent content2 = ChangeDiffRequestProducer.createContent(project, aRev, context2, indicator2);
        String userLeftRevisionTitle = (String)this.myChangeContext.get(DiffUserDataKeysEx.VCS_DIFF_LEFT_CONTENT_TITLE);
        String beforeRevisionTitle = userLeftRevisionTitle != null ? userLeftRevisionTitle : ChangeDiffRequestProducer.getRevisionTitle(bRev, ChangeDiffRequestProducer.getBaseVersion());
        String userRightRevisionTitle = (String)this.myChangeContext.get(DiffUserDataKeysEx.VCS_DIFF_RIGHT_CONTENT_TITLE);
        String afterRevisionTitle = userRightRevisionTitle != null ? userRightRevisionTitle : ChangeDiffRequestProducer.getRevisionTitle(aRev, ChangeDiffRequestProducer.getYourVersion());
        SimpleDiffRequest request2 = new SimpleDiffRequest(title2, content1, content2, beforeRevisionTitle, afterRevisionTitle);
        boolean bRevCurrent = bRev instanceof CurrentContentRevision;
        boolean aRevCurrent = aRev instanceof CurrentContentRevision;
        if (bRevCurrent && !aRevCurrent) {
            request2.putUserData(DiffUserDataKeys.MASTER_SIDE, (Object)Side.LEFT);
        }
        if (!bRevCurrent && aRevCurrent) {
            request2.putUserData(DiffUserDataKeys.MASTER_SIDE, (Object)Side.RIGHT);
        }
        SimpleDiffRequest simpleDiffRequest = request2;
        if (simpleDiffRequest == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(28);
        }
        return simpleDiffRequest;
    }

    @Nullable
    private static LocalChangeListDiffRequest createLocalChangeListRequest(@Nullable Project project, @NotNull Change change, @NotNull ContentDiffRequest request2) {
        if (change == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(29);
        }
        if (request2 == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(30);
        }
        if (project == null) {
            return null;
        }
        if (!(change instanceof ChangeListChange)) {
            return null;
        }
        ChangeListChange changeListChange = (ChangeListChange)change;
        List contents = request2.getContents();
        if (contents.size() != 2) {
            return null;
        }
        DocumentContent content1 = (DocumentContent)ObjectUtils.tryCast((Object)Side.LEFT.select(contents), DocumentContent.class);
        DocumentContent content2 = (DocumentContent)ObjectUtils.tryCast((Object)Side.RIGHT.select(contents), DocumentContent.class);
        if (content1 == null || content2 == null) {
            return null;
        }
        if (!(content2 instanceof FileContent)) {
            return null;
        }
        VirtualFile virtualFile2 = ((FileContent)content2).getFile();
        if (!LineStatusTrackerManager.getInstance(project).arePartialChangelistsEnabled(virtualFile2)) {
            return null;
        }
        return new LocalChangeListDiffRequest(project, virtualFile2, changeListChange.getChangeListId(), changeListChange.getChangeListName(), request2);
    }

    @NotNull
    @Nls
    public static String getRequestTitle(@NotNull Change change) {
        if (change == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(31);
        }
        FilePath bPath = ChangesUtil.getBeforePath((Change)change);
        FilePath aPath = ChangesUtil.getAfterPath((Change)change);
        String string = DiffRequestFactoryImpl.getTitle(bPath, aPath, " -> ");
        if (string == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    @Nls
    public static String getRevisionTitle(@Nullable ContentRevision revision, @NotNull @Nls String defaultValue) {
        if (defaultValue == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(33);
        }
        if (revision == null) {
            String string = defaultValue;
            if (string == null) {
                ChangeDiffRequestProducer.$$$reportNull$$$0(34);
            }
            return string;
        }
        String title2 = revision.getRevisionNumber().asString();
        String string = title2.isEmpty() ? defaultValue : title2;
        if (string == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    public static DiffContent createContent(@Nullable Project project, @Nullable ContentRevision revision, @NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator2) throws DiffRequestProducerException {
        DocumentContent documentContent;
        DiffContentFactoryEx contentFactory;
        FilePath filePath;
        block15: {
            block14: {
                if (context2 == null) {
                    ChangeDiffRequestProducer.$$$reportNull$$$0(36);
                }
                if (indicator2 == null) {
                    ChangeDiffRequestProducer.$$$reportNull$$$0(37);
                }
                indicator2.checkCanceled();
                if (revision != null) break block14;
                EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
                if (emptyContent == null) {
                    ChangeDiffRequestProducer.$$$reportNull$$$0(38);
                }
                return emptyContent;
            }
            filePath = revision.getFile();
            contentFactory = DiffContentFactoryEx.getInstanceEx();
            if (!(revision instanceof CurrentContentRevision)) break block15;
            VirtualFile vFile = ((CurrentContentRevision)revision).getVirtualFile();
            if (vFile == null || !vFile.isValid()) {
                throw new DiffRequestProducerException(DiffBundle.message((String)"error.cant.show.diff.cant.load.revision.content", (Object[])new Object[0]));
            }
            DiffContent diffContent = contentFactory.create(project, vFile);
            if (diffContent == null) {
                ChangeDiffRequestProducer.$$$reportNull$$$0(39);
            }
            return diffContent;
        }
        try {
            DocumentContent content2;
            if (revision instanceof ByteBackedContentRevision) {
                byte[] revisionContent = ((ByteBackedContentRevision)revision).getContentAsBytes();
                if (revisionContent == null) {
                    throw new DiffRequestProducerException(DiffBundle.message((String)"error.cant.show.diff.cant.load.revision.content", (Object[])new Object[0]));
                }
                content2 = contentFactory.createFromBytes(project, revisionContent, filePath);
            } else {
                String revisionContent = revision.getContent();
                if (revisionContent == null) {
                    throw new DiffRequestProducerException(DiffBundle.message((String)"error.cant.show.diff.cant.load.revision.content", (Object[])new Object[0]));
                }
                content2 = contentFactory.create(project, revisionContent, filePath);
            }
            content2.putUserData(DiffVcsDataKeys.REVISION_INFO, (Object)Pair.create((Object)revision.getFile(), (Object)revision.getRevisionNumber()));
            documentContent = content2;
        }
        catch (VcsException | IOException e) {
            LOG.info(e);
            throw new DiffRequestProducerException(e);
        }
        if (documentContent == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(40);
        }
        return documentContent;
    }

    public static void checkContentRevision(@Nullable Project project, @NotNull ContentRevision rev, @NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator2) throws DiffRequestProducerException {
        if (rev == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(41);
        }
        if (context2 == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(42);
        }
        if (indicator2 == null) {
            ChangeDiffRequestProducer.$$$reportNull$$$0(43);
        }
        if (rev.getFile().isDirectory()) {
            throw new DiffRequestProducerException(DiffBundle.message((String)"error.cant.show.diff.cant.show.for.directory", (Object[])new Object[0]));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeDiffRequestProducer producer = (ChangeDiffRequestProducer)o;
        return ChangeDiffRequestProducer.isEquals(producer.myChange, this.myChange);
    }

    public int hashCode() {
        return ChangeDiffRequestProducer.hashCode(this.myChange);
    }

    @Nls
    public static String getYourVersion() {
        return DiffBundle.message((String)"merge.version.title.our", (Object[])new Object[0]);
    }

    @Nls
    public static String getServerVersion() {
        return DiffBundle.message((String)"merge.version.title.their", (Object[])new Object[0]);
    }

    @Nls
    public static String getBaseVersion() {
        return DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]);
    }

    @Nls
    public static String getMergedVersion() {
        return DiffBundle.message((String)"merge.version.title.merged", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 16: 
            case 20: 
            case 21: 
            case 24: 
            case 28: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 16: 
            case 20: 
            case 21: 
            case 24: 
            case 28: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 16: 
            case 20: 
            case 21: 
            case 24: 
            case 28: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change2";
                break;
            }
            case 12: 
            case 14: 
            case 18: 
            case 23: 
            case 26: 
            case 36: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 15: 
            case 19: 
            case 27: 
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rev";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStatus";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCurrentContents";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequest";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createMergeRequest";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimpleRequest";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestTitle";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionTitle";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 16: 
            case 20: 
            case 21: 
            case 24: 
            case 28: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEquals";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hashCode";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canCreate";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadCurrentContents";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createRequest";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createMergeRequest";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleRequest";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createLocalChangeListRequest";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getRequestTitle";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionTitle";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createContent";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "checkContentRevision";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 16: 
            case 20: 
            case 21: 
            case 24: 
            case 28: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

