/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.combined.CombinedDiffRequest;
import com.intellij.diff.tools.combined.CombinedDiffRequestProducer;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangesComparator;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J,\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/CombinedChangeDiffRequestProducer;", "Lcom/intellij/diff/tools/combined/CombinedDiffRequestProducer;", "project", "Lcom/intellij/openapi/project/Project;", "producers", "", "Lcom/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getProducers", "()Ljava/util/List;", "createChildRequest", "Lcom/intellij/diff/tools/combined/CombinedDiffRequest$ChildDiffRequest;", "producer", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getFilesSize", "", "getName", "", "process", "Lcom/intellij/diff/requests/DiffRequest;", "intellij.platform.vcs.impl"})
public final class CombinedChangeDiffRequestProducer
implements CombinedDiffRequestProducer {
    private final Project project;
    @NotNull
    private final List<ChangeDiffRequestProducer> producers;

    @Override
    public int getFilesSize() {
        return this.producers.size();
    }

    @NotNull
    public String getName() {
        String string = VcsBundle.message((String)"changes.combined.diff", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VcsBundle.message(\"changes.combined.diff\")");
        return string;
    }

    @NotNull
    public DiffRequest process(@NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        Comparator<FilePath> comparator2 = ChangesComparator.getFilePathComparator(true);
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"ChangesComparator.getFilePathComparator(true)");
        Comparator<FilePath> filePathComparator = comparator2;
        List requests2 = SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.producers), (Function1)((Function1)new Function1<ChangeDiffRequestProducer, CombinedDiffRequest.ChildDiffRequest>(this, context2, indicator2){
            final /* synthetic */ CombinedChangeDiffRequestProducer this$0;
            final /* synthetic */ UserDataHolder $context;
            final /* synthetic */ ProgressIndicator $indicator;

            @Nullable
            public final CombinedDiffRequest.ChildDiffRequest invoke(@NotNull ChangeDiffRequestProducer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CombinedChangeDiffRequestProducer.access$createChildRequest(this.this$0, CombinedChangeDiffRequestProducer.access$getProject$p(this.this$0), it, this.$context, this.$indicator);
            }
            {
                this.this$0 = combinedChangeDiffRequestProducer;
                this.$context = userDataHolder;
                this.$indicator = progressIndicator;
                super(1);
            }
        })), (Comparator)new Comparator(filePathComparator){
            final /* synthetic */ Comparator $filePathComparator;

            public final int compare(CombinedDiffRequest.ChildDiffRequest r1, CombinedDiffRequest.ChildDiffRequest r2) {
                return this.$filePathComparator.compare(r1.getPath(), r2.getPath());
            }
            {
                this.$filePathComparator = comparator2;
            }
        }));
        return new CombinedDiffRequest(this.getName(), requests2);
    }

    private final CombinedDiffRequest.ChildDiffRequest createChildRequest(Project project, ChangeDiffRequestProducer producer, UserDataHolder context2, ProgressIndicator indicator2) {
        Change change = producer.getChange();
        Intrinsics.checkNotNullExpressionValue((Object)change, (String)"producer.change");
        Change change2 = change;
        ChangeDiffRequestProducer changeDiffRequestProducer = ChangeDiffRequestProducer.create(project, change2);
        if (changeDiffRequestProducer == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)changeDiffRequestProducer, (String)"ChangeDiffRequestProduce\u2026t, change) ?: return null");
        ChangeDiffRequestProducer requestProducer = changeDiffRequestProducer;
        DiffRequest diffRequest = requestProducer.process(context2, indicator2);
        if (!(diffRequest instanceof ContentDiffRequest)) {
            diffRequest = null;
        }
        ContentDiffRequest contentDiffRequest = (ContentDiffRequest)diffRequest;
        if (contentDiffRequest == null) {
            return null;
        }
        ContentDiffRequest childRequest = contentDiffRequest;
        DiffRequest diffRequest2 = (DiffRequest)childRequest;
        FilePath filePath = ChangesUtil.getFilePath((Change)change2);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"ChangesUtil.getFilePath(change)");
        FileStatus fileStatus = change2.getFileStatus();
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"change.fileStatus");
        return new CombinedDiffRequest.ChildDiffRequest(diffRequest2, filePath, fileStatus);
    }

    @NotNull
    public final List<ChangeDiffRequestProducer> getProducers() {
        return this.producers;
    }

    public CombinedChangeDiffRequestProducer(@Nullable Project project, @NotNull List<ChangeDiffRequestProducer> producers2) {
        Intrinsics.checkNotNullParameter(producers2, (String)"producers");
        this.project = project;
        this.producers = producers2;
    }

    public static final /* synthetic */ CombinedDiffRequest.ChildDiffRequest access$createChildRequest(CombinedChangeDiffRequestProducer $this, Project project, ChangeDiffRequestProducer producer, UserDataHolder context2, ProgressIndicator indicator2) {
        return $this.createChildRequest(project, producer, context2, indicator2);
    }

    public static final /* synthetic */ Project access$getProject$p(CombinedChangeDiffRequestProducer $this) {
        return $this.project;
    }
}

