/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.issueLinks;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class IssueLinkRenderer {
    private final SimpleColoredComponent myColoredComponent;
    private final IssueNavigationConfiguration myIssueNavigationConfiguration;

    public IssueLinkRenderer(Project project, SimpleColoredComponent coloredComponent) {
        this.myColoredComponent = coloredComponent;
        this.myIssueNavigationConfiguration = IssueNavigationConfiguration.getInstance((Project)project);
    }

    public List<String> appendTextWithLinks(@Nls String text2) {
        return this.appendTextWithLinks(text2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public List<String> appendTextWithLinks(@Nls String text2, @NotNull SimpleTextAttributes baseStyle2) {
        if (baseStyle2 == null) {
            IssueLinkRenderer.$$$reportNull$$$0(0);
        }
        ArrayList<String> pieces = new ArrayList<String>();
        SimpleTextAttributes linkAttributes = IssueLinkRenderer.getLinkAttributes(baseStyle2);
        IssueNavigationConfiguration.processTextWithLinks((String)text2, (List)this.myIssueNavigationConfiguration.findIssueLinks((CharSequence)text2), s -> {
            pieces.add((String)s);
            this.append((String)s, baseStyle2);
        }, (link2, target2) -> {
            pieces.add((String)link2);
            this.append((String)link2, linkAttributes, (String)target2);
        });
        return pieces;
    }

    private void append(@Nls String piece, SimpleTextAttributes baseStyle2) {
        this.myColoredComponent.append(piece, baseStyle2);
    }

    private void append(@Nls String piece, SimpleTextAttributes baseStyle2, @NlsSafe String targetUrl) {
        this.myColoredComponent.append(piece, baseStyle2, (Object)new SimpleColoredComponent.BrowserLauncherTag(targetUrl));
    }

    private static SimpleTextAttributes getLinkAttributes(@NotNull SimpleTextAttributes baseStyle2) {
        Color color;
        if (baseStyle2 == null) {
            IssueLinkRenderer.$$$reportNull$$$0(1);
        }
        int alpha = (color = baseStyle2.getFgColor()) != null ? color.getAlpha() : 255;
        Color linkColor = JBUI.CurrentTheme.Link.Foreground.ENABLED;
        Color resultColor = new Color(linkColor.getRed(), linkColor.getGreen(), linkColor.getBlue(), alpha);
        return new SimpleTextAttributes(baseStyle2.getStyle() | 0x10, resultColor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "baseStyle";
        objectArray2[1] = "com/intellij/openapi/vcs/changes/issueLinks/IssueLinkRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "appendTextWithLinks";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLinkAttributes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

