/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnshelvePatchDefaultExecutor
extends ApplyPatchDefaultExecutor {
    private static final Logger LOG = Logger.getInstance(UnshelvePatchDefaultExecutor.class);
    @NotNull
    private final ShelvedChangeList myCurrentShelveChangeList;

    public UnshelvePatchDefaultExecutor(@NotNull Project project, @NotNull ShelvedChangeList changeList) {
        if (project == null) {
            UnshelvePatchDefaultExecutor.$$$reportNull$$$0(0);
        }
        if (changeList == null) {
            UnshelvePatchDefaultExecutor.$$$reportNull$$$0(1);
        }
        super(project);
        this.myCurrentShelveChangeList = changeList;
    }

    @Override
    public void apply(final @NotNull List<? extends FilePatch> remaining, @NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress<?>> patchGroupsToApply, final @Nullable LocalChangeList localList, @Nullable String fileName, @Nullable ThrowableComputable<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo) {
        if (remaining == null) {
            UnshelvePatchDefaultExecutor.$$$reportNull$$$0(2);
        }
        if (patchGroupsToApply == null) {
            UnshelvePatchDefaultExecutor.$$$reportNull$$$0(3);
        }
        final CommitContext commitContext = new CommitContext();
        if (additionalInfo != null) {
            UnshelvePatchDefaultExecutor.applyAdditionalInfoBefore(this.myProject, additionalInfo, commitContext);
        }
        final Collection<PatchApplier> appliers = this.getPatchAppliers(patchGroupsToApply, localList, commitContext);
        new Task.Backgroundable(this.myProject, VcsBundle.message((String)"unshelve.changes.progress.title", (Object[])new Object[0])){
            ApplyPatchStatus myApplyPatchStatus;

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.myApplyPatchStatus = PatchApplier.executePatchGroup(appliers, localList);
            }

            public void onSuccess() {
                if (this.myApplyPatchStatus != ApplyPatchStatus.ABORT && this.myApplyPatchStatus != ApplyPatchStatus.FAILURE) {
                    UnshelvePatchDefaultExecutor.this.removeAppliedAndSaveRemainedIfNeeded(remaining, appliers, commitContext);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/patch/UnshelvePatchDefaultExecutor$1", "run"));
            }
        }.queue();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private void removeAppliedAndSaveRemainedIfNeeded(@NotNull List<? extends FilePatch> list2, @NotNull Collection<PatchApplier> collection, @NotNull CommitContext commitContext) {
        ShelveChangesManager shelveChangesManager;
        void commitContext2;
        void appliers;
        void remaining;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (remaining == null) {
            UnshelvePatchDefaultExecutor.$$$reportNull$$$0(4);
        }
        if (appliers == null) {
            UnshelvePatchDefaultExecutor.$$$reportNull$$$0(5);
        }
        if (commitContext2 == null) {
            UnshelvePatchDefaultExecutor.$$$reportNull$$$0(6);
        }
        if (!(shelveChangesManager = ShelveChangesManager.getInstance(this.myProject)).isRemoveFilesFromShelf()) {
            return;
        }
        try {
            ArrayList<FilePatch> patches2 = new ArrayList<FilePatch>((Collection<FilePatch>)remaining);
            for (PatchApplier applier : appliers) {
                patches2.addAll(applier.getRemainingPatches());
            }
            List binaries = ContainerUtil.mapNotNull(patches2, patch2 -> patch2 instanceof ShelvedBinaryFilePatch ? ((ShelvedBinaryFilePatch)((Object)patch2)).getShelvedBinaryFile() : null);
            shelveChangesManager.updateListAfterUnshelve(this.myCurrentShelveChangeList, patches2, binaries, (CommitContext)commitContext2);
        }
        catch (Exception e) {
            LOG.error("Couldn't update and store remaining patches", (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remaining";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchGroupsToApply";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appliers";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/UnshelvePatchDefaultExecutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "removeAppliedAndSaveRemainedIfNeeded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

