/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class ChangesBrowserSpecificFilePathsNode<T>
extends ChangesBrowserNode<T> {
    protected final boolean myIsMany;
    @NotNull
    protected final Runnable myDialogShower;
    private final int myManyFileCount;
    private final int myManyDirectoryCount;
    private SimpleTextAttributes myAttributes;

    protected ChangesBrowserSpecificFilePathsNode(T userObject, @NotNull Collection<FilePath> files2, @NotNull Runnable shower) {
        if (files2 == null) {
            ChangesBrowserSpecificFilePathsNode.$$$reportNull$$$0(0);
        }
        if (shower == null) {
            ChangesBrowserSpecificFilePathsNode.$$$reportNull$$$0(1);
        }
        super(userObject);
        this.myAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        this.myManyDirectoryCount = ContainerUtil.count(files2, it -> it.isDirectory());
        this.myManyFileCount = files2.size() - this.myManyDirectoryCount;
        this.myIsMany = ChangesBrowserSpecificFilePathsNode.isManyFiles(files2);
        this.myDialogShower = shower;
    }

    public final void setAttributes(@NotNull SimpleTextAttributes attributes2) {
        if (attributes2 == null) {
            ChangesBrowserSpecificFilePathsNode.$$$reportNull$$$0(2);
        }
        this.myAttributes = attributes2;
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected2, boolean expanded2, boolean hasFocus) {
        if (renderer2 == null) {
            ChangesBrowserSpecificFilePathsNode.$$$reportNull$$$0(3);
        }
        renderer2.append(this.getTextPresentation(), this.myAttributes);
        this.appendCount(renderer2);
        if (this.isManyFiles()) {
            renderer2.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            renderer2.append(VcsBundle.message((String)"changes.browse", (Object[])new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, this.myDialogShower);
        }
    }

    @Override
    public int getFileCount() {
        return this.myIsMany ? this.myManyFileCount : super.getFileCount();
    }

    @Override
    public int getDirectoryCount() {
        return this.myIsMany ? this.myManyDirectoryCount : super.getDirectoryCount();
    }

    public boolean isManyFiles() {
        return this.myIsMany;
    }

    public static boolean isManyFiles(@NotNull Collection<?> files2) {
        if (files2 == null) {
            ChangesBrowserSpecificFilePathsNode.$$$reportNull$$$0(4);
        }
        return files2.size() > Registry.intValue((String)"vcs.unversioned.files.max.intree", (int)1000);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shower";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserSpecificFilePathsNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setAttributes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isManyFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

