/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.actions.ToolWindowEmptyStateAction;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.ui.VcsToolWindowEmptyStateKt;
import com.intellij.openapi.vcs.changes.ui.VcsToolWindowFactory;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.StatusText;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesViewToolWindowFactory;", "Lcom/intellij/openapi/vcs/changes/ui/VcsToolWindowFactory;", "()V", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "init", "window", "shouldBeAvailable", "", "updateState", "intellij.platform.vcs.impl"})
final class ChangesViewToolWindowFactory
extends VcsToolWindowFactory {
    @Override
    public void init(@NotNull ToolWindow window) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            super.init(window);
            ToolWindowEx cfr_ignored_0 = (ToolWindowEx)window;
            AnAction anAction2 = ActionManager.getInstance().getAction("LocalChangesView.GearActions");
            if (anAction2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
            }
            ((ToolWindowEx)window).setAdditionalGearActions((ActionGroup)anAction2);
            ToolWindowEmptyStateAction.setEmptyStateBackground(window);
            StatusText statusText2 = ((ToolWindowEx)window).getEmptyText();
            if (statusText2 == null) break block1;
            Project project = ((ToolWindowEx)window).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"window.project");
            VcsToolWindowEmptyStateKt.setChangesViewEmptyState(statusText2, project);
        }
    }

    @Override
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        super.createToolWindowContent(project, toolWindow2);
        ContentManager contentManager2 = toolWindow2.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"toolWindow.contentManager");
        if (contentManager2.isEmpty()) {
            ToolWindowEmptyStateAction.rebuildContentUi(toolWindow2);
        }
    }

    @Override
    protected void updateState(@NotNull Project project, @NotNull ToolWindow toolWindow2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        super.updateState(project, toolWindow2);
        Object[] objectArray = VcsToolWindowFactory.Companion.getVcsManager$intellij_platform_vcs_impl(project).getAllActiveVcss();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.vcsManager.allActiveVcss");
        Object object = (AbstractVcs)ArraysKt.singleOrNull((Object[])objectArray);
        if (object == null || (object = object.getDisplayName()) == null) {
            object = "Version Control";
        }
        toolWindow2.setStripeTitle((String)object);
    }

    public boolean shouldBeAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return TrustedProjects.isTrusted(project);
    }
}

