/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.configurable.VcsCheckBoxWithSpinnerConfigurable;
import com.intellij.openapi.vcs.contentAnnotation.VcsContentAnnotationSettings;
import javax.swing.SpinnerNumberModel;
import org.jetbrains.annotations.Nls;

public class VcsContentAnnotationConfigurable
extends VcsCheckBoxWithSpinnerConfigurable {
    public VcsContentAnnotationConfigurable(Project project) {
        super(project, VcsBundle.message((String)"settings.checkbox.show.changed.in.last", (Object[])new Object[0]), VcsBundle.message((String)"settings.checkbox.measure.days", (Object[])new Object[0]));
    }

    @Override
    protected SpinnerNumberModel createSpinnerModel() {
        return new SpinnerNumberModel(1, 1, 31, 1);
    }

    @Nls
    public String getDisplayName() {
        return VcsBundle.message((String)"configurable.VcsContentAnnotationConfigurable.display.name", (Object[])new Object[0]);
    }

    public boolean isModified() {
        VcsContentAnnotationSettings settings = VcsContentAnnotationSettings.getInstance((Project)this.myProject);
        if (this.myHighlightRecentlyChanged.isSelected() != settings.isShow()) {
            return true;
        }
        return !Comparing.equal((Object)this.myHighlightInterval.getValue(), (Object)settings.getLimitDays());
    }

    public void apply() {
        VcsContentAnnotationSettings settings = VcsContentAnnotationSettings.getInstance((Project)this.myProject);
        settings.setShow(this.myHighlightRecentlyChanged.isSelected());
        settings.setLimitDays(((Number)this.myHighlightInterval.getValue()).intValue());
    }

    public void reset() {
        VcsContentAnnotationSettings settings = VcsContentAnnotationSettings.getInstance((Project)this.myProject);
        this.myHighlightRecentlyChanged.setSelected(settings.isShow());
        this.myHighlightInterval.setValue(settings.getLimitDays());
        this.myHighlightInterval.setEnabled(this.myHighlightRecentlyChanged.isSelected());
    }
}

