/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DefaultFlagsProvider;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.LineStatusMarkerDrawUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ex.LineStatusTrackerI;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.PeekableIteratorWrapper;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LineStatusMarkerRenderer {
    private static final Logger LOG = Logger.getInstance(LineStatusMarkerRenderer.class);
    public static final Key<MarkerData> TOOLTIP_KEY = Key.create((String)"LineStatusMarkerRenderer.Tooltip.Id");
    public static final Key<Boolean> MAIN_KEY = Key.create((String)"LineStatusMarkerRenderer.Main.Id");
    @NotNull
    protected final LineStatusTrackerI<?> myTracker;
    private final MarkupEditorFilter myEditorFilter;
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    private boolean myDisposed;
    @NotNull
    private RangeHighlighter myHighlighter;
    @NotNull
    private final List<RangeHighlighter> myTooltipHighlighters;

    LineStatusMarkerRenderer(@NotNull LineStatusTrackerI<?> tracker2) {
        if (tracker2 == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(0);
        }
        this.myTooltipHighlighters = new ArrayList<RangeHighlighter>();
        this.myTracker = tracker2;
        this.myEditorFilter = this.getEditorFilter();
        this.myUpdateQueue = new MergingUpdateQueue("LineStatusMarkerRenderer", 100, true, MergingUpdateQueue.ANY_COMPONENT, this.myTracker.getDisposable());
        this.myHighlighter = this.createGutterHighlighter();
        Disposer.register((Disposable)this.myTracker.getDisposable(), () -> {
            this.myDisposed = true;
            this.destroyHighlighters();
        });
        ApplicationManager.getApplication().getMessageBus().connect(this.myTracker.getDisposable()).subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                LineStatusMarkerRenderer.this.scheduleValidateHighlighter();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer$1", "pluginUnloaded"));
            }
        });
        this.scheduleUpdate();
    }

    public void scheduleUpdate() {
        this.myUpdateQueue.queue((Update)DisposableUpdate.createDisposable((Disposable)this.myUpdateQueue, "update", () -> this.updateHighlighters()));
    }

    public void scheduleValidateHighlighter() {
        this.myUpdateQueue.queue((Update)DisposableUpdate.createDisposable((Disposable)this.myUpdateQueue, "validate highlighter", () -> {
            if (this.myDisposed || this.myHighlighter.isValid()) {
                return;
            }
            LineStatusMarkerRenderer.disposeHighlighter(this.myHighlighter);
            this.myHighlighter = this.createGutterHighlighter();
            this.updateHighlighters();
        }));
    }

    @NotNull
    private RangeHighlighter createGutterHighlighter() {
        Document document = this.myTracker.getDocument();
        MarkupModelEx markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(document, this.myTracker.getProject(), true);
        RangeHighlighterEx rangeHighlighterEx = markupModel.addRangeHighlighterAndChangeAttributes(null, 0, document.getTextLength(), 5999, HighlighterTargetArea.LINES_IN_RANGE, false, (Consumer<? super RangeHighlighterEx>)((Consumer)it -> {
            it.setGreedyToLeft(true);
            it.setGreedyToRight(true);
            it.setLineMarkerRenderer((LineMarkerRenderer)new MyActiveGutterRenderer());
            if (this.myEditorFilter != null) {
                it.setEditorFilter(this.myEditorFilter);
            }
            it.putUserData(MAIN_KEY, true);
        }));
        if (rangeHighlighterEx == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(1);
        }
        return rangeHighlighterEx;
    }

    @RequiresEdt
    private void updateHighlighters() {
        List<?> ranges;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myDisposed) {
            return;
        }
        EditorFactory.getInstance().editors(this.myTracker.getDocument()).forEach(editor2 -> {
            if (editor2 instanceof EditorEx) {
                ((EditorEx)editor2).getGutterComponentEx().repaint();
            }
        });
        List<?> list2 = ranges = this.shouldPaintErrorStripeMarkers() ? this.myTracker.getRanges() : null;
        if (ContainerUtil.isEmpty(ranges)) {
            for (RangeHighlighter highlighter : this.myTooltipHighlighters) {
                LineStatusMarkerRenderer.disposeHighlighter(highlighter);
            }
            this.myTooltipHighlighters.clear();
            return;
        }
        MarkupModelEx markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(this.myTracker.getDocument(), this.myTracker.getProject(), true);
        PeekableIteratorWrapper highlighterIt = new PeekableIteratorWrapper(this.myTooltipHighlighters.iterator());
        ArrayList<RangeHighlighter> newHighlighters = new ArrayList<RangeHighlighter>();
        ArrayList<RangeHighlighter> oldHighlighters = new ArrayList<RangeHighlighter>();
        for (Range range2 : ranges) {
            MarkerData oldMarkerData;
            TextRange textRange = DiffUtil.getLinesRange(markupModel.getDocument(), range2.getLine1(), range2.getLine2(), false);
            while (highlighterIt.hasNext() && ((RangeHighlighter)highlighterIt.peek()).getStartOffset() < textRange.getStartOffset()) {
                oldHighlighters.add((RangeHighlighter)highlighterIt.next());
            }
            RangeHighlighter oldHighlighter = highlighterIt.hasNext() ? (RangeHighlighter)highlighterIt.peek() : null;
            MarkerData markerData = oldMarkerData = oldHighlighter != null ? (MarkerData)oldHighlighter.getUserData(TOOLTIP_KEY) : null;
            if (oldHighlighter != null && oldHighlighter.isValid() && oldMarkerData != null && oldMarkerData.type == range2.getType() && oldHighlighter.getStartOffset() == textRange.getStartOffset() && oldHighlighter.getEndOffset() == textRange.getEndOffset()) {
                newHighlighters.add(oldHighlighter);
                highlighterIt.next();
                continue;
            }
            newHighlighters.add(this.createTooltipRangeHighlighter(markupModel, textRange, range2.getType()));
        }
        while (highlighterIt.hasNext()) {
            oldHighlighters.add((RangeHighlighter)highlighterIt.next());
        }
        for (RangeHighlighter highlighter : oldHighlighters) {
            LineStatusMarkerRenderer.disposeHighlighter(highlighter);
        }
        this.myTooltipHighlighters.clear();
        this.myTooltipHighlighters.addAll(newHighlighters);
    }

    @NotNull
    private RangeHighlighter createTooltipRangeHighlighter(@NotNull MarkupModelEx markupModel, @NotNull TextRange textRange, byte diffType) {
        if (markupModel == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(2);
        }
        if (textRange == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(3);
        }
        RangeHighlighterEx rangeHighlighterEx = markupModel.addRangeHighlighterAndChangeAttributes(null, textRange.getStartOffset(), textRange.getEndOffset(), 5999, HighlighterTargetArea.LINES_IN_RANGE, false, (Consumer<? super RangeHighlighterEx>)((Consumer)it -> {
            it.setThinErrorStripeMark(true);
            it.setGreedyToLeft(true);
            it.setGreedyToRight(true);
            it.setTextAttributes(new LineStatusMarkerDrawUtil.DiffStripeTextAttributes(diffType));
            if (this.myEditorFilter != null) {
                it.setEditorFilter(this.myEditorFilter);
            }
            it.putUserData(TOOLTIP_KEY, new MarkerData(diffType));
        }));
        if (rangeHighlighterEx == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(4);
        }
        return rangeHighlighterEx;
    }

    private void destroyHighlighters() {
        if (!this.myHighlighter.isValid() || this.myHighlighter.getStartOffset() != 0 || this.myHighlighter.getEndOffset() != this.myTracker.getDocument().getTextLength()) {
            LOG.warn(String.format("Highlighter is damaged for %s, isValid: %s", this.myTracker, this.myHighlighter.isValid()));
        }
        LineStatusMarkerRenderer.disposeHighlighter(this.myHighlighter);
        for (RangeHighlighter highlighter : this.myTooltipHighlighters) {
            LineStatusMarkerRenderer.disposeHighlighter(highlighter);
        }
        this.myTooltipHighlighters.clear();
    }

    private static void disposeHighlighter(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(5);
        }
        try {
            highlighter.dispose();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private boolean canDoAction(@NotNull Editor editor2, @NotNull MouseEvent e) {
        List<? extends Range> ranges;
        if (editor2 == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(6);
        }
        if (e == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(7);
        }
        return !(ranges = this.getSelectedRanges(editor2, e.getY())).isEmpty() && this.canDoAction(editor2, ranges, e);
    }

    private void doAction(@NotNull Editor editor2, @NotNull MouseEvent e) {
        List<? extends Range> ranges;
        if (editor2 == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(8);
        }
        if (e == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(9);
        }
        if (!(ranges = this.getSelectedRanges(editor2, e.getY())).isEmpty()) {
            e.consume();
            this.doAction(editor2, ranges, e);
        }
    }

    @NotNull
    private List<? extends Range> getSelectedRanges(@NotNull Editor editor2, int y) {
        List<?> ranges;
        if (editor2 == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(10);
        }
        if ((ranges = this.myTracker.getRanges()) == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                LineStatusMarkerRenderer.$$$reportNull$$$0(11);
            }
            return list2;
        }
        List<Range> list3 = LineStatusMarkerDrawUtil.getSelectedRanges(ranges, editor2, y);
        if (list3 == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(12);
        }
        return list3;
    }

    protected boolean canDoAction(@NotNull Editor editor2, @NotNull List<? extends Range> ranges, @NotNull MouseEvent e) {
        if (editor2 == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(13);
        }
        if (ranges == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(14);
        }
        if (e == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(15);
        }
        return false;
    }

    protected void doAction(@NotNull Editor editor2, @NotNull List<? extends Range> ranges, @NotNull MouseEvent e) {
        if (editor2 == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(16);
        }
        if (ranges == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(17);
        }
        if (e == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(18);
        }
    }

    @Nullable
    protected MarkupEditorFilter getEditorFilter() {
        return null;
    }

    private Rectangle calcBounds(Editor editor2, int lineNum, Rectangle bounds2) {
        List<?> ranges = this.myTracker.getRanges();
        if (ranges == null) {
            return null;
        }
        return LineStatusMarkerDrawUtil.calcBounds(ranges, editor2, lineNum);
    }

    protected boolean shouldPaintGutter() {
        return true;
    }

    protected boolean shouldPaintErrorStripeMarkers() {
        return this.shouldPaintGutter();
    }

    protected void paint(@NotNull Editor editor2, @NotNull Graphics g) {
        if (editor2 == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(19);
        }
        if (g == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(20);
        }
        LineStatusMarkerDrawUtil.paintDefault(editor2, g, this.myTracker, DefaultFlagsProvider.DEFAULT, 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markupModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: 
            case 9: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createGutterHighlighter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltipRangeHighlighter";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTooltipRangeHighlighter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "disposeHighlighter";
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "canDoAction";
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doAction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedRanges";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MarkerData {
        public final byte type;

        public MarkerData(byte type) {
            this.type = type;
        }
    }

    private class MyActiveGutterRenderer
    implements ActiveGutterRenderer {
        private MyActiveGutterRenderer() {
        }

        public void paint(@NotNull Editor editor2, @NotNull Graphics g, @NotNull Rectangle r) {
            if (editor2 == null) {
                MyActiveGutterRenderer.$$$reportNull$$$0(0);
            }
            if (g == null) {
                MyActiveGutterRenderer.$$$reportNull$$$0(1);
            }
            if (r == null) {
                MyActiveGutterRenderer.$$$reportNull$$$0(2);
            }
            if (LineStatusMarkerRenderer.this.shouldPaintGutter()) {
                LineStatusMarkerRenderer.this.paint(editor2, g);
            }
        }

        public boolean canDoAction(@NotNull Editor editor2, @NotNull MouseEvent e) {
            if (editor2 == null) {
                MyActiveGutterRenderer.$$$reportNull$$$0(3);
            }
            if (e == null) {
                MyActiveGutterRenderer.$$$reportNull$$$0(4);
            }
            return LineStatusMarkerRenderer.this.shouldPaintGutter() && LineStatusMarkerRenderer.this.canDoAction(editor2, e);
        }

        public void doAction(@NotNull Editor editor2, @NotNull MouseEvent e) {
            if (editor2 == null) {
                MyActiveGutterRenderer.$$$reportNull$$$0(5);
            }
            if (e == null) {
                MyActiveGutterRenderer.$$$reportNull$$$0(6);
            }
            if (LineStatusMarkerRenderer.this.shouldPaintGutter()) {
                LineStatusMarkerRenderer.this.doAction(editor2, e);
            }
        }

        @Nullable
        public Rectangle calcBounds(@NotNull Editor editor2, int lineNum, @NotNull Rectangle preferredBounds) {
            if (editor2 == null) {
                MyActiveGutterRenderer.$$$reportNull$$$0(7);
            }
            if (preferredBounds == null) {
                MyActiveGutterRenderer.$$$reportNull$$$0(8);
            }
            if (!LineStatusMarkerRenderer.this.shouldPaintGutter()) {
                return new Rectangle(-1, -1, 0, 0);
            }
            return LineStatusMarkerRenderer.this.calcBounds(editor2, lineNum, preferredBounds);
        }

        @NotNull
        public String getAccessibleName() {
            String string = DiffBundle.message((String)"vcs.marker.changed.line", (Object[])new Object[0]);
            if (string == null) {
                MyActiveGutterRenderer.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preferredBounds";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer$MyActiveGutterRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer$MyActiveGutterRenderer";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAccessibleName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "paint";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "canDoAction";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "doAction";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "calcBounds";
                    break;
                }
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

