/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.LineStatusTrackerI;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\bf\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH'J\u0018\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH'R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "R", "Lcom/intellij/openapi/vcs/ex/Range;", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerI;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "isAvailableAt", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "scrollAndShowHint", "", "range", "showHint", "intellij.platform.vcs.impl"})
public interface LineStatusTracker<R extends Range>
extends LineStatusTrackerI<R> {
    @Override
    @NotNull
    public Project getProject();

    @Override
    @NotNull
    public VirtualFile getVirtualFile();

    @RequiresEdt
    public boolean isAvailableAt(@NotNull Editor var1);

    @RequiresEdt
    public void scrollAndShowHint(@NotNull Range var1, @NotNull Editor var2);

    @RequiresEdt
    public void showHint(@NotNull Range var1, @NotNull Editor var2);

    @Metadata(mv={1, 5, 1}, k=3)
    public static final class DefaultImpls {
        @RequiresEdt
        public static <R extends Range> boolean isAvailableAt(@NotNull LineStatusTracker<? extends R> $this, @NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            EditorSettings editorSettings = editor2.getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"editor.settings");
            return editorSettings.isLineMarkerAreaShown() && !DiffUtil.isDiffEditor(editor2);
        }
    }
}

