/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.CollectingHistorySessionConsumer;
import com.intellij.openapi.vcs.history.LightweightVcsHistorySessionConsumer;
import com.intellij.openapi.vcs.history.LimitHistoryCheck;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsHistorySessionConsumer;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsCachingHistory {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsHistoryCache myVcsHistoryCache;
    @NotNull
    private final VcsHistoryProvider myHistoryProvider;
    @NotNull
    private final VcsType myType;
    private final DiffProvider myDiffProvider;

    private VcsCachingHistory(@NotNull AbstractVcs vcs, @NotNull VcsHistoryProvider historyProvider, DiffProvider diffProvider) {
        if (vcs == null) {
            VcsCachingHistory.$$$reportNull$$$0(0);
        }
        if (historyProvider == null) {
            VcsCachingHistory.$$$reportNull$$$0(1);
        }
        this.myProject = vcs.getProject();
        this.myVcsHistoryCache = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsHistoryCache();
        this.myHistoryProvider = historyProvider;
        this.myType = vcs.getType();
        this.myDiffProvider = diffProvider;
    }

    private void reportHistoryInBackground(final @NotNull FilePath filePath, final @Nullable VcsRevisionNumber startRevisionNumber, final @NotNull VcsKey vcsKey, final @NotNull BackgroundableActionLock lock2, final @NotNull VcsHistorySessionConsumer partner, final boolean canUseCache) {
        if (filePath == null) {
            VcsCachingHistory.$$$reportNull$$$0(2);
        }
        if (vcsKey == null) {
            VcsCachingHistory.$$$reportNull$$$0(3);
        }
        if (lock2 == null) {
            VcsCachingHistory.$$$reportNull$$$0(4);
        }
        if (partner == null) {
            VcsCachingHistory.$$$reportNull$$$0(5);
        }
        if (lock2.isLocked()) {
            return;
        }
        lock2.lock();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, VcsBundle.message((String)"loading.file.history.progress", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator2.setText(VcsUtil.getPathForProgressPresentation((File)filePath.getIOFile()));
                indicator2.setIndeterminate(true);
                VcsCachingHistory.this.reportHistory(filePath, startRevisionNumber, vcsKey, partner, canUseCache);
            }

            public void onFinished() {
                lock2.unlock();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/history/VcsCachingHistory$1", "run"));
            }
        });
    }

    private void reportHistory(@NotNull FilePath filePath, @Nullable VcsRevisionNumber startRevisionNumber, @NotNull VcsKey vcsKey, @NotNull VcsHistorySessionConsumer partner, boolean canUseCache) {
        if (filePath == null) {
            VcsCachingHistory.$$$reportNull$$$0(6);
        }
        if (vcsKey == null) {
            VcsCachingHistory.$$$reportNull$$$0(7);
        }
        if (partner == null) {
            VcsCachingHistory.$$$reportNull$$$0(8);
        }
        try {
            if (startRevisionNumber == null) {
                partner = this.wrapPartnerToCachingPartner(vcsKey, filePath, partner);
            }
            VcsAbstractHistorySession cachedSession = null;
            VcsCacheableHistorySessionFactory<Serializable, VcsAbstractHistorySession> cacheableFactory = this.getCacheableFactory();
            if (canUseCache && cacheableFactory != null) {
                cachedSession = this.getSessionFromCacheWithLastRevisionCheck(filePath, vcsKey, cacheableFactory);
            }
            if (cachedSession != null) {
                partner.reportCreatedEmptySession(cachedSession);
            } else if (this.myHistoryProvider instanceof VcsHistoryProviderEx) {
                ((VcsHistoryProviderEx)this.myHistoryProvider).reportAppendableHistory(filePath, startRevisionNumber, (VcsAppendableHistorySessionPartner)partner);
            } else {
                this.myHistoryProvider.reportAppendableHistory(filePath, (VcsAppendableHistorySessionPartner)partner);
            }
            partner.finished();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (LimitHistoryCheck.VcsFileHistoryLimitReachedException ignored) {
            partner.finished();
        }
        catch (VcsException e) {
            partner.reportException(e);
        }
        catch (Throwable t) {
            partner.reportException(new VcsException(t));
        }
    }

    @Nullable
    private VcsCacheableHistorySessionFactory<Serializable, VcsAbstractHistorySession> getCacheableFactory() {
        if (!(this.myHistoryProvider instanceof VcsCacheableHistorySessionFactory)) {
            return null;
        }
        return (VcsCacheableHistorySessionFactory)this.myHistoryProvider;
    }

    @NotNull
    private VcsHistoryCache getHistoryCache() {
        VcsHistoryCache vcsHistoryCache = this.myVcsHistoryCache;
        if (vcsHistoryCache == null) {
            VcsCachingHistory.$$$reportNull$$$0(9);
        }
        return vcsHistoryCache;
    }

    @NotNull
    private VcsHistorySessionConsumer wrapPartnerToCachingPartner(@NotNull VcsKey vcsKey, @NotNull FilePath filePath, @NotNull VcsHistorySessionConsumer partner) {
        VcsCacheableHistorySessionFactory<Serializable, VcsAbstractHistorySession> cacheableFactory;
        if (vcsKey == null) {
            VcsCachingHistory.$$$reportNull$$$0(10);
        }
        if (filePath == null) {
            VcsCachingHistory.$$$reportNull$$$0(11);
        }
        if (partner == null) {
            VcsCachingHistory.$$$reportNull$$$0(12);
        }
        if ((cacheableFactory = this.getCacheableFactory()) != null) {
            return new HistoryPartnerProxy(partner, (Consumer<? super VcsAbstractHistorySession>)((Consumer)session2 -> {
                if (session2 == null) {
                    return;
                }
                FilePath correctedPath = cacheableFactory.getUsedFilePath(session2);
                this.myVcsHistoryCache.put(filePath, correctedPath, vcsKey, (VcsAbstractHistorySession)session2.copy(), cacheableFactory, true);
            }));
        }
        VcsHistorySessionConsumer vcsHistorySessionConsumer = partner;
        if (vcsHistorySessionConsumer == null) {
            VcsCachingHistory.$$$reportNull$$$0(13);
        }
        return vcsHistorySessionConsumer;
    }

    @Nullable
    private VcsAbstractHistorySession getSessionFromCacheWithLastRevisionCheck(@NotNull FilePath filePath, @NotNull VcsKey vcsKey, @NotNull VcsCacheableHistorySessionFactory<Serializable, VcsAbstractHistorySession> cacheableFactory) {
        VcsAbstractHistorySession cached;
        ProgressIndicator indicator2;
        if (filePath == null) {
            VcsCachingHistory.$$$reportNull$$$0(14);
        }
        if (vcsKey == null) {
            VcsCachingHistory.$$$reportNull$$$0(15);
        }
        if (cacheableFactory == null) {
            VcsCachingHistory.$$$reportNull$$$0(16);
        }
        if ((indicator2 = ProgressManager.getInstance().getProgressIndicator()) != null) {
            indicator2.setText2(VcsBundle.message((String)"file.history.checking.last.revision.process", (Object[])new Object[0]));
        }
        if ((cached = this.myVcsHistoryCache.getFull(filePath, vcsKey, cacheableFactory)) == null || cached.getRevisionList().isEmpty()) {
            return null;
        }
        FilePath correctedFilePath = cacheableFactory.getUsedFilePath(cached);
        FilePath path2 = correctedFilePath != null ? correctedFilePath : filePath;
        VcsRevisionNumber currentRevision = null;
        if (VcsType.distributed.equals((Object)this.myType)) {
            currentRevision = cached.calcCurrentRevisionNumber();
        } else {
            ItemLatestState lastRevision = this.myDiffProvider.getLastRevision(path2);
            if (lastRevision != null && !lastRevision.isDefaultHead() && lastRevision.isItemExists()) {
                currentRevision = lastRevision.getNumber();
            }
        }
        if (((VcsFileRevision)cached.getRevisionList().get(0)).getRevisionNumber().equals(currentRevision)) {
            return cached;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    public static void collect(@NotNull AbstractVcs abstractVcs, @NotNull FilePath filePath, @Nullable VcsRevisionNumber vcsRevisionNumber, @NotNull Consumer<VcsFileRevision> consumer2) throws VcsException {
        void revision;
        void revisionConsumer;
        void filePath2;
        AbstractVcs vcs;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (vcs == null) {
            VcsCachingHistory.$$$reportNull$$$0(17);
        }
        if (filePath2 == null) {
            VcsCachingHistory.$$$reportNull$$$0(18);
        }
        if (revisionConsumer == null) {
            VcsCachingHistory.$$$reportNull$$$0(19);
        }
        VcsCachingHistory history2 = new VcsCachingHistory(vcs, Objects.requireNonNull(vcs.getVcsHistoryProvider()), vcs.getDiffProvider());
        LightweightVcsHistorySessionConsumer partner = new LightweightVcsHistorySessionConsumer((Consumer<VcsFileRevision>)revisionConsumer);
        history2.reportHistory((FilePath)filePath2, (VcsRevisionNumber)revision, vcs.getKeyInstanceMethod(), partner, true);
        partner.throwIfError();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    public static List<VcsFileRevision> collect(@NotNull AbstractVcs abstractVcs, @NotNull FilePath filePath, @Nullable VcsRevisionNumber vcsRevisionNumber) throws VcsException {
        void revision;
        void filePath2;
        AbstractVcs vcs;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (vcs == null) {
            VcsCachingHistory.$$$reportNull$$$0(20);
        }
        if (filePath2 == null) {
            VcsCachingHistory.$$$reportNull$$$0(21);
        }
        return VcsCachingHistory.collectSession(vcs, (FilePath)filePath2, (VcsRevisionNumber)revision).getRevisionList();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    public static VcsHistorySession collectSession(@NotNull AbstractVcs abstractVcs, @NotNull FilePath filePath, @Nullable VcsRevisionNumber vcsRevisionNumber) throws VcsException {
        void revision;
        void filePath2;
        AbstractVcs vcs;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (vcs == null) {
            VcsCachingHistory.$$$reportNull$$$0(22);
        }
        if (filePath2 == null) {
            VcsCachingHistory.$$$reportNull$$$0(23);
        }
        VcsCachingHistory history2 = new VcsCachingHistory(vcs, Objects.requireNonNull(vcs.getVcsHistoryProvider()), vcs.getDiffProvider());
        CollectingHistorySessionConsumer partner = new CollectingHistorySessionConsumer();
        history2.reportHistory((FilePath)filePath2, (VcsRevisionNumber)revision, vcs.getKeyInstanceMethod(), partner, true);
        partner.check();
        return partner.getSession();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public static void collectInBackground(@NotNull AbstractVcs abstractVcs, @NotNull FilePath filePath, @NotNull VcsBackgroundableActions vcsBackgroundableActions, @NotNull Consumer<? super VcsHistorySession> consumer2) {
        void consumer3;
        void actionKey;
        void filePath2;
        AbstractVcs vcs;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (vcs == null) {
            VcsCachingHistory.$$$reportNull$$$0(24);
        }
        if (filePath2 == null) {
            VcsCachingHistory.$$$reportNull$$$0(25);
        }
        if (actionKey == null) {
            VcsCachingHistory.$$$reportNull$$$0(26);
        }
        if (consumer3 == null) {
            VcsCachingHistory.$$$reportNull$$$0(27);
        }
        VcsCachingHistory history2 = new VcsCachingHistory(vcs, Objects.requireNonNull(vcs.getVcsHistoryProvider()), vcs.getDiffProvider());
        CollectingHistoryPartner partner = new CollectingHistoryPartner(vcs.getProject(), (FilePath)filePath2, (Consumer<? super VcsHistorySession>)consumer3);
        BackgroundableActionLock lock2 = VcsCachingHistory.getHistoryLock(vcs, (VcsBackgroundableActions)actionKey, (FilePath)filePath2, null);
        history2.reportHistoryInBackground((FilePath)filePath2, null, vcs.getKeyInstanceMethod(), lock2, partner, true);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public static void collectInBackground(@NotNull AbstractVcs abstractVcs, @NotNull FilePath filePath, @NotNull VcsHistorySessionConsumer vcsHistorySessionConsumer, boolean bl) {
        void canUseCache;
        void partner;
        void filePath2;
        AbstractVcs vcs;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (vcs == null) {
            VcsCachingHistory.$$$reportNull$$$0(28);
        }
        if (filePath2 == null) {
            VcsCachingHistory.$$$reportNull$$$0(29);
        }
        if (partner == null) {
            VcsCachingHistory.$$$reportNull$$$0(30);
        }
        VcsCachingHistory history2 = new VcsCachingHistory(vcs, Objects.requireNonNull(vcs.getVcsHistoryProvider()), vcs.getDiffProvider());
        BackgroundableActionLock lock2 = VcsCachingHistory.getHistorySessionLock(vcs, (FilePath)filePath2, null);
        history2.reportHistoryInBackground((FilePath)filePath2, null, vcs.getKeyInstanceMethod(), lock2, (VcsHistorySessionConsumer)partner, (boolean)canUseCache);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public static void collectInBackground(@NotNull AbstractVcs abstractVcs, @NotNull FilePath filePath, @NotNull VcsRevisionNumber vcsRevisionNumber, @NotNull VcsHistorySessionConsumer vcsHistorySessionConsumer) {
        void partner;
        void startRevisionNumber;
        void filePath2;
        AbstractVcs vcs;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (vcs == null) {
            VcsCachingHistory.$$$reportNull$$$0(31);
        }
        if (filePath2 == null) {
            VcsCachingHistory.$$$reportNull$$$0(32);
        }
        if (startRevisionNumber == null) {
            VcsCachingHistory.$$$reportNull$$$0(33);
        }
        if (partner == null) {
            VcsCachingHistory.$$$reportNull$$$0(34);
        }
        if (!(vcs.getVcsHistoryProvider() instanceof VcsHistoryProviderEx)) {
            throw new UnsupportedOperationException();
        }
        BackgroundableActionLock lock2 = VcsCachingHistory.getHistorySessionLock(vcs, (FilePath)filePath2, (VcsRevisionNumber)startRevisionNumber);
        VcsCachingHistory history2 = new VcsCachingHistory(vcs, Objects.requireNonNull(vcs.getVcsHistoryProvider()), vcs.getDiffProvider());
        history2.reportHistoryInBackground((FilePath)filePath2, (VcsRevisionNumber)startRevisionNumber, vcs.getKeyInstanceMethod(), lock2, (VcsHistorySessionConsumer)partner, false);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public static boolean collectFromCache(@NotNull AbstractVcs abstractVcs, @NotNull FilePath filePath, @NotNull VcsHistorySessionConsumer vcsHistorySessionConsumer) {
        VcsAbstractHistorySession session2;
        VcsCachingHistory history2;
        VcsCacheableHistorySessionFactory<Serializable, VcsAbstractHistorySession> cacheableFactory;
        void partner;
        void filePath2;
        AbstractVcs vcs;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (vcs == null) {
            VcsCachingHistory.$$$reportNull$$$0(35);
        }
        if (filePath2 == null) {
            VcsCachingHistory.$$$reportNull$$$0(36);
        }
        if (partner == null) {
            VcsCachingHistory.$$$reportNull$$$0(37);
        }
        if ((cacheableFactory = (history2 = new VcsCachingHistory(vcs, Objects.requireNonNull(vcs.getVcsHistoryProvider()), vcs.getDiffProvider())).getCacheableFactory()) != null && (session2 = history2.getHistoryCache().getFull((FilePath)filePath2, vcs.getKeyInstanceMethod(), cacheableFactory)) != null) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(vcs.getProject(), VcsBundle.message((String)"loading.file.history.progress", (Object[])new Object[0]), true, (VcsHistorySessionConsumer)partner, session2){
                final /* synthetic */ VcsHistorySessionConsumer val$partner;
                final /* synthetic */ VcsAbstractHistorySession val$session;
                {
                    this.val$partner = vcsHistorySessionConsumer;
                    this.val$session = vcsAbstractHistorySession;
                    super(arg0, arg1, arg2);
                }

                public void run(@NotNull ProgressIndicator indicator2) {
                    if (indicator2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    this.val$partner.reportCreatedEmptySession(this.val$session);
                    this.val$partner.finished();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/history/VcsCachingHistory$2", "run"));
                }
            });
            return true;
        }
        return false;
    }

    @NotNull
    public static BackgroundableActionLock getHistorySessionLock(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @Nullable VcsRevisionNumber startRevisionNumber) {
        if (vcs == null) {
            VcsCachingHistory.$$$reportNull$$$0(38);
        }
        if (filePath == null) {
            VcsCachingHistory.$$$reportNull$$$0(39);
        }
        return VcsCachingHistory.getHistoryLock(vcs, VcsBackgroundableActions.CREATE_HISTORY_SESSION, filePath, startRevisionNumber);
    }

    @NotNull
    public static BackgroundableActionLock getHistoryLock(@NotNull AbstractVcs vcs, @NotNull VcsBackgroundableActions actionKey, @NotNull FilePath filePath, @Nullable VcsRevisionNumber startRevisionNumber) {
        if (vcs == null) {
            VcsCachingHistory.$$$reportNull$$$0(40);
        }
        if (actionKey == null) {
            VcsCachingHistory.$$$reportNull$$$0(41);
        }
        if (filePath == null) {
            VcsCachingHistory.$$$reportNull$$$0(42);
        }
        if (startRevisionNumber != null) {
            BackgroundableActionLock backgroundableActionLock = BackgroundableActionLock.getLock(vcs.getProject(), new Object[]{actionKey, filePath.getPath(), startRevisionNumber.asString()});
            if (backgroundableActionLock == null) {
                VcsCachingHistory.$$$reportNull$$$0(43);
            }
            return backgroundableActionLock;
        }
        BackgroundableActionLock backgroundableActionLock = BackgroundableActionLock.getLock(vcs.getProject(), new Object[]{actionKey, filePath.getPath()});
        if (backgroundableActionLock == null) {
            VcsCachingHistory.$$$reportNull$$$0(44);
        }
        return backgroundableActionLock;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 13: 
            case 43: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 13: 
            case 43: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "historyProvider";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 14: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 29: 
            case 32: 
            case 36: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsKey";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lock";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 30: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partner";
                break;
            }
            case 9: 
            case 13: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/history/VcsCachingHistory";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheableFactory";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionConsumer";
                break;
            }
            case 26: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionKey";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startRevisionNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/history/VcsCachingHistory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryCache";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapPartnerToCachingPartner";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reportHistoryInBackground";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reportHistory";
                break;
            }
            case 9: 
            case 13: 
            case 43: 
            case 44: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "wrapPartnerToCachingPartner";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSessionFromCacheWithLastRevisionCheck";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectSession";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "collectInBackground";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "collectFromCache";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getHistorySessionLock";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getHistoryLock";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 13: 
            case 43: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class HistoryPartnerProxy
    implements VcsHistorySessionConsumer {
        @NotNull
        private final VcsHistorySessionConsumer myPartner;
        @NotNull
        private final Consumer<? super VcsAbstractHistorySession> myFinish;
        private VcsAbstractHistorySession myCopy;

        private HistoryPartnerProxy(@NotNull VcsHistorySessionConsumer partner, @NotNull Consumer<? super VcsAbstractHistorySession> finish) {
            if (partner == null) {
                HistoryPartnerProxy.$$$reportNull$$$0(0);
            }
            if (finish == null) {
                HistoryPartnerProxy.$$$reportNull$$$0(1);
            }
            this.myPartner = partner;
            this.myFinish = finish;
        }

        public void reportCreatedEmptySession(VcsAbstractHistorySession session2) {
            this.myCopy = (VcsAbstractHistorySession)session2.copy();
            this.myPartner.reportCreatedEmptySession(session2);
        }

        public void acceptRevision(VcsFileRevision revision) {
            this.myCopy.appendRevision(revision);
            this.myPartner.acceptRevision(revision);
        }

        public void reportException(VcsException exception) {
            this.myPartner.reportException(exception);
        }

        @Override
        public void finished() {
            this.myPartner.finished();
            this.myFinish.consume((Object)this.myCopy);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "partner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "finish";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/history/VcsCachingHistory$HistoryPartnerProxy";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class CollectingHistoryPartner
    implements VcsHistorySessionConsumer {
        @NotNull
        private final Project myProject;
        @NotNull
        private final Consumer<? super VcsHistorySession> myContinuation;
        @NotNull
        private final LimitHistoryCheck myCheck;
        private VcsAbstractHistorySession mySession;

        private CollectingHistoryPartner(@NotNull Project project, @NotNull FilePath path2, @NotNull Consumer<? super VcsHistorySession> continuation) {
            if (project == null) {
                CollectingHistoryPartner.$$$reportNull$$$0(0);
            }
            if (path2 == null) {
                CollectingHistoryPartner.$$$reportNull$$$0(1);
            }
            if (continuation == null) {
                CollectingHistoryPartner.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myContinuation = continuation;
            this.myCheck = new LimitHistoryCheck(this.myProject, path2.getPath());
        }

        public void reportCreatedEmptySession(VcsAbstractHistorySession session2) {
            List revisionList = session2.getRevisionList();
            while (this.myCheck.isOver(revisionList.size())) {
                revisionList.remove(revisionList.size() - 1);
            }
            this.mySession = session2;
        }

        public void acceptRevision(VcsFileRevision revision) {
            this.myCheck.checkNumber();
            this.mySession.appendRevision(revision);
        }

        public void reportException(VcsException exception) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showError(exception, VcsBundle.message((String)"message.title.could.not.load.file.history", (Object[])new Object[0]));
        }

        @Override
        public void finished() {
            if (this.mySession != null) {
                ApplicationManager.getApplication().invokeLater(() -> this.myContinuation.consume((Object)this.mySession), ModalityState.defaultModalityState());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "continuation";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/history/VcsCachingHistory$CollectingHistoryPartner";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

