/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history.actions;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.formove.TriggerAdditionOrDeletion;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.ui.ReplaceFileConfirmationDialog;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GetVersionAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(GetVersionAction.class);

    public GetVersionAction() {
        super(VcsBundle.messagePointer((String)"action.name.get.file.content.from.repository", (Object[])new Object[0]), VcsBundle.messagePointer((String)"action.description.get.file.content.from.repository", (Object[])new Object[0]), AllIcons.Actions.Download);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GetVersionAction.$$$reportNull$$$0(0);
        }
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        if (e.getProject() == null || filePath == null || revision == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setEnabledAndVisible(this.isContentAvailable(filePath, revision, e));
        }
    }

    protected boolean isContentAvailable(@NotNull FilePath filePath, @NotNull VcsFileRevision revision, @NotNull AnActionEvent e) {
        VcsHistorySession historySession;
        if (filePath == null) {
            GetVersionAction.$$$reportNull$$$0(1);
        }
        if (revision == null) {
            GetVersionAction.$$$reportNull$$$0(2);
        }
        if (e == null) {
            GetVersionAction.$$$reportNull$$$0(3);
        }
        if ((historySession = (VcsHistorySession)e.getData(VcsDataKeys.HISTORY_SESSION)) == null) {
            return false;
        }
        return historySession.isContentAvailable(revision) && !filePath.isDirectory();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GetVersionAction.$$$reportNull$$$0(4);
        }
        if (ChangeListManager.getInstance((Project)(project = (Project)e.getRequiredData(CommonDataKeys.PROJECT))).isFreezedWithNotification(null)) {
            return;
        }
        VcsFileRevision revision = (VcsFileRevision)e.getRequiredData(VcsDataKeys.VCS_FILE_REVISION);
        FilePath filePath = (FilePath)e.getRequiredData(VcsDataKeys.FILE_PATH);
        GetVersionAction.doGet(project, revision, filePath);
    }

    public static void doGet(@NotNull Project project, @NotNull VcsFileRevision revision, @NotNull FilePath filePath) {
        if (project == null) {
            GetVersionAction.$$$reportNull$$$0(5);
        }
        if (revision == null) {
            GetVersionAction.$$$reportNull$$$0(6);
        }
        if (filePath == null) {
            GetVersionAction.$$$reportNull$$$0(7);
        }
        String actionTitle = VcsBundle.message((String)"action.name.for.file.get.version", (Object[])new Object[]{filePath.getPath(), revision.getRevisionNumber()});
        GetVersionAction.doGet(project, actionTitle, Collections.singletonList(new VcsFileRevisionProvider(filePath, revision)), null);
    }

    public static void doGet(@NotNull Project project, @NotNull @NlsContexts.Label String actionTitle, @NotNull List<FileRevisionProvider> providers, @Nullable Runnable onFinished) {
        List files2;
        if (project == null) {
            GetVersionAction.$$$reportNull$$$0(8);
        }
        if (actionTitle == null) {
            GetVersionAction.$$$reportNull$$$0(9);
        }
        if (providers == null) {
            GetVersionAction.$$$reportNull$$$0(10);
        }
        if (!(files2 = ContainerUtil.mapNotNull(providers, it -> it.getFilePath().getVirtualFile())).isEmpty()) {
            ReplaceFileConfirmationDialog confirmationDialog = new ReplaceFileConfirmationDialog(project, VcsBundle.message((String)"acton.name.get.revision", (Object[])new Object[0]));
            if (!confirmationDialog.confirmFor(VfsUtilCore.toVirtualFileArray((Collection)files2))) {
                return;
            }
            if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable((Collection)files2).hasReadonlyFiles()) {
                return;
            }
        }
        new MyWriteVersionTask(project, actionTitle, providers, onFinished).queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionTitle";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/history/actions/GetVersionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isContentAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "doGet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class VcsFileRevisionProvider
    implements FileRevisionProvider {
        @NotNull
        private final FilePath myFilePath;
        @NotNull
        private final VcsFileRevision myRevision;

        private VcsFileRevisionProvider(@NotNull FilePath filePath, @NotNull VcsFileRevision revision) {
            if (filePath == null) {
                VcsFileRevisionProvider.$$$reportNull$$$0(0);
            }
            if (revision == null) {
                VcsFileRevisionProvider.$$$reportNull$$$0(1);
            }
            this.myFilePath = filePath;
            this.myRevision = revision;
        }

        @Override
        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = this.myFilePath;
            if (filePath == null) {
                VcsFileRevisionProvider.$$$reportNull$$$0(2);
            }
            return filePath;
        }

        @Override
        public byte @Nullable [] getContent() throws VcsException {
            try {
                return VcsHistoryUtil.loadRevisionContent(this.myRevision);
            }
            catch (IOException e) {
                throw new VcsException((Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/history/actions/GetVersionAction$VcsFileRevisionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/history/actions/GetVersionAction$VcsFileRevisionProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface FileRevisionProvider {
        @NotNull
        public FilePath getFilePath();

        public byte @Nullable [] getContent() throws VcsException;
    }

    private static class MyWriteVersionTask
    extends Task.Backgroundable {
        @NotNull
        private final @NlsContexts.Label String myActionTitle;
        @NotNull
        private final List<FileRevisionProvider> myProviders;
        @Nullable
        private final Runnable myOnFinished;

        MyWriteVersionTask(@NotNull Project project, @NotNull @NlsContexts.Label String actionTitle, @NotNull List<FileRevisionProvider> providers, @Nullable Runnable onFinished) {
            if (project == null) {
                MyWriteVersionTask.$$$reportNull$$$0(0);
            }
            if (actionTitle == null) {
                MyWriteVersionTask.$$$reportNull$$$0(1);
            }
            if (providers == null) {
                MyWriteVersionTask.$$$reportNull$$$0(2);
            }
            super(project, VcsBundle.message((String)"show.diff.progress.title", (Object[])new Object[0]));
            this.myActionTitle = actionTitle;
            this.myProviders = providers;
            this.myOnFinished = onFinished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator2) {
            if (indicator2 == null) {
                MyWriteVersionTask.$$$reportNull$$$0(3);
            }
            LocalHistoryAction action2 = LocalHistory.getInstance().startAction(this.myActionTitle);
            try {
                TriggerAdditionOrDeletion trigger = new TriggerAdditionOrDeletion(this.myProject);
                Object commandGroup = new Object();
                for (FileRevisionProvider provider2 : this.myProviders) {
                    FilePath filePath = provider2.getFilePath();
                    byte[] revisionContent = provider2.getContent();
                    Ref exRef = new Ref();
                    ApplicationManager.getApplication().invokeAndWait(() -> {
                        try {
                            CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                                VirtualFile virtualFile2 = filePath.getVirtualFile();
                                if (revisionContent == null && virtualFile2 == null) {
                                    return;
                                }
                                if (revisionContent == null) {
                                    trigger.prepare(Collections.emptyList(), Collections.singletonList(filePath));
                                } else if (virtualFile2 == null) {
                                    trigger.prepare(Collections.singletonList(filePath), Collections.emptyList());
                                }
                                ApplicationManager.getApplication().runWriteAction(() -> {
                                    try {
                                        if (revisionContent == null) {
                                            MyWriteVersionTask.writeDeletion(virtualFile2);
                                        } else if (virtualFile2 == null) {
                                            MyWriteVersionTask.writeCreation(filePath, revisionContent);
                                        } else {
                                            MyWriteVersionTask.writeModification(virtualFile2, revisionContent);
                                        }
                                    }
                                    catch (IOException e) {
                                        exRef.set((Object)e);
                                    }
                                });
                            }, VcsBundle.message((String)"message.title.get.version", (Object[])new Object[0]), commandGroup);
                        }
                        finally {
                            trigger.cleanup();
                        }
                    });
                    if (exRef.isNull()) continue;
                    throw (IOException)exRef.get();
                }
                trigger.processIt();
            }
            catch (IOException e) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.cannot.save.content", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.get.revision.content", (Object[])new Object[0]), (Icon)Messages.getErrorIcon()));
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
                ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.cannot.load.revision", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.get.revision.content", (Object[])new Object[0]), (Icon)Messages.getInformationIcon()));
            }
            finally {
                action2.finish();
            }
        }

        private static void writeDeletion(@NotNull VirtualFile virtualFile2) throws IOException {
            if (virtualFile2 == null) {
                MyWriteVersionTask.$$$reportNull$$$0(4);
            }
            virtualFile2.delete(MyWriteVersionTask.class);
        }

        private static void writeCreation(@NotNull FilePath filePath, byte @NotNull [] revisionContent) throws IOException {
            FilePath parentPath;
            VirtualFile parent;
            if (filePath == null) {
                MyWriteVersionTask.$$$reportNull$$$0(5);
            }
            if (revisionContent == null) {
                MyWriteVersionTask.$$$reportNull$$$0(6);
            }
            if ((parent = VfsUtil.createDirectories((String)(parentPath = Objects.requireNonNull(filePath.getParentPath())).getPath())) == null) {
                throw new IOException("Can't create directory: " + parentPath);
            }
            VirtualFile virtualFile2 = parent.createChildData(MyWriteVersionTask.class, filePath.getName());
            virtualFile2.setBinaryContent(revisionContent);
        }

        private static void writeModification(@NotNull VirtualFile virtualFile2, byte @NotNull [] revisionContent) throws IOException {
            if (virtualFile2 == null) {
                MyWriteVersionTask.$$$reportNull$$$0(7);
            }
            if (revisionContent == null) {
                MyWriteVersionTask.$$$reportNull$$$0(8);
            }
            virtualFile2.setBinaryContent(revisionContent);
            FileDocumentManager.getInstance().reloadFiles(new VirtualFile[]{virtualFile2});
        }

        public void onFinished() {
            if (this.myOnFinished != null) {
                this.myOnFinished.run();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionTitle";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "providers";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revisionContent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/history/actions/GetVersionAction$MyWriteVersionTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeDeletion";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeCreation";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeModification";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

