/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history.impl;

import com.intellij.CommonBundle;
import com.intellij.diff.Block;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.TableLinkMouseListener;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.FileHistoryPanelImpl;
import com.intellij.openapi.vcs.history.StandardDiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsCachingHistory;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IntPair;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsSelectionHistoryDialog
extends FrameWrapper
implements DataProvider {
    private static final DataKey<VcsSelectionHistoryDialog> SELECTION_HISTORY_DIALOG_KEY = DataKey.create("VCS_SELECTION_HISTORY_DIALOG");
    private static final VcsRevisionNumber LOCAL_REVISION_NUMBER = new VcsRevisionNumber(){

        @Nls
        @NotNull
        public String asString() {
            String string = VcsBundle.message((String)"selection.history.local.revision.text", (Object[])new Object[0]);
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        public int compareTo(@NotNull VcsRevisionNumber vcsRevisionNumber) {
            if (vcsRevisionNumber == null) {
                1.$$$reportNull$$$0(1);
            }
            return 0;
        }

        @NonNls
        public String toString() {
            return "Local Changes";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/history/impl/VcsSelectionHistoryDialog$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcsRevisionNumber";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asString";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/history/impl/VcsSelectionHistoryDialog$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final float DIFF_SPLITTER_PROPORTION = 0.5f;
    private static final float COMMENTS_SPLITTER_PROPORTION = 0.8f;
    private static final String DIFF_SPLITTER_PROPORTION_KEY = "file.history.selection.diff.splitter.proportion";
    private static final String COMMENTS_SPLITTER_PROPORTION_KEY = "file.history.selection.comments.splitter.proportion";
    private static final Block EMPTY_BLOCK = new Block("", 0, 0);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final AbstractVcs myActiveVcs;
    @NotNull
    private final VcsHistoryProvider myVcsHistoryProvider;
    private final ColumnInfo[] myDefaultColumns;
    private ListTableModel<VcsFileRevision> myListModel;
    private final TableView<VcsFileRevision> myList;
    private final Splitter mySplitter;
    private final DiffRequestPanel myDiffPanel;
    private final JCheckBox myChangesOnlyCheckBox;
    private final JLabel myStatusLabel;
    private final AnimatedIcon myStatusSpinner;
    private final JEditorPane myComments;
    private final Wrapper myDetailsPanel;
    @Nullable
    private Consumer<VcsFileRevision> mySelectedRevisionListener;
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    @NotNull
    private final BlockLoader myBlockLoader;
    private boolean myRevisionsLoaded;
    private boolean myIsDuringUpdate;
    private boolean myIsDisposed;

    public VcsSelectionHistoryDialog(@NotNull Project project, @NotNull VirtualFile file2, @NotNull Document document, @NotNull VcsHistoryProvider vcsHistoryProvider, @NotNull AbstractVcs vcs, int selectionStart, int selectionEnd, @NotNull @NlsContexts.DialogTitle String title2) {
        if (project == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(1);
        }
        if (document == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(2);
        }
        if (vcsHistoryProvider == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(3);
        }
        if (vcs == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(4);
        }
        if (title2 == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(5);
        }
        super(project, "VCS.FileHistoryDialog");
        this.myChangesOnlyCheckBox = new JCheckBox(VcsBundle.message((String)"checkbox.show.changed.revisions.only", (Object[])new Object[0]));
        this.myStatusLabel = new JBLabel();
        this.myStatusSpinner = new AsyncProcessIcon("VcsSelectionHistoryDialog");
        this.myDetailsPanel = new Wrapper();
        this.myRevisionsLoaded = false;
        this.myIsDuringUpdate = false;
        this.myIsDisposed = false;
        this.myProject = project;
        this.myFile = file2;
        this.myActiveVcs = vcs;
        this.myVcsHistoryProvider = vcsHistoryProvider;
        this.myComments = new JEditorPane("text/html", "");
        this.myComments.setPreferredSize((Dimension)new JBDimension(150, 100));
        this.myComments.setEditable(false);
        this.myComments.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        this.myDefaultColumns = new ColumnInfo[]{new FileHistoryPanelImpl.RevisionColumnInfo(null), new FileHistoryPanelImpl.DateColumnInfo(), new FileHistoryPanelImpl.AuthorColumnInfo(), new FileHistoryPanelImpl.MessageColumnInfo(project)};
        this.myListModel = new ListTableModel(this.myDefaultColumns);
        this.myListModel.setSortable(false);
        this.myList = new TableView(this.myListModel);
        new TableLinkMouseListener().installOn((Component)this.myList);
        this.myList.getEmptyText().setText(VcsBundle.message((String)"history.loading.revisions", (Object[])new Object[0]));
        this.myDiffPanel = DiffManager.getInstance().createRequestPanel(this.myProject, (Disposable)this, this.getFrame());
        this.myUpdateQueue = new MergingUpdateQueue("VcsSelectionHistoryDialog", 300, true, this.myList, (Disposable)this);
        this.mySplitter = new JBSplitter(true, DIFF_SPLITTER_PROPORTION_KEY, 0.5f);
        this.mySplitter.setFirstComponent(this.myDiffPanel.getComponent());
        this.mySplitter.setSecondComponent(this.createBottomPanel());
        ListSelectionListener selectionListener2 = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VcsFileRevision revision;
                if (VcsSelectionHistoryDialog.this.myList.getSelectedRowCount() == 1 && !VcsSelectionHistoryDialog.this.myList.isEmpty()) {
                    revision = (VcsFileRevision)VcsSelectionHistoryDialog.this.myList.getItems().get(VcsSelectionHistoryDialog.this.myList.getSelectedRow());
                    String message2 = IssueLinkHtmlRenderer.formatTextIntoHtml(VcsSelectionHistoryDialog.this.myProject, Objects.requireNonNull(revision.getCommitMessage()));
                    VcsSelectionHistoryDialog.this.myComments.setText(message2);
                    VcsSelectionHistoryDialog.this.myComments.setCaretPosition(0);
                } else {
                    revision = null;
                    VcsSelectionHistoryDialog.this.myComments.setText("");
                }
                if (VcsSelectionHistoryDialog.this.mySelectedRevisionListener != null) {
                    VcsSelectionHistoryDialog.this.mySelectedRevisionListener.consume((Object)revision);
                }
                VcsSelectionHistoryDialog.this.updateDiff();
            }
        };
        this.myList.getSelectionModel().addListSelectionListener(selectionListener2);
        final VcsConfiguration configuration2 = VcsConfiguration.getInstance((Project)this.myProject);
        this.myChangesOnlyCheckBox.setSelected(configuration2.SHOW_ONLY_CHANGED_IN_SELECTION_DIFF);
        this.myChangesOnlyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                configuration2.SHOW_ONLY_CHANGED_IN_SELECTION_DIFF = VcsSelectionHistoryDialog.this.myChangesOnlyCheckBox.isSelected();
                VcsSelectionHistoryDialog.this.updateRevisionsList();
            }
        });
        PopupHandler.installPopupMenu(this.myList, (String)"VcsSelectionHistoryDialog.Popup", (String)"UpdatePopup");
        this.setTitle(title2);
        this.setComponent((JComponent)this.mySplitter);
        this.setPreferredFocusedComponent((JComponent)this.myList);
        this.closeOnEsc();
        this.myBlockLoader = new BlockLoader(this.myActiveVcs, this.myFile, document, selectionStart, selectionEnd){

            @Override
            protected void notifyError(@NotNull VcsException e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                this.runOnEdt(() -> PopupUtil.showBalloonForComponent((Component)VcsSelectionHistoryDialog.this.mySplitter, (String)VcsSelectionHistoryDialog.canNoLoadMessage(e), (MessageType)MessageType.ERROR, (boolean)true, (Disposable)VcsSelectionHistoryDialog.this.myProject));
            }

            @Override
            protected void notifyUpdate(boolean shouldFlush) {
                VcsSelectionHistoryDialog.this.myUpdateQueue.queue((Update)DisposableUpdate.createDisposable((Disposable)VcsSelectionHistoryDialog.this.myUpdateQueue, this, () -> {
                    VcsSelectionHistoryDialog.this.updateStatusPanel();
                    VcsSelectionHistoryDialog.this.updateRevisionsList();
                }));
                if (shouldFlush) {
                    this.runOnEdt(() -> VcsSelectionHistoryDialog.this.myUpdateQueue.flush());
                }
            }

            private void runOnEdt(@NotNull Runnable task2) {
                if (task2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.stateForComponent((Component)VcsSelectionHistoryDialog.this.mySplitter), () -> {
                    VcsSelectionHistoryDialog dialog2 = VcsSelectionHistoryDialog.this;
                    if (!dialog2.isDisposed() && dialog2.getFrame().isShowing()) {
                        task2.run();
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "task";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/vcs/history/impl/VcsSelectionHistoryDialog$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "notifyError";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runOnEdt";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myBlockLoader.start(this);
        this.updateRevisionsList();
        this.updateDiff();
    }

    @Nls
    @NotNull
    private static String canNoLoadMessage(@Nullable VcsException e) {
        String string = VcsBundle.message((String)"selection.history.can.not.load.message", (Object[])new Object[0]) + (String)(e != null ? ": " + e.getLocalizedMessage() : "");
        if (string == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(6);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    private void updateRevisionsList() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myIsDuringUpdate) {
            return;
        }
        try {
            this.myIsDuringUpdate = true;
            BlockData data2 = this.myBlockLoader.getLoadedData();
            if (data2.getRevisions().isEmpty()) {
                return;
            }
            if (!this.myRevisionsLoaded) {
                this.myRevisionsLoaded = true;
                JRootPane rootPane = ((RootPaneContainer)((Object)this.getFrame())).getRootPane();
                VcsDependentHistoryComponents components = this.myVcsHistoryProvider.getUICustomization(data2.getSession(), (JComponent)rootPane);
                Object[] additionalColumns = components.getColumns();
                this.myListModel = new ListTableModel((ColumnInfo[])ArrayUtil.mergeArrays((Object[])this.myDefaultColumns, (Object[])additionalColumns, ColumnInfo[]::new));
                this.myListModel.setSortable(false);
                this.myList.setModel(this.myListModel);
                this.mySelectedRevisionListener = components.getRevisionListener();
                this.myDetailsPanel.setContent(components.getDetailsComponent());
            }
            List<VcsFileRevision> newItems = this.myChangesOnlyCheckBox.isSelected() ? this.filteredRevisions(data2) : data2.getRevisions();
            IntPair range2 = this.getSelectedRevisionsRange(data2);
            List<VcsFileRevision> oldSelection = data2.getRevisions().subList(range2.first, range2.second);
            this.myListModel.setItems(newItems);
            this.myList.setSelection(oldSelection);
            if (this.myList.getSelectedRowCount() == 0) {
                int index2 = this.getNearestVisibleRevision((VcsFileRevision)ContainerUtil.getFirstItem(oldSelection), data2);
                if (this.myList.getRowCount() != 0) {
                    this.myList.getSelectionModel().setSelectionInterval(index2, index2);
                }
            }
            TableUtil.scrollSelectionToVisible(this.myList);
        }
        finally {
            this.myIsDuringUpdate = false;
        }
        this.updateDiff();
    }

    private void updateStatusPanel() {
        BlockData data2 = this.myBlockLoader.getLoadedData();
        if (data2.isLoading()) {
            VcsFileRevision revision = data2.getCurrentLoadingRevision();
            Object message2 = revision != null ? VcsBundle.message((String)"selection.history.loading.revision.status", (Object[])new Object[]{XmlStringUtil.wrapInHtmlTag((String)VcsUtil.getShortRevisionString((VcsRevisionNumber)revision.getRevisionNumber()), (String)"tt")}) : CommonBundle.getLoadingTreeNodeText();
            int totalRevisions = data2.getRevisions().size();
            if (totalRevisions != 0) {
                message2 = (String)message2 + String.format(" (%s/%s)", data2.myBlocks.size(), totalRevisions);
            }
            this.myStatusLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)message2));
            this.myStatusSpinner.resume();
            this.myStatusSpinner.setVisible(true);
        } else {
            this.myStatusLabel.setText("");
            this.myStatusSpinner.suspend();
            this.myStatusSpinner.setVisible(false);
        }
    }

    @NotNull
    private IntPair getSelectedRevisionsRange(@NotNull BlockData blockData) {
        List selection;
        if (blockData == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(7);
        }
        if ((selection = this.myList.getSelectedObjects()).isEmpty()) {
            return new IntPair(0, 0);
        }
        int startIndex = blockData.getRevisions().indexOf(ContainerUtil.getFirstItem((List)selection));
        int endIndex = blockData.getRevisions().indexOf(ContainerUtil.getLastItem((List)selection));
        return new IntPair(startIndex, endIndex + 1);
    }

    private int getNearestVisibleRevision(@Nullable VcsFileRevision anchor2, @NotNull BlockData blockData) {
        int anchorIndex;
        if (blockData == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(8);
        }
        if ((anchorIndex = blockData.getRevisions().indexOf(anchor2)) == -1) {
            return 0;
        }
        for (int i2 = anchorIndex - 1; i2 > 0; --i2) {
            int index2 = this.myListModel.indexOf((Object)blockData.getRevisions().get(i2));
            if (index2 == -1) continue;
            return index2;
        }
        return 0;
    }

    private List<VcsFileRevision> filteredRevisions(@NotNull BlockData blockData) {
        int initialCommit;
        Block initialCommitBlock;
        if (blockData == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(9);
        }
        ArrayList<VcsFileRevision> result2 = new ArrayList<VcsFileRevision>();
        BlockData data2 = this.myBlockLoader.getLoadedData();
        for (int i2 = 1; i2 < blockData.getRevisions().size(); ++i2) {
            Block block1 = data2.getBlock(i2 - 1);
            Block block2 = data2.getBlock(i2);
            if (block1 == null || block2 == null) break;
            if (!block1.getLines().equals(block2.getLines())) {
                result2.add(blockData.getRevisions().get(i2 - 1));
            }
            if (block2 == EMPTY_BLOCK) break;
        }
        if ((initialCommitBlock = data2.getBlock(initialCommit = blockData.getRevisions().size() - 1)) != null && initialCommitBlock != EMPTY_BLOCK) {
            result2.add(blockData.getRevisions().get(initialCommit));
        }
        return result2;
    }

    private void updateDiff() {
        if (this.myIsDisposed || this.myIsDuringUpdate) {
            return;
        }
        if (this.myList.getSelectedRowCount() == 0) {
            this.myDiffPanel.setRequest((DiffRequest)NoDiffRequest.INSTANCE);
            return;
        }
        BlockData blockData = this.myBlockLoader.getLoadedData();
        int count = blockData.getRevisions().size();
        if (count == 0) {
            this.myDiffPanel.setRequest((DiffRequest)new LoadingDiffRequest());
            return;
        }
        IntPair range2 = this.getSelectedRevisionsRange(blockData);
        int revIndex1 = range2.second;
        int revIndex2 = range2.first;
        if (revIndex1 == count && revIndex2 == count) {
            this.myDiffPanel.setRequest((DiffRequest)NoDiffRequest.INSTANCE);
            return;
        }
        DiffContent content1 = this.createDiffContent(revIndex1, blockData);
        DiffContent content2 = this.createDiffContent(revIndex2, blockData);
        String title1 = VcsSelectionHistoryDialog.createDiffContentTitle(revIndex1, blockData);
        String title2 = VcsSelectionHistoryDialog.createDiffContentTitle(revIndex2, blockData);
        if (content1 != null && content2 != null) {
            this.myDiffPanel.setRequest((DiffRequest)new SimpleDiffRequest(null, content1, content2, title1, title2), (Object)new IntPair(revIndex1, revIndex2));
            return;
        }
        if (blockData.isLoading()) {
            this.myDiffPanel.setRequest((DiffRequest)new LoadingDiffRequest());
        } else {
            this.myDiffPanel.setRequest((DiffRequest)new MessageDiffRequest(VcsSelectionHistoryDialog.canNoLoadMessage(blockData.getException())));
        }
    }

    @Nullable
    @NlsContexts.Label
    private static String createDiffContentTitle(int index2, @NotNull BlockData data2) {
        if (data2 == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(10);
        }
        if (index2 >= data2.getRevisions().size()) {
            return null;
        }
        return VcsBundle.message((String)"diff.content.title.revision.number", (Object[])new Object[]{data2.getRevisions().get(index2).getRevisionNumber()});
    }

    @Nullable
    private DiffContent createDiffContent(int index2, @NotNull BlockData data2) {
        if (data2 == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(11);
        }
        if (index2 >= data2.getRevisions().size()) {
            return DiffContentFactory.getInstance().createEmpty();
        }
        Block block = data2.getBlock(index2);
        if (block == null) {
            return null;
        }
        if (block == EMPTY_BLOCK) {
            return DiffContentFactory.getInstance().createEmpty();
        }
        DocumentContent documentContent = DiffContentFactory.getInstance().create(block.getBlockContent(), this.myFile.getFileType());
        documentContent.putUserData(DiffUserDataKeysEx.LINE_NUMBER_CONVERTOR, value2 -> value2 + block.getStart());
        return documentContent;
    }

    @Override
    public void dispose() {
        this.myIsDisposed = true;
        super.dispose();
    }

    private JComponent createBottomPanel() {
        JBSplitter splitter2 = new JBSplitter(true, COMMENTS_SPLITTER_PROPORTION_KEY, 0.8f);
        splitter2.setDividerWidth(4);
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)ScrollPaneFactory.createScrollPane(this.myList), "Center");
        JPanel statusPanel = new JPanel(new FlowLayout());
        statusPanel.add((Component)this.myStatusSpinner);
        statusPanel.add(this.myStatusLabel);
        JPanel separatorPanel = new JPanel(new BorderLayout());
        separatorPanel.add((Component)this.myChangesOnlyCheckBox, "West");
        separatorPanel.add((Component)statusPanel, "East");
        tablePanel.add((Component)separatorPanel, "North");
        splitter2.setFirstComponent((JComponent)tablePanel);
        splitter2.setSecondComponent(this.createComments());
        return splitter2;
    }

    private JComponent createComments() {
        JPanel panel2 = new JPanel(new BorderLayout(4, 4));
        panel2.add((Component)new JLabel(VcsBundle.message((String)"selection.history.commit.message.label", (Object[])new Object[0])), "North");
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myComments), "Center");
        Splitter splitter2 = new Splitter(false);
        splitter2.setFirstComponent((JComponent)panel2);
        splitter2.setSecondComponent((JComponent)this.myDetailsPanel);
        return splitter2;
    }

    @Override
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(12);
        }
        if (SELECTION_HISTORY_DIALOG_KEY.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (VcsDataKeys.VCS_VIRTUAL_FILE.is(dataId)) {
            return this.myFile;
        }
        if (VcsDataKeys.VCS_FILE_REVISION.is(dataId)) {
            VcsFileRevision selectedObject = (VcsFileRevision)this.myList.getSelectedObject();
            return selectedObject instanceof CurrentRevision ? null : selectedObject;
        }
        if (VcsDataKeys.VCS_FILE_REVISIONS.is(dataId)) {
            return ContainerUtil.filter((Collection)this.myList.getSelectedObjects(), (Condition)Conditions.notEqualTo((Object)this.myBlockLoader.getLocalRevision())).toArray(new VcsFileRevision[0]);
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            return this.myActiveVcs.getKeyInstanceMethod();
        }
        if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
            return ObjectUtils.notNull((Object)this.myVcsHistoryProvider.getHelpId(), (Object)"reference.dialogs.vcs.selection.history");
        }
        return null;
    }

    @NotNull
    private DiffFromHistoryHandler getDiffHandler() {
        VcsHistoryProvider historyProvider = this.myActiveVcs.getVcsHistoryProvider();
        DiffFromHistoryHandler handler2 = historyProvider != null ? historyProvider.getHistoryDiffHandler() : null;
        return handler2 != null ? handler2 : new StandardDiffFromHistoryHandler();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsHistoryProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/history/impl/VcsSelectionHistoryDialog";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockData";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/history/impl/VcsSelectionHistoryDialog";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "canNoLoadMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedRevisionsRange";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNearestVisibleRevision";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filteredRevisions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDiffContentTitle";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDiffContent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyDiffAfterWithLocalAction
    implements AnActionExtensionProvider {
        @Override
        public boolean isActive(@NotNull AnActionEvent e) {
            if (e == null) {
                MyDiffAfterWithLocalAction.$$$reportNull$$$0(0);
            }
            return e.getData(SELECTION_HISTORY_DIALOG_KEY) != null;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyDiffAfterWithLocalAction.$$$reportNull$$$0(1);
            }
            VcsSelectionHistoryDialog dialog2 = (VcsSelectionHistoryDialog)e.getRequiredData(SELECTION_HISTORY_DIALOG_KEY);
            e.getPresentation().setEnabled(dialog2.myList.getSelectedRowCount() == 1 && dialog2.myList.getSelectedObject() != dialog2.myBlockLoader.getLocalRevision());
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyDiffAfterWithLocalAction.$$$reportNull$$$0(2);
            }
            VcsSelectionHistoryDialog dialog2 = (VcsSelectionHistoryDialog)e.getRequiredData(SELECTION_HISTORY_DIALOG_KEY);
            VcsFileRevision revision = (VcsFileRevision)dialog2.myList.getSelectedObject();
            if (revision == null) {
                return;
            }
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)dialog2.myFile);
            dialog2.getDiffHandler().showDiffForTwo(dialog2.myProject, filePath, revision, dialog2.myBlockLoader.getLocalRevision());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/history/impl/VcsSelectionHistoryDialog$MyDiffAfterWithLocalAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isActive";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyDiffAction
    implements AnActionExtensionProvider {
        @Override
        public boolean isActive(@NotNull AnActionEvent e) {
            if (e == null) {
                MyDiffAction.$$$reportNull$$$0(0);
            }
            return e.getData(SELECTION_HISTORY_DIALOG_KEY) != null;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyDiffAction.$$$reportNull$$$0(1);
            }
            VcsSelectionHistoryDialog dialog2 = (VcsSelectionHistoryDialog)e.getRequiredData(SELECTION_HISTORY_DIALOG_KEY);
            e.getPresentation().setText(VcsBundle.message((String)"action.name.compare", (Object[])new Object[0]));
            e.getPresentation().setDescription(VcsBundle.message((String)"action.description.compare", (Object[])new Object[0]));
            e.getPresentation().setEnabled(dialog2.myList.getSelectedRowCount() > 1 || dialog2.myList.getSelectedRowCount() == 1 && dialog2.myList.getSelectedObject() != dialog2.myBlockLoader.getLocalRevision());
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyDiffAction.$$$reportNull$$$0(2);
            }
            VcsSelectionHistoryDialog dialog2 = (VcsSelectionHistoryDialog)e.getRequiredData(SELECTION_HISTORY_DIALOG_KEY);
            BlockData blockData = dialog2.myBlockLoader.getLoadedData();
            if (blockData.getRevisions().isEmpty()) {
                return;
            }
            IntPair range2 = dialog2.getSelectedRevisionsRange(blockData);
            List<VcsFileRevision> revisions = blockData.getRevisions();
            VcsFileRevision beforeRevision = range2.second < revisions.size() ? revisions.get(range2.second) : VcsFileRevision.NULL;
            VcsFileRevision afterRevision = revisions.get(range2.first);
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)dialog2.myFile);
            if (range2.second - range2.first > 1) {
                dialog2.getDiffHandler().showDiffForTwo(dialog2.myProject, filePath, beforeRevision, afterRevision);
            } else {
                dialog2.getDiffHandler().showDiffForOne(e, dialog2.myProject, filePath, beforeRevision, afterRevision);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/history/impl/VcsSelectionHistoryDialog$MyDiffAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isActive";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BlockData {
        private final boolean myIsLoading;
        private final VcsHistorySession mySession;
        @NotNull
        private final List<VcsFileRevision> myRevisions;
        @NotNull
        private final List<? extends Block> myBlocks;
        @Nullable
        private final VcsException myException;
        @Nullable
        private final VcsFileRevision myCurrentLoadingRevision;

        BlockData(boolean isLoading, @Nullable VcsHistorySession session2, @NotNull List<VcsFileRevision> revisions, @NotNull List<? extends Block> blocks, @Nullable VcsException exception, @Nullable VcsFileRevision currentLoadingRevision) {
            if (revisions == null) {
                BlockData.$$$reportNull$$$0(0);
            }
            if (blocks == null) {
                BlockData.$$$reportNull$$$0(1);
            }
            this.myIsLoading = isLoading;
            this.mySession = session2;
            this.myRevisions = revisions;
            this.myBlocks = blocks;
            this.myException = exception;
            this.myCurrentLoadingRevision = currentLoadingRevision;
        }

        public boolean isLoading() {
            return this.myIsLoading;
        }

        @Nullable
        public VcsException getException() {
            return this.myException;
        }

        @Nullable
        public VcsFileRevision getCurrentLoadingRevision() {
            return this.myCurrentLoadingRevision;
        }

        @Nullable
        public Block getBlock(int index2) {
            if (this.myBlocks.size() <= index2) {
                return null;
            }
            return this.myBlocks.get(index2);
        }

        @Nullable
        private VcsHistorySession getSession() {
            return this.mySession;
        }

        @NotNull
        private List<VcsFileRevision> getRevisions() {
            List<VcsFileRevision> list2 = this.myRevisions;
            if (list2 == null) {
                BlockData.$$$reportNull$$$0(2);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revisions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blocks";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/history/impl/VcsSelectionHistoryDialog$BlockData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/history/impl/VcsSelectionHistoryDialog$BlockData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class BlockLoader {
        @NotNull
        private final Object LOCK;
        private final AbstractVcs myVcs;
        private final VirtualFile myFile;
        private final VcsFileRevision myLocalRevision;
        private VcsHistorySession mySession;
        private final List<VcsFileRevision> myRevisions;
        private final List<Block> myBlocks;
        @Nullable
        private VcsException myException;
        private boolean myIsLoading;
        private VcsFileRevision myCurrentLoadingRevision;

        BlockLoader(@NotNull AbstractVcs vcs, @NotNull VirtualFile file2, @NotNull Document document, int selectionStart, int selectionEnd) {
            if (vcs == null) {
                BlockLoader.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                BlockLoader.$$$reportNull$$$0(1);
            }
            if (document == null) {
                BlockLoader.$$$reportNull$$$0(2);
            }
            this.LOCK = new Object();
            this.myRevisions = new ArrayList<VcsFileRevision>();
            this.myBlocks = new ArrayList<Block>();
            this.myIsLoading = true;
            this.myVcs = vcs;
            this.myFile = file2;
            this.myLocalRevision = new CurrentRevision(file2, LOCAL_REVISION_NUMBER);
            String[] lastContent = Block.tokenize(document.getText());
            this.myBlocks.add(new Block(lastContent, selectionStart, selectionEnd + 1));
        }

        public VcsFileRevision getLocalRevision() {
            return this.myLocalRevision;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        public BlockData getLoadedData() {
            Object object = this.LOCK;
            // MONITORENTER : object
            BlockData blockData = new BlockData(this.myIsLoading, this.mySession, new ArrayList<VcsFileRevision>(this.myRevisions), new ArrayList<Block>(this.myBlocks), this.myException, this.myCurrentLoadingRevision);
            // MONITOREXIT : object
            if (blockData != null) return blockData;
            BlockLoader.$$$reportNull$$$0(3);
            return blockData;
        }

        public void start(@NotNull Disposable disposable2) {
            if (disposable2 == null) {
                BlockLoader.$$$reportNull$$$0(4);
            }
            this.notifyUpdate(true);
            BackgroundTaskUtil.executeOnPooledThread(disposable2, () -> {
                try {
                    Object session2 = VcsCachingHistory.collectSession(this.myVcs, VcsUtil.getFilePath((VirtualFile)this.myFile), null);
                    Object object = this.LOCK;
                    synchronized (object) {
                        this.mySession = session2;
                        this.myRevisions.add(this.myLocalRevision);
                        this.myRevisions.addAll(session2.getRevisionList());
                    }
                    this.notifyUpdate(true);
                    for (int index2 = 1; index2 < this.myRevisions.size(); ++index2) {
                        ProgressManager.checkCanceled();
                        Block block = this.myBlocks.get(index2 - 1);
                        VcsFileRevision revision = this.myRevisions.get(index2);
                        Object object2 = this.LOCK;
                        synchronized (object2) {
                            this.myCurrentLoadingRevision = revision;
                        }
                        this.notifyUpdate(false);
                        Block previousBlock = this.createBlock(block, revision);
                        Object object3 = this.LOCK;
                        synchronized (object3) {
                            this.myBlocks.add(previousBlock);
                        }
                        this.notifyUpdate(false);
                    }
                }
                catch (VcsException e) {
                    Object object = this.LOCK;
                    synchronized (object) {
                        this.myException = e;
                    }
                    this.notifyError(e);
                }
                finally {
                    Object object = this.LOCK;
                    synchronized (object) {
                        this.myIsLoading = false;
                        this.myCurrentLoadingRevision = null;
                    }
                    this.notifyUpdate(true);
                }
            });
        }

        @RequiresBackgroundThread
        protected abstract void notifyError(@NotNull VcsException var1);

        @RequiresBackgroundThread
        protected abstract void notifyUpdate(boolean var1);

        @NotNull
        private Block createBlock(@NotNull Block block, @NotNull VcsFileRevision revision) throws VcsException {
            if (block == null) {
                BlockLoader.$$$reportNull$$$0(5);
            }
            if (revision == null) {
                BlockLoader.$$$reportNull$$$0(6);
            }
            if (block == EMPTY_BLOCK) {
                Block block2 = EMPTY_BLOCK;
                if (block2 == null) {
                    BlockLoader.$$$reportNull$$$0(7);
                }
                return block2;
            }
            String revisionContent = this.loadContents(revision);
            Block newBlock = block.createPreviousBlock(revisionContent);
            Block block3 = newBlock.getStart() != newBlock.getEnd() ? newBlock : EMPTY_BLOCK;
            if (block3 == null) {
                BlockLoader.$$$reportNull$$$0(8);
            }
            return block3;
        }

        @NotNull
        private String loadContents(@NotNull VcsFileRevision revision) throws VcsException {
            if (revision == null) {
                BlockLoader.$$$reportNull$$$0(9);
            }
            try {
                byte[] bytes = revision.loadContent();
                if (bytes == null) {
                    throw new VcsException(VcsBundle.message((String)"history.failed.to.load.content.for.revision.0", (Object[])new Object[]{revision.getRevisionNumber().asString()}));
                }
                return new String(bytes, this.myFile.getCharset());
            }
            catch (IOException e) {
                throw new VcsException((Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcs";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 3: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/history/impl/VcsSelectionHistoryDialog$BlockLoader";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/history/impl/VcsSelectionHistoryDialog$BlockLoader";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLoadedData";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createBlock";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 7: 
                case 8: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "start";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createBlock";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "loadContents";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

