/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.impl.PlatformVcsPathPresenter;
import com.intellij.openapi.vcs.impl.VcsPathPresenter;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleVcsPathPresenter
extends VcsPathPresenter {
    private final Project myProject;

    public ModuleVcsPathPresenter(Project project) {
        this.myProject = project;
    }

    @NotNull
    public String getPresentableRelativePathFor(VirtualFile file2) {
        if (file2 == null) {
            return "";
        }
        String string = (String)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return file2.getPresentableUrl();
            }
            boolean hideExcludedFiles = Registry.is((String)"ide.hide.excluded.files");
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            Module module = fileIndex.getModuleForFile(file2, hideExcludedFiles);
            VirtualFile contentRoot = fileIndex.getContentRootForFile(file2, hideExcludedFiles);
            if (module == null || contentRoot == null) {
                return file2.getPresentableUrl();
            }
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)contentRoot, (char)File.separatorChar);
            assert (relativePath != null);
            return ModuleVcsPathPresenter.getPresentableRelativePathFor(module, contentRoot, relativePath);
        });
        if (string == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getPresentableRelativePath(@NotNull ContentRevision fromRevision, @NotNull ContentRevision toRevision) {
        String moduleResult;
        if (fromRevision == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(1);
        }
        if (toRevision == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(2);
        }
        FilePath fromPath = fromRevision.getFile();
        FilePath toPath = toRevision.getFile();
        VirtualFile fromParent = ModuleVcsPathPresenter.getParentFile(fromPath);
        VirtualFile toParent = ModuleVcsPathPresenter.getParentFile(toPath);
        if (fromParent != null && toParent != null && (moduleResult = (String)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return null;
            }
            boolean hideExcludedFiles = Registry.is((String)"ide.hide.excluded.files");
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            Module fromModule = fileIndex.getModuleForFile(fromParent, hideExcludedFiles);
            Module toModule = fileIndex.getModuleForFile(toParent, hideExcludedFiles);
            if (fromModule == null || toModule == null || fromModule.equals(toModule)) {
                return null;
            }
            VirtualFile fromContentRoot = fileIndex.getContentRootForFile(fromParent, hideExcludedFiles);
            if (fromContentRoot == null) {
                return null;
            }
            Object relativePath = VfsUtilCore.getRelativePath((VirtualFile)fromParent, (VirtualFile)fromContentRoot, (char)File.separatorChar);
            assert (relativePath != null);
            if (!((String)relativePath).isEmpty()) {
                relativePath = (String)relativePath + File.separatorChar;
            }
            if (!fromPath.getName().equals(toPath.getName())) {
                relativePath = (String)relativePath + fromPath.getName();
            }
            return ModuleVcsPathPresenter.getPresentableRelativePathFor(fromModule, fromContentRoot, (String)relativePath);
        })) != null) {
            String string = moduleResult;
            if (string == null) {
                ModuleVcsPathPresenter.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = PlatformVcsPathPresenter.getPresentableRelativePath(toPath, fromPath);
        if (string == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static VirtualFile getParentFile(@NotNull FilePath path2) {
        FilePath parentPath;
        if (path2 == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(5);
        }
        return (parentPath = path2.getParentPath()) != null ? parentPath.getVirtualFile() : null;
    }

    @NlsContexts.Label
    @NotNull
    private static String getPresentableRelativePathFor(@NotNull Module module, @NotNull VirtualFile contentRoot, @NotNull String relativePath) {
        if (module == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(6);
        }
        if (contentRoot == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(7);
        }
        if (relativePath == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(8);
        }
        @NlsContexts.Label StringBuilder result2 = new StringBuilder();
        result2.append("[");
        result2.append(module.getName());
        result2.append("] ");
        result2.append(contentRoot.getName());
        result2.append(File.separatorChar);
        result2.append(relativePath);
        String string = result2.toString();
        if (string == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/ModuleVcsPathPresenter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromRevision";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRevision";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableRelativePathFor";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/ModuleVcsPathPresenter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableRelativePath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getParentFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableRelativePathFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

