/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.statistics.VcsUsagesCollector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.StringKt;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/statistics/VcsUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.platform.vcs.impl"})
public final class VcsUsagesCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP;
    private static final StringEventField VCS_FIELD;
    private static final EventId2<PluginInfo, String> ACTIVE_VCS;
    private static final BooleanEventField IS_PROJECT_MAPPING_FIELD;
    private static final BooleanEventField IS_BASE_DIR_FIELD;
    private static final Companion.VCS_FIELD_WITH_NONE.1 VCS_FIELD_WITH_NONE;
    private static final VarargEventId MAPPING;
    private static final EventId3<PluginInfo, String, Boolean> PROJECT_MAPPED_ROOTS;
    private static final EventId1<Integer> MAPPED_ROOTS;
    private static final EventId1<Integer> CHANGELISTS;
    private static final EventId1<Integer> UNVERSIONED_FILES;
    private static final EventId1<Integer> IGNORED_FILES;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        List data2;
        VirtualFile virtualFile2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        HashSet<MetricEvent> set2 = new HashSet<MetricEvent>();
        ProjectLevelVcsManagerEx vcsManager2 = ProjectLevelVcsManagerEx.getInstanceEx(project);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
        ChangeListManager clm = changeListManager;
        String string = project.getBasePath();
        if (string != null) {
            String string2 = string;
            int n = 0;
            boolean bl = false;
            String it = string2;
            boolean bl2 = false;
            virtualFile2 = VcsUtil.getVirtualFile((String)it);
        } else {
            virtualFile2 = null;
        }
        VirtualFile projectBaseDir = virtualFile2;
        ProjectLevelVcsManagerEx projectLevelVcsManagerEx = vcsManager2;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)projectLevelVcsManagerEx), (String)"vcsManager");
        for (AbstractVcs vcs : projectLevelVcsManagerEx.getAllActiveVcss()) {
            PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(vcs.getClass());
            AbstractVcs abstractVcs = vcs;
            Intrinsics.checkNotNullExpressionValue((Object)abstractVcs, (String)"vcs");
            set2.add(ACTIVE_VCS.metric((Object)pluginInfo, (Object)abstractVcs.getName()));
        }
        Iterator iterator2 = vcsManager2.getDirectoryMappings().iterator();
        while (iterator2.hasNext()) {
            PluginInfo pluginInfo;
            boolean bl;
            VcsDirectoryMapping mapping2;
            VcsDirectoryMapping vcsDirectoryMapping = mapping2 = (VcsDirectoryMapping)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)vcsDirectoryMapping, (String)"mapping");
            String vcsName = StringKt.nullize((String)vcsDirectoryMapping.getVcs(), (boolean)true);
            AbstractVcs vcs = vcsManager2.findVcsByName(vcsName);
            if (vcs != null) {
                AbstractVcs abstractVcs;
                bl = false;
                boolean bl3 = false;
                AbstractVcs it = abstractVcs;
                boolean bl4 = false;
                pluginInfo = PluginInfoDetectorKt.getPluginInfo(it.getClass());
            } else {
                pluginInfo = null;
            }
            PluginInfo pluginInfo2 = pluginInfo;
            bl = false;
            data2 = new ArrayList();
            data2.add(EventFields.PluginInfo.with((Object)pluginInfo2));
            data2.add(IS_PROJECT_MAPPING_FIELD.with((Object)mapping2.isDefaultMapping()));
            String string3 = vcsName;
            if (string3 == null) {
                string3 = "None";
            }
            data2.add(VCS_FIELD_WITH_NONE.with(string3));
            if (!mapping2.isDefaultMapping()) {
                data2.add(IS_BASE_DIR_FIELD.with((Object)(projectBaseDir != null && Intrinsics.areEqual((Object)projectBaseDir, (Object)VcsUtil.getVirtualFile((String)mapping2.getDirectory())) ? 1 : 0)));
            }
            set2.add(MAPPING.metric(data2));
        }
        AbstractVcs defaultVcs = vcsManager2.findVcsByName(vcsManager2.haveDefaultMapping());
        if (defaultVcs != null) {
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            int n;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            VcsDirectoryMapping it;
            Iterable $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(defaultVcs.getClass());
            List list2 = vcsManager2.getDirectoryMappings();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"vcsManager.directoryMappings");
            Iterable vcs = list2;
            boolean $i$f$filter = false;
            data2 = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (VcsDirectoryMapping)element$iv$iv;
                boolean bl = false;
                VcsDirectoryMapping vcsDirectoryMapping = it;
                Intrinsics.checkNotNullExpressionValue((Object)vcsDirectoryMapping, (String)"it");
                if (!Intrinsics.areEqual((Object)vcsDirectoryMapping.getVcs(), (Object)defaultVcs.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv2 = $this$filter$iv2;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (VcsDirectoryMapping)element$iv$iv;
                boolean bl = false;
                VcsDirectoryMapping vcsDirectoryMapping = it;
                Intrinsics.checkNotNullExpressionValue((Object)vcsDirectoryMapping, (String)"it");
                String string4 = vcsDirectoryMapping.getDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.directory");
                CharSequence charSequence = string4;
                boolean bl5 = false;
                if (!(charSequence.length() > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv;
            boolean $i$f$map22 = false;
            $this$filterTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (VcsDirectoryMapping)item$iv$iv;
                Collection collection = destination$iv$iv;
                n = 0;
                VcsDirectoryMapping vcsDirectoryMapping = it;
                Intrinsics.checkNotNullExpressionValue((Object)vcsDirectoryMapping, (String)"it");
                VirtualFile virtualFile3 = VcsUtil.getVirtualFile((String)vcsDirectoryMapping.getDirectory());
                collection.add(virtualFile3);
            }
            Set explicitRoots = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            VcsRoot[] vcsRootArray = vcsManager2.getAllVcsRoots();
            Intrinsics.checkNotNullExpressionValue((Object)vcsRootArray, (String)"vcsManager.allVcsRoots");
            VcsRoot[] $i$f$map22 = vcsRootArray;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            Iterator iterator3 = $this$filterTo$iv$iv;
            int it2 = ((void)iterator3).length;
            for (n = 0; n < it2; ++n) {
                void element$iv$iv;
                void it3 = element$iv$iv = iterator3[n];
                boolean bl = false;
                void v14 = it3;
                Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"it");
                if (!Intrinsics.areEqual((Object)v14.getVcs(), (Object)defaultVcs)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            $i$f$filter2 = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VcsRoot it4 = (VcsRoot)element$iv$iv;
                boolean bl = false;
                VcsRoot vcsRoot = it4;
                Intrinsics.checkNotNullExpressionValue((Object)vcsRoot, (String)"it");
                if (!(!explicitRoots.contains(vcsRoot.getPath()))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List projectMappedRoots = (List)destination$iv$iv2;
            for (VcsRoot vcsRoot : projectMappedRoots) {
                String string5 = defaultVcs.getName();
                VcsRoot vcsRoot2 = vcsRoot;
                Intrinsics.checkNotNullExpressionValue((Object)vcsRoot2, (String)"vcsRoot");
                set2.add(PROJECT_MAPPED_ROOTS.metric((Object)pluginInfo, (Object)string5, (Object)Intrinsics.areEqual((Object)vcsRoot2.getPath(), (Object)projectBaseDir)));
            }
        }
        set2.add(MAPPED_ROOTS.metric((Object)vcsManager2.getAllVcsRoots().length));
        set2.add(CHANGELISTS.metric((Object)clm.getChangeListsNumber()));
        set2.add(UNVERSIONED_FILES.metric((Object)clm.getUnversionedFilesPaths().size()));
        set2.add(IGNORED_FILES.metric((Object)clm.getIgnoredFilePaths().size()));
        return set2;
    }

    static {
        Companion = new Companion(null);
        GROUP = new EventLogGroup("vcs.configuration", 3);
        VCS_FIELD = EventFields.StringValidatedByEnum((String)"vcs", (String)"vcs");
        ACTIVE_VCS = GROUP.registerEvent("active.vcs", (EventField)EventFields.PluginInfo, (EventField)VCS_FIELD);
        IS_PROJECT_MAPPING_FIELD = EventFields.Boolean((String)"is_project_mapping");
        IS_BASE_DIR_FIELD = EventFields.Boolean((String)"is_base_dir");
        VCS_FIELD_WITH_NONE = new StringEventField("vcs"){

            @NotNull
            public List<String> getValidationRule() {
                return CollectionsKt.listOf((Object[])new String[]{"{enum#vcs}", "{enum:None}"});
            }
        };
        MAPPING = GROUP.registerVarargEvent("mapping", new EventField[]{(EventField)EventFields.PluginInfo, (EventField)VCS_FIELD_WITH_NONE, (EventField)IS_PROJECT_MAPPING_FIELD, (EventField)IS_BASE_DIR_FIELD});
        PROJECT_MAPPED_ROOTS = GROUP.registerEvent("project.mapped.root", (EventField)EventFields.PluginInfo, (EventField)VCS_FIELD, (EventField)EventFields.Boolean((String)"is_base_dir"));
        MAPPED_ROOTS = GROUP.registerEvent("mapped.roots", (EventField)EventFields.Count);
        CHANGELISTS = GROUP.registerEvent("changelists", (EventField)EventFields.Count);
        UNVERSIONED_FILES = GROUP.registerEvent("unversioned.files", (EventField)EventFields.Count);
        IGNORED_FILES = GROUP.registerEvent("ignored.files", (EventField)EventFields.Count);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000S\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003*\u0001\u001a\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/vcs/statistics/VcsUsagesCollector$Companion;", "", "()V", "ACTIVE_VCS", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "", "CHANGELISTS", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "IGNORED_FILES", "IS_BASE_DIR_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "IS_PROJECT_MAPPING_FIELD", "MAPPED_ROOTS", "MAPPING", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "PROJECT_MAPPED_ROOTS", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "UNVERSIONED_FILES", "VCS_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "VCS_FIELD_WITH_NONE", "com/intellij/openapi/vcs/statistics/VcsUsagesCollector$Companion$VCS_FIELD_WITH_NONE$1", "Lcom/intellij/openapi/vcs/statistics/VcsUsagesCollector$Companion$VCS_FIELD_WITH_NONE$1;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

