/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GroupByPackages {
    private final Map<File, Collection<File>> myParentToChildrenMap;
    private final Collection<File> myRoots;

    public GroupByPackages(@NotNull Collection<? extends File> files2) {
        if (files2 == null) {
            GroupByPackages.$$$reportNull$$$0(0);
        }
        this.myParentToChildrenMap = new HashMap<File, Collection<File>>();
        this.myRoots = new HashSet<File>();
        for (File file2 : files2) {
            this.process(file2);
        }
        this.splitRoots();
    }

    private void splitRoots() {
        for (File oldRoot : new ArrayList<File>(this.myRoots)) {
            File newRoot;
            if (oldRoot.equals(newRoot = this.splitRoot(oldRoot))) continue;
            this.replaceRoot(oldRoot, newRoot);
        }
    }

    private void replaceRoot(File oldRoot, File newRoot) {
        this.myRoots.remove(oldRoot);
        this.myRoots.add(newRoot);
    }

    private File splitRoot(@NotNull File oldRoot) {
        List<File> children2;
        if (oldRoot == null) {
            GroupByPackages.$$$reportNull$$$0(1);
        }
        if ((children2 = this.getChildren(oldRoot)).size() == 1) {
            return this.splitRoot(children2.get(0));
        }
        return oldRoot;
    }

    private void process(@NotNull File file2) {
        if (file2 == null) {
            GroupByPackages.$$$reportNull$$$0(2);
        }
        File f = file2;
        for (File parent = file2.getParentFile(); parent != null; parent = parent.getParentFile()) {
            Collection<File> files2 = this.myParentToChildrenMap.get(parent);
            if (files2 == null) {
                files2 = new HashSet<File>();
                this.myParentToChildrenMap.put(parent, files2);
            }
            files2.add(f);
            f = parent;
        }
        this.myRoots.add(f);
    }

    @NotNull
    public List<File> getRoots() {
        return new ArrayList<File>(this.myRoots);
    }

    @NotNull
    public List<File> getChildren(File file2) {
        Collection<File> collection = this.myParentToChildrenMap.get(file2);
        if (collection == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                GroupByPackages.$$$reportNull$$$0(3);
            }
            return list2;
        }
        return new ArrayList<File>(collection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/update/GroupByPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/update/GroupByPackages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "splitRoot";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

