/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.versionBrowser;

import com.intellij.DynamicBundle;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.DateFilterComponent;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StandardVersionFilterComponent<T extends ChangeBrowserSettings>
implements ChangesBrowserSettingsEditor<T> {
    private JPanel myPanel;
    private JTextField myNumBefore;
    private JCheckBox myUseNumBeforeFilter;
    private JCheckBox myUseNumAfterFilter;
    private JTextField myNumAfter;
    private DateFilterComponent myDateFilterComponent;
    private JPanel myVersionNumberPanel;
    private T mySettings;

    protected JPanel getDatePanel() {
        return this.myDateFilterComponent.getPanel();
    }

    protected Component getStandardPanel() {
        return this.myPanel;
    }

    public StandardVersionFilterComponent() {
        this.$$$setupUI$$$();
    }

    public StandardVersionFilterComponent(boolean showDateFilter) {
        this.$$$setupUI$$$();
        this.myDateFilterComponent.getPanel().setVisible(showDateFilter);
    }

    protected void init(@NotNull T settings) {
        if (settings == null) {
            StandardVersionFilterComponent.$$$reportNull$$$0(0);
        }
        this.myVersionNumberPanel.setBorder(IdeBorderFactory.createTitledBorder((String)this.getChangeNumberTitle()));
        this.installCheckBoxesListeners();
        this.initValues(settings);
        this.updateAllEnabled(null);
    }

    protected void disableVersionNumbers() {
        this.myNumAfter.setVisible(false);
        this.myNumBefore.setVisible(false);
        this.myUseNumBeforeFilter.setVisible(false);
        this.myUseNumAfterFilter.setVisible(false);
    }

    @Nls
    protected String getChangeNumberTitle() {
        return VcsBundle.message((String)"border.changes.filter.change.number.filter", (Object[])new Object[0]);
    }

    @Nls
    protected String getChangeFromParseError() {
        return VcsBundle.message((String)"error.change.from.must.be.a.valid.number", (Object[])new Object[0]);
    }

    @Nls
    protected String getChangeToParseError() {
        return VcsBundle.message((String)"error.change.to.must.be.a.valid.number", (Object[])new Object[0]);
    }

    private void installCheckBoxesListeners() {
        ActionListener filterListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StandardVersionFilterComponent.this.updateAllEnabled(e);
            }
        };
        this.installCheckBoxListener(filterListener);
    }

    public static void updatePair(@NotNull JCheckBox checkBox2, @NotNull JComponent textField2, @Nullable ActionEvent e) {
        Object source;
        if (checkBox2 == null) {
            StandardVersionFilterComponent.$$$reportNull$$$0(1);
        }
        if (textField2 == null) {
            StandardVersionFilterComponent.$$$reportNull$$$0(2);
        }
        textField2.setEnabled(checkBox2.isSelected());
        if (e != null && e.getSource() instanceof JCheckBox && ((JCheckBox)e.getSource()).isSelected() && (source = e.getSource()) == checkBox2 && checkBox2.isSelected()) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)textField2, true));
        }
    }

    protected void updateAllEnabled(@Nullable ActionEvent e) {
        StandardVersionFilterComponent.updatePair(this.myUseNumBeforeFilter, this.myNumBefore, e);
        StandardVersionFilterComponent.updatePair(this.myUseNumAfterFilter, this.myNumAfter, e);
    }

    protected void initValues(@NotNull T settings) {
        if (settings == null) {
            StandardVersionFilterComponent.$$$reportNull$$$0(3);
        }
        this.myUseNumBeforeFilter.setSelected(((ChangeBrowserSettings)settings).USE_CHANGE_BEFORE_FILTER);
        this.myUseNumAfterFilter.setSelected(((ChangeBrowserSettings)settings).USE_CHANGE_AFTER_FILTER);
        this.myDateFilterComponent.initValues((ChangeBrowserSettings)settings);
        this.myNumBefore.setText(((ChangeBrowserSettings)settings).CHANGE_BEFORE);
        this.myNumAfter.setText(((ChangeBrowserSettings)settings).CHANGE_AFTER);
    }

    public void saveValues(@NotNull T settings) {
        if (settings == null) {
            StandardVersionFilterComponent.$$$reportNull$$$0(4);
        }
        this.myDateFilterComponent.saveValues((ChangeBrowserSettings)settings);
        ((ChangeBrowserSettings)settings).USE_CHANGE_BEFORE_FILTER = this.myUseNumBeforeFilter.isSelected();
        ((ChangeBrowserSettings)settings).USE_CHANGE_AFTER_FILTER = this.myUseNumAfterFilter.isSelected();
        ((ChangeBrowserSettings)settings).CHANGE_BEFORE = this.myNumBefore.getText();
        ((ChangeBrowserSettings)settings).CHANGE_AFTER = this.myNumAfter.getText();
    }

    protected void installCheckBoxListener(@NotNull ActionListener filterListener) {
        if (filterListener == null) {
            StandardVersionFilterComponent.$$$reportNull$$$0(5);
        }
        this.myUseNumBeforeFilter.addActionListener(filterListener);
        this.myUseNumAfterFilter.addActionListener(filterListener);
    }

    @NotNull
    public T getSettings() {
        this.saveValues(this.mySettings);
        T t = this.mySettings;
        if (t == null) {
            StandardVersionFilterComponent.$$$reportNull$$$0(6);
        }
        return t;
    }

    public void setSettings(@NotNull T settings) {
        if (settings == null) {
            StandardVersionFilterComponent.$$$reportNull$$$0(7);
        }
        this.mySettings = settings;
        this.initValues(settings);
        this.updateAllEnabled(null);
    }

    @Nullable
    public String validateInput() {
        if (this.myUseNumAfterFilter.isSelected()) {
            try {
                Long.parseLong(this.myNumAfter.getText());
            }
            catch (NumberFormatException ex) {
                return this.getChangeFromParseError();
            }
        }
        if (this.myUseNumBeforeFilter.isSelected()) {
            try {
                Long.parseLong(this.myNumBefore.getText());
            }
            catch (NumberFormatException ex) {
                return this.getChangeToParseError();
            }
        }
        return this.myDateFilterComponent.validateInput();
    }

    public void updateEnabledControls() {
        this.updateAllEnabled(null);
    }

    @NotNull
    public String getDimensionServiceKey() {
        String string = this.getClass().getName();
        if (string == null) {
            StandardVersionFilterComponent.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkBox";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterListener";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/versionBrowser/StandardVersionFilterComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/versionBrowser/StandardVersionFilterComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionServiceKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updatePair";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initValues";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveValues";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "installCheckBoxListener";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        DateFilterComponent dateFilterComponent;
        JTextField jTextField;
        JCheckBox jCheckBox;
        JTextField jTextField2;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myVersionNumberPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseNumAfterFilter = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/VcsBundle", StandardVersionFilterComponent.class).getString("checkbox.show.changes.after.num"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNumAfter = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(50, -1), null));
        this.myUseNumBeforeFilter = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/VcsBundle", StandardVersionFilterComponent.class).getString("checkbox.show.changes.before.num"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNumBefore = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(50, -1), null));
        this.myDateFilterComponent = dateFilterComponent = new DateFilterComponent();
        JComponent jComponent = dateFilterComponent.$$$getRootComponent$$$();
        jPanel3.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

