/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.VirtualFileManagerImpl;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformVirtualFileManager
extends VirtualFileManagerImpl {
    @NotNull
    private final ManagingFS myManagingFS = ManagingFS.getInstance();

    public PlatformVirtualFileManager() {
        super(Collections.emptyList());
    }

    @Override
    protected long doRefresh(boolean asynchronous, @Nullable Runnable postAction) {
        if (!asynchronous) {
            ApplicationManager.getApplication().assertIsWriteThread();
        }
        RefreshSession session2 = RefreshQueue.getInstance().createSession(asynchronous, true, postAction);
        session2.addAllFiles(this.myManagingFS.getRoots());
        session2.launch();
        super.doRefresh(asynchronous, postAction);
        return session2.getId();
    }

    @Override
    public long getModificationCount() {
        return this.myManagingFS.getModificationCount();
    }

    @Override
    public long getStructureModificationCount() {
        return this.myManagingFS.getStructureModificationCount();
    }

    public VirtualFile findFileById(int id2) {
        return this.myManagingFS.findFileById(id2);
    }

    @Override
    @NotNull
    public CharSequence getVFileName(int nameId) {
        CharSequence charSequence = FileNameCache.getVFileName(nameId);
        if (charSequence == null) {
            PlatformVirtualFileManager.$$$reportNull$$$0(0);
        }
        return charSequence;
    }

    @Override
    public int storeName(@NotNull String name2) {
        if (name2 == null) {
            PlatformVirtualFileManager.$$$reportNull$$$0(1);
        }
        return FileNameCache.storeName(name2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/PlatformVirtualFileManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVFileName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/PlatformVirtualFileManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "storeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

