/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class IdentityVirtualFilePointer
extends VirtualFilePointerImpl
implements VirtualFilePointer,
Disposable {
    private final Map<String, IdentityVirtualFilePointer> myUrlToIdentity;
    private final VirtualFilePointerManagerImpl myVirtualFilePointerManager;
    private final VirtualFile myFile;
    private final String myUrl;

    IdentityVirtualFilePointer(VirtualFile file2, @NotNull String url, Map<String, IdentityVirtualFilePointer> urlToIdentity, @NotNull VirtualFilePointerManagerImpl virtualFilePointerManager, VirtualFilePointerListener listener2) {
        if (url == null) {
            IdentityVirtualFilePointer.$$$reportNull$$$0(0);
        }
        if (virtualFilePointerManager == null) {
            IdentityVirtualFilePointer.$$$reportNull$$$0(1);
        }
        super(listener2);
        this.myVirtualFilePointerManager = virtualFilePointerManager;
        this.myUrlToIdentity = urlToIdentity;
        this.myFile = file2;
        this.myUrl = url;
    }

    @Override
    @NotNull
    public String getFileName() {
        String string = this.getUrl();
        if (string == null) {
            IdentityVirtualFilePointer.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public VirtualFile getFile() {
        return this.isValid() ? this.myFile : null;
    }

    @Override
    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            IdentityVirtualFilePointer.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableUrl() {
        String string = this.getUrl();
        if (string == null) {
            IdentityVirtualFilePointer.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean isValid() {
        return this.myFile == null || this.myFile.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = this.myVirtualFilePointerManager;
        synchronized (virtualFilePointerManagerImpl) {
            this.incrementUsageCount(-1);
            this.myUrlToIdentity.remove(this.myUrl);
        }
    }

    @Override
    public String toString() {
        return "identity: url='" + this.myUrl + "'; file=" + this.myFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFilePointerManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/IdentityVirtualFilePointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/IdentityVirtualFilePointer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

