/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.http.FileDownloadingAdapter;
import com.intellij.openapi.vfs.impl.http.HttpFileSystemBase;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfoImpl;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HttpVirtualFileImpl
extends HttpVirtualFile {
    private final HttpFileSystemBase myFileSystem;
    @Nullable
    private final RemoteFileInfoImpl myFileInfo;
    @Nullable
    private FileType myInitialFileType;
    private final String myPath;
    private final String myParentPath;
    private final String myName;
    private List<VirtualFile> myChildren;

    HttpVirtualFileImpl(@NotNull HttpFileSystemBase fileSystem, @Nullable HttpVirtualFileImpl parent, String path2, @Nullable RemoteFileInfoImpl fileInfo) {
        if (fileSystem == null) {
            HttpVirtualFileImpl.$$$reportNull$$$0(0);
        }
        if (parent != null) {
            if (parent.myChildren == null) {
                parent.myChildren = new SmartList();
            }
            parent.myChildren.add(this);
        }
        this.myFileSystem = fileSystem;
        this.myPath = path2;
        this.myFileInfo = fileInfo;
        if (this.myFileInfo != null) {
            this.myFileInfo.addDownloadingListener(new FileDownloadingAdapter(){

                @Override
                public void fileDownloaded(@NotNull VirtualFile localFile) {
                    if (localFile == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        HttpVirtualFileImpl file2 = HttpVirtualFileImpl.this;
                        FileDocumentManager.getInstance().reloadFiles(new VirtualFile[]{file2});
                        if (HttpVirtualFileImpl.this.myInitialFileType != null && !FileTypeRegistry.getInstance().isFileOfType(localFile, HttpVirtualFileImpl.this.myInitialFileType)) {
                            FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{file2});
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFile", "com/intellij/openapi/vfs/impl/http/HttpVirtualFileImpl$1", "fileDownloaded"));
                }
            });
            path2 = UriUtil.trimTrailingSlashes(UriUtil.trimParameters(path2));
            int lastSlash = path2.lastIndexOf(47);
            if (lastSlash == -1) {
                this.myParentPath = null;
                this.myName = path2;
            } else {
                this.myParentPath = path2.substring(0, lastSlash);
                this.myName = path2.substring(lastSlash + 1);
            }
        } else {
            int lastSlash = path2.lastIndexOf(47);
            if (lastSlash == path2.length() - 1) {
                this.myParentPath = null;
                this.myName = path2;
            } else {
                int prevSlash = path2.lastIndexOf(47, lastSlash - 1);
                this.myParentPath = path2.substring(0, prevSlash < 0 ? lastSlash + 1 : lastSlash);
                this.myName = path2.substring(lastSlash + 1);
            }
        }
    }

    @Override
    @Nullable
    public RemoteFileInfoImpl getFileInfo() {
        return this.myFileInfo;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        HttpFileSystemBase httpFileSystemBase = this.myFileSystem;
        if (httpFileSystemBase == null) {
            HttpVirtualFileImpl.$$$reportNull$$$0(1);
        }
        return httpFileSystemBase;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            HttpVirtualFileImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            HttpVirtualFileImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NonNls
    public String toString() {
        return "HttpVirtualFile:" + this.myPath + ", info=" + this.myFileInfo;
    }

    public VirtualFile getParent() {
        return this.myParentPath == null ? null : this.myFileSystem.findFileByPath(this.myParentPath, true);
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isDirectory() {
        return this.myFileInfo == null;
    }

    public VirtualFile[] getChildren() {
        return ContainerUtil.isEmpty(this.myChildren) ? EMPTY_ARRAY : this.myChildren.toArray(VirtualFile.EMPTY_ARRAY);
    }

    @Nullable
    public VirtualFile findChild(@NotNull @NonNls String name2) {
        if (name2 == null) {
            HttpVirtualFileImpl.$$$reportNull$$$0(4);
        }
        if (!ContainerUtil.isEmpty(this.myChildren)) {
            for (VirtualFile child2 : this.myChildren) {
                if (!StringUtil.equals((CharSequence)child2.getNameSequence(), (CharSequence)name2)) continue;
                return child2;
            }
        }
        return null;
    }

    @NotNull
    public FileType getFileType() {
        if (this.myFileInfo == null) {
            FileType fileType = super.getFileType();
            if (fileType == null) {
                HttpVirtualFileImpl.$$$reportNull$$$0(5);
            }
            return fileType;
        }
        VirtualFile localFile = this.myFileInfo.getLocalFile();
        if (localFile != null) {
            FileType fileType = localFile.getFileType();
            if (fileType == null) {
                HttpVirtualFileImpl.$$$reportNull$$$0(6);
            }
            return fileType;
        }
        FileType fileType = super.getFileType();
        if (this.myInitialFileType == null) {
            this.myInitialFileType = fileType;
        }
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            HttpVirtualFileImpl.$$$reportNull$$$0(7);
        }
        return fileType2;
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        VirtualFile localFile;
        if (this.myFileInfo != null && (localFile = this.myFileInfo.getLocalFile()) != null) {
            InputStream inputStream2 = localFile.getInputStream();
            if (inputStream2 == null) {
                HttpVirtualFileImpl.$$$reportNull$$$0(8);
            }
            return inputStream2;
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        VirtualFile localFile;
        if (this.myFileInfo != null && (localFile = this.myFileInfo.getLocalFile()) != null) {
            OutputStream outputStream = localFile.getOutputStream(requestor, newModificationStamp, newTimeStamp);
            if (outputStream == null) {
                HttpVirtualFileImpl.$$$reportNull$$$0(9);
            }
            return outputStream;
        }
        throw new UnsupportedOperationException();
    }

    public byte @NotNull [] contentsToByteArray() throws IOException {
        if (this.myFileInfo == null) {
            throw new UnsupportedOperationException();
        }
        VirtualFile localFile = this.myFileInfo.getLocalFile();
        if (localFile != null) {
            byte[] byArray = localFile.contentsToByteArray();
            if (byArray == null) {
                HttpVirtualFileImpl.$$$reportNull$$$0(10);
            }
            return byArray;
        }
        if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
            HttpVirtualFileImpl.$$$reportNull$$$0(11);
        }
        return ArrayUtilRt.EMPTY_BYTE_ARRAY;
    }

    public long getTimeStamp() {
        return 0L;
    }

    public long getModificationStamp() {
        return 0L;
    }

    public long getLength() {
        return -1L;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
        if (this.myFileInfo != null) {
            this.myFileInfo.refresh(postRunnable);
        } else if (postRunnable != null) {
            postRunnable.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/http/HttpVirtualFileImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/http/HttpVirtualFileImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

