/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.wsl;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.local.FileWatcherNotificationSink;
import com.intellij.openapi.vfs.local.PluggableFileWatcher;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class WslFileWatcher
extends PluggableFileWatcher {
    private static final String FSNOTIFIER_WSL = "fsnotifier-wsl";
    private static final int NAME_START = "\\\\wsl$\\".length();
    private static final String ROOTS_COMMAND = "ROOTS";
    private static final String EXIT_COMMAND = "EXIT";
    private static final int MAX_PROCESS_LAUNCH_ATTEMPT_COUNT = 10;
    private FileWatcherNotificationSink myNotificationSink;
    private Path myExecutable;
    private final Map<String, VmData> myVMs = new ConcurrentHashMap<String, VmData>();
    private final AtomicInteger mySettingRoots = new AtomicInteger(0);
    private volatile boolean myShuttingDown = false;
    private volatile boolean myTestStarted = false;
    private static final BaseOutputReader.Options READER_OPTIONS = new BaseOutputReader.Options(){

        public BaseDataReader.SleepingPolicy policy() {
            return BaseDataReader.SleepingPolicy.BLOCKING;
        }

        public boolean sendIncompleteLines() {
            return false;
        }

        public boolean withSeparators() {
            return false;
        }
    };

    private static Logger logger(@Nullable String vm) {
        return vm == null ? Logger.getInstance(WslFileWatcher.class) : Logger.getInstance((String)("#" + WslFileWatcher.class.getName() + "." + vm));
    }

    @Override
    public void initialize(@NotNull ManagingFS managingFS, @NotNull FileWatcherNotificationSink notificationSink) {
        if (managingFS == null) {
            WslFileWatcher.$$$reportNull$$$0(0);
        }
        if (notificationSink == null) {
            WslFileWatcher.$$$reportNull$$$0(1);
        }
        this.myNotificationSink = notificationSink;
        if (SystemInfo.isWin10OrNewer && PathEnvironmentVariableUtil.findInPath((String)"wsl.exe") != null) {
            this.myExecutable = PathManager.findBinFile((String)FSNOTIFIER_WSL);
            if (this.myExecutable != null) {
                WslFileWatcher.logger(null).info("WSL file watcher: " + this.myExecutable);
            }
        }
    }

    private void notifyOnFailure(@NlsSafe String vm, @NlsContexts.NotificationContent String cause, @Nullable NotificationListener listener2) {
        this.myNotificationSink.notifyUserOnFailure("[" + vm + "] " + cause, listener2);
    }

    @Override
    public void dispose() {
        this.myShuttingDown = true;
        for (Map.Entry<String, VmData> entry2 : this.myVMs.entrySet()) {
            this.shutdownProcess(entry2.getValue());
        }
    }

    @Override
    public boolean isOperational() {
        return this.myExecutable != null && (!ApplicationManager.getApplication().isUnitTestMode() || this.myTestStarted);
    }

    @Override
    public boolean isSettingRoots() {
        return this.isOperational() && this.mySettingRoots.get() > 0;
    }

    @Override
    public void setWatchRoots(@NotNull List<String> recursive, @NotNull List<String> flat) {
        if (recursive == null) {
            WslFileWatcher.$$$reportNull$$$0(2);
        }
        if (flat == null) {
            WslFileWatcher.$$$reportNull$$$0(3);
        }
        if (this.myShuttingDown) {
            return;
        }
        HashMap<String, VmData> newVMs = new HashMap<String, VmData>();
        ArrayList<String> ignored = new ArrayList<String>();
        WslFileWatcher.sortRoots(recursive, newVMs, ignored, true);
        WslFileWatcher.sortRoots(flat, newVMs, ignored, false);
        this.myNotificationSink.notifyManualWatchRoots(this, ignored);
        for (Map.Entry entry2 : newVMs.entrySet()) {
            VmData upcoming = (VmData)entry2.getValue();
            VmData vm = this.myVMs.computeIfAbsent((String)entry2.getKey(), k -> upcoming);
            assert (vm != null) : entry2;
            if (vm == upcoming) {
                this.setupProcess(vm);
                continue;
            }
            if (!vm.recursive.equals(upcoming.recursive) || !vm.flat.equals(upcoming.flat)) {
                vm.reload(upcoming);
                this.setupProcess(vm);
                continue;
            }
            this.myNotificationSink.notifyManualWatchRoots(this, vm.ignored);
        }
        Iterator<Map.Entry<String, VmData>> iterator2 = this.myVMs.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, VmData> entry3 = iterator2.next();
            if (newVMs.containsKey(entry3.getKey())) continue;
            iterator2.remove();
            this.shutdownProcess(entry3.getValue());
        }
    }

    private static void sortRoots(List<String> roots2, Map<String, VmData> vms, List<String> ignored, boolean recursive) {
        for (String root2 : roots2) {
            int nameEnd;
            if (StringUtil.startsWithIgnoreCase((String)root2, (String)"\\\\wsl$\\") && (nameEnd = root2.indexOf(92, NAME_START)) > NAME_START) {
                String prefix = root2.substring(0, nameEnd);
                String name2 = root2.substring(NAME_START, nameEnd);
                VmData vm = vms.computeIfAbsent(name2, k -> new VmData((String)k, prefix));
                String path2 = root2.substring(nameEnd).replace('\\', '/');
                (recursive ? vm.recursive : vm.flat).add(path2);
                continue;
            }
            ignored.add(root2);
        }
    }

    private void setupProcess(VmData vm) {
        if (this.myShuttingDown || vm.shuttingDown) {
            return;
        }
        MyProcessHandler handler2 = vm.handler;
        if (handler2 == null) {
            if (vm.startAttemptCount.incrementAndGet() > 10) {
                this.notifyOnFailure(vm.name, IdeCoreBundle.message((String)"watcher.bailed.out.10x", (Object[])new Object[]{vm.name}), null);
                return;
            }
            try {
                Path toolName = this.myExecutable.getFileName();
                Path toolDir = this.myExecutable.getParent();
                Process process2 = new ProcessBuilder("wsl", "-d", vm.name, "-e", "./" + toolName).directory(toolDir.toFile()).start();
                vm.handler = handler2 = new MyProcessHandler(process2, vm);
                handler2.startNotify();
            }
            catch (IOException e) {
                vm.logger.error((Throwable)e);
                vm.startAttemptCount.set(10);
                this.notifyOnFailure(vm.name, IdeCoreBundle.message((String)"watcher.failed.to.start", (Object[])new Object[]{vm.name}), null);
                return;
            }
        }
        this.mySettingRoots.incrementAndGet();
        try {
            handler2.writeLine(ROOTS_COMMAND);
            for (String path2 : vm.recursive) {
                handler2.writeLine(path2);
            }
            for (String path2 : vm.flat) {
                handler2.writeLine("|" + path2);
            }
            handler2.writeLine("#");
        }
        catch (IOException e) {
            vm.logger.error((Throwable)e);
        }
    }

    private void shutdownProcess(VmData vm) {
        MyProcessHandler processHandler2 = vm.handler;
        if (processHandler2 != null && !processHandler2.isProcessTerminated()) {
            vm.shuttingDown = true;
            try {
                processHandler2.writeLine(EXIT_COMMAND);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!processHandler2.waitFor(10L)) {
                Runnable r = () -> {
                    if (!processHandler2.waitFor(500L)) {
                        vm.logger.warn("WSL file watcher is still alive, doing a force quit.");
                        processHandler2.destroyProcess();
                    }
                };
                if (this.myShuttingDown) {
                    new Thread(r, "fsnotifier-wsl shutdown").start();
                } else {
                    ApplicationManager.getApplication().executeOnPooledThread(r);
                }
            }
        }
        vm.handler = null;
    }

    @Override
    @TestOnly
    public void startup() {
        Application app2 = ApplicationManager.getApplication();
        if (app2 == null || !app2.isUnitTestMode()) {
            throw new IllegalStateException();
        }
        this.myTestStarted = true;
        this.myShuttingDown = false;
    }

    @Override
    @TestOnly
    public void shutdown() {
        Application app2 = ApplicationManager.getApplication();
        if (app2 == null || !app2.isUnitTestMode()) {
            throw new IllegalStateException();
        }
        this.myTestStarted = false;
        this.myShuttingDown = true;
        this.myVMs.forEach((key, value2) -> this.shutdownProcess((VmData)value2));
        this.myVMs.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managingFS";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationSink";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursive";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flat";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/impl/wsl/WslFileWatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "initialize";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setWatchRoots";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyProcessHandler
    extends OSProcessHandler {
        private final BufferedWriter myWriter;
        private final VmData myVm;
        private WatcherOp myLastOp;
        private final List<String> myLines;

        MyProcessHandler(Process process2, VmData vm) {
            super(process2, "fsnotifier-wsl @ " + vm.name, StandardCharsets.UTF_8);
            this.myLines = new ArrayList<String>();
            this.myWriter = new BufferedWriter(new OutputStreamWriter(process2.getOutputStream(), StandardCharsets.UTF_8));
            this.myVm = vm;
        }

        void writeLine(String line) throws IOException {
            if (this.myVm.logger.isTraceEnabled()) {
                this.myVm.logger.trace("<< " + line);
            }
            this.myWriter.write(line);
            this.myWriter.write(10);
            this.myWriter.flush();
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options2 = READER_OPTIONS;
            if (options2 == null) {
                MyProcessHandler.$$$reportNull$$$0(0);
            }
            return options2;
        }

        protected void notifyProcessTerminated(int exitCode) {
            super.notifyProcessTerminated(exitCode);
            String message2 = "Watcher terminated with exit code " + exitCode;
            if (WslFileWatcher.this.myShuttingDown || this.myVm.shuttingDown) {
                this.myVm.logger.info(message2);
            } else {
                this.myVm.logger.warn(message2);
            }
            this.myVm.handler = null;
            WslFileWatcher.this.setupProcess(this.myVm);
        }

        public void notifyTextAvailable(@NotNull String line, @NotNull Key outputType) {
            if (line == null) {
                MyProcessHandler.$$$reportNull$$$0(1);
            }
            if (outputType == null) {
                MyProcessHandler.$$$reportNull$$$0(2);
            }
            if (outputType == ProcessOutputTypes.STDERR) {
                this.myVm.logger.warn(line);
            }
            if (outputType != ProcessOutputTypes.STDOUT) {
                return;
            }
            if (this.myVm.logger.isTraceEnabled()) {
                this.myVm.logger.trace(">> " + line);
            }
            if (this.myLastOp == null) {
                WatcherOp watcherOp;
                try {
                    watcherOp = WatcherOp.valueOf(line);
                }
                catch (IllegalArgumentException e) {
                    byte[] raw = line.getBytes(StandardCharsets.UTF_8);
                    if (raw.length > 3 && raw[0] != 0 && raw[2] != 0 && raw[1] + raw[3] == 0) {
                        this.myVm.logger.warn(new String(raw, StandardCharsets.UTF_16LE));
                    } else if (!(raw.length == 1 && raw[0] == 0 || raw.length == 2 && raw[0] + raw[1] == 0)) {
                        this.myVm.logger.error("Illegal watcher command: '" + line + "'", (Throwable)null);
                    }
                    return;
                }
                if (watcherOp == WatcherOp.GIVEUP) {
                    WslFileWatcher.this.notifyOnFailure(this.myVm.name, IdeCoreBundle.message((String)"watcher.gave.up", (Object[])new Object[0]), null);
                } else if (watcherOp == WatcherOp.RESET) {
                    WslFileWatcher.this.myNotificationSink.notifyReset(Strings.trimEnd((String)this.myVm.prefix, (char)'\\'));
                } else {
                    this.myLastOp = watcherOp;
                }
            } else if (this.myLastOp == WatcherOp.MESSAGE) {
                String localized = Objects.requireNonNullElse(IdeCoreBundle.INSTANCE.messageOrNull(line, new Object[0]), line);
                this.myVm.logger.warn(localized);
                WslFileWatcher.this.notifyOnFailure(this.myVm.name, localized, NotificationListener.URL_OPENING_LISTENER);
                this.myLastOp = null;
            } else if (this.myLastOp == WatcherOp.UNWATCHEABLE) {
                if ("#".equals(line)) {
                    WslFileWatcher.this.mySettingRoots.decrementAndGet();
                    this.processUnwatchable();
                    this.myLines.clear();
                    this.myLastOp = null;
                } else {
                    this.myLines.add(line);
                }
            } else {
                String path2 = StringUtil.trimEnd((String)line.replace('\u0000', '\n'), (String)File.separator);
                this.processChange(path2, this.myLastOp);
                this.myLastOp = null;
            }
        }

        private void processUnwatchable() {
            ArrayList<String> roots2 = new ArrayList<String>(this.myLines.size());
            for (String line : this.myLines) {
                roots2.add(this.myVm.prefix + line.replace('/', '\\'));
            }
            this.myVm.ignored = new CopyOnWriteArrayList<String>(roots2);
            WslFileWatcher.this.myNotificationSink.notifyManualWatchRoots(WslFileWatcher.this, roots2);
        }

        private void processChange(String path2, WatcherOp op) {
            String root2 = this.myVm.prefix + path2.replace('/', '\\');
            if (op == WatcherOp.STATS || op == WatcherOp.CHANGE) {
                WslFileWatcher.this.myNotificationSink.notifyDirtyPath(root2);
            } else if (op == WatcherOp.CREATE || op == WatcherOp.DELETE) {
                WslFileWatcher.this.myNotificationSink.notifyPathCreatedOrDeleted(root2);
            } else {
                this.myVm.logger.error("unexpected op: " + op);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/impl/wsl/WslFileWatcher$MyProcessHandler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/impl/wsl/WslFileWatcher$MyProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyTextAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum WatcherOp {
        GIVEUP,
        RESET,
        UNWATCHEABLE,
        MESSAGE,
        CREATE,
        DELETE,
        STATS,
        CHANGE;

    }

    private static final class VmData {
        final String name;
        final String prefix;
        final List<String> recursive = new ArrayList<String>();
        final List<String> flat = new ArrayList<String>();
        final Logger logger;
        final AtomicInteger startAttemptCount = new AtomicInteger(0);
        volatile MyProcessHandler handler;
        volatile List<String> ignored = Collections.emptyList();
        volatile boolean shuttingDown;

        VmData(String name2, String prefix) {
            this.name = name2;
            this.prefix = prefix;
            this.logger = WslFileWatcher.logger(name2);
        }

        void reload(VmData other) {
            this.recursive.clear();
            this.recursive.addAll(other.recursive);
            this.flat.clear();
            this.flat.addAll(other.flat);
            this.ignored = Collections.emptyList();
        }
    }
}

