/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.util.containers.CollectionFactory;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class FileLoadingTracker {
    private static final Logger LOG = Logger.getInstance(FileLoadingTracker.class);
    private static final Set<String> ourPaths;
    private static final IntSet ourLeafNameIds;

    FileLoadingTracker() {
    }

    static void fileLoaded(@NotNull VirtualDirectoryImpl parent, int nameId) {
        String path2;
        if (parent == null) {
            FileLoadingTracker.$$$reportNull$$$0(0);
        }
        if (ourLeafNameIds.contains(nameId) && ourPaths.contains(path2 = parent.getPath() + "/" + FileNameCache.getVFileName(nameId))) {
            LOG.info("Loading " + path2, new Throwable());
        }
    }

    static {
        String[] pathsToTrack = System.getProperty("file.system.trace.loading", "").split(";");
        if (pathsToTrack.length == 0) {
            ourPaths = Collections.emptySet();
            ourLeafNameIds = IntSets.EMPTY_SET;
        } else {
            ourPaths = CollectionFactory.createFilePathSet((String[])pathsToTrack, (boolean)SystemInfoRt.isFileSystemCaseSensitive);
            ourLeafNameIds = new IntOpenHashSet(ourPaths.size());
            for (String path2 : ourPaths) {
                ourLeafNameIds.add(FileNameCache.storeName(StringUtilRt.getShortName((String)path2, (char)'/')));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/newvfs/impl/FileLoadingTracker", "fileLoaded"));
    }
}

