/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.vfs.newvfs.ChildInfoImpl;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.FastUtilHashingStrategies;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

final class ListResult {
    private final int modStamp;
    final List<? extends ChildInfo> children;
    private final int myParentId;

    ListResult(@NotNull List<? extends ChildInfo> children2, int parentId) {
        if (children2 == null) {
            ListResult.$$$reportNull$$$0(0);
        }
        this(FSRecords.getModCount(parentId), children2, parentId);
    }

    private ListResult(int modStamp, @NotNull List<? extends ChildInfo> children2, int parentId) {
        if (children2 == null) {
            ListResult.$$$reportNull$$$0(1);
        }
        this.modStamp = modStamp;
        this.children = children2;
        this.myParentId = parentId;
        Application app2 = ApplicationManager.getApplication();
        if (app2.isUnitTestMode() && !ApplicationManagerEx.isInStressTest() || app2.isInternal()) {
            this.assertSortedById(children2);
        }
    }

    private void assertSortedById(@NotNull List<? extends ChildInfo> children2) {
        if (children2 == null) {
            ListResult.$$$reportNull$$$0(2);
        }
        for (int i2 = 1; i2 < children2.size(); ++i2) {
            ChildInfo info2 = children2.get(i2);
            if (info2.getId() >= children2.get(i2 - 1).getId()) continue;
            throw new IllegalArgumentException("Unsorted list: " + this);
        }
    }

    @Contract(pure=true)
    @NotNull
    ListResult insert(@NotNull ChildInfo child2) {
        if (child2 == null) {
            ListResult.$$$reportNull$$$0(3);
        }
        ArrayList<Object> newChildren = new ArrayList<Object>(this.children.size() + 1);
        int id2 = child2.getId();
        int i2 = ObjectUtils.binarySearch((int)0, (int)this.children.size(), mid -> Integer.compare(this.children.get(mid).getId(), id2));
        if (i2 >= 0) {
            newChildren.addAll(this.children);
            newChildren.set(i2, child2);
        } else {
            int j;
            int toInsert = -i2 - 1;
            for (j = 0; j < toInsert; ++j) {
                newChildren.add(this.children.get(j));
            }
            newChildren.add(child2);
            for (j = toInsert; j < this.children.size(); ++j) {
                newChildren.add(this.children.get(j));
            }
        }
        return new ListResult(this.modStamp, newChildren, this.myParentId);
    }

    @Contract(pure=true)
    @NotNull
    ListResult remove(@NotNull ChildInfo child2) {
        int j;
        if (child2 == null) {
            ListResult.$$$reportNull$$$0(4);
        }
        ArrayList<ChildInfo> newChildren = new ArrayList<ChildInfo>(this.children.size() + 1);
        int id2 = child2.getId();
        int toRemove2 = ObjectUtils.binarySearch((int)0, (int)this.children.size(), mid -> Integer.compare(this.children.get(mid).getId(), id2));
        if (toRemove2 < 0) {
            ListResult listResult = this;
            if (listResult == null) {
                ListResult.$$$reportNull$$$0(5);
            }
            return listResult;
        }
        for (j = 0; j < toRemove2; ++j) {
            newChildren.add(this.children.get(j));
        }
        for (j = toRemove2 + 1; j < this.children.size(); ++j) {
            newChildren.add(this.children.get(j));
        }
        return new ListResult(this.modStamp, newChildren, this.myParentId);
    }

    @Contract(pure=true)
    @NotNull
    ListResult merge(@NotNull List<? extends ChildInfo> newChildren, boolean isCaseSensitive) {
        if (newChildren == null) {
            ListResult.$$$reportNull$$$0(6);
        }
        ListResult newList = new ListResult(newChildren, this.myParentId);
        if (this.children.isEmpty()) {
            ListResult listResult = newList;
            if (listResult == null) {
                ListResult.$$$reportNull$$$0(7);
            }
            return listResult;
        }
        List<? extends ChildInfo> oldChildren = this.children;
        int size = Math.max(oldChildren.size(), newChildren.size());
        Object2IntOpenCustomHashMap nameToIndex = new Object2IntOpenCustomHashMap(size, FastUtilHashingStrategies.getCharSequenceStrategy((boolean)isCaseSensitive));
        nameToIndex.defaultReturnValue(-1);
        boolean needToSortResult = false;
        ArrayList<? extends ChildInfo> result2 = new ArrayList<ChildInfo>(size);
        int i2 = 0;
        int j = 0;
        while (i2 < newChildren.size() || j < oldChildren.size()) {
            ChildInfo replaced;
            int nameId;
            int dupI;
            CharSequence name2;
            int oldId;
            ChildInfo newChild = i2 == newChildren.size() ? null : newChildren.get(i2);
            ChildInfo oldChild = j == oldChildren.size() ? null : oldChildren.get(j);
            int newId = newChild == null ? Integer.MAX_VALUE : newChild.getId();
            int n = oldId = oldChild == null ? Integer.MAX_VALUE : oldChild.getId();
            if (newId == oldId) {
                ++i2;
                ++j;
                result2.add((ChildInfo)oldChild);
                continue;
            }
            if (newId < oldId) {
                name2 = newChild.getName();
                dupI = nameToIndex.put((Object)name2, result2.size());
                if (dupI == -1) {
                    result2.add((ChildInfo)newChild);
                } else {
                    ChildInfo oldDup = (ChildInfo)result2.get(dupI);
                    nameId = newChild.getNameId();
                    assert (nameId > 0) : newChildren;
                    replaced = ((ChildInfoImpl)oldDup).withNameId(nameId);
                    result2.set(dupI, (ChildInfo)replaced);
                    needToSortResult = true;
                }
                ++i2;
                continue;
            }
            name2 = oldChild.getName();
            dupI = nameToIndex.put((Object)name2, result2.size());
            if (dupI == -1) {
                result2.add((ChildInfo)oldChild);
            } else {
                ChildInfo dup = (ChildInfo)result2.get(dupI);
                nameId = dup.getNameId();
                assert (nameId > 0) : this;
                replaced = ((ChildInfoImpl)dup).withId(oldChild.getId());
                result2.set(dupI, (ChildInfo)replaced);
                needToSortResult = true;
            }
            ++j;
        }
        if (needToSortResult) {
            result2.sort(ChildInfo.BY_ID);
        }
        List<? extends ChildInfo> newRes = nameToIndex.isEmpty() ? newChildren : result2;
        return new ListResult(this.modStamp, newRes, this.myParentId);
    }

    @Contract(pure=true)
    @NotNull
    ListResult subtract(@NotNull List<? extends ChildInfo> list2) {
        if (list2 == null) {
            ListResult.$$$reportNull$$$0(8);
        }
        ArrayList<ChildInfo> newChildren = new ArrayList<ChildInfo>(this.children.size() + list2.size());
        int index1 = 0;
        int index2 = 0;
        while (index1 < this.children.size() && index2 < list2.size()) {
            ChildInfo element2;
            ChildInfo element1 = this.children.get(index1);
            int c = ChildInfo.BY_ID.compare(element1, element2 = list2.get(index2));
            if (c == 0) {
                ++index1;
                ++index2;
                continue;
            }
            if (c < 0) {
                newChildren.add(element1);
                ++index1;
                continue;
            }
            ++index2;
        }
        for (int i2 = index1; i2 < this.children.size(); ++i2) {
            newChildren.add(this.children.get(i2));
        }
        return new ListResult(this.modStamp, newChildren, this.myParentId);
    }

    boolean childrenWereChangedSinceLastList() {
        return this.modStamp != FSRecords.getModCount(this.myParentId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListResult result2 = (ListResult)o;
        return this.modStamp == result2.modStamp && this.children.equals(result2.children);
    }

    public int hashCode() {
        return Objects.hash(this.modStamp, this.children);
    }

    public String toString() {
        return "modStamp: " + this.modStamp + "; children: " + this.children;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/ListResult";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChildren";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/ListResult";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "remove";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assertSortedById";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "subtract";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

