/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VirtualDirectoryCache {
    private final ConcurrentIntObjectMap<VirtualFileSystemEntry> myIdToDirCache = ConcurrentCollectionFactory.createConcurrentIntObjectSoftValueMap();

    VirtualDirectoryCache() {
    }

    @NotNull
    VirtualFileSystemEntry getOrCacheDir(@NotNull VirtualFileSystemEntry newDir) {
        int id2;
        VirtualFileSystemEntry dir;
        if (newDir == null) {
            VirtualDirectoryCache.$$$reportNull$$$0(0);
        }
        if ((dir = (VirtualFileSystemEntry)((Object)this.myIdToDirCache.get(id2 = newDir.getId()))) != null) {
            VirtualFileSystemEntry virtualFileSystemEntry = dir;
            if (virtualFileSystemEntry == null) {
                VirtualDirectoryCache.$$$reportNull$$$0(1);
            }
            return virtualFileSystemEntry;
        }
        VirtualFileSystemEntry virtualFileSystemEntry = (VirtualFileSystemEntry)((Object)this.myIdToDirCache.cacheOrGet(id2, (Object)newDir));
        if (virtualFileSystemEntry == null) {
            VirtualDirectoryCache.$$$reportNull$$$0(2);
        }
        return virtualFileSystemEntry;
    }

    void cacheDir(@NotNull VirtualFileSystemEntry newDir) {
        if (newDir == null) {
            VirtualDirectoryCache.$$$reportNull$$$0(3);
        }
        this.myIdToDirCache.put(newDir.getId(), (Object)newDir);
    }

    @Nullable
    VirtualFileSystemEntry cacheDirIfAbsent(@NotNull VirtualFileSystemEntry newDir) {
        if (newDir == null) {
            VirtualDirectoryCache.$$$reportNull$$$0(4);
        }
        return (VirtualFileSystemEntry)((Object)this.myIdToDirCache.putIfAbsent(newDir.getId(), (Object)newDir));
    }

    @Nullable
    VirtualFileSystemEntry getCachedDir(int id2) {
        return (VirtualFileSystemEntry)((Object)this.myIdToDirCache.get(id2));
    }

    void dropNonRootCachedDirs() {
        this.myIdToDirCache.entrySet().removeIf(e -> ((VirtualFileSystemEntry)((Object)((Object)e.getValue()))).getParent() != null);
    }

    void remove(int id2) {
        this.myIdToDirCache.remove(id2);
    }

    @NotNull
    Collection<VirtualFileSystemEntry> getCachedDirs() {
        Collection collection = this.myIdToDirCache.values();
        if (collection == null) {
            VirtualDirectoryCache.$$$reportNull$$$0(5);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDir";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/VirtualDirectoryCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/VirtualDirectoryCache";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCacheDir";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCacheDir";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cacheDir";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cacheDirIfAbsent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

