/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.actionSystem.impl.PopupMenuPreloader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.FrameInfoHelper;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.LinuxIdeMenuBar;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.status.ClockPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.mac.foundation.NSDefaults;
import com.intellij.ui.mac.screenmenu.Menu;
import com.intellij.ui.mac.screenmenu.MenuBar;
import com.intellij.ui.mac.screenmenu.MenuItem;
import com.intellij.util.Alarm;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeMenuBar
extends JMenuBar
implements IdeEventQueue.EventDispatcher,
UISettingsListener {
    private static final Logger LOG = Logger.getInstance(IdeMenuBar.class);
    private static final int COLLAPSED_HEIGHT = 2;
    private List<AnAction> myVisibleActions = new ArrayList<AnAction>();
    private final MenuItemPresentationFactory myPresentationFactory = new MenuItemPresentationFactory();
    private final TimerListener myTimerListener = new MyTimerListener();
    protected final CheckedDisposable myDisposable = Disposer.newCheckedDisposable();
    @Nullable
    private final ClockPanel myClockPanel;
    @Nullable
    private final MyExitFullScreenButton myButton;
    @Nullable
    private final Animator myAnimator;
    @Nullable
    private final Timer myActivationWatcher;
    private final Alarm myUpdateAlarm = new Alarm();
    @NotNull
    private State myState = State.EXPANDED;
    private double myProgress;
    private boolean myActivated;
    private final MenuBar myScreenMenuPeer;

    @NotNull
    public static IdeMenuBar createMenuBar() {
        return SystemInfoRt.isLinux ? new LinuxIdeMenuBar() : new IdeMenuBar();
    }

    public IdeMenuBar setFrame(@NotNull JFrame frame) {
        if (frame == null) {
            IdeMenuBar.$$$reportNull$$$0(0);
        }
        if (this.myScreenMenuPeer != null) {
            this.myScreenMenuPeer.setFrame((Frame)frame);
        }
        return this;
    }

    protected IdeMenuBar() {
        MenuBar menuBar = this.myScreenMenuPeer = Menu.isJbScreenMenuEnabled() ? new MenuBar("MainMenu") : null;
        if (FrameInfoHelper.isFloatingMenuBarSupported()) {
            this.myAnimator = new MyAnimator();
            this.myActivationWatcher = TimerUtil.createNamedTimer((String)"IdeMenuBar", (int)100, (ActionListener)new MyActionListener());
            this.myClockPanel = new ClockPanel();
            this.myButton = new MyExitFullScreenButton();
            this.add(this.myClockPanel);
            this.add(this.myButton);
            this.addPropertyChangeListener("ide.frame.full.screen", event -> this.updateState());
            this.addMouseListener(new MyMouseListener());
        } else {
            this.myAnimator = null;
            this.myActivationWatcher = null;
            this.myClockPanel = null;
            this.myButton = null;
        }
        if (IdeFrameDecorator.isCustomDecorationActive()) {
            this.setOpaque(false);
        }
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
    }

    @NotNull
    public State getState() {
        State state = this.myState == null ? State.EXPANDING : this.myState;
        if (state == null) {
            IdeMenuBar.$$$reportNull$$$0(1);
        }
        return state;
    }

    @Override
    public JMenu add(JMenu menu) {
        menu.setFocusable(false);
        return super.add(menu);
    }

    @Override
    public Border getBorder() {
        if (IdeFrameDecorator.isCustomDecorationActive()) {
            return JBUI.Borders.empty();
        }
        State state = this.getState();
        if (state == State.EXPANDING || state == State.COLLAPSING) {
            return JBUI.Borders.empty();
        }
        if (state == State.TEMPORARY_EXPANDED && StartupUiUtil.isUnderDarcula()) {
            return JBUI.Borders.customLine((Color)Gray._75, (int)0, (int)0, (int)1, (int)0);
        }
        if (state == State.COLLAPSED) {
            return JBUI.Borders.emptyBottom((int)1);
        }
        return UISettings.getInstance().getShowMainToolbar() || UISettings.getInstance().getShowNavigationBar() ? super.getBorder() : null;
    }

    @Override
    public void paint(Graphics g) {
        if (this.getState() == State.COLLAPSED) {
            return;
        }
        super.paint(g);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.myClockPanel == null || this.myButton == null) {
            return;
        }
        if (this.getState() == State.EXPANDED) {
            this.myClockPanel.setVisible(false);
            this.myButton.setVisible(false);
        } else {
            this.myClockPanel.setVisible(true);
            this.myButton.setVisible(true);
            Dimension preferredSize = this.myButton.getPreferredSize();
            this.myButton.setBounds(this.getBounds().width - preferredSize.width, 0, preferredSize.width, preferredSize.height);
            preferredSize = this.myClockPanel.getPreferredSize();
            this.myClockPanel.setBounds(this.getBounds().width - preferredSize.width - this.myButton.getWidth(), 0, preferredSize.width, preferredSize.height);
        }
    }

    @Override
    public void menuSelectionChanged(boolean isIncluded) {
        if (!isIncluded && this.getState() == State.TEMPORARY_EXPANDED) {
            this.myActivated = false;
            this.setState(State.COLLAPSING);
            this.restartAnimator();
            return;
        }
        if (isIncluded && this.getState() == State.COLLAPSED) {
            this.myActivated = true;
            this.setState(State.TEMPORARY_EXPANDED);
            this.revalidate();
            this.repaint();
            SwingUtilities.invokeLater(() -> {
                JMenu menu = this.getMenu(this.getSelectionModel().getSelectedIndex());
                if (menu.isPopupMenuVisible()) {
                    menu.setPopupMenuVisible(false);
                    menu.setPopupMenuVisible(true);
                }
            });
        }
        super.menuSelectionChanged(isIncluded);
    }

    private boolean isActivated() {
        int index2 = this.getSelectionModel().getSelectedIndex();
        return index2 != -1 && this.getMenu(index2).isPopupMenuVisible();
    }

    private void updateState() {
        if (this.myAnimator == null) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(this);
        if (!(window instanceof IdeFrame)) {
            return;
        }
        boolean fullScreen = ((IdeFrame)window).isInFullScreen();
        if (fullScreen) {
            this.setState(State.COLLAPSING);
            this.restartAnimator();
        } else {
            this.myAnimator.suspend();
            this.setState(State.EXPANDED);
            if (this.myClockPanel != null) {
                this.myClockPanel.setVisible(false);
                if (this.myButton != null) {
                    this.myButton.setVisible(false);
                }
            }
        }
    }

    private void setState(@NotNull State state) {
        if (state == null) {
            IdeMenuBar.$$$reportNull$$$0(2);
        }
        this.myState = state;
        if (this.myState == State.EXPANDING && this.myActivationWatcher != null && !this.myActivationWatcher.isRunning()) {
            this.myActivationWatcher.start();
        } else if (this.myActivationWatcher != null && this.myActivationWatcher.isRunning() && (state == State.EXPANDED || state == State.COLLAPSED)) {
            this.myActivationWatcher.stop();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.getState().isInProgress()) {
            dimension.height = 2 + (int)((this.getState() == State.COLLAPSING ? 1.0 - this.myProgress : this.myProgress) * (double)(dimension.height - 2));
        } else if (this.getState() == State.COLLAPSED) {
            dimension.height = 2;
        }
        return dimension;
    }

    private void restartAnimator() {
        if (this.myAnimator != null) {
            this.myAnimator.reset();
            this.myAnimator.resume();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        ActionManagerEx.doWithLazyActionManager(actionManager -> {
            if (this.myDisposable.isDisposed()) {
                return;
            }
            this.doUpdateMenuActions(false, (ActionManager)actionManager);
            for (AnAction action2 : this.myVisibleActions) {
                if (!(action2 instanceof ActionGroup)) continue;
                PopupMenuPreloader.install(this, "MainMenu", null, () -> (ActionGroup)action2);
            }
            actionManager.addTimerListener(this.myTimerListener);
            Disposer.register((Disposable)this.myDisposable, () -> actionManager.removeTimerListener(this.myTimerListener));
        });
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this.myDisposable);
        IdeEventQueue.getInstance().addDispatcher(this, (Disposable)this.myDisposable);
    }

    @Override
    public void removeNotify() {
        if (ScreenUtil.isStandardAddRemoveNotify((Component)this)) {
            if (this.myAnimator != null) {
                this.myAnimator.suspend();
            }
            Disposer.dispose((Disposable)this.myDisposable);
        }
        super.removeNotify();
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        if (uiSettings == null) {
            IdeMenuBar.$$$reportNull$$$0(3);
        }
        this.myUpdateAlarm.cancelAllRequests();
        this.myUpdateAlarm.addRequest(() -> {
            this.myPresentationFactory.reset();
            this.updateMenuActions(true);
        }, 50);
    }

    @Override
    public boolean dispatch(@NotNull AWTEvent e) {
        if (e == null) {
            IdeMenuBar.$$$reportNull$$$0(4);
        }
        if (e instanceof MouseEvent && this.getState() != State.EXPANDED) {
            this.considerRestartingAnimator((MouseEvent)e);
        }
        return false;
    }

    private void considerRestartingAnimator(MouseEvent mouseEvent) {
        boolean mouseInside;
        boolean bl = mouseInside = this.myActivated || UIUtil.isDescendingFrom((Component)this.findActualComponent(mouseEvent), (Component)this);
        if (mouseEvent.getID() == 505 && mouseEvent.getSource() == SwingUtilities.windowForComponent(this) && !this.myActivated) {
            mouseInside = false;
        }
        if (mouseInside && this.getState() == State.COLLAPSED) {
            this.setState(State.EXPANDING);
            this.restartAnimator();
        } else if (!mouseInside && this.getState() != State.COLLAPSING && this.getState() != State.COLLAPSED) {
            this.setState(State.COLLAPSING);
            this.restartAnimator();
        }
    }

    @Nullable
    private Component findActualComponent(MouseEvent mouseEvent) {
        Component component2 = mouseEvent.getComponent();
        if (component2 == null) {
            return null;
        }
        Component deepestComponent = this.getState() != State.EXPANDED && !this.getState().isInProgress() && this.contains(SwingUtilities.convertPoint(component2, mouseEvent.getPoint(), this)) ? this : SwingUtilities.getDeepestComponentAt(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        if (deepestComponent != null) {
            component2 = deepestComponent;
        }
        return component2;
    }

    public void updateMenuActions() {
        this.updateMenuActions(false);
    }

    public void updateMenuActions(boolean forceRebuild) {
        this.doUpdateMenuActions(forceRebuild, ActionManager.getInstance());
    }

    public void updateMenuActionsLazily(boolean forceRebuild) {
        ActionManagerEx.doWithLazyActionManager(manager2 -> this.doUpdateMenuActions(forceRebuild, (ActionManager)manager2));
    }

    private void doUpdateMenuActions(boolean forceRebuild, @NotNull ActionManager manager2) {
        if (manager2 == null) {
            IdeMenuBar.$$$reportNull$$$0(5);
        }
        boolean enableMnemonics = !UISettings.getInstance().getDisableMnemonics();
        ArrayList<AnAction> myNewVisibleActions = new ArrayList<AnAction>();
        Component targetComponent = IJSwingUtilities.getFocusedComponentInWindowOrSelf(this);
        DataContext dataContext = DataManager.getInstance().getDataContext(targetComponent);
        this.expandActionGroup(dataContext, myNewVisibleActions, manager2);
        if (!forceRebuild && !this.myPresentationFactory.isNeedRebuild() && myNewVisibleActions.equals(this.myVisibleActions)) {
            for (Component child2 : this.getComponents()) {
                if (!(child2 instanceof ActionMenu)) continue;
                ((ActionMenu)((Object)child2)).updateFromPresentation(enableMnemonics);
            }
            return;
        }
        boolean changeBarVisibility = myNewVisibleActions.isEmpty() || this.myVisibleActions.isEmpty();
        this.myVisibleActions = myNewVisibleActions;
        this.removeAll();
        if (this.myScreenMenuPeer != null) {
            this.myScreenMenuPeer.beginFill();
        }
        boolean isDarkMenu = this.isDarkMenu();
        for (AnAction action2 : this.myVisibleActions) {
            ActionMenu actionMenu = new ActionMenu(null, "MainMenu", (ActionGroup)action2, this.myPresentationFactory, enableMnemonics, isDarkMenu);
            if (IdeFrameDecorator.isCustomDecorationActive()) {
                actionMenu.setOpaque(false);
                actionMenu.setFocusable(false);
            }
            if (this.myScreenMenuPeer != null) {
                this.myScreenMenuPeer.add((MenuItem)actionMenu.getScreenMenuPeer());
                continue;
            }
            this.add((JMenu)((Object)actionMenu));
        }
        this.myPresentationFactory.resetNeedRebuild();
        if (this.myScreenMenuPeer != null) {
            this.myScreenMenuPeer.endFill();
        }
        this.updateGlobalMenuRoots();
        if (this.myClockPanel != null) {
            this.add(this.myClockPanel);
            this.add(this.myButton);
        }
        this.validate();
        if (changeBarVisibility) {
            this.invalidate();
            JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
            if (frame != null) {
                frame.validate();
            }
        }
    }

    protected boolean isDarkMenu() {
        return SystemInfo.isMacSystemMenu && NSDefaults.isDarkMenuBar();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintBackground(g);
    }

    protected void paintBackground(Graphics g) {
        boolean fullScreen;
        Window window;
        if (IdeFrameDecorator.isCustomDecorationActive() && (window = SwingUtilities.getWindowAncestor(this)) instanceof IdeFrame && !(fullScreen = ((IdeFrame)window).isInFullScreen())) {
            return;
        }
        if (StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
            g.setColor(UIManager.getColor("MenuItem.background"));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
        if (this.getState().isInProgress()) {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform oldTransform = g2.getTransform();
            AffineTransform newTransform = oldTransform != null ? new AffineTransform(oldTransform) : new AffineTransform();
            newTransform.concatenate(AffineTransform.getTranslateInstance(0.0, this.getHeight() - super.getPreferredSize().height));
            g2.setTransform(newTransform);
            super.paintChildren(g2);
            g2.setTransform(oldTransform);
        } else if (this.getState() != State.COLLAPSED) {
            super.paintChildren(g);
        }
    }

    private void expandActionGroup(@NotNull DataContext context2, @NotNull List<? super AnAction> newVisibleActions, @NotNull ActionManager actionManager) {
        AnAction[] children2;
        ActionGroup mainActionGroup;
        if (context2 == null) {
            IdeMenuBar.$$$reportNull$$$0(6);
        }
        if (newVisibleActions == null) {
            IdeMenuBar.$$$reportNull$$$0(7);
        }
        if (actionManager == null) {
            IdeMenuBar.$$$reportNull$$$0(8);
        }
        if ((mainActionGroup = this.getMainMenuActionGroup()) == null) {
            return;
        }
        boolean inModalContext = LaterInvocator.isInModalContext();
        for (AnAction action2 : children2 = mainActionGroup.getChildren(null)) {
            if (!(action2 instanceof ActionGroup)) continue;
            Presentation presentation2 = this.myPresentationFactory.getPresentation(action2);
            AnActionEvent e = new AnActionEvent(null, context2, "MainMenu", presentation2, actionManager, 0);
            ActionUtil.performDumbAwareUpdate((boolean)inModalContext, (AnAction)action2, (AnActionEvent)e, (boolean)false);
            if (!presentation2.isVisible()) continue;
            newVisibleActions.add((AnAction)action2);
        }
    }

    @Nullable
    public ActionGroup getMainMenuActionGroup() {
        ActionGroup group2;
        JRootPane rootPane = this.getRootPane();
        ActionGroup actionGroup2 = group2 = rootPane instanceof IdeRootPane ? ((IdeRootPane)rootPane).getMainMenuActionGroup() : null;
        if (group2 != null) {
            return group2;
        }
        return (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("MainMenu");
    }

    @Override
    public int getMenuCount() {
        int menuCount = super.getMenuCount();
        return this.myClockPanel != null ? menuCount - 2 : menuCount;
    }

    protected void updateGlobalMenuRoots() {
    }

    public static void installAppMenuIfNeeded(@NotNull JFrame frame) {
        JMenuBar menuBar;
        if (frame == null) {
            IdeMenuBar.$$$reportNull$$$0(9);
        }
        if ((menuBar = frame.getJMenuBar()) instanceof IdeMenuBar) {
            try {
                ((IdeMenuBar)menuBar).doInstallAppMenuIfNeeded(frame);
            }
            catch (Throwable e) {
                LOG.warn("cannot install app menu", e);
            }
        } else if (menuBar != null) {
            LOG.info("The menu bar '" + menuBar + " of frame '" + frame + "' isn't instance of IdeMenuBar");
        }
    }

    protected void doInstallAppMenuIfNeeded(@NotNull JFrame frame) {
        if (frame == null) {
            IdeMenuBar.$$$reportNull$$$0(10);
        }
    }

    public void onToggleFullScreen(boolean isFullScreen) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/IdeMenuBar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newVisibleActions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/IdeMenuBar";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setFrame";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "uiSettingsChanged";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "dispatch";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateMenuActions";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "expandActionGroup";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "installAppMenuIfNeeded";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doInstallAppMenuIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyExitFullScreenButton
    extends JButton {
        private MyExitFullScreenButton() {
            this.setFocusable(false);
            this.addActionListener(e -> {
                ProjectFrameHelper frameHelper = ProjectFrameHelper.getFrameHelper(SwingUtilities.getWindowAncestor(this));
                if (frameHelper != null) {
                    frameHelper.toggleFullScreen(false);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    model.setRollover(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    model.setRollover(false);
                }
            });
        }

        @Override
        public Dimension getPreferredSize() {
            Container parent = this.getParent();
            int height = this.isVisible() && parent != null ? parent.getSize().height - parent.getInsets().top - parent.getInsets().bottom : super.getPreferredSize().height;
            return new Dimension(height, height);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            try {
                g2d.setColor(UIManager.getColor("Label.background"));
                g2d.fillRect(0, 0, this.getWidth() + 1, this.getHeight() + 1);
                g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                double s = (double)this.getHeight() / 13.0;
                g2d.translate(s, s);
                RoundRectangle2D.Double plate = new RoundRectangle2D.Double(0.0, 0.0, s * 11.0, s * 11.0, s, s);
                Color color = UIManager.getColor("Label.foreground");
                boolean hover = this.model.isRollover() || this.model.isPressed();
                g2d.setColor(ColorUtil.withAlpha((Color)color, (double)(hover ? 0.25 : 0.18)));
                g2d.fill(plate);
                g2d.setColor(ColorUtil.withAlpha((Color)color, (double)(hover ? 0.4 : 0.33)));
                g2d.draw(plate);
                g2d.setColor(ColorUtil.withAlpha((Color)color, (double)(hover ? 0.7 : 0.66)));
                GeneralPath path2 = new GeneralPath();
                path2.moveTo(s * 2.0, s * 6.0);
                path2.lineTo(s * 5.0, s * 6.0);
                path2.lineTo(s * 5.0, s * 9.0);
                path2.lineTo(s * 4.0, s * 8.0);
                path2.lineTo(s * 2.0, s * 10.0);
                path2.quadTo(s * 2.0 - s / Math.sqrt(2.0), s * 9.0 + s / Math.sqrt(2.0), s, s * 9.0);
                path2.lineTo(s * 3.0, s * 7.0);
                path2.lineTo(s * 2.0, s * 6.0);
                path2.closePath();
                g2d.fill(path2);
                g2d.draw(path2);
                path2 = new GeneralPath();
                path2.moveTo(s * 6.0, s * 2.0);
                path2.lineTo(s * 6.0, s * 5.0);
                path2.lineTo(s * 9.0, s * 5.0);
                path2.lineTo(s * 8.0, s * 4.0);
                path2.lineTo(s * 10.0, s * 2.0);
                path2.quadTo(s * 9.0 + s / Math.sqrt(2.0), s * 2.0 - s / Math.sqrt(2.0), s * 9.0, s);
                path2.lineTo(s * 7.0, s * 3.0);
                path2.lineTo(s * 6.0, s * 2.0);
                path2.closePath();
                g2d.fill(path2);
                g2d.draw(path2);
            }
            finally {
                g2d.dispose();
            }
        }
    }

    private static final class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Component c = e.getComponent();
            if (c instanceof IdeMenuBar) {
                Component item;
                Dimension size = c.getSize();
                Insets insets = ((IdeMenuBar)c).getInsets();
                Point p = e.getPoint();
                if ((p.y < insets.top || p.y >= size.height - insets.bottom) && (item = ((IdeMenuBar)c).findComponentAt(p.x, size.height / 2)) instanceof JMenuItem) {
                    item.dispatchEvent(MouseEventAdapter.convert((MouseEvent)e, (Component)item, (int)1, (int)1));
                    e.consume();
                }
            }
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (IdeMenuBar.this.getState() == State.EXPANDED || IdeMenuBar.this.getState() == State.EXPANDING) {
                return;
            }
            boolean activated = IdeMenuBar.this.isActivated();
            if (IdeMenuBar.this.myActivated && !activated && IdeMenuBar.this.getState() == State.TEMPORARY_EXPANDED) {
                IdeMenuBar.this.myActivated = false;
                IdeMenuBar.this.setState(State.COLLAPSING);
                IdeMenuBar.this.restartAnimator();
            }
            if (activated) {
                IdeMenuBar.this.myActivated = true;
            }
        }
    }

    private final class MyAnimator
    extends Animator {
        MyAnimator() {
            super("MenuBarAnimator", 16, 300, false);
        }

        public void paintNow(int frame, int totalFrames, int cycle) {
            IdeMenuBar.this.myProgress = (1.0 - Math.cos(Math.PI * (double)((float)frame / (float)totalFrames))) / 2.0;
            IdeMenuBar.this.revalidate();
            IdeMenuBar.this.repaint();
        }

        protected void paintCycleEnd() {
            IdeMenuBar.this.myProgress = 1.0;
            switch (IdeMenuBar.this.getState()) {
                case COLLAPSING: {
                    IdeMenuBar.this.setState(State.COLLAPSED);
                    break;
                }
                case EXPANDING: {
                    IdeMenuBar.this.setState(State.TEMPORARY_EXPANDED);
                    break;
                }
            }
            if (!IdeMenuBar.this.isShowing()) {
                return;
            }
            IdeMenuBar.this.revalidate();
            if (IdeMenuBar.this.getState() == State.COLLAPSED) {
                IdeMenuBar.this.getParent().repaint();
            } else {
                IdeMenuBar.this.repaint();
            }
        }
    }

    private final class MyTimerListener
    implements TimerListener {
        private MyTimerListener() {
        }

        public ModalityState getModalityState() {
            return ModalityState.stateForComponent((Component)IdeMenuBar.this);
        }

        public void run() {
            if (!IdeMenuBar.this.isShowing()) {
                return;
            }
            Window myWindow = SwingUtilities.windowForComponent(IdeMenuBar.this);
            if (myWindow != null && !myWindow.isActive()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = menuSelectionManager.getSelectedPath();
            if (selectedPath.length > 0) {
                return;
            }
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            if (window instanceof Dialog && ((Dialog)window).isModal()) {
                return;
            }
            IdeMenuBar.this.updateMenuActions();
        }
    }

    private static enum State {
        EXPANDED,
        COLLAPSING,
        COLLAPSED,
        EXPANDING,
        TEMPORARY_EXPANDED;


        boolean isInProgress() {
            return this == COLLAPSING || this == EXPANDING;
        }
    }
}

