/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowInfo;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.openapi.wm.impl.ToolWindowEventSource;
import com.intellij.openapi.wm.impl.ToolWindowHeader;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ComponentWithMnemonics;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.ui.content.impl.ContentManagerImpl;
import com.intellij.ui.hover.HoverStateListener;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InternalDecoratorImpl
extends InternalDecorator
implements Queryable,
DataProvider,
ComponentWithMnemonics {
    @ApiStatus.Internal
    public static final Key<Boolean> SHARED_ACCESS_KEY = Key.create((String)"sharedAccess");
    @ApiStatus.Internal
    static final Key<Boolean> HIDE_COMMON_TOOLWINDOW_BUTTONS = Key.create((String)"HideCommonToolWindowButtons");
    static final Key<Boolean> INACTIVE_LOOK = Key.create((String)"InactiveLook");
    private final ToolWindowContentUi myContentUi;
    private final JComponent myDecoratorChild;
    private Mode myMode;
    private boolean isSplitUnsplitInProgress;
    private boolean isWindowHovered;
    private final ToolWindowImpl toolWindow;
    @Nullable
    private JPanel divider;
    private final JPanel dividerAndHeader;
    private Disposable disposable;
    static final String HIDE_ACTIVE_WINDOW_ACTION_ID = "HideActiveWindow";
    private final ToolWindowHeader header;
    private final Wrapper notificationHeader;
    private InternalDecoratorImpl myFirstDecorator;
    private InternalDecoratorImpl mySecondDecorator;
    private Splitter mySplitter;
    private static final HoverStateListener HOVER_STATE_LISTENER = new HoverStateListener(){

        protected void hoverChanged(@NotNull Component component2, boolean hovered2) {
            if (component2 == null) {
                4.$$$reportNull$$$0(0);
            }
            if (component2 instanceof InternalDecoratorImpl) {
                InternalDecoratorImpl decorator = (InternalDecoratorImpl)component2;
                decorator.isWindowHovered = hovered2;
                decorator.updateActiveAndHoverState();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/InternalDecoratorImpl$4", "hoverChanged"));
        }
    };

    InternalDecoratorImpl(final @NotNull ToolWindowImpl toolWindow2, @NotNull ToolWindowContentUi contentUi, @NotNull JComponent decoratorChild) {
        if (toolWindow2 == null) {
            InternalDecoratorImpl.$$$reportNull$$$0(0);
        }
        if (contentUi == null) {
            InternalDecoratorImpl.$$$reportNull$$$0(1);
        }
        if (decoratorChild == null) {
            InternalDecoratorImpl.$$$reportNull$$$0(2);
        }
        this.myMode = null;
        this.dividerAndHeader = new JPanel(new BorderLayout());
        this.notificationHeader = new Wrapper();
        this.myContentUi = contentUi;
        this.myDecoratorChild = decoratorChild;
        this.toolWindow = toolWindow2;
        this.setFocusable(false);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.updateMode(Mode.SINGLE);
        this.header = new ToolWindowHeader(toolWindow2, contentUi, () -> toolWindow2.createPopupGroup(true)){

            @Override
            protected boolean isActive() {
                return toolWindow2.isActive() && Boolean.TRUE != UIUtil.getClientProperty((Object)InternalDecoratorImpl.this, INACTIVE_LOOK);
            }

            @Override
            protected void hideToolWindow() {
                toolWindow2.getToolWindowManager().hideToolWindow(toolWindow2.getId(), false, true, ToolWindowEventSource.HideButton);
            }
        };
        this.enableEvents(1L);
        InternalDecoratorImpl.installFocusTraversalPolicy(this, new LayoutFocusTraversalPolicy());
        this.dividerAndHeader.setOpaque(false);
        this.dividerAndHeader.add((Component)JBUI.Panels.simplePanel((Component)this.header).addToBottom((Component)this.notificationHeader), "South");
        if (SystemInfo.isMac) {
            this.setBackground((Color)new JBColor((Color)Gray._200, (Color)Gray._90));
        }
        this.getContentManager().addContentManagerListener(new ContentManagerListener(){

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                InternalDecoratorImpl parentDecorator;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((parentDecorator = InternalDecoratorImpl.findNearestDecorator(InternalDecoratorImpl.this)) == null) {
                    return;
                }
                if (!parentDecorator.isSplitUnsplitInProgress() && !InternalDecoratorImpl.this.isSplitUnsplitInProgress() && InternalDecoratorImpl.this.getContentManager().isEmpty()) {
                    parentDecorator.unsplit(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/InternalDecoratorImpl$2", "contentRemoved"));
            }
        });
    }

    public void updateMode(Mode mode) {
        if (mode == this.myMode) {
            return;
        }
        this.myMode = mode;
        this.removeAll();
        this.setBorder(null);
        switch (mode) {
            case SINGLE: 
            case CELL: {
                this.setLayout(new BorderLayout());
                this.add((Component)this.dividerAndHeader, "North");
                this.add((Component)this.myDecoratorChild, "Center");
                ApplicationManager.getApplication().invokeLater(() -> this.setBorder(new InnerPanelBorder(this.toolWindow)));
                ObjectUtils.consumeIfNotNull((Object)this.myFirstDecorator, decorator -> Disposer.dispose((Disposable)decorator.getContentManager()));
                ObjectUtils.consumeIfNotNull((Object)this.mySecondDecorator, decorator -> Disposer.dispose((Disposable)decorator.getContentManager()));
                return;
            }
            case VERTICAL_SPLIT: 
            case HORIZONTAL_SPLIT: {
                this.mySplitter = new OnePixelSplitter(mode == Mode.VERTICAL_SPLIT);
                this.mySplitter.setFirstComponent((JComponent)this.myFirstDecorator);
                this.mySplitter.setSecondComponent((JComponent)this.mySecondDecorator);
                this.setLayout(new BorderLayout());
                this.add((Component)this.mySplitter, "Center");
            }
        }
    }

    public void splitWithContent(@NotNull Content content2, int dropSide, int dropIndex) {
        if (content2 == null) {
            InternalDecoratorImpl.$$$reportNull$$$0(3);
        }
        if (dropSide == -1 || dropSide == 0 || dropIndex >= 0) {
            this.getContentManager().addContent(content2, dropIndex);
            return;
        }
        this.myFirstDecorator = this.toolWindow.createCellDecorator();
        this.attach(this.myFirstDecorator);
        this.mySecondDecorator = this.toolWindow.createCellDecorator();
        this.attach(this.mySecondDecorator);
        ArrayList contents = ContainerUtil.newArrayList((Object[])this.getContentManager().getContents());
        if (!contents.contains(content2)) {
            contents.add(content2);
        }
        Iterator iterator2 = contents.iterator();
        while (iterator2.hasNext()) {
            Content c;
            InternalDecoratorImpl.moveContent(c, this, (c = (Content)iterator2.next()) != content2 ^ (dropSide == 2 || dropSide == 1) ? this.myFirstDecorator : this.mySecondDecorator);
        }
        this.myFirstDecorator.updateMode(Mode.CELL);
        this.mySecondDecorator.updateMode(Mode.CELL);
        this.updateMode(dropSide == 1 || dropSide == 3 ? Mode.VERTICAL_SPLIT : Mode.HORIZONTAL_SPLIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void moveContent(@NotNull Content content2, @NotNull InternalDecoratorImpl source, @NotNull InternalDecoratorImpl target2) {
        if (content2 == null) {
            InternalDecoratorImpl.$$$reportNull$$$0(4);
        }
        if (source == null) {
            InternalDecoratorImpl.$$$reportNull$$$0(5);
        }
        if (target2 == null) {
            InternalDecoratorImpl.$$$reportNull$$$0(6);
        }
        ContentManager targetContentManager = target2.getContentManager();
        if (Objects.equals(content2.getManager(), targetContentManager)) {
            return;
        }
        Boolean initialState = (Boolean)content2.getUserData(Content.TEMPORARY_REMOVED_KEY);
        try {
            source.setSplitUnsplitInProgress(true);
            content2.putUserData(Content.TEMPORARY_REMOVED_KEY, (Object)Boolean.TRUE);
            ObjectUtils.consumeIfNotNull((Object)content2.getManager(), manager2 -> manager2.removeContent(content2, false));
            ((ContentImpl)content2).setManager(targetContentManager);
            targetContentManager.addContent(content2);
        }
        finally {
            content2.putUserData(Content.TEMPORARY_REMOVED_KEY, (Object)initialState);
            source.setSplitUnsplitInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void raise(boolean raiseFirst) {
        @NotNull InternalDecoratorImpl source = raiseFirst ? this.myFirstDecorator : this.mySecondDecorator;
        InternalDecoratorImpl first = source.myFirstDecorator;
        InternalDecoratorImpl second = source.mySecondDecorator;
        Mode mode = source.myMode;
        source.detach(first);
        source.detach(second);
        source.myFirstDecorator = null;
        source.mySecondDecorator = null;
        InternalDecoratorImpl toRemove1 = this.myFirstDecorator;
        InternalDecoratorImpl toRemove2 = this.mySecondDecorator;
        toRemove1.updateMode(Mode.CELL);
        toRemove2.updateMode(Mode.CELL);
        first.setSplitUnsplitInProgress(true);
        second.setSplitUnsplitInProgress(true);
        try {
            this.myFirstDecorator = first;
            this.mySecondDecorator = second;
            this.myMode = mode;
            this.mySplitter.setOrientation(mode == Mode.VERTICAL_SPLIT);
            this.mySplitter.setFirstComponent((JComponent)this.myFirstDecorator);
            this.mySplitter.setSecondComponent((JComponent)this.mySecondDecorator);
            this.attach(first);
            this.attach(second);
        }
        finally {
            first.setSplitUnsplitInProgress(false);
            second.setSplitUnsplitInProgress(false);
            Disposer.dispose((Disposable)toRemove1.getContentManager());
            Disposer.dispose((Disposable)toRemove2.getContentManager());
        }
    }

    private void detach(InternalDecoratorImpl decorator) {
        ContentManager parentManager = this.getContentManager();
        ContentManager childManager = decorator.getContentManager();
        if (parentManager instanceof ContentManagerImpl && childManager instanceof ContentManagerImpl) {
            ((ContentManagerImpl)parentManager).removeNestedManager((ContentManagerImpl)childManager);
        }
    }

    private void attach(InternalDecoratorImpl decorator) {
        ContentManager parentManager = this.getContentManager();
        ContentManager childManager = decorator.getContentManager();
        if (parentManager instanceof ContentManagerImpl && childManager instanceof ContentManagerImpl) {
            ((ContentManagerImpl)parentManager).addNestedManager((ContentManagerImpl)childManager);
        }
    }

    public boolean canUnsplit() {
        if (this.getMode() != Mode.CELL) {
            return false;
        }
        InternalDecoratorImpl parent = InternalDecoratorImpl.findNearestDecorator(this);
        if (parent != null) {
            if (parent.myFirstDecorator == this) {
                return parent.mySecondDecorator != null && parent.mySecondDecorator.getMode() == Mode.CELL;
            }
            if (parent.mySecondDecorator == this) {
                return parent.myFirstDecorator != null && parent.myFirstDecorator.getMode() == Mode.CELL;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsplit(@Nullable Content toSelect2) {
        if (!this.myMode.isSplit()) {
            ObjectUtils.consumeIfNotNull((Object)InternalDecoratorImpl.findNearestDecorator(this), decorator -> decorator.unsplit(toSelect2));
            return;
        }
        if (this.isSplitUnsplitInProgress()) {
            return;
        }
        this.setSplitUnsplitInProgress(true);
        try {
            if (this.myFirstDecorator == null || this.mySecondDecorator == null) {
                return;
            }
            if (this.myFirstDecorator.getMode().isSplit()) {
                this.raise(true);
                return;
            }
            if (this.mySecondDecorator.getMode().isSplit()) {
                this.raise(false);
                return;
            }
            for (Content c : this.myFirstDecorator.getContentManager().getContents()) {
                InternalDecoratorImpl.moveContent(c, this.myFirstDecorator, this);
            }
            for (Content c : this.mySecondDecorator.getContentManager().getContents()) {
                InternalDecoratorImpl.moveContent(c, this.mySecondDecorator, this);
            }
            this.updateMode(InternalDecoratorImpl.findNearestDecorator(this) != null ? Mode.CELL : Mode.SINGLE);
            if (toSelect2 != null) {
                ObjectUtils.consumeIfNotNull((Object)toSelect2.getManager(), m -> m.setSelectedContent(toSelect2));
            }
            this.myFirstDecorator = null;
            this.mySecondDecorator = null;
            this.mySplitter = null;
        }
        finally {
            this.setSplitUnsplitInProgress(false);
        }
    }

    public void setSplitUnsplitInProgress(boolean inProgress) {
        this.isSplitUnsplitInProgress = inProgress;
    }

    public boolean isSplitUnsplitInProgress() {
        return this.isSplitUnsplitInProgress;
    }

    public void setMode(Mode mode) {
        this.myMode = mode;
    }

    public Mode getMode() {
        return this.myMode;
    }

    @Override
    public ContentManager getContentManager() {
        return this.myContentUi.getContentManager();
    }

    @Override
    public ActionToolbar getHeaderToolbar() {
        return this.header.getToolbar();
    }

    public ActionGroup getHeaderToolbarActions() {
        return this.header.getToolbarActions();
    }

    public ActionGroup getHeaderToolbarWestActions() {
        return this.header.getToolbarWestActions();
    }

    @Override
    public String toString() {
        return this.toolWindow.getId() + ": " + StringUtil.trimMiddle((String)Arrays.toString(Arrays.stream(this.getContentManager().getContents()).map(content2 -> content2.getDisplayName()).toArray()), (int)40) + " #" + System.identityHashCode(this);
    }

    @NotNull
    private JComponent initDivider() {
        if (this.divider != null) {
            JPanel jPanel2 = this.divider;
            if (jPanel2 == null) {
                InternalDecoratorImpl.$$$reportNull$$$0(7);
            }
            return jPanel2;
        }
        JPanel jPanel3 = this.divider = new JPanel(){

            @Override
            @NotNull
            public Cursor getCursor() {
                WindowInfo info2 = InternalDecoratorImpl.this.toolWindow.getWindowInfo();
                boolean isVerticalCursor = info2.getType() == ToolWindowType.DOCKED ? info2.getAnchor().isSplitVertically() : info2.getAnchor().isHorizontal();
                Cursor cursor = isVerticalCursor ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11);
                if (cursor == null) {
                    3.$$$reportNull$$$0(0);
                }
                return cursor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/InternalDecoratorImpl$3", "getCursor"));
            }
        };
        if (jPanel3 == null) {
            InternalDecoratorImpl.$$$reportNull$$$0(8);
        }
        return jPanel3;
    }

    void applyWindowInfo(@NotNull WindowInfo info2) {
        FloatingDecorator floatingDecorator;
        if (info2 == null) {
            InternalDecoratorImpl.$$$reportNull$$$0(9);
        }
        if (info2.getType() == ToolWindowType.SLIDING) {
            ToolWindowAnchor anchor2 = info2.getAnchor();
            JComponent divider = this.initDivider();
            divider.invalidate();
            if (anchor2 == ToolWindowAnchor.TOP) {
                this.add((Component)divider, "South");
            } else if (anchor2 == ToolWindowAnchor.LEFT) {
                this.add((Component)divider, "East");
            } else if (anchor2 == ToolWindowAnchor.BOTTOM) {
                this.dividerAndHeader.add((Component)divider, "North");
            } else if (anchor2 == ToolWindowAnchor.RIGHT) {
                this.add((Component)divider, "West");
            }
            divider.setPreferredSize(new Dimension(0, 0));
        } else if (this.divider != null) {
            this.divider.getParent().remove(this.divider);
            this.divider = null;
        }
        if (info2.getType() == ToolWindowType.FLOATING && (floatingDecorator = (FloatingDecorator)SwingUtilities.getAncestorOfClass(FloatingDecorator.class, this)) != null) {
            floatingDecorator.apply(info2);
        }
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            InternalDecoratorImpl.$$$reportNull$$$0(10);
        }
        if (PlatformDataKeys.TOOL_WINDOW.is(dataId)) {
            return this.toolWindow;
        }
        return null;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        Collection keyStrokes;
        if (condition == 1 && pressed && (keyStrokes = KeymapUtil.getKeyStrokes((ShortcutSet)ActionManager.getInstance().getAction("FocusEditor").getShortcutSet())).contains(ks)) {
            this.toolWindow.getToolWindowManager().activateEditorComponent();
            return true;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public void setTitleActions(@NotNull List<? extends AnAction> actions2) {
        if (actions2 == null) {
            InternalDecoratorImpl.$$$reportNull$$$0(11);
        }
        this.header.setAdditionalTitleActions(actions2);
    }

    void setTabActions(@NotNull @NotNull AnAction @NotNull [] actions2) {
        if (actions2 == null) {
            InternalDecoratorImpl.$$$reportNull$$$0(12);
        }
        this.header.setTabActions(actions2);
    }

    @NotNull
    ToolWindowImpl getToolWindow() {
        ToolWindowImpl toolWindowImpl = this.toolWindow;
        if (toolWindowImpl == null) {
            InternalDecoratorImpl.$$$reportNull$$$0(13);
        }
        return toolWindowImpl;
    }

    @Override
    public int getHeaderHeight() {
        return this.header.getPreferredSize().height;
    }

    @Override
    public void setHeaderVisible(boolean value2) {
        this.header.setVisible(value2);
    }

    @Override
    public boolean isHeaderVisible() {
        return this.header.isVisible();
    }

    public boolean isActive() {
        return this.toolWindow.isActive();
    }

    void updateActiveAndHoverState() {
        ActionToolbar toolbar = this.getHeaderToolbar();
        if (toolbar != null) {
            toolbar.getComponent().setVisible(!ExperimentalUI.isNewUI() || this.isWindowHovered || this.toolWindow.isActive());
        }
    }

    public void activate(ToolWindowEventSource source) {
        this.toolWindow.fireActivated(source);
    }

    @NotNull
    public String getToolWindowId() {
        String string = this.toolWindow.getId();
        if (string == null) {
            InternalDecoratorImpl.$$$reportNull$$$0(14);
        }
        return string;
    }

    public void setHeaderComponent(@Nullable JComponent notification) {
        this.notificationHeader.setContent(notification);
    }

    @Nullable
    public JComponent getHeaderComponent() {
        JComponent component2 = this.notificationHeader.getTargetComponent();
        return component2 != this.notificationHeader ? component2 : null;
    }

    @Nullable
    public Rectangle getHeaderScreenBounds() {
        if (!this.header.isShowing()) {
            return null;
        }
        Rectangle bounds2 = this.header.getBounds();
        bounds2.setLocation(this.header.getLocationOnScreen());
        return bounds2;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.isSplitUnsplitInProgress()) {
            return;
        }
        if (this.disposable != null) {
            Disposer.dispose((Disposable)this.disposable);
        }
        JPanel divider = this.divider;
        this.disposable = Disposer.newDisposable();
        HOVER_STATE_LISTENER.addTo((JComponent)this, this.disposable);
        this.updateActiveAndHoverState();
        if (divider != null) {
            IdeGlassPane glassPane = (IdeGlassPane)this.getRootPane().getGlassPane();
            ResizeOrMoveDocketToolWindowMouseListener listener2 = new ResizeOrMoveDocketToolWindowMouseListener(divider, glassPane, this);
            glassPane.addMouseMotionPreprocessor((MouseMotionListener)listener2, this.disposable);
            glassPane.addMousePreprocessor((MouseListener)listener2, this.disposable);
        }
        this.myContentUi.update();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.isSplitUnsplitInProgress()) {
            return;
        }
        Disposable disposable2 = this.disposable;
        if (disposable2 != null && !Disposer.isDisposed((Disposable)disposable2)) {
            this.disposable = null;
            Disposer.dispose((Disposable)disposable2);
        }
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        super.reshape(x, y, w, h);
        InternalDecoratorImpl topLevelDecorator = InternalDecoratorImpl.findTopLevelDecorator(this);
        if (topLevelDecorator == null || !topLevelDecorator.isShowing()) {
            this.putClientProperty("HideIdLabel", null);
            UIUtil.putClientProperty((JComponent)this, HIDE_COMMON_TOOLWINDOW_BUTTONS, null);
            UIUtil.putClientProperty((JComponent)this, INACTIVE_LOOK, null);
        } else {
            String hideLabel = SwingUtilities.convertPoint(this, x, y, topLevelDecorator).equals(new Point()) ? null : "true";
            this.putClientProperty("HideIdLabel", hideLabel);
            Point topScreenLocation = topLevelDecorator.getLocationOnScreen();
            topScreenLocation.x += topLevelDecorator.getWidth();
            Point screenLocation = this.getLocationOnScreen();
            screenLocation.x += w;
            Boolean hideButtons = topScreenLocation.equals(screenLocation) ? null : Boolean.TRUE;
            Boolean hideActivity = topScreenLocation.y == screenLocation.y ? null : Boolean.TRUE;
            UIUtil.putClientProperty((JComponent)this, HIDE_COMMON_TOOLWINDOW_BUTTONS, (Object)hideButtons);
            UIUtil.putClientProperty((JComponent)this, INACTIVE_LOOK, (Object)hideActivity);
        }
        this.myContentUi.update();
    }

    public void setDropInfoIndex(int index2, int width) {
        this.myContentUi.setDropInfoIndex(index2, width);
    }

    public void updateBounds(@NotNull MouseEvent dragEvent) {
        if (dragEvent == null) {
            InternalDecoratorImpl.$$$reportNull$$$0(15);
        }
        ToolWindowAnchor anchor2 = this.toolWindow.getAnchor();
        Container windowPane = this.getParent();
        Point lastPoint = SwingUtilities.convertPoint(dragEvent.getComponent(), dragEvent.getPoint(), windowPane);
        lastPoint.x = MathUtil.clamp((int)lastPoint.x, (int)0, (int)windowPane.getWidth());
        lastPoint.y = MathUtil.clamp((int)lastPoint.y, (int)0, (int)windowPane.getHeight());
        Rectangle bounds2 = this.getBounds();
        if (anchor2 == ToolWindowAnchor.TOP) {
            this.setBounds(0, 0, bounds2.width, lastPoint.y);
        } else if (anchor2 == ToolWindowAnchor.LEFT) {
            this.setBounds(0, 0, lastPoint.x, bounds2.height);
        } else if (anchor2 == ToolWindowAnchor.BOTTOM) {
            this.setBounds(0, lastPoint.y, bounds2.width, windowPane.getHeight() - lastPoint.y);
        } else if (anchor2 == ToolWindowAnchor.RIGHT) {
            this.setBounds(lastPoint.x, 0, windowPane.getWidth() - lastPoint.x, bounds2.height);
        }
        this.validate();
    }

    public void putInfo(@NotNull Map<? super String, ? super String> info2) {
        if (info2 == null) {
            InternalDecoratorImpl.$$$reportNull$$$0(16);
        }
        info2.put("toolWindowTitle", this.toolWindow.getTitle());
        Content selection = this.toolWindow.getContentManager().getSelectedContent();
        if (selection != null) {
            info2.put("toolWindowTab", selection.getTabName());
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleInternalDecorator();
        }
        return this.accessibleContext;
    }

    static void installFocusTraversalPolicy(@NotNull Container container, @NotNull FocusTraversalPolicy policy) {
        if (container == null) {
            InternalDecoratorImpl.$$$reportNull$$$0(17);
        }
        if (policy == null) {
            InternalDecoratorImpl.$$$reportNull$$$0(18);
        }
        container.setFocusCycleRoot(true);
        container.setFocusTraversalPolicyProvider(true);
        container.setFocusTraversalPolicy(policy);
        InternalDecoratorImpl.installDefaultFocusTraversalKeys(container, 0);
        InternalDecoratorImpl.installDefaultFocusTraversalKeys(container, 1);
    }

    @Nullable
    public static InternalDecoratorImpl findTopLevelDecorator(Component component2) {
        InternalDecoratorImpl candidate = null;
        for (Container parent = component2 != null ? component2.getParent() : null; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof InternalDecoratorImpl)) continue;
            candidate = (InternalDecoratorImpl)parent;
        }
        return candidate;
    }

    public static InternalDecoratorImpl findNearestDecorator(Component component2) {
        if (component2 != null) {
            component2 = component2.getParent();
        }
        return (InternalDecoratorImpl)ComponentUtil.findParentByCondition((Component)component2, c -> c instanceof InternalDecoratorImpl);
    }

    private static void installDefaultFocusTraversalKeys(@NotNull Container container, int id2) {
        if (container == null) {
            InternalDecoratorImpl.$$$reportNull$$$0(19);
        }
        container.setFocusTraversalKeys(id2, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(id2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentUi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratorChild";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/InternalDecoratorImpl";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragEvent";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/InternalDecoratorImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "initDivider";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindow";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "splitWithContent";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "moveContent";
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyWindowInfo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setTitleActions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setTabActions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateBounds";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "installFocusTraversalPolicy";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "installDefaultFocusTraversalKeys";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class AccessibleInternalDecorator
    extends JPanel.AccessibleJPanel {
        private AccessibleInternalDecorator() {
            super(InternalDecoratorImpl.this);
        }

        @Override
        public String getAccessibleName() {
            Object name2 = super.getAccessibleName();
            if (name2 == null) {
                String title2 = StringUtil.defaultIfEmpty((String)InternalDecoratorImpl.this.toolWindow.getTitle(), (String)InternalDecoratorImpl.this.toolWindow.getStripeTitle());
                title2 = StringUtil.defaultIfEmpty((String)title2, (String)InternalDecoratorImpl.this.toolWindow.getId());
                name2 = StringUtil.notNullize((String)title2) + " " + IdeBundle.message((String)"internal.decorator.accessible.postfix", (Object[])new Object[0]);
            }
            return name2;
        }
    }

    private static final class ResizeOrMoveDocketToolWindowMouseListener
    extends MouseAdapter {
        private final JComponent divider;
        private final IdeGlassPane glassPane;
        private final InternalDecoratorImpl decorator;
        private boolean isDragging;

        private ResizeOrMoveDocketToolWindowMouseListener(@NotNull JComponent divider, @NotNull IdeGlassPane glassPane, @NotNull InternalDecoratorImpl decorator) {
            if (divider == null) {
                ResizeOrMoveDocketToolWindowMouseListener.$$$reportNull$$$0(0);
            }
            if (glassPane == null) {
                ResizeOrMoveDocketToolWindowMouseListener.$$$reportNull$$$0(1);
            }
            if (decorator == null) {
                ResizeOrMoveDocketToolWindowMouseListener.$$$reportNull$$$0(2);
            }
            this.divider = divider;
            this.glassPane = glassPane;
            this.decorator = decorator;
        }

        private boolean isInDragZone(@NotNull MouseEvent e) {
            if (e == null) {
                ResizeOrMoveDocketToolWindowMouseListener.$$$reportNull$$$0(3);
            }
            Point point = new Point(e.getPoint());
            SwingUtilities.convertPointToScreen(point, e.getComponent());
            if ((this.decorator.toolWindow.getWindowInfo().getAnchor().isHorizontal() ? point.y : point.x) == 0) {
                return false;
            }
            SwingUtilities.convertPointFromScreen(point, this.divider);
            return Math.abs(this.decorator.toolWindow.getWindowInfo().getAnchor().isHorizontal() ? point.y : point.x) <= ToolWindowsPane.getHeaderResizeArea();
        }

        private void updateCursor(@NotNull MouseEvent event, boolean isInDragZone) {
            if (event == null) {
                ResizeOrMoveDocketToolWindowMouseListener.$$$reportNull$$$0(4);
            }
            if (isInDragZone) {
                this.glassPane.setCursor(this.divider.getCursor(), (Object)this.divider);
                event.consume();
            }
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                ResizeOrMoveDocketToolWindowMouseListener.$$$reportNull$$$0(5);
            }
            this.isDragging = this.isInDragZone(e);
            this.updateCursor(e, this.isDragging);
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            if (e == null) {
                ResizeOrMoveDocketToolWindowMouseListener.$$$reportNull$$$0(6);
            }
            this.updateCursor(e, this.isInDragZone(e));
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (e == null) {
                ResizeOrMoveDocketToolWindowMouseListener.$$$reportNull$$$0(7);
            }
            this.updateCursor(e, this.isInDragZone(e));
            this.isDragging = false;
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            if (e == null) {
                ResizeOrMoveDocketToolWindowMouseListener.$$$reportNull$$$0(8);
            }
            this.updateCursor(e, this.isDragging || this.isInDragZone(e));
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            if (e == null) {
                ResizeOrMoveDocketToolWindowMouseListener.$$$reportNull$$$0(9);
            }
            if (!this.isDragging) {
                return;
            }
            this.decorator.updateBounds(e);
            e.consume();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "divider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "glassPane";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "decorator";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/wm/impl/InternalDecoratorImpl$ResizeOrMoveDocketToolWindowMouseListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInDragZone";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateCursor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressed";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseClicked";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseReleased";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseDragged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class InnerPanelBorder
    implements Border {
        @NotNull
        private final ToolWindowImpl window;

        private InnerPanelBorder(@NotNull ToolWindowImpl window) {
            if (window == null) {
                InnerPanelBorder.$$$reportNull$$$0(0);
            }
            this.window = window;
        }

        @Override
        public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
            if (c == null) {
                InnerPanelBorder.$$$reportNull$$$0(1);
            }
            if (g == null) {
                InnerPanelBorder.$$$reportNull$$$0(2);
            }
            g.setColor(JBColor.border());
            this.doPaintBorder(c, g, x, y, width, height);
        }

        private void doPaintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Insets insets = this.getBorderInsets(c);
            Graphics2D graphics2D = (Graphics2D)g;
            if (insets.top > 0) {
                LinePainter2D.paint((Graphics2D)graphics2D, (double)x, (double)(y + insets.top - 1), (double)(x + width - 1), (double)(y + insets.top - 1));
                LinePainter2D.paint((Graphics2D)graphics2D, (double)x, (double)(y + insets.top), (double)(x + width - 1), (double)(y + insets.top));
            }
            if (insets.left > 0) {
                LinePainter2D.paint((Graphics2D)graphics2D, (double)x, (double)y, (double)x, (double)(y + height));
                LinePainter2D.paint((Graphics2D)graphics2D, (double)(x + 1), (double)y, (double)(x + 1), (double)(y + height));
            }
            if (insets.right > 0) {
                LinePainter2D.paint((Graphics2D)graphics2D, (double)(x + width - 1), (double)(y + insets.top), (double)(x + width - 1), (double)(y + height));
                LinePainter2D.paint((Graphics2D)graphics2D, (double)(x + width), (double)(y + insets.top), (double)(x + width), (double)(y + height));
            }
            if (insets.bottom > 0) {
                LinePainter2D.paint((Graphics2D)graphics2D, (double)x, (double)(y + height - 1), (double)(x + width), (double)(y + height - 1));
                LinePainter2D.paint((Graphics2D)graphics2D, (double)x, (double)(y + height), (double)(x + width), (double)(y + height));
            }
        }

        @Override
        public Insets getBorderInsets(@NotNull Component c) {
            if (c == null) {
                InnerPanelBorder.$$$reportNull$$$0(3);
            }
            ToolWindowManagerImpl toolWindowManager = this.window.getToolWindowManager();
            WindowInfo windowInfo = this.window.getWindowInfo();
            if (toolWindowManager.getProject().isDisposed() || !toolWindowManager.isToolWindowRegistered(this.window.getId()) || this.window.isDisposed() || windowInfo.getType() == ToolWindowType.FLOATING || windowInfo.getType() == ToolWindowType.WINDOWED) {
                return JBUI.emptyInsets();
            }
            ToolWindowAnchor anchor2 = windowInfo.getAnchor();
            Container component2 = this.window.getComponent();
            Container parent = component2.getParent();
            boolean isSplitter = false;
            boolean isFirstInSplitter = false;
            boolean isVerticalSplitter = false;
            while (parent != null) {
                if (parent instanceof Splitter) {
                    Splitter splitter2 = (Splitter)parent;
                    isSplitter = true;
                    isFirstInSplitter = splitter2.getFirstComponent() == component2;
                    isVerticalSplitter = splitter2.isVertical();
                    break;
                }
                component2 = parent;
                parent = component2.getParent();
            }
            int top = isSplitter && (anchor2 == ToolWindowAnchor.RIGHT || anchor2 == ToolWindowAnchor.LEFT) && windowInfo.isSplit() && isVerticalSplitter ? -1 : 0;
            int left = anchor2 == ToolWindowAnchor.RIGHT && (!isSplitter || isVerticalSplitter || isFirstInSplitter) ? 1 : 0;
            int bottom = 0;
            int right = anchor2 == ToolWindowAnchor.LEFT && (!isSplitter || isVerticalSplitter || !isFirstInSplitter) ? 1 : 0;
            return new Insets(top, left, bottom, right);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/wm/impl/InternalDecoratorImpl$InnerPanelBorder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintBorder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getBorderInsets";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum Mode {
        SINGLE,
        VERTICAL_SPLIT,
        HORIZONTAL_SPLIT,
        CELL;


        public boolean isSplit() {
            return this == VERTICAL_SPLIT || this == HORIZONTAL_SPLIT;
        }
    }
}

