/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.ide.ProjectGroupActionGroup;
import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WelcomeScreenTab;
import com.intellij.openapi.wm.WelcomeTabFactory;
import com.intellij.openapi.wm.impl.welcomeScreen.ActionGroupPanelWrapper;
import com.intellij.openapi.wm.impl.welcomeScreen.EmptyStateProjectsPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.NewRecentProjectPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.TabbedWelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenActionsUtil;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenComponentFactory;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenEventCollector;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

final class ProjectsTabFactory
implements WelcomeTabFactory {
    static final int PRIMARY_BUTTONS_NUM = 3;

    ProjectsTabFactory() {
    }

    @NotNull
    public WelcomeScreenTab createWelcomeTab(final @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            ProjectsTabFactory.$$$reportNull$$$0(0);
        }
        return new TabbedWelcomeScreen.DefaultWelcomeScreenTab(IdeBundle.message((String)"welcome.screen.projects.title", (Object[])new Object[0]), WelcomeScreenEventCollector.TabType.TabNavProject){

            @Override
            protected JComponent buildComponent() {
                EmptyStateProjectsPanel mainPanel2;
                if (RecentProjectListActionProvider.getInstance().getActions(false, true).isEmpty()) {
                    mainPanel2 = new EmptyStateProjectsPanel(parentDisposable);
                } else {
                    mainPanel2 = ((BorderLayoutPanel)JBUI.Panels.simplePanel().withBorder((Border)JBUI.Borders.empty((int)13, (int)12))).withBackground(WelcomeScreenUIManager.getProjectsBackground());
                    SearchTextField projectSearch = this.createSearchProjectsField();
                    NewRecentProjectPanel projectsPanel = this.createProjectsPanelWithExternalSearch(projectSearch);
                    projectsPanel.setBorder((Border)JBUI.Borders.emptyTop((int)10));
                    JBPanel northPanel = ((BorderLayoutPanel)JBUI.Panels.simplePanel().andTransparent()).withBorder((Border)new CustomLineBorder((Color)WelcomeScreenUIManager.getSeparatorColor(), (Insets)JBUI.insetsBottom((int)1)){

                        public Insets getBorderInsets(Component c) {
                            return JBUI.insetsBottom((int)12);
                        }
                    });
                    ActionToolbar actionsToolbar = this.createActionsToolbar();
                    actionsToolbar.setTargetComponent((JComponent)projectsPanel.myList);
                    JComponent projectActionsPanel = actionsToolbar.getComponent();
                    northPanel.add((Component)projectSearch, "Center");
                    northPanel.add((Component)projectActionsPanel, "East");
                    ((Container)((Object)mainPanel2)).add((Component)northPanel, "North");
                    ((Container)((Object)mainPanel2)).add(projectsPanel, "Center");
                    ((Container)((Object)mainPanel2)).add(WelcomeScreenComponentFactory.createNotificationPanel(parentDisposable), "South");
                }
                DnDNativeTarget target2 = ProjectsTabFactory.createDropFileTarget();
                DnDSupport.createBuilder((JComponent)((Object)mainPanel2)).enableAsNativeTarget().setTargetChecker((DnDTargetChecker)target2).setDropHandler((DnDDropHandler)target2).setDisposableParent(parentDisposable).install();
                return mainPanel2;
            }

            @NotNull
            private NewRecentProjectPanel createProjectsPanelWithExternalSearch(final @NotNull SearchTextField projectSearch) {
                if (projectSearch == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new NewRecentProjectPanel(parentDisposable, false){

                    @Override
                    protected JBList<AnAction> createList(AnAction[] recentProjectActions, Dimension size) {
                        JBList<AnAction> projectsList = super.createList(recentProjectActions, size);
                        projectsList.setEmptyText(IdeCoreBundle.message((String)"message.nothingToShow", (Object[])new Object[0]));
                        final SpeedSearch speedSearch2 = new SpeedSearch();
                        NameFilteringListModel<AnAction> model2 = new NameFilteringListModel<AnAction>(projectsList.getModel(), 2.createProjectNameFunction(), arg_0 -> ((SpeedSearch)speedSearch2).shouldBeShowing(arg_0), () -> StringUtil.notNullize((String)speedSearch2.getFilter())){

                            @NotNull
                            protected Collection<AnAction> getElementsToFilter() {
                                if (projectSearch.getText().isEmpty()) {
                                    Collection collection = super.getElementsToFilter();
                                    if (collection == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    return collection;
                                }
                                ArrayList<AnAction> result2 = new ArrayList<AnAction>();
                                ListModel originalModel = this.getOriginalModel();
                                for (int i2 = 0; i2 < originalModel.getSize(); ++i2) {
                                    ProjectGroupActionGroup group2;
                                    AnAction element2 = (AnAction)originalModel.getElementAt(i2);
                                    result2.add(element2);
                                    if (!(element2 instanceof ProjectGroupActionGroup) || (group2 = (ProjectGroupActionGroup)element2).getGroup().isExpanded()) continue;
                                    ContainerUtil.addAll(result2, (Object[])group2.getChildActionsOrStubs());
                                }
                                ArrayList<AnAction> arrayList = result2;
                                if (arrayList == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                return arrayList;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/welcomeScreen/ProjectsTabFactory$1$2$1", "getElementsToFilter"));
                            }
                        };
                        projectsList.setModel((ListModel)model2);
                        projectSearch.addDocumentListener((DocumentListener)new DocumentAdapter((NameFilteringListModel)model2, projectsList){
                            final /* synthetic */ NameFilteringListModel val$model;
                            final /* synthetic */ JBList val$projectsList;
                            {
                                this.val$model = nameFilteringListModel;
                                this.val$projectsList = jBList;
                            }

                            public void insertUpdate(@NotNull DocumentEvent e) {
                                if (e == null) {
                                    2.$$$reportNull$$$0(0);
                                }
                                if (StringUtil.length((CharSequence)projectSearch.getText()) == 1) {
                                    WelcomeScreenEventCollector.logProjectSearchUsed();
                                }
                                super.insertUpdate(e);
                            }

                            protected void textChanged(@NotNull DocumentEvent e) {
                                if (e == null) {
                                    2.$$$reportNull$$$0(1);
                                }
                                speedSearch2.updatePattern(projectSearch.getText());
                                this.val$model.refilter();
                                this.val$projectsList.setSelectedIndex(0);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2 = new Object[3];
                                objectArray2[0] = "e";
                                objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/ProjectsTabFactory$1$2$2";
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "insertUpdate";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "textChanged";
                                        break;
                                    }
                                }
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        });
                        ScrollingUtil.installActions(projectsList, (JComponent)projectSearch);
                        DumbAwareAction.create(event -> {
                            AnAction selectedProject = (AnAction)this.myList.getSelectedValue();
                            if (selectedProject != null) {
                                selectedProject.actionPerformed(event);
                            }
                        }).registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)projectSearch, parentDisposable);
                        return projectsList;
                    }
                };
            }

            @NotNull
            private SearchTextField createSearchProjectsField() {
                SearchTextField projectSearch = new SearchTextField(false);
                projectSearch.setOpaque(false);
                projectSearch.setBorder((Border)JBUI.Borders.empty());
                JBTextField textEditor = projectSearch.getTextEditor();
                textEditor.setOpaque(false);
                textEditor.setBorder((Border)JBUI.Borders.empty());
                textEditor.getEmptyText().setText(IdeBundle.message((String)"welcome.screen.search.projects.empty.text", (Object[])new Object[0]));
                textEditor.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"welcome.screen.search.projects.empty.text", (Object[])new Object[0]));
                projectSearch.getTextEditor().putClientProperty((Object)"StatusVisibleFunction", editor2 -> editor2.getText().isEmpty());
                SearchTextField searchTextField2 = projectSearch;
                if (searchTextField2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return searchTextField2;
            }

            @NotNull
            private ActionToolbar createActionsToolbar() {
                Couple<DefaultActionGroup> mainAndMore = WelcomeScreenActionsUtil.splitAndWrapActions((ActionGroup)ActionManager.getInstance().getAction("WelcomeScreen.QuickStart.ProjectsState"), action2 -> ActionGroupPanelWrapper.wrapGroups(action2, parentDisposable), 3);
                DefaultActionGroup toolbarActionGroup = new DefaultActionGroup(ContainerUtil.map2List((Object[])((DefaultActionGroup)mainAndMore.getFirst()).getChildren(null), action2 -> this.createButtonWrapper((AnAction)action2)));
                ActionGroup moreActionGroup = (ActionGroup)mainAndMore.getSecond();
                Presentation moreActionPresentation = moreActionGroup.getTemplatePresentation();
                moreActionPresentation.setIcon(AllIcons.Actions.More);
                moreActionPresentation.putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)true);
                toolbarActionGroup.addAction((AnAction)moreActionGroup);
                ActionToolbarImpl toolbar = new ActionToolbarImpl("WelcomeScreen", (ActionGroup)toolbarActionGroup, true){

                    @Override
                    @NotNull
                    protected ActionButton createToolbarButton(@NotNull AnAction action2, ActionButtonLook look, @NotNull String place, @NotNull Presentation presentation2, @NotNull Dimension minimumSize) {
                        if (action2 == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if (place == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        if (presentation2 == null) {
                            3.$$$reportNull$$$0(2);
                        }
                        if (minimumSize == null) {
                            3.$$$reportNull$$$0(3);
                        }
                        ActionButton toolbarButton = super.createToolbarButton(action2, look, place, presentation2, minimumSize);
                        toolbarButton.setFocusable(true);
                        ActionButton actionButton2 = toolbarButton;
                        if (actionButton2 == null) {
                            3.$$$reportNull$$$0(4);
                        }
                        return actionButton2;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 4: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 4: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "action";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "place";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "presentation";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "minimumSize";
                                break;
                            }
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/ProjectsTabFactory$1$3";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/ProjectsTabFactory$1$3";
                                break;
                            }
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[1] = "createToolbarButton";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "createToolbarButton";
                                break;
                            }
                            case 4: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 4: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
                toolbar.setOpaque(false);
                toolbar.setReservePlaceAutoPopupIcon(false);
                ActionToolbarImpl actionToolbarImpl = toolbar;
                if (actionToolbarImpl == null) {
                    1.$$$reportNull$$$0(2);
                }
                return actionToolbarImpl;
            }

            @NotNull
            private WelcomeScreenActionsUtil.ToolbarTextButtonWrapper createButtonWrapper(@NotNull AnAction action2) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (action2 instanceof ActionGroup) {
                    List actions2 = ContainerUtil.map((Object[])((ActionGroup)action2).getChildren(null), a -> ActionGroupPanelWrapper.wrapGroups(a, parentDisposable));
                    WelcomeScreenActionsUtil.ToolbarTextButtonWrapper toolbarTextButtonWrapper = WelcomeScreenActionsUtil.ToolbarTextButtonWrapper.wrapAsOptionButton(actions2);
                    if (toolbarTextButtonWrapper == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return toolbarTextButtonWrapper;
                }
                WelcomeScreenActionsUtil.ToolbarTextButtonWrapper toolbarTextButtonWrapper = WelcomeScreenActionsUtil.ToolbarTextButtonWrapper.wrapAsTextButton(action2);
                if (toolbarTextButtonWrapper == null) {
                    1.$$$reportNull$$$0(5);
                }
                return toolbarTextButtonWrapper;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectSearch";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/ProjectsTabFactory$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/ProjectsTabFactory$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createSearchProjectsField";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createActionsToolbar";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createButtonWrapper";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createProjectsPanelWithExternalSearch";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "createButtonWrapper";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public boolean isApplicable() {
        return !PlatformUtils.isDataSpell();
    }

    @NotNull
    private static DnDNativeTarget createDropFileTarget() {
        return new DnDNativeTarget(){

            public boolean update(@NotNull DnDEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!FileCopyPasteUtil.isFileListFlavorAvailable(event)) {
                    return false;
                }
                event.setDropPossible(true);
                return false;
            }

            public void drop(@NotNull DnDEvent event) {
                List<File> files2;
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!(files2 = FileCopyPasteUtil.getFileListFromAttachedObject(event.getAttachedObject())).isEmpty()) {
                    ProjectUtil.tryOpenFiles(null, ContainerUtil.map(files2, file2 -> file2.toPath()), "WelcomeFrame");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/ProjectsTabFactory$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "drop";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/welcomeScreen/ProjectsTabFactory", "createWelcomeTab"));
    }
}

