/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WelcomeScreenCustomization;
import com.intellij.openapi.wm.WelcomeScreenTab;
import com.intellij.openapi.wm.WelcomeTabFactory;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractWelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenComponentFactory;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenEventCollector;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.ui.CardLayoutPanel;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.Objects;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TabbedWelcomeScreen
extends AbstractWelcomeScreen {
    DefaultMutableTreeNode root = new DefaultMutableTreeNode();
    DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
    JTree tree = new Tree((TreeModel)this.treeModel);
    private JPanel leftPanel = new NonOpaquePanel();

    TabbedWelcomeScreen() {
        this.setBackground(WelcomeScreenUIManager.getMainTabListBackground());
        CardLayoutPanel<WelcomeScreenTab, WelcomeScreenTab, JPanel> mainPanel2 = TabbedWelcomeScreen.createCardPanel();
        for (WelcomeTabFactory tabFactory : WelcomeTabFactory.WELCOME_TAB_FACTORY_EP.getExtensionList()) {
            if (!tabFactory.isApplicable()) continue;
            WelcomeScreenTab tab = tabFactory.createWelcomeTab((Disposable)this);
            TabbedWelcomeScreen.addTab(this.root, tab);
        }
        TreeUtil.installActions((JTree)this.tree);
        this.tree.putClientProperty(RenderingUtil.ALWAYS_PAINT_SELECTION_AS_FOCUSED, true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.tree.setBackground(WelcomeScreenUIManager.getMainTabListBackground());
        this.tree.setBorder((Border)JBUI.Borders.emptyLeft((int)16));
        this.tree.setCellRenderer(new MyCellRenderer());
        this.tree.setRowHeight(0);
        this.tree.addTreeSelectionListener(e -> {
            WelcomeScreenTab tab = (WelcomeScreenTab)TreeUtil.getUserObject(WelcomeScreenTab.class, (Object)e.getPath().getLastPathComponent());
            if (tab == null) {
                return;
            }
            mainPanel2.select(tab, true);
            WelcomeScreenEventCollector.logTabSelected(tab);
        });
        this.tree.getAccessibleContext().setAccessibleName(UIBundle.message((String)"welcome.screen.welcome.screen.categories.accessible.name", (Object[])new Object[0]));
        JComponent logoComponent = WelcomeScreenComponentFactory.createSmallLogo();
        logoComponent.setFocusable(false);
        logoComponent.setBorder((Border)JBUI.Borders.emptyLeft((int)16));
        this.leftPanel.add((Component)logoComponent, "North");
        this.leftPanel.add((Component)this.tree, "Center");
        JComponent quickAccessPanel = TabbedWelcomeScreen.createQuickAccessPanel((Disposable)this);
        quickAccessPanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)10));
        this.leftPanel.add((Component)quickAccessPanel, "South");
        this.leftPanel.setPreferredSize(new Dimension(JBUI.scale((int)215), this.leftPanel.getPreferredSize().height));
        JComponent centralPanel = mainPanel2;
        JComponent mainPanelToolbar = TabbedWelcomeScreen.createMainPanelToolbar((Disposable)this);
        if (mainPanelToolbar != null) {
            centralPanel = new JPanel(new BorderLayout());
            centralPanel.add(mainPanel2, "Center");
            centralPanel.add((Component)mainPanelToolbar, "South");
        }
        this.add((Component)this.leftPanel, "West");
        this.add(centralPanel, "Center");
        if (this.root.getChildCount() > 0) {
            DefaultMutableTreeNode firstTabNode = (DefaultMutableTreeNode)this.root.getFirstChild();
            WelcomeScreenTab firstTab = (WelcomeScreenTab)TreeUtil.getUserObject(WelcomeScreenTab.class, (Object)firstTabNode);
            TreeUtil.selectNode((JTree)this.tree, (TreeNode)firstTabNode);
            TreeUtil.expandAll((JTree)this.tree);
            JComponent firstShownPanel = firstTab.getAssociatedComponent();
            UiNotifyConnector.doWhenFirstShown((JComponent)firstShownPanel, () -> {
                JComponent preferred = IdeFocusTraversalPolicy.getPreferredFocusedComponent(firstShownPanel);
                IdeFocusManager.getGlobalInstance().requestFocus((Component)Objects.requireNonNullElse(preferred, this.tree), true);
                WelcomeScreenEventCollector.logWelcomeScreenShown();
            });
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        WelcomeScreenEventCollector.logWelcomeScreenHide();
    }

    public void setTabListVisible(boolean visible) {
        this.leftPanel.setVisible(visible);
    }

    @ApiStatus.Experimental
    public void selectTab(@NotNull WelcomeScreenTab tab) {
        TreeNode targetNode;
        if (tab == null) {
            TabbedWelcomeScreen.$$$reportNull$$$0(0);
        }
        if ((targetNode = (TreeNode)TreeUtil.treeNodeTraverser((TreeNode)this.root).traverse(TreeTraversal.POST_ORDER_DFS).find(node2 -> {
            Object currentTab;
            return node2 instanceof DefaultMutableTreeNode && (currentTab = ((DefaultMutableTreeNode)node2).getUserObject()) instanceof WelcomeScreenTab && currentTab == tab;
        })) != null) {
            TreeUtil.selectNode((JTree)this.tree, (TreeNode)targetNode);
        }
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public void navigateToTabAndSetMainComponent(Component component2, int tabIndex) {
        this.tree.setSelectionRow(tabIndex);
        DefaultWelcomeScreenTab selectedTab = this.getSelectedTab();
        if (selectedTab == null) {
            return;
        }
        if (selectedTab.myAssociatedComponent.getComponentCount() == 0) {
            return;
        }
        Component panel2 = selectedTab.myAssociatedComponent.getComponent(0);
        ((JComponent)panel2).removeAll();
        ((JComponent)panel2).add(component2, "Center");
        this.revalidate();
        this.repaint();
        this.leftPanel.setVisible(false);
    }

    private DefaultWelcomeScreenTab getSelectedTab() {
        Object panel2;
        Object tab = this.tree.getLastSelectedPathComponent();
        if (tab == null) {
            return null;
        }
        if (tab instanceof DefaultMutableTreeNode && (panel2 = ((DefaultMutableTreeNode)tab).getUserObject()) instanceof DefaultWelcomeScreenTab) {
            return (DefaultWelcomeScreenTab)panel2;
        }
        return null;
    }

    private static void addTab(@NotNull DefaultMutableTreeNode parent, @NotNull WelcomeScreenTab tab) {
        if (parent == null) {
            TabbedWelcomeScreen.$$$reportNull$$$0(1);
        }
        if (tab == null) {
            TabbedWelcomeScreen.$$$reportNull$$$0(2);
        }
        DefaultMutableTreeNode child2 = new DefaultMutableTreeNode(tab);
        parent.add(child2);
        tab.getChildTabs().forEach(it -> TabbedWelcomeScreen.addTab(child2, it));
    }

    private static JComponent createQuickAccessPanel(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            TabbedWelcomeScreen.$$$reportNull$$$0(3);
        }
        NonOpaquePanel quickAccessPanel = new NonOpaquePanel((LayoutManager)new FlowLayout(0, 0, 0));
        WelcomeScreenCustomization.WELCOME_SCREEN_CUSTOMIZATION.getExtensionsIfPointIsRegistered().stream().map(c -> c.createQuickAccessComponent(parentDisposable)).filter(Objects::nonNull).forEach(((JPanel)quickAccessPanel)::add);
        return quickAccessPanel;
    }

    @Nullable
    private static JComponent createMainPanelToolbar(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            TabbedWelcomeScreen.$$$reportNull$$$0(4);
        }
        return WelcomeScreenCustomization.WELCOME_SCREEN_CUSTOMIZATION.getExtensionsIfPointIsRegistered().stream().map(c -> c.createMainPanelToolbar(parentDisposable)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @NotNull
    private static CardLayoutPanel<WelcomeScreenTab, WelcomeScreenTab, JPanel> createCardPanel() {
        return new CardLayoutPanel<WelcomeScreenTab, WelcomeScreenTab, JPanel>(){

            @Override
            protected WelcomeScreenTab prepare(WelcomeScreenTab key) {
                key.updateComponent();
                return key;
            }

            @Override
            protected JPanel create(WelcomeScreenTab screenTab) {
                return JBUI.Panels.simplePanel((Component)screenTab.getAssociatedComponent());
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tab";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/TabbedWelcomeScreen";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "selectTab";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addTab";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createQuickAccessPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createMainPanelToolbar";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class DefaultWelcomeScreenTab
    implements WelcomeScreenTab,
    Accessible {
        protected final JComponent myKeyComponent;
        private final JBLabel myLabel;
        private final WelcomeScreenEventCollector.TabType myType;
        private JComponent myAssociatedComponent;

        public DefaultWelcomeScreenTab(@NotNull @Nls String tabName) {
            if (tabName == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(0);
            }
            this(tabName, null, WelcomeScreenEventCollector.TabType.TabNavOther);
        }

        public DefaultWelcomeScreenTab(@NotNull @Nls String tabName, @Nullable Icon icon2) {
            if (tabName == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(1);
            }
            this(tabName, icon2, WelcomeScreenEventCollector.TabType.TabNavOther);
        }

        DefaultWelcomeScreenTab(@NotNull @Nls String tabName, @NotNull WelcomeScreenEventCollector.TabType tabType) {
            if (tabName == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(2);
            }
            if (tabType == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(3);
            }
            this(tabName, null, tabType);
        }

        DefaultWelcomeScreenTab(@NotNull @Nls String tabName, @Nullable Icon icon2, @NotNull WelcomeScreenEventCollector.TabType tabType) {
            if (tabName == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(4);
            }
            if (tabType == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(5);
            }
            this.myLabel = new JBLabel(tabName, icon2, 2);
            this.myType = tabType;
            this.myKeyComponent = ((BorderLayoutPanel)JBUI.Panels.simplePanel().addToLeft((Component)this.myLabel).withBackground(WelcomeScreenUIManager.getMainTabListBackground())).withBorder((Border)JBUI.Borders.empty((int)8, (int)0));
        }

        @NotNull
        public JComponent getKeyComponent(@NotNull JComponent parent) {
            if (parent == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(6);
            }
            JComponent jComponent = this.myKeyComponent;
            if (jComponent == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(7);
            }
            return jComponent;
        }

        @NotNull
        public JComponent getAssociatedComponent() {
            if (this.myAssociatedComponent == null) {
                this.myAssociatedComponent = this.buildComponent();
            }
            JComponent jComponent = this.myAssociatedComponent;
            if (jComponent == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(8);
            }
            return jComponent;
        }

        WelcomeScreenEventCollector.TabType getType() {
            return this.myType;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return this.myLabel.getAccessibleContext();
        }

        protected abstract JComponent buildComponent();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabName";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/TabbedWelcomeScreen$DefaultWelcomeScreenTab";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/TabbedWelcomeScreen$DefaultWelcomeScreenTab";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeyComponent";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAssociatedComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getKeyComponent";
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyCellRenderer
    implements TreeCellRenderer {
        private MyCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean isSelected, boolean isExpanded, boolean leaf, int row2, boolean cellHasFocus) {
            WelcomeScreenTab tab = (WelcomeScreenTab)TreeUtil.getUserObject(WelcomeScreenTab.class, (Object)value2);
            JComponent keyComponent = tab != null ? tab.getKeyComponent((JComponent)tree) : new JLabel("");
            BorderLayoutPanel wrappedPanel = JBUI.Panels.simplePanel((Component)keyComponent);
            UIUtil.setBackgroundRecursively((Component)wrappedPanel, (Color)(isSelected ? UIUtil.getListSelectionBackground((boolean)cellHasFocus) : WelcomeScreenUIManager.getMainTabListBackground()));
            UIUtil.setForegroundRecursively((Component)wrappedPanel, (Color)UIUtil.getListForeground((boolean)isSelected, (boolean)cellHasFocus));
            if (tab instanceof Accessible) {
                wrappedPanel.getAccessibleContext().setAccessibleName(((Accessible)tab).getAccessibleContext().getAccessibleName());
            }
            return wrappedPanel;
        }
    }
}

