/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.projectImport.ProjectSetProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSetReader {
    private static final Logger LOG = Logger.getInstance(ProjectSetReader.class);

    public void readDescriptor(@NotNull JsonObject descriptor2, @Nullable ProjectSetProcessor.Context context2) {
        if (descriptor2 == null) {
            ProjectSetReader.$$$reportNull$$$0(0);
        }
        HashMap<String, ProjectSetProcessor> processors = new HashMap<String, ProjectSetProcessor>();
        for (ProjectSetProcessor extension2 : (ProjectSetProcessor[])ProjectSetProcessor.EXTENSION_POINT_NAME.getExtensions()) {
            processors.put(extension2.getId(), extension2);
        }
        if (context2 == null) {
            context2 = new ProjectSetProcessor.Context();
        }
        context2.directoryName = "";
        if (descriptor2.get("project") == null) {
            descriptor2.add("project", (JsonElement)new JsonObject());
        }
        ProjectSetReader.runProcessor(processors, context2, descriptor2.entrySet().iterator());
    }

    private static void runProcessor(Map<String, ProjectSetProcessor> processors, ProjectSetProcessor.Context context2, Iterator<? extends Map.Entry<String, JsonElement>> iterator2) {
        List list2;
        if (!iterator2.hasNext()) {
            return;
        }
        Map.Entry<String, JsonElement> entry2 = iterator2.next();
        String key = entry2.getKey();
        ProjectSetProcessor processor2 = processors.get(key);
        if (processor2 == null) {
            LOG.error("Processor not found for " + key);
            return;
        }
        if (entry2.getValue().isJsonObject()) {
            JsonObject object = entry2.getValue().getAsJsonObject();
            if (object.entrySet().size() == 1 && ((JsonElement)((Map.Entry)object.entrySet().iterator().next()).getValue()).isJsonArray()) {
                Map.Entry next = (Map.Entry)object.entrySet().iterator().next();
                list2 = ContainerUtil.map((Iterable)((JsonElement)next.getValue()).getAsJsonArray(), o -> Pair.create((Object)((String)next.getKey()), (Object)ProjectSetReader.getString(o)));
            } else {
                list2 = ContainerUtil.map((Collection)object.entrySet(), entry1 -> {
                    JsonElement value2 = (JsonElement)entry1.getValue();
                    return Pair.create((Object)((String)entry1.getKey()), (Object)ProjectSetReader.getString(value2));
                });
            }
        } else {
            list2 = Collections.singletonList(Pair.create((Object)entry2.getKey(), (Object)entry2.getValue().getAsString()));
        }
        processor2.processEntries(list2, context2, () -> ProjectSetReader.runProcessor(processors, context2, iterator2));
    }

    public static String getString(JsonElement value2) {
        return value2 instanceof JsonPrimitive ? value2.getAsString() : value2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/platform/ProjectSetReader", "readDescriptor"));
    }
}

