/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates.github;

import com.intellij.lang.LangBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.platform.templates.github.GeneratorException;
import com.intellij.platform.templates.github.Outcome;
import com.intellij.util.NullableFunction;
import com.intellij.util.Producer;
import com.intellij.util.io.Decompressor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ZipUtil {
    private static final Logger LOG = Logger.getInstance(ZipUtil.class);

    public static void unzipWithProgressSynchronously(@Nullable Project project, @NotNull @NlsContexts.ProgressTitle String progressTitle2, @NotNull Path zipArchive, @NotNull Path extractToDir, boolean unwrapSingleTopLevelFolder) throws GeneratorException {
        if (progressTitle2 == null) {
            ZipUtil.$$$reportNull$$$0(0);
        }
        if (zipArchive == null) {
            ZipUtil.$$$reportNull$$$0(1);
        }
        if (extractToDir == null) {
            ZipUtil.$$$reportNull$$$0(2);
        }
        ZipUtil.unzipWithProgressSynchronously(project, progressTitle2, zipArchive.toFile(), extractToDir.toFile(), null, unwrapSingleTopLevelFolder);
    }

    public static void unzipWithProgressSynchronously(@Nullable Project project, @NotNull @NlsContexts.ProgressTitle String progressTitle2, @NotNull File zipArchive, @NotNull File extractToDir, @Nullable NullableFunction<? super String, String> pathConvertor, boolean unwrapSingleTopLevelFolder) throws GeneratorException {
        Outcome<Boolean> outcome;
        Boolean result2;
        if (progressTitle2 == null) {
            ZipUtil.$$$reportNull$$$0(3);
        }
        if (zipArchive == null) {
            ZipUtil.$$$reportNull$$$0(4);
        }
        if (extractToDir == null) {
            ZipUtil.$$$reportNull$$$0(5);
        }
        if ((result2 = (outcome = DownloadUtil.provideDataWithProgressSynchronously(project, progressTitle2, LangBundle.message((String)"progress.text.unpacking", (Object[])new Object[0]), () -> {
            ProgressIndicator progress2 = ProgressManager.getInstance().getProgressIndicator();
            ZipUtil.unzip(progress2, extractToDir, zipArchive, pathConvertor, null, unwrapSingleTopLevelFolder);
            return true;
        }, (Producer<Boolean>)((Producer)() -> false))).get()) == null) {
            Exception e = outcome.getException();
            if (e != null) {
                throw new GeneratorException(LangBundle.message((String)"dialog.message.unpacking.failed.downloaded.archive.broken", (Object[])new Object[0]));
            }
            throw new GeneratorException(LangBundle.message((String)"dialog.message.unpacking.was.cancelled", (Object[])new Object[0]));
        }
    }

    @NotNull
    private static Path getUnzipToDir(@Nullable ProgressIndicator progress2, @NotNull Path targetDir, boolean unwrapSingleTopLevelFolder) throws IOException {
        if (targetDir == null) {
            ZipUtil.$$$reportNull$$$0(6);
        }
        if (progress2 != null) {
            progress2.setText(LangBundle.message((String)"progress.text.extracting", (Object[])new Object[0]));
        }
        Path path2 = unwrapSingleTopLevelFolder ? Files.createTempDirectory("unzip-dir-", new FileAttribute[0]) : targetDir;
        if (path2 == null) {
            ZipUtil.$$$reportNull$$$0(7);
        }
        return path2;
    }

    public static void unzip(@Nullable ProgressIndicator progress2, @NotNull File targetDir, @NotNull File zipArchive, @Nullable NullableFunction<? super String, String> pathConvertor, @Nullable ContentProcessor contentProcessor, boolean unwrapSingleTopLevelFolder) throws IOException {
        if (targetDir == null) {
            ZipUtil.$$$reportNull$$$0(8);
        }
        if (zipArchive == null) {
            ZipUtil.$$$reportNull$$$0(9);
        }
        Path unzipToDir = ZipUtil.getUnzipToDir(progress2, targetDir.toPath(), unwrapSingleTopLevelFolder);
        try (ZipFile zipFile = new ZipFile(zipArchive, 1);){
            Enumeration<? extends ZipEntry> entries2 = zipFile.entries();
            while (entries2.hasMoreElements()) {
                ZipEntry entry2 = entries2.nextElement();
                InputStream entryContentStream = zipFile.getInputStream(entry2);
                try {
                    ZipUtil.unzipEntryToDir(progress2, entry2, entryContentStream, unzipToDir, pathConvertor, contentProcessor);
                }
                finally {
                    if (entryContentStream == null) continue;
                    entryContentStream.close();
                }
            }
        }
        if (unwrapSingleTopLevelFolder) {
            ZipUtil.doUnwrapSingleTopLevelFolder(unzipToDir, targetDir.toPath());
        }
    }

    public static void unzip(@Nullable ProgressIndicator progress2, @NotNull Path targetDir, @NotNull ZipInputStream stream, @Nullable NullableFunction<? super String, String> pathConvertor, @Nullable ContentProcessor contentProcessor, boolean unwrapSingleTopLevelFolder) throws IOException {
        ZipEntry entry2;
        if (targetDir == null) {
            ZipUtil.$$$reportNull$$$0(10);
        }
        if (stream == null) {
            ZipUtil.$$$reportNull$$$0(11);
        }
        Path unzipToDir = ZipUtil.getUnzipToDir(progress2, targetDir, unwrapSingleTopLevelFolder);
        while ((entry2 = stream.getNextEntry()) != null) {
            ZipUtil.unzipEntryToDir(progress2, entry2, stream, unzipToDir, pathConvertor, contentProcessor);
        }
        if (unwrapSingleTopLevelFolder) {
            ZipUtil.doUnwrapSingleTopLevelFolder(unzipToDir, targetDir);
        }
    }

    private static void doUnwrapSingleTopLevelFolder(@NotNull Path unzipToDir, @NotNull Path targetDir) throws IOException {
        List children2;
        Path dirToMove;
        List topLevelFiles;
        if (unzipToDir == null) {
            ZipUtil.$$$reportNull$$$0(12);
        }
        if (targetDir == null) {
            ZipUtil.$$$reportNull$$$0(13);
        }
        try (Stream<Path> stream = Files.list(unzipToDir);){
            topLevelFiles = stream.collect(Collectors.toList());
        }
        catch (NoSuchFileException e) {
            return;
        }
        if (topLevelFiles.size() == 1 && Files.isDirectory((Path)topLevelFiles.get(0), new LinkOption[0])) {
            dirToMove = (Path)topLevelFiles.get(0);
            try (Stream<Path> stream = Files.list(dirToMove);){
                children2 = stream.collect(Collectors.toList());
            }
        } else {
            dirToMove = unzipToDir;
            children2 = topLevelFiles;
        }
        for (Path child2 : children2) {
            Path to = targetDir.resolve(dirToMove.relativize(child2));
            if (Files.isDirectory(child2, new LinkOption[0])) {
                FileUtil.copyDir((File)child2.toFile(), (File)to.toFile(), (boolean)true);
                continue;
            }
            Files.createDirectories(to.getParent(), new FileAttribute[0]);
            Files.copy(child2, to, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
        FileUtil.delete((Path)unzipToDir);
    }

    private static void unzipEntryToDir(@Nullable ProgressIndicator progress2, @NotNull ZipEntry zipEntry, @NotNull InputStream entryContentStream, @NotNull Path extractToDir, @Nullable NullableFunction<? super String, String> pathConvertor, @Nullable ContentProcessor contentProcessor) throws IOException {
        if (zipEntry == null) {
            ZipUtil.$$$reportNull$$$0(14);
        }
        if (entryContentStream == null) {
            ZipUtil.$$$reportNull$$$0(15);
        }
        if (extractToDir == null) {
            ZipUtil.$$$reportNull$$$0(16);
        }
        String relativeExtractPath = ZipUtil.createRelativeExtractPath(zipEntry);
        if (pathConvertor != null && (relativeExtractPath = (String)pathConvertor.fun((Object)relativeExtractPath)) == null) {
            return;
        }
        Path child2 = Decompressor.entryFile((Path)extractToDir, (String)relativeExtractPath);
        Path dir = zipEntry.isDirectory() ? child2 : child2.getParent();
        Files.createDirectories(dir, new FileAttribute[0]);
        if (zipEntry.isDirectory()) {
            return;
        }
        if (progress2 != null) {
            progress2.setText2(LangBundle.message((String)"progress.text.extracting.path", (Object[])new Object[]{relativeExtractPath}));
        }
        if (contentProcessor == null) {
            Files.copy(entryContentStream, child2, StandardCopyOption.REPLACE_EXISTING);
        } else {
            byte[] content2 = contentProcessor.processContent(FileUtilRt.loadBytes((InputStream)entryContentStream), child2.toFile());
            if (content2 != null) {
                Files.write(child2, content2, new OpenOption[0]);
            }
        }
        LOG.info("Extract: " + relativeExtractPath);
    }

    @NotNull
    private static String createRelativeExtractPath(@NotNull ZipEntry zipEntry) {
        if (zipEntry == null) {
            ZipUtil.$$$reportNull$$$0(17);
        }
        String name2 = StringUtil.trimStart((String)zipEntry.getName(), (String)"/");
        String string = StringUtil.trimEnd((String)name2, (String)"/");
        if (string == null) {
            ZipUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipArchive";
                break;
            }
            case 2: 
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractToDir";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/templates/github/ZipUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unzipToDir";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipEntry";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryContentStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/templates/github/ZipUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnzipToDir";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createRelativeExtractPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unzipWithProgressSynchronously";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUnzipToDir";
                break;
            }
            case 7: 
            case 18: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unzip";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doUnwrapSingleTopLevelFolder";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "unzipEntryToDir";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createRelativeExtractPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ContentProcessor {
        public byte @Nullable [] processContent(byte[] var1, File var2) throws IOException;
    }
}

