/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.CodeStyleBundle;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategyFactory;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FormatterUtil {
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static final String REFORMAT_BEFORE_COMMIT_COMMAND_NAME = "Reformat Code Before Commit";
    public static final Collection<String> FORMATTER_ACTION_NAMES = Collections.unmodifiableCollection(ContainerUtil.newHashSet((Object[])new String[]{CodeStyleBundle.message((String)"process.reformat.code", (Object[])new Object[0]), FormatterUtil.getReformatBeforeCommitCommandName()}));

    private FormatterUtil() {
    }

    public static boolean isWhitespaceOrEmpty(@Nullable ASTNode node2) {
        if (node2 == null) {
            return false;
        }
        IElementType type = node2.getElementType();
        return type == TokenType.WHITE_SPACE || type != TokenType.ERROR_ELEMENT && node2.getTextLength() == 0;
    }

    public static boolean isOneOf(@Nullable ASTNode node2, IElementType ... types) {
        if (types == null) {
            FormatterUtil.$$$reportNull$$$0(0);
        }
        if (node2 == null) {
            return false;
        }
        IElementType elementType = node2.getElementType();
        for (IElementType each : types) {
            if (elementType != each) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ASTNode getPrevious(@Nullable ASTNode node2, IElementType ... typesToIgnore) {
        if (typesToIgnore == null) {
            FormatterUtil.$$$reportNull$$$0(1);
        }
        return FormatterUtil.getNextOrPrevious(node2, false, typesToIgnore);
    }

    @Nullable
    public static ASTNode getNext(@Nullable ASTNode node2, IElementType ... typesToIgnore) {
        if (typesToIgnore == null) {
            FormatterUtil.$$$reportNull$$$0(2);
        }
        return FormatterUtil.getNextOrPrevious(node2, true, typesToIgnore);
    }

    @Nullable
    private static ASTNode getNextOrPrevious(@Nullable ASTNode node2, boolean isNext, IElementType ... typesToIgnore) {
        if (typesToIgnore == null) {
            FormatterUtil.$$$reportNull$$$0(3);
        }
        if (node2 == null) {
            return null;
        }
        ASTNode each = isNext ? node2.getTreeNext() : node2.getTreePrev();
        for (ASTNode parent = node2.getTreeParent(); each == null && parent != null; parent = parent.getTreeParent()) {
            each = isNext ? parent.getTreeNext() : parent.getTreePrev();
        }
        if (each == null) {
            return null;
        }
        for (IElementType type : typesToIgnore) {
            if (each.getElementType() != type) continue;
            return FormatterUtil.getNextOrPrevious(each, isNext, typesToIgnore);
        }
        return each;
    }

    @Nullable
    public static ASTNode getPreviousLeaf(@Nullable ASTNode node2, IElementType ... typesToIgnore) {
        ASTNode prev2;
        if (typesToIgnore == null) {
            FormatterUtil.$$$reportNull$$$0(4);
        }
        if ((prev2 = FormatterUtil.getPrevious(node2, typesToIgnore)) == null) {
            return null;
        }
        ASTNode result2 = prev2;
        for (ASTNode lastChild = prev2.getLastChildNode(); lastChild != null; lastChild = lastChild.getLastChildNode()) {
            result2 = lastChild;
        }
        for (IElementType type : typesToIgnore) {
            if (result2.getElementType() != type) continue;
            return FormatterUtil.getPreviousLeaf(result2, typesToIgnore);
        }
        return result2;
    }

    @Nullable
    public static ASTNode getPreviousNonWhitespaceLeaf(@Nullable ASTNode node2) {
        if (node2 == null) {
            return null;
        }
        ASTNode treePrev = node2.getTreePrev();
        if (treePrev != null) {
            ASTNode candidate = TreeUtil.getLastChild(treePrev);
            if (candidate != null && !FormatterUtil.isWhitespaceOrEmpty(candidate)) {
                return candidate;
            }
            return FormatterUtil.getPreviousNonWhitespaceLeaf(candidate);
        }
        ASTNode treeParent = node2.getTreeParent();
        if (treeParent == null || treeParent.getTreeParent() == null) {
            return null;
        }
        return FormatterUtil.getPreviousNonWhitespaceLeaf(treeParent);
    }

    @Nullable
    public static ASTNode getNextNonWhitespaceLeaf(@Nullable ASTNode node2) {
        if (node2 == null) {
            return null;
        }
        ASTNode treeNext = node2.getTreeNext();
        if (treeNext != null) {
            LeafElement candidate = TreeUtil.findFirstLeaf(treeNext);
            if (candidate != null && !FormatterUtil.isWhitespaceOrEmpty(candidate)) {
                return candidate;
            }
            return FormatterUtil.getNextNonWhitespaceLeaf(candidate);
        }
        ASTNode treeParent = node2.getTreeParent();
        if (treeParent == null || treeParent.getTreeParent() == null) {
            return null;
        }
        return FormatterUtil.getNextNonWhitespaceLeaf(treeParent);
    }

    @Nullable
    public static ASTNode getPreviousNonWhitespaceSibling(@Nullable ASTNode node2) {
        ASTNode prevNode;
        ASTNode aSTNode = prevNode = node2 == null ? null : node2.getTreePrev();
        while (prevNode != null && FormatterUtil.isWhitespaceOrEmpty(prevNode)) {
            prevNode = prevNode.getTreePrev();
        }
        return prevNode;
    }

    @Nullable
    public static ASTNode getNextNonWhitespaceSibling(@Nullable ASTNode node2) {
        ASTNode next;
        ASTNode aSTNode = next = node2 == null ? null : node2.getTreeNext();
        while (next != null && FormatterUtil.isWhitespaceOrEmpty(next)) {
            next = next.getTreeNext();
        }
        return next;
    }

    public static boolean isPrecededBy(@Nullable ASTNode node2, IElementType expectedType) {
        return FormatterUtil.isPrecededBy(node2, expectedType, IElementType.EMPTY_ARRAY);
    }

    public static boolean isPrecededBy(@Nullable ASTNode node2, IElementType expectedType, TokenSet skipTypes) {
        return FormatterUtil.isPrecededBy(node2, expectedType, skipTypes.getTypes());
    }

    public static boolean isPrecededBy(@Nullable ASTNode node2, IElementType expectedType, IElementType ... skipTypes) {
        ASTNode prevNode;
        ASTNode aSTNode = prevNode = node2 == null ? null : node2.getTreePrev();
        while (prevNode != null && (FormatterUtil.isWhitespaceOrEmpty(prevNode) || FormatterUtil.isOneOf(prevNode, skipTypes))) {
            prevNode = prevNode.getTreePrev();
        }
        if (prevNode == null) {
            return false;
        }
        return prevNode.getElementType() == expectedType;
    }

    public static boolean isPrecededBy(@Nullable ASTNode node2, TokenSet expectedTypes) {
        return FormatterUtil.isPrecededBy(node2, expectedTypes, IElementType.EMPTY_ARRAY);
    }

    public static boolean isPrecededBy(@Nullable ASTNode node2, TokenSet expectedTypes, TokenSet skipTypes) {
        return FormatterUtil.isPrecededBy(node2, expectedTypes, skipTypes.getTypes());
    }

    public static boolean isPrecededBy(@Nullable ASTNode node2, TokenSet expectedTypes, IElementType ... skipTypes) {
        ASTNode prevNode;
        ASTNode aSTNode = prevNode = node2 == null ? null : node2.getTreePrev();
        while (prevNode != null && (FormatterUtil.isWhitespaceOrEmpty(prevNode) || FormatterUtil.isOneOf(prevNode, skipTypes))) {
            prevNode = prevNode.getTreePrev();
        }
        if (prevNode == null) {
            return false;
        }
        return expectedTypes.contains(prevNode.getElementType());
    }

    public static boolean hasPrecedingSiblingOfType(@Nullable ASTNode node2, IElementType expectedSiblingType, IElementType ... skipTypes) {
        ASTNode prevNode;
        ASTNode aSTNode = prevNode = node2 == null ? null : node2.getTreePrev();
        while (prevNode != null) {
            if (!FormatterUtil.isWhitespaceOrEmpty(prevNode) && !FormatterUtil.isOneOf(prevNode, skipTypes) && prevNode.getElementType() == expectedSiblingType) {
                return true;
            }
            prevNode = prevNode.getTreePrev();
        }
        return false;
    }

    public static boolean isFollowedBy(@Nullable ASTNode node2, IElementType expectedType) {
        return FormatterUtil.isFollowedBy(node2, expectedType, IElementType.EMPTY_ARRAY);
    }

    public static boolean isFollowedBy(@Nullable ASTNode node2, IElementType expectedType, TokenSet skipTypes) {
        return FormatterUtil.isFollowedBy(node2, expectedType, skipTypes.getTypes());
    }

    public static boolean isFollowedBy(@Nullable ASTNode node2, IElementType expectedType, IElementType ... skipTypes) {
        ASTNode nextNode;
        ASTNode aSTNode = nextNode = node2 == null ? null : node2.getTreeNext();
        while (nextNode != null && (FormatterUtil.isWhitespaceOrEmpty(nextNode) || FormatterUtil.isOneOf(nextNode, skipTypes))) {
            nextNode = nextNode.getTreeNext();
        }
        if (nextNode == null) {
            return false;
        }
        return nextNode.getElementType() == expectedType;
    }

    public static boolean isFollowedBy(@Nullable ASTNode node2, @NotNull TokenSet expectedTypes, TokenSet skipTypes) {
        if (expectedTypes == null) {
            FormatterUtil.$$$reportNull$$$0(5);
        }
        return FormatterUtil.isFollowedBy(node2, expectedTypes, skipTypes.getTypes());
    }

    public static boolean isFollowedBy(@Nullable ASTNode node2, @NotNull TokenSet expectedTypes, IElementType ... skipTypes) {
        ASTNode nextNode;
        if (expectedTypes == null) {
            FormatterUtil.$$$reportNull$$$0(6);
        }
        ASTNode aSTNode = nextNode = node2 == null ? null : node2.getTreeNext();
        while (nextNode != null && (FormatterUtil.isWhitespaceOrEmpty(nextNode) || FormatterUtil.isOneOf(nextNode, skipTypes))) {
            nextNode = nextNode.getTreeNext();
        }
        if (nextNode == null) {
            return false;
        }
        return expectedTypes.contains(nextNode.getElementType());
    }

    public static boolean isIncomplete(@Nullable ASTNode node2) {
        ASTNode lastChild;
        ASTNode aSTNode = lastChild = node2 == null ? null : node2.getLastChildNode();
        while (lastChild != null && lastChild.getElementType() == TokenType.WHITE_SPACE) {
            lastChild = lastChild.getTreePrev();
        }
        if (lastChild == null) {
            return false;
        }
        if (lastChild.getElementType() == TokenType.ERROR_ELEMENT) {
            return true;
        }
        return FormatterUtil.isIncomplete(lastChild);
    }

    public static boolean containsWhiteSpacesOnly(@Nullable ASTNode node2) {
        if (node2 == null) {
            return false;
        }
        ArrayDeque<ASTNode> queue2 = new ArrayDeque<ASTNode>();
        queue2.offer(node2);
        while (!queue2.isEmpty()) {
            TreeElement each = (TreeElement)queue2.poll();
            if (each instanceof CompositeElement && FormatterUtil.spacesOnly(each)) continue;
            if (each instanceof LeafElement && !FormatterUtil.spacesOnly(each)) {
                return false;
            }
            Collections.addAll(queue2, each.getChildren(null));
        }
        return true;
    }

    private static boolean spacesOnly(@Nullable TreeElement node2) {
        if (node2 == null) {
            return false;
        }
        if (FormatterUtil.isWhitespaceOrEmpty(node2)) {
            return true;
        }
        PsiElement psi = node2.getPsi();
        if (psi == null) {
            return false;
        }
        Language language2 = psi.getLanguage();
        return WhiteSpaceFormattingStrategyFactory.getStrategy(language2).containsWhitespacesOnly(node2);
    }

    public static void replaceInnerWhiteSpace(@NotNull String newWhiteSpaceText, @NotNull ASTNode holder, @NotNull TextRange whiteSpaceRange) {
        if (newWhiteSpaceText == null) {
            FormatterUtil.$$$reportNull$$$0(7);
        }
        if (holder == null) {
            FormatterUtil.$$$reportNull$$$0(8);
        }
        if (whiteSpaceRange == null) {
            FormatterUtil.$$$reportNull$$$0(9);
        }
        CharTable charTable = SharedImplUtil.findCharTableByTree(holder);
        StringBuilder newText = FormatterUtil.createNewLeafChars(holder, whiteSpaceRange, newWhiteSpaceText);
        LeafElement newElement = Factory.createSingleLeafElement(holder.getElementType(), newText, charTable, holder.getPsi().getManager());
        holder.getTreeParent().replaceChild(holder, (ASTNode)newElement);
    }

    public static void replaceWhiteSpace(String whiteSpace, ASTNode leafElement, IElementType whiteSpaceToken, @Nullable TextRange textRange) {
        CharTable charTable = SharedImplUtil.findCharTableByTree(leafElement);
        if (textRange != null && textRange.getStartOffset() > leafElement.getTextRange().getStartOffset() && textRange.getEndOffset() < leafElement.getTextRange().getEndOffset()) {
            FormatterUtil.replaceInnerWhiteSpace(whiteSpace, leafElement, textRange);
            return;
        }
        ASTNode treePrev = FormatterUtil.findPreviousWhiteSpace(leafElement, whiteSpaceToken);
        if (treePrev == null) {
            treePrev = FormatterUtil.getWsCandidate(leafElement);
        }
        if (treePrev != null && treePrev.getText().trim().isEmpty() && treePrev.getElementType() != whiteSpaceToken && treePrev.getTextLength() > 0 && !whiteSpace.isEmpty()) {
            LeafElement whiteSpaceElement = Factory.createSingleLeafElement(treePrev.getElementType(), whiteSpace, charTable, SharedImplUtil.getManagerByTree(leafElement));
            ASTNode treeParent = treePrev.getTreeParent();
            treeParent.replaceChild(treePrev, (ASTNode)whiteSpaceElement);
        } else {
            LeafElement whiteSpaceElement = Factory.createSingleLeafElement(whiteSpaceToken, whiteSpace, charTable, SharedImplUtil.getManagerByTree(leafElement));
            if (treePrev == null) {
                if (!whiteSpace.isEmpty()) {
                    FormatterUtil.addWhiteSpace(leafElement, whiteSpaceElement);
                }
            } else if (treePrev.getElementType() != whiteSpaceToken) {
                if (!whiteSpace.isEmpty()) {
                    FormatterUtil.addWhiteSpace(treePrev, whiteSpaceElement);
                }
            } else if (treePrev.getElementType() == whiteSpaceToken) {
                CompositeElement treeParent = (CompositeElement)treePrev.getTreeParent();
                if (!whiteSpace.isEmpty()) {
                    treeParent.replaceChild(treePrev, whiteSpaceElement);
                } else {
                    treeParent.removeChild(treePrev);
                }
                ASTNode removeCandidate = FormatterUtil.findPreviousWhiteSpace(whiteSpaceElement, whiteSpaceToken);
                while (textRange != null && removeCandidate != null && removeCandidate.getStartOffset() >= textRange.getStartOffset()) {
                    treePrev = FormatterUtil.findPreviousWhiteSpace(removeCandidate, whiteSpaceToken);
                    removeCandidate.getTreeParent().removeChild(removeCandidate);
                    removeCandidate = treePrev;
                }
            }
        }
    }

    @Nullable
    private static ASTNode findPreviousWhiteSpace(ASTNode leafElement, IElementType whiteSpaceTokenType) {
        int offset = leafElement.getTextRange().getStartOffset() - 1;
        if (offset < 0) {
            return null;
        }
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi(leafElement);
        if (psiElement == null) {
            return null;
        }
        PsiElement found = psiElement.getContainingFile().findElementAt(offset);
        if (found == null) {
            return null;
        }
        ASTNode treeElement = found.getNode();
        if (treeElement != null && treeElement.getElementType() == whiteSpaceTokenType) {
            return treeElement;
        }
        return null;
    }

    @Nullable
    private static ASTNode getWsCandidate(@Nullable ASTNode node2) {
        if (node2 == null) {
            return null;
        }
        ASTNode treePrev = node2.getTreePrev();
        if (treePrev != null) {
            if (treePrev.getElementType() == TokenType.WHITE_SPACE) {
                return treePrev;
            }
            if (treePrev.getTextLength() == 0 && FormatterUtil.isSpaceBeforeEmptyElement(treePrev)) {
                return FormatterUtil.getWsCandidate(treePrev);
            }
            return node2;
        }
        ASTNode treeParent = node2.getTreeParent();
        if (treeParent == null || treeParent.getTreeParent() == null) {
            return node2;
        }
        return FormatterUtil.getWsCandidate(treeParent);
    }

    private static boolean isSpaceBeforeEmptyElement(ASTNode node2) {
        if (node2.getElementType().isLeftBound()) {
            ASTNode parent = node2.getTreeParent();
            return parent != null && parent.getFirstChildNode() == node2;
        }
        return true;
    }

    private static StringBuilder createNewLeafChars(ASTNode leafElement, TextRange textRange, String whiteSpace) {
        TextRange elementRange = leafElement.getTextRange();
        String elementText = leafElement.getText();
        StringBuilder result2 = new StringBuilder();
        if (elementRange.getStartOffset() < textRange.getStartOffset()) {
            result2.append(elementText, 0, textRange.getStartOffset() - elementRange.getStartOffset());
        }
        result2.append(whiteSpace);
        if (elementRange.getEndOffset() > textRange.getEndOffset()) {
            result2.append(elementText.substring(textRange.getEndOffset() - elementRange.getStartOffset()));
        }
        return result2;
    }

    private static void addWhiteSpace(ASTNode treePrev, LeafElement whiteSpaceElement) {
        for (WhiteSpaceFormattingStrategy strategy : WhiteSpaceFormattingStrategyFactory.getAllStrategies()) {
            if (!strategy.addWhitespace(treePrev, whiteSpaceElement)) continue;
            return;
        }
        ASTNode treeParent = treePrev.getTreeParent();
        treeParent.addChild((ASTNode)whiteSpaceElement, treePrev);
    }

    public static void replaceLastWhiteSpace(ASTNode astNode, String whiteSpace, TextRange textRange) {
        ASTNode lastWS = TreeUtil.findLastLeaf(astNode);
        if (lastWS == null) {
            return;
        }
        if (lastWS.getElementType() != TokenType.WHITE_SPACE) {
            lastWS = null;
        }
        if (lastWS != null && !lastWS.getTextRange().equals((Object)textRange)) {
            return;
        }
        if (whiteSpace.isEmpty() && lastWS == null) {
            return;
        }
        if (lastWS != null && whiteSpace.isEmpty()) {
            lastWS.getTreeParent().removeRange(lastWS, null);
            return;
        }
        LeafElement whiteSpaceElement = ASTFactory.whitespace(whiteSpace);
        if (lastWS == null) {
            astNode.addChild((ASTNode)whiteSpaceElement, null);
        } else {
            ASTNode treeParent = lastWS.getTreeParent();
            treeParent.replaceChild(lastWS, (ASTNode)whiteSpaceElement);
        }
    }

    public static boolean isFormatterCalledExplicitly() {
        return FORMATTER_ACTION_NAMES.contains(CommandProcessor.getInstance().getCurrentCommandName());
    }

    @Nls
    public static String getReformatBeforeCommitCommandName() {
        return CodeStyleBundle.message((String)"process.reformat.code.before.commit", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesToIgnore";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newWhiteSpaceText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whiteSpaceRange";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/formatter/FormatterUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isOneOf";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPrevious";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getNext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getNextOrPrevious";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreviousLeaf";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isFollowedBy";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceInnerWhiteSpace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

