/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.concurrency.JobLauncher;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbUtil;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.search.BulkOccurrenceProcessor;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.impl.search.WordRequestInfo;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.PsiSearchRequest;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.ScopeOptimizer;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.UseScopeEnlarger;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.codeInsight.CommentUtilCore;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.text.StringSearcher;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSearchHelperImpl
implements PsiSearchHelper {
    private static final ExtensionPointName<ScopeOptimizer> USE_SCOPE_OPTIMIZER_EP_NAME = ExtensionPointName.create((String)"com.intellij.useScopeOptimizer");
    public static final Logger LOG = Logger.getInstance(PsiSearchHelperImpl.class);
    private final PsiManagerEx myManager;
    private final DumbService myDumbService;

    @NotNull
    public SearchScope getUseScope(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(0);
        }
        return PsiSearchHelperImpl.getUseScope(element2, false);
    }

    @NotNull
    public SearchScope getCodeUsageScope(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(1);
        }
        return PsiSearchHelperImpl.getUseScope(element2, true);
    }

    @NotNull
    private static SearchScope getUseScope(@NotNull PsiElement element2, boolean restrictToCodeUsageScope) {
        if (element2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(2);
        }
        SearchScope scope2 = element2.getUseScope();
        for (UseScopeEnlarger enlarger : (UseScopeEnlarger[])UseScopeEnlarger.EP_NAME.getExtensions()) {
            ProgressManager.checkCanceled();
            SearchScope additionalScope = enlarger.getAdditionalUseScope(element2);
            if (additionalScope == null) continue;
            scope2 = scope2.union(additionalScope);
        }
        scope2 = PsiSearchHelperImpl.restrictScope(scope2, (ScopeOptimizer[])USE_SCOPE_OPTIMIZER_EP_NAME.getExtensions(), element2);
        if (restrictToCodeUsageScope) {
            scope2 = PsiSearchHelperImpl.restrictScope(scope2, (ScopeOptimizer[])CODE_USAGE_SCOPE_OPTIMIZER_EP_NAME.getExtensions(), element2);
        }
        SearchScope searchScope2 = scope2;
        if (searchScope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(3);
        }
        return searchScope2;
    }

    @NotNull
    private static SearchScope restrictScope(@NotNull SearchScope baseScope, @NotNull @NotNull ScopeOptimizer @NotNull [] optimizers, @NotNull PsiElement element2) {
        SearchScope scopeToRestrict;
        if (baseScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(4);
        }
        if (optimizers == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(5);
        }
        if (element2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(6);
        }
        if ((scopeToRestrict = ScopeOptimizer.calculateOverallRestrictedUseScope((ScopeOptimizer[])optimizers, (PsiElement)element2)) != null) {
            SearchScope searchScope2 = baseScope.intersectWith(scopeToRestrict);
            if (searchScope2 == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(7);
            }
            return searchScope2;
        }
        SearchScope searchScope3 = baseScope;
        if (searchScope3 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(8);
        }
        return searchScope3;
    }

    public PsiSearchHelperImpl(@NotNull Project project) {
        if (project == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(9);
        }
        this.myManager = PsiManagerEx.getInstanceEx(project);
        this.myDumbService = DumbService.getInstance((Project)this.myManager.getProject());
    }

    public PsiElement @NotNull [] findCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope2) {
        if (identifier == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(10);
        }
        if (searchScope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(11);
        }
        List result2 = Collections.synchronizedList(new ArrayList());
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        this.processCommentsContainingIdentifier(identifier, searchScope2, (Processor<? super PsiElement>)processor2);
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result2);
        if (psiElementArray == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(12);
        }
        return psiElementArray;
    }

    public boolean processCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope2, @NotNull Processor<? super PsiElement> processor2) {
        if (identifier == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(13);
        }
        if (searchScope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(14);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(15);
        }
        TextOccurenceProcessor occurrenceProcessor2 = (element2, offsetInElement) -> {
            if (CommentUtilCore.isCommentTextElement(element2) && element2.findReferenceAt(offsetInElement) == null) {
                return processor2.process((Object)element2);
            }
            return true;
        };
        return this.processElementsWithWord(occurrenceProcessor2, searchScope2, identifier, (short)2, true);
    }

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope2, @NotNull String text2, short searchContext, boolean caseSensitive) {
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(16);
        }
        if (searchScope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(17);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(18);
        }
        return this.processElementsWithWord(processor2, searchScope2, text2, searchContext, caseSensitive, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope2));
    }

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope2, @NotNull String text2, short searchContext, boolean caseSensitive, boolean processInjectedPsi) {
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(19);
        }
        if (searchScope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(20);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(21);
        }
        EnumSet<Options> options2 = PsiSearchHelperImpl.makeOptions(caseSensitive, processInjectedPsi);
        return this.processElementsWithWord(searchScope2, text2, searchContext, options2, null, new SearchSession(), processor2);
    }

    public boolean hasIdentifierInFile(@NotNull PsiFile file2, @NotNull String name2) {
        if (file2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(22);
        }
        if (name2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(23);
        }
        PsiUtilCore.ensureValid((PsiElement)file2);
        if (file2.getVirtualFile() == null || DumbService.isDumb((Project)file2.getProject())) {
            return StringUtil.contains((CharSequence)file2.getViewProvider().getContents(), (CharSequence)name2);
        }
        GlobalSearchScope fileScope = GlobalSearchScope.fileScope((PsiFile)file2);
        IdIndexEntry key = new IdIndexEntry(name2, true);
        return !FileBasedIndex.getInstance().getContainingFiles(IdIndex.NAME, (Object)key, fileScope).isEmpty();
    }

    @NotNull
    private static EnumSet<Options> makeOptions(boolean caseSensitive, boolean processInjectedPsi) {
        EnumSet<Options> options2 = EnumSet.of(Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE);
        if (caseSensitive) {
            options2.add(Options.CASE_SENSITIVE_SEARCH);
        }
        if (processInjectedPsi) {
            options2.add(Options.PROCESS_INJECTED_PSI);
        }
        EnumSet<Options> enumSet = options2;
        if (enumSet == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(24);
        }
        return enumSet;
    }

    @NotNull
    public AsyncFuture<Boolean> processElementsWithWordAsync(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope2, @NotNull String text2, short searchContext, boolean caseSensitively) {
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(25);
        }
        if (searchScope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(26);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(27);
        }
        boolean result2 = this.processElementsWithWord(processor2, searchScope2, text2, searchContext, caseSensitively, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope2));
        AsyncFuture asyncFuture = AsyncUtil.wrapBoolean((boolean)result2);
        if (asyncFuture == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(28);
        }
        return asyncFuture;
    }

    public boolean processElementsWithWord(@NotNull SearchScope searchScope2, @NotNull String text2, short searchContext, @NotNull EnumSet<Options> options2, @Nullable String containerName, @NotNull SearchSession session2, @NotNull TextOccurenceProcessor processor2) {
        if (searchScope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(29);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(30);
        }
        if (options2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(31);
        }
        if (session2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(32);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(33);
        }
        return this.bulkProcessElementsWithWord(searchScope2, text2, searchContext, options2, containerName, session2, (scope2, offsetsInScope, searcher2) -> LowLevelSearchUtil.processElementsAtOffsets(scope2, searcher2, options2.contains((Object)Options.PROCESS_INJECTED_PSI), PsiSearchHelperImpl.getOrCreateIndicator(), offsetsInScope, processor2));
    }

    boolean bulkProcessElementsWithWord(@NotNull SearchScope searchScope2, @NotNull String text2, short searchContext, @NotNull EnumSet<Options> options2, @Nullable String containerName, @NotNull SearchSession session2, final @NotNull BulkOccurrenceProcessor processor2) {
        if (searchScope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(34);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(35);
        }
        if (options2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(36);
        }
        if (session2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(37);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(38);
        }
        if (text2.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text");
        }
        ProgressIndicator progress2 = PsiSearchHelperImpl.getOrCreateIndicator();
        if (searchScope2 instanceof GlobalSearchScope) {
            StringSearcher searcher2 = new StringSearcher(text2, options2.contains((Object)Options.CASE_SENSITIVE_SEARCH), true, searchContext == 4, options2.contains((Object)Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE));
            return this.processElementsWithTextInGlobalScope((GlobalSearchScope)searchScope2, searcher2, searchContext, options2.contains((Object)Options.CASE_SENSITIVE_SEARCH), containerName, session2, progress2, processor2);
        }
        LocalSearchScope scope2 = (LocalSearchScope)searchScope2;
        PsiElement[] scopeElements = scope2.getScope();
        final StringSearcher searcher3 = new StringSearcher(text2, options2.contains((Object)Options.CASE_SENSITIVE_SEARCH), true, searchContext == 4, options2.contains((Object)Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE));
        ReadActionProcessor<PsiElement> localProcessor = new ReadActionProcessor<PsiElement>(){

            public boolean processInReadAction(PsiElement scopeElement) {
                if (!scopeElement.isValid()) {
                    return true;
                }
                if (!scopeElement.isPhysical() || scopeElement instanceof PsiCompiledElement) {
                    scopeElement = scopeElement.getNavigationElement();
                }
                if (scopeElement instanceof PsiCompiledElement) {
                    return true;
                }
                if (scopeElement.getTextRange() == null) {
                    LOG.debug("Element " + scopeElement + " of class " + scopeElement.getClass() + " has null range");
                    return true;
                }
                return processor2.execute(scopeElement, LowLevelSearchUtil.getTextOccurrencesInScope(scopeElement, searcher3), searcher3);
            }

            public String toString() {
                return processor2.toString();
            }
        };
        return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(Arrays.asList(scopeElements), progress2, localProcessor);
    }

    @NotNull
    private static ProgressIndicator getOrCreateIndicator() {
        ProgressIndicator progress2 = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progress2 == null) {
            progress2 = new EmptyProgressIndicator();
        }
        progress2.setIndeterminate(false);
        ProgressIndicator progressIndicator = progress2;
        if (progressIndicator == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(39);
        }
        return progressIndicator;
    }

    public static boolean shouldProcessInjectedPsi(@NotNull SearchScope scope2) {
        if (scope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(40);
        }
        return !(scope2 instanceof LocalSearchScope) || !((LocalSearchScope)scope2).isIgnoreInjectedPsi();
    }

    @NotNull
    static Processor<PsiElement> localProcessor(final @NotNull StringSearcher searcher2, final @NotNull BulkOccurrenceProcessor processor2) {
        if (searcher2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(41);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(42);
        }
        return new ReadActionProcessor<PsiElement>(){

            public boolean processInReadAction(PsiElement scopeElement) {
                if (scopeElement instanceof PsiCompiledElement) {
                    return true;
                }
                return scopeElement.isValid() && processor2.execute(scopeElement, LowLevelSearchUtil.getTextOccurrencesInScope(scopeElement, searcher2), searcher2);
            }

            public String toString() {
                return processor2.toString();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processElementsWithTextInGlobalScope(@NotNull GlobalSearchScope scope2, @NotNull StringSearcher searcher2, short searchContext, boolean caseSensitively, @Nullable String containerName, @NotNull SearchSession session2, @NotNull ProgressIndicator progress2, @NotNull BulkOccurrenceProcessor processor2) {
        if (scope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(43);
        }
        if (searcher2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(44);
        }
        if (session2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(45);
        }
        if (progress2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(46);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(47);
        }
        progress2.setIndeterminate(false);
        progress2.pushState();
        try {
            progress2.setText(IndexingBundle.message((String)"psi.scanning.files.progress", (Object[])new Object[0]));
            Processor<PsiElement> localProcessor = PsiSearchHelperImpl.localProcessor(searcher2, processor2);
            List<List<VirtualFile>> priorities = this.computePriorities(scope2, searcher2, searchContext, caseSensitively, containerName, session2);
            if (priorities.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            int totalSize = priorities.stream().mapToInt(l -> l.size()).sum();
            progress2.setText(IndexingBundle.message((String)"psi.search.for.word.progress", (Object[])new Object[]{searcher2.getPattern(), totalSize}));
            int alreadyProcessedFiles = 0;
            for (List<VirtualFile> files2 : priorities) {
                if (!this.processPsiFileRoots(files2, totalSize, alreadyProcessedFiles, progress2, localProcessor)) {
                    boolean bl = false;
                    return bl;
                }
                alreadyProcessedFiles += files2.size();
            }
        }
        finally {
            progress2.popState();
        }
        return true;
    }

    @NotNull
    private List<List<VirtualFile>> computePriorities(@NotNull GlobalSearchScope scope2, @NotNull StringSearcher searcher2, short searchContext, boolean caseSensitively, @Nullable String containerName, @NotNull SearchSession session2) {
        List directories;
        if (scope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(48);
        }
        if (searcher2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(49);
        }
        if (session2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(50);
        }
        String text2 = searcher2.getPattern();
        HashSet allFiles = new HashSet();
        this.getFilesWithText(scope2, searchContext, caseSensitively, text2, allFiles);
        ArrayList<List<VirtualFile>> priorities = new ArrayList<List<VirtualFile>>();
        List targets2 = (List)ReadAction.compute(() -> ContainerUtil.filter((Collection)session2.getTargetVirtualFiles(), arg_0 -> ((GlobalSearchScope)scope2).contains(arg_0)));
        if (targets2.isEmpty()) {
            directories = Collections.emptyList();
        } else {
            priorities.add(targets2);
            allFiles.removeAll(targets2);
            directories = ContainerUtil.mapNotNull((Collection)targets2, v -> v.getParent());
            DelegatingGlobalSearchScope directoryNearTargetScope = new DelegatingGlobalSearchScope(scope2){

                public boolean contains(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return super.contains(file2) && directories.contains(file2.getParent());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/search/PsiSearchHelperImpl$3", "contains"));
                }
            };
            List directoryNearTargetFiles = (List)ReadAction.compute(() -> PsiSearchHelperImpl.lambda$computePriorities$6(allFiles, (GlobalSearchScope)directoryNearTargetScope, targets2));
            if (!directoryNearTargetFiles.isEmpty()) {
                priorities.add(directoryNearTargetFiles);
                allFiles.removeAll(directoryNearTargetFiles);
            }
        }
        if (containerName != null) {
            HashSet intersectionWithContainerFiles = new HashSet();
            this.getFilesWithText(scope2, searchContext, caseSensitively, text2 + " " + containerName, intersectionWithContainerFiles);
            intersectionWithContainerFiles.removeAll(targets2);
            intersectionWithContainerFiles.removeAll(directories);
            if (!intersectionWithContainerFiles.isEmpty()) {
                priorities.add(new ArrayList(intersectionWithContainerFiles));
                allFiles.removeAll(intersectionWithContainerFiles);
            }
        }
        if (!allFiles.isEmpty()) {
            priorities.add(new ArrayList(allFiles));
        }
        ArrayList<List<VirtualFile>> arrayList = priorities;
        if (arrayList == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(51);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processPsiFileRoots(@NotNull List<? extends VirtualFile> files2, int totalSize, int alreadyProcessedFiles, @NotNull ProgressIndicator progress2, @NotNull Processor<? super PsiFile> localProcessor) {
        if (files2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(52);
        }
        if (progress2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(53);
        }
        if (localProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(54);
        }
        this.myManager.startBatchFilesProcessingMode();
        try {
            AtomicInteger counter = new AtomicInteger(alreadyProcessedFiles);
            AtomicBoolean stopped = new AtomicBoolean(false);
            ProgressIndicator originalIndicator = ProgressWrapper.unwrapAll(progress2);
            boolean bl = PsiSearchHelperImpl.processFilesConcurrentlyDespiteWriteActions(this.myManager.getProject(), files2, progress2, stopped, (Processor<? super VirtualFile>)((Processor)vfile -> {
                TooManyUsagesStatus.getFrom(originalIndicator).pauseProcessingIfTooManyUsages();
                try {
                    this.processVirtualFile((VirtualFile)vfile, stopped, localProcessor);
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error("Error during processing of: " + vfile.getName(), e);
                    throw e;
                }
                if (progress2.isRunning()) {
                    double fraction = (double)counter.incrementAndGet() / (double)totalSize;
                    progress2.setFraction(fraction);
                }
                return !stopped.get();
            }));
            return bl;
        }
        finally {
            this.myManager.finishBatchFilesProcessingMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processFilesConcurrentlyDespiteWriteActions(@NotNull Project project, @NotNull List<? extends VirtualFile> files2, @NotNull ProgressIndicator progress2, @NotNull AtomicBoolean stopped, @NotNull Processor<? super VirtualFile> localProcessor) {
        ApplicationEx app2;
        if (project == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(55);
        }
        if (files2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(56);
        }
        if (progress2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(57);
        }
        if (stopped == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(58);
        }
        if (localProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(59);
        }
        if (!(app2 = (ApplicationEx)ApplicationManager.getApplication()).isDispatchThread()) {
            CoreProgressManager.assertUnderProgress(progress2);
        }
        List<? extends VirtualFile> processedFiles = Collections.synchronizedList(new ArrayList(files2.size()));
        while (true) {
            ProgressManager.checkCanceled();
            final SensitiveProgressWrapper wrapper2 = new SensitiveProgressWrapper(progress2);
            ApplicationListener listener2 = new ApplicationListener(){

                public void beforeWriteActionStart(@NotNull Object action2) {
                    if (action2 == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    wrapper2.cancel();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/psi/impl/search/PsiSearchHelperImpl$4", "beforeWriteActionStart"));
                }
            };
            processedFiles.clear();
            Disposable disposable2 = Disposer.newDisposable();
            app2.addApplicationListener(listener2, disposable2);
            boolean processorCanceled = false;
            try {
                if (app2.isWriteAccessAllowed() || app2.isReadAccessAllowed() && app2.isWriteActionPending()) {
                    boolean bl = processorCanceled = !ContainerUtil.process(files2, localProcessor);
                    if (processorCanceled) {
                        stopped.set(true);
                    }
                    processedFiles.addAll(files2);
                } else if (app2.isWriteActionPending()) {
                } else {
                    AtomicBoolean someTaskFailed = new AtomicBoolean();
                    Processor processor2 = vfile -> {
                        ProgressManager.checkCanceled();
                        if (someTaskFailed.get()) {
                            return false;
                        }
                        try {
                            app2.executeByImpatientReader(() -> {
                                if (localProcessor.process(vfile)) {
                                    processedFiles.add((VirtualFile)vfile);
                                } else {
                                    stopped.set(true);
                                }
                            });
                        }
                        catch (ProcessCanceledException e) {
                            someTaskFailed.set(true);
                            throw e;
                        }
                        return !stopped.get();
                    };
                    try {
                        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(files2, wrapper2, processor2);
                        processorCanceled = stopped.get();
                    }
                    catch (ProcessCanceledException e) {
                        progress2.checkCanceled();
                    }
                }
            }
            finally {
                Disposer.dispose((Disposable)disposable2);
            }
            if (processorCanceled) {
                return false;
            }
            if (processedFiles.size() == files2.size()) break;
            DumbService.getInstance((Project)project).runReadActionInSmartMode(EmptyRunnable.getInstance());
            HashSet<? extends VirtualFile> t = new HashSet<VirtualFile>(files2);
            List<? extends VirtualFile> list2 = processedFiles;
            synchronized (list2) {
                t.removeAll(processedFiles);
            }
            files2 = new ArrayList<VirtualFile>(t);
        }
        return true;
    }

    private void processVirtualFile(@NotNull VirtualFile vfile, @NotNull AtomicBoolean stopped, @NotNull Processor<? super PsiFile> localProcessor) throws ApplicationUtil.CannotRunReadActionException {
        if (vfile == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(60);
        }
        if (stopped == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(61);
        }
        if (localProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(62);
        }
        if (!vfile.isDirectory() && !vfile.getFileType().isBinary()) {
            try {
                vfile.contentsToByteArray();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!ApplicationManagerEx.getApplicationEx().tryRunReadAction(() -> {
            PsiFile file2;
            PsiFile psiFile = file2 = vfile.isValid() ? this.myManager.findFile(vfile) : null;
            if (file2 != null && !(file2 instanceof PsiBinaryFile)) {
                Project project = this.myManager.getProject();
                if (project.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                if (!DumbUtil.getInstance((Project)project).mayUseIndices()) {
                    throw ApplicationUtil.CannotRunReadActionException.create();
                }
                FileViewProvider provider2 = file2.getViewProvider();
                List psiRoots = provider2.getAllFiles();
                HashSet<PsiFile> processed2 = new HashSet<PsiFile>(psiRoots.size() * 2, 0.5f);
                for (PsiFile psiRoot : psiRoots) {
                    ProgressManager.checkCanceled();
                    assert (psiRoot != null) : "One of the roots of file " + file2 + " is null. All roots: " + psiRoots + "; ViewProvider: " + provider2 + "; Virtual file: " + provider2.getVirtualFile();
                    if (!processed2.add(psiRoot) || !psiRoot.isValid() || localProcessor.process((Object)psiRoot)) continue;
                    stopped.set(true);
                    break;
                }
            }
        })) {
            throw ApplicationUtil.CannotRunReadActionException.create();
        }
    }

    private void getFilesWithText(@NotNull GlobalSearchScope scope2, short searchContext, boolean caseSensitively, @NotNull String text2, @NotNull Collection<? super VirtualFile> result2) {
        if (scope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(63);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(64);
        }
        if (result2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(65);
        }
        this.processCandidateFilesForText(scope2, searchContext, caseSensitively, text2, (Processor<? super VirtualFile>)Processors.cancelableCollectProcessor(result2));
    }

    public boolean processCandidateFilesForText(@NotNull GlobalSearchScope scope2, short searchContext, boolean caseSensitively, boolean useOnlyWordHashToSearch, @NotNull String text2, @NotNull Processor<? super VirtualFile> processor2) {
        if (scope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(66);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(67);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(68);
        }
        return PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope2, processor2, TextIndexQuery.fromWord(text2, caseSensitively, useOnlyWordHashToSearch, searchContext));
    }

    public boolean processCandidateFilesForText(@NotNull GlobalSearchScope scope2, short searchContext, boolean caseSensitively, @NotNull String text2, @NotNull Processor<? super VirtualFile> processor2) {
        if (scope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(69);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(70);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(71);
        }
        return this.processCandidateFilesForText(scope2, searchContext, caseSensitively, false, text2, processor2);
    }

    public PsiFile @NotNull [] findFilesWithPlainTextWords(@NotNull String word) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(72);
        }
        PsiFile[] psiFileArray = CacheManager.getInstance((Project)this.myManager.getProject()).getFilesWithWord(word, (short)16, GlobalSearchScope.projectScope((Project)this.myManager.getProject()), true);
        if (psiFileArray == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(73);
        }
        return psiFileArray;
    }

    public boolean processUsagesInNonJavaFiles(@NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor2, @NotNull GlobalSearchScope searchScope2) {
        if (qName == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(74);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(75);
        }
        if (searchScope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(76);
        }
        return this.processUsagesInNonJavaFiles(null, qName, processor2, searchScope2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processUsagesInNonJavaFiles(@Nullable PsiElement originalElement, @NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor2, @NotNull GlobalSearchScope initialScope) {
        int dollarIndex;
        if (qName == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(77);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(78);
        }
        if (initialScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(79);
        }
        if (qName.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text. Element: " + originalElement + "; " + (originalElement == null ? null : originalElement.getClass()));
        }
        ProgressIndicator progress2 = PsiSearchHelperImpl.getOrCreateIndicator();
        int dotIndex = qName.lastIndexOf(46);
        int maxIndex = Math.max(dotIndex, dollarIndex = qName.lastIndexOf(36));
        String wordToSearch = maxIndex >= 0 ? qName.substring(maxIndex + 1) : qName;
        GlobalSearchScope theSearchScope = (GlobalSearchScope)ReadAction.compute(() -> {
            if (originalElement != null && this.myManager.isInProject(originalElement) && initialScope.isSearchInLibraries()) {
                return initialScope.intersectWith(GlobalSearchScope.projectScope((Project)this.myManager.getProject()));
            }
            return initialScope;
        });
        PsiFile[] files2 = (PsiFile[])this.myDumbService.runReadActionInSmartMode(() -> CacheManager.getInstance((Project)this.myManager.getProject()).getFilesWithWord(wordToSearch, (short)16, theSearchScope, true));
        StringSearcher searcher2 = new StringSearcher(qName, true, true, false);
        progress2.pushState();
        Ref stopped = Ref.create((Object)Boolean.FALSE);
        try {
            progress2.setText(IndexingBundle.message((String)"psi.search.in.non.java.files.progress", (Object[])new Object[0]));
            SearchScope useScope = originalElement == null ? null : (SearchScope)this.myDumbService.runReadActionInSmartMode(() -> this.getUseScope(originalElement));
            int patternLength = qName.length();
            for (int i2 = 0; i2 < files2.length; ++i2) {
                ProgressManager.checkCanceled();
                PsiFile psiFile = files2[i2];
                if (psiFile instanceof PsiBinaryFile) continue;
                CharSequence text2 = (CharSequence)ReadAction.compute(() -> psiFile.getViewProvider().getContents());
                LowLevelSearchUtil.processTexts(text2, 0, text2.length(), searcher2, index2 -> {
                    boolean isReferenceOK = (Boolean)this.myDumbService.runReadActionInSmartMode(() -> {
                        PsiReference referenceAt = psiFile.findReferenceAt(index2);
                        return referenceAt == null || useScope == null || !PsiSearchScopeUtil.isInScope((SearchScope)useScope.intersectWith((SearchScope)initialScope), (PsiElement)psiFile);
                    });
                    if (isReferenceOK && !processor2.process(psiFile, index2, index2 + patternLength)) {
                        stopped.set((Object)Boolean.TRUE);
                        return false;
                    }
                    return true;
                });
                if (((Boolean)stopped.get()).booleanValue()) {
                    break;
                }
                progress2.setFraction((double)(i2 + 1) / (double)files2.length);
            }
        }
        finally {
            progress2.popState();
        }
        return (Boolean)stopped.get() == false;
    }

    public boolean processAllFilesWithWord(@NotNull String word, @NotNull GlobalSearchScope scope2, @NotNull Processor<? super PsiFile> processor2, boolean caseSensitively) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(80);
        }
        if (scope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(81);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(82);
        }
        return CacheManager.getInstance((Project)this.myManager.getProject()).processFilesWithWord(processor2, word, (short)1, scope2, caseSensitively);
    }

    public boolean processAllFilesWithWordInText(@NotNull String word, @NotNull GlobalSearchScope scope2, @NotNull Processor<? super PsiFile> processor2, boolean caseSensitively) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(83);
        }
        if (scope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(84);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(85);
        }
        return CacheManager.getInstance((Project)this.myManager.getProject()).processFilesWithWord(processor2, word, (short)16, scope2, caseSensitively);
    }

    public boolean processAllFilesWithWordInComments(@NotNull String word, @NotNull GlobalSearchScope scope2, @NotNull Processor<? super PsiFile> processor2) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(86);
        }
        if (scope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(87);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(88);
        }
        return CacheManager.getInstance((Project)this.myManager.getProject()).processFilesWithWord(processor2, word, (short)2, scope2, true);
    }

    public boolean processAllFilesWithWordInLiterals(@NotNull String word, @NotNull GlobalSearchScope scope2, @NotNull Processor<? super PsiFile> processor2) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(89);
        }
        if (scope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(90);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(91);
        }
        return CacheManager.getInstance((Project)this.myManager.getProject()).processFilesWithWord(processor2, word, (short)4, scope2, true);
    }

    public boolean processRequests(@NotNull SearchRequestCollector collector, @NotNull Processor<? super PsiReference> processor2) {
        QueryRequestsRunResult result2;
        if (collector == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(92);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(93);
        }
        HashMap<SearchRequestCollector, Processor<? super PsiReference>> collectors = new HashMap<SearchRequestCollector, Processor<? super PsiReference>>();
        collectors.put(collector, processor2);
        ProgressIndicator progress2 = PsiSearchHelperImpl.getOrCreateIndicator();
        if (PsiSearchHelperImpl.appendCollectorsFromQueryRequests(progress2, collectors) == QueryRequestsRunResult.STOPPED) {
            return false;
        }
        do {
            HashMap<TextIndexQuery, Collection<RequestWithProcessor>> globals = new HashMap<TextIndexQuery, Collection<RequestWithProcessor>>();
            ArrayList customs = new ArrayList();
            LinkedHashSet<RequestWithProcessor> locals = new LinkedHashSet<RequestWithProcessor>();
            HashMap<RequestWithProcessor, Processor<? super PsiElement>> localProcessors = new HashMap<RequestWithProcessor, Processor<? super PsiElement>>();
            PsiSearchHelperImpl.distributePrimitives(collectors, locals, globals, customs, localProcessors);
            if (!this.processGlobalRequestsOptimized(globals, progress2, localProcessors)) {
                return false;
            }
            for (RequestWithProcessor local : locals) {
                progress2.checkCanceled();
                if (this.processSingleRequest(local.request, local.refProcessor)) continue;
                return false;
            }
            for (Computable custom : customs) {
                progress2.checkCanceled();
                if (((Boolean)custom.compute()).booleanValue()) continue;
                return false;
            }
            result2 = PsiSearchHelperImpl.appendCollectorsFromQueryRequests(progress2, collectors);
            if (result2 != QueryRequestsRunResult.STOPPED) continue;
            return false;
        } while (result2 != QueryRequestsRunResult.UNCHANGED);
        return true;
    }

    @NotNull
    public AsyncFuture<Boolean> processRequestsAsync(@NotNull SearchRequestCollector collector, @NotNull Processor<? super PsiReference> processor2) {
        if (collector == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(94);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(95);
        }
        AsyncFuture asyncFuture = AsyncUtil.wrapBoolean((boolean)this.processRequests(collector, processor2));
        if (asyncFuture == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(96);
        }
        return asyncFuture;
    }

    @NotNull
    private static QueryRequestsRunResult appendCollectorsFromQueryRequests(@NotNull ProgressIndicator progress2, @NotNull Map<SearchRequestCollector, Processor<? super PsiReference>> collectors) {
        if (progress2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(97);
        }
        if (collectors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(98);
        }
        boolean changed2 = false;
        LinkedList<SearchRequestCollector> queue2 = new LinkedList<SearchRequestCollector>(collectors.keySet());
        while (!queue2.isEmpty()) {
            progress2.checkCanceled();
            SearchRequestCollector each = (SearchRequestCollector)queue2.removeFirst();
            for (QuerySearchRequest request2 : each.takeQueryRequests()) {
                progress2.checkCanceled();
                if (!request2.runQuery()) {
                    QueryRequestsRunResult queryRequestsRunResult = QueryRequestsRunResult.STOPPED;
                    if (queryRequestsRunResult == null) {
                        PsiSearchHelperImpl.$$$reportNull$$$0(99);
                    }
                    return queryRequestsRunResult;
                }
                assert (!collectors.containsKey(request2.collector) || collectors.get(request2.collector) == request2.processor);
                collectors.put(request2.collector, (Processor<? super PsiReference>)request2.processor);
                queue2.addLast(request2.collector);
                changed2 = true;
            }
        }
        QueryRequestsRunResult queryRequestsRunResult = changed2 ? QueryRequestsRunResult.CHANGED : QueryRequestsRunResult.UNCHANGED;
        if (queryRequestsRunResult == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(100);
        }
        return queryRequestsRunResult;
    }

    private boolean processGlobalRequestsOptimized(@NotNull Map<TextIndexQuery, Collection<RequestWithProcessor>> singles, @NotNull ProgressIndicator progress2, @NotNull Map<RequestWithProcessor, Processor<? super PsiElement>> localProcessors) {
        Collection<RequestWithProcessor> requests2;
        if (singles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(101);
        }
        if (progress2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(102);
        }
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(103);
        }
        if (singles.isEmpty()) {
            return true;
        }
        if (singles.size() == 1 && (requests2 = singles.values().iterator().next()).size() == 1) {
            RequestWithProcessor theOnly = requests2.iterator().next();
            return this.processSingleRequest(theOnly.request, theOnly.refProcessor);
        }
        return this.processGlobalRequests(singles, progress2, localProcessors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends WordRequestInfo> boolean processGlobalRequests(@NotNull Map<TextIndexQuery, Collection<T>> singles, @NotNull ProgressIndicator progress2, @NotNull Map<T, Processor<? super PsiElement>> localProcessors) {
        boolean result2;
        if (singles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(104);
        }
        if (progress2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(105);
        }
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(106);
        }
        progress2.pushState();
        progress2.setText(IndexingBundle.message((String)"psi.scanning.files.progress", (Object[])new Object[0]));
        try {
            HashMap<VirtualFile, Collection<T>> targetFiles = new HashMap<VirtualFile, Collection<T>>();
            HashMap<VirtualFile, Collection<T>> nearDirectoryFiles = new HashMap<VirtualFile, Collection<T>>();
            HashMap<VirtualFile, Collection<T>> intersectionCandidateFiles = new HashMap<VirtualFile, Collection<T>>();
            HashMap<VirtualFile, Collection<T>> restCandidateFiles = new HashMap<VirtualFile, Collection<T>>();
            int totalSize = this.collectFiles(singles, targetFiles, nearDirectoryFiles, intersectionCandidateFiles, restCandidateFiles);
            if (totalSize == 0) {
                boolean bl = true;
                return bl;
            }
            TreeSet<String> allWords = new TreeSet<String>();
            for (WordRequestInfo singleRequest : localProcessors.keySet()) {
                ProgressManager.checkCanceled();
                allWords.add(singleRequest.getWord());
            }
            progress2.setText(IndexingBundle.message((String)"psi.search.for.word.progress", (Object[])new Object[]{PsiSearchHelperImpl.concat(allWords), totalSize}));
            int alreadyProcessedFiles = 0;
            if (!targetFiles.isEmpty()) {
                result2 = this.processCandidates(localProcessors, targetFiles, progress2, totalSize, alreadyProcessedFiles);
                if (!result2) {
                    boolean bl = false;
                    return bl;
                }
                alreadyProcessedFiles += targetFiles.size();
            }
            if (!nearDirectoryFiles.isEmpty()) {
                result2 = this.processCandidates(localProcessors, nearDirectoryFiles, progress2, totalSize, alreadyProcessedFiles);
                if (!result2) {
                    boolean bl = false;
                    return bl;
                }
                alreadyProcessedFiles += nearDirectoryFiles.size();
            }
            if (!intersectionCandidateFiles.isEmpty()) {
                result2 = this.processCandidates(localProcessors, intersectionCandidateFiles, progress2, totalSize, alreadyProcessedFiles);
                if (!result2) {
                    boolean bl = false;
                    return bl;
                }
                alreadyProcessedFiles += intersectionCandidateFiles.size();
            }
            result2 = this.processCandidates(localProcessors, restCandidateFiles, progress2, totalSize, alreadyProcessedFiles);
        }
        finally {
            progress2.popState();
        }
        return result2;
    }

    private <T> boolean processCandidates(@NotNull Map<T, Processor<? super PsiElement>> localProcessors, @NotNull Map<VirtualFile, Collection<T>> candidateFiles, @NotNull ProgressIndicator progress2, int totalSize, int alreadyProcessedFiles) {
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(107);
        }
        if (candidateFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(108);
        }
        if (progress2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(109);
        }
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>(candidateFiles.keySet());
        return this.processPsiFileRoots(files2, totalSize, alreadyProcessedFiles, progress2, (Processor<? super PsiFile>)((Processor)psiRoot -> {
            VirtualFile vfile = psiRoot.getVirtualFile();
            for (Object singleRequest : (Collection)candidateFiles.get(vfile)) {
                ProgressManager.checkCanceled();
                Processor localProcessor = (Processor)localProcessors.get(singleRequest);
                if (localProcessor.process(psiRoot)) continue;
                return false;
            }
            return true;
        }));
    }

    @NotNull
    private static CharSequence concat(@NotNull Set<String> allWords) {
        if (allWords == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(110);
        }
        StringBuilder result2 = new StringBuilder(50);
        for (String string : allWords) {
            ProgressManager.checkCanceled();
            if (string.isEmpty()) continue;
            if (result2.length() > 50) {
                result2.append("...");
                break;
            }
            if (result2.length() != 0) {
                result2.append(", ");
            }
            result2.append(string);
        }
        StringBuilder stringBuilder = result2;
        if (stringBuilder == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(111);
        }
        return stringBuilder;
    }

    @NotNull
    private static BulkOccurrenceProcessor adaptProcessor(@NotNull PsiSearchRequest singleRequest, final @NotNull Processor<? super PsiReference> consumer2) {
        SearchScope searchScope2;
        if (singleRequest == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(112);
        }
        if (consumer2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(113);
        }
        final boolean ignoreInjectedPsi = (searchScope2 = singleRequest.searchScope) instanceof LocalSearchScope && ((LocalSearchScope)searchScope2).isIgnoreInjectedPsi();
        final RequestResultProcessor wrapped = singleRequest.processor;
        return new BulkOccurrenceProcessor(){

            @Override
            public boolean execute(@NotNull PsiElement scope2, int @NotNull [] offsetsInScope, @NotNull StringSearcher searcher2) {
                if (scope2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (searcher2 == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (offsetsInScope == null) {
                    5.$$$reportNull$$$0(2);
                }
                ProgressManager.checkCanceled();
                if (wrapped instanceof RequestResultProcessor.BulkResultProcessor) {
                    return ((RequestResultProcessor.BulkResultProcessor)wrapped).processTextOccurrences(scope2, offsetsInScope, consumer2);
                }
                return LowLevelSearchUtil.processElementsAtOffsets(scope2, searcher2, !ignoreInjectedPsi, PsiSearchHelperImpl.getOrCreateIndicator(), offsetsInScope, (element2, offsetInElement) -> {
                    if (ignoreInjectedPsi && element2 instanceof PsiLanguageInjectionHost) {
                        return true;
                    }
                    return wrapped.processTextOccurrence(element2, offsetInElement, consumer2);
                });
            }

            public String toString() {
                return consumer2.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "scope";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "searcher";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "offsetsInScope";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$5";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private <T extends WordRequestInfo> int collectFiles(@NotNull Map<TextIndexQuery, Collection<T>> singles, @NotNull Map<VirtualFile, Collection<T>> targetFiles, @NotNull Map<VirtualFile, Collection<T>> nearDirectoryFiles, @NotNull Map<VirtualFile, Collection<T>> containerNameFiles, @NotNull Map<VirtualFile, Collection<T>> restFiles) {
        if (singles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(114);
        }
        if (targetFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(115);
        }
        if (nearDirectoryFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(116);
        }
        if (containerNameFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(117);
        }
        if (restFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(118);
        }
        for (Map.Entry<TextIndexQuery, Collection<T>> entry2 : singles.entrySet()) {
            ProgressManager.checkCanceled();
            TextIndexQuery key = entry2.getKey();
            if (key.isEmpty()) continue;
            Collection processors = entry2.getValue();
            GlobalSearchScope commonScope = PsiSearchHelperImpl.uniteScopes(processors);
            Set thisTargetFiles = (Set)ReadAction.compute(() -> processors.stream().flatMap(p -> p.getSearchSession().getTargetVirtualFiles().stream()).filter(arg_0 -> ((GlobalSearchScope)commonScope).contains(arg_0)).collect(Collectors.toSet()));
            Set thisTargetDirectories = ContainerUtil.map2SetNotNull((Collection)thisTargetFiles, f -> f.getParent());
            Set<VirtualFile> intersectionWithContainerNameFiles = this.intersectionWithContainerNameFiles(commonScope, processors, key);
            ArrayList allFilesForKeys = new ArrayList();
            PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, (Processor<? super VirtualFile>)Processors.cancelableCollectProcessor(allFilesForKeys), key);
            Object2IntOpenHashMap file2Mask = new Object2IntOpenHashMap();
            file2Mask.defaultReturnValue(-1);
            IntRef maskRef = new IntRef();
            for (VirtualFile file2 : allFilesForKeys) {
                ProgressManager.checkCanceled();
                for (IdIndexEntry indexEntry : key.myIdIndexEntries) {
                    ProgressManager.checkCanceled();
                    maskRef.set(0);
                    this.myDumbService.runReadActionInSmartMode(() -> FileBasedIndex.getInstance().processValues(IdIndex.NAME, (Object)indexEntry, file2, (__, value2) -> {
                        maskRef.set(value2.intValue());
                        return true;
                    }, commonScope));
                    int oldMask = file2Mask.getOrDefault((Object)file2, 255);
                    file2Mask.put((Object)file2, oldMask & maskRef.get());
                }
            }
            for (Object2IntMap.Entry fileEntry : file2Mask.object2IntEntrySet()) {
                VirtualFile file3 = (VirtualFile)fileEntry.getKey();
                int mask = fileEntry.getIntValue();
                this.myDumbService.runReadActionInSmartMode(() -> {
                    Map result2 = thisTargetFiles.contains(file3) ? targetFiles : (thisTargetDirectories.contains(file3.getParent()) ? nearDirectoryFiles : (intersectionWithContainerNameFiles != null && intersectionWithContainerNameFiles.contains(file3) ? containerNameFiles : restFiles));
                    for (WordRequestInfo single : processors) {
                        ProgressManager.checkCanceled();
                        if ((mask & single.getSearchContext()) == 0 || !single.getSearchScope().contains(file3)) continue;
                        result2.computeIfAbsent(file3, ___ -> new SmartList()).add(single);
                    }
                });
            }
        }
        return targetFiles.size() + nearDirectoryFiles.size() + containerNameFiles.size() + restFiles.size();
    }

    @Nullable(value="null means we did not find common container files")
    private @Nullable(value="null means we did not find common container files") Set<VirtualFile> intersectionWithContainerNameFiles(@NotNull GlobalSearchScope commonScope, @NotNull Collection<? extends WordRequestInfo> data2, @NotNull TextIndexQuery query2) {
        if (commonScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(119);
        }
        if (data2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(120);
        }
        if (query2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(121);
        }
        String commonName = null;
        short searchContext = 0;
        boolean caseSensitive = true;
        for (WordRequestInfo wordRequestInfo : data2) {
            ProgressManager.checkCanceled();
            String containerName = wordRequestInfo.getContainerName();
            if (containerName == null) continue;
            if (commonName == null) {
                commonName = containerName;
                searchContext = wordRequestInfo.getSearchContext();
                caseSensitive = wordRequestInfo.isCaseSensitive();
                continue;
            }
            if (commonName.equals(containerName)) {
                searchContext = (short)(searchContext | wordRequestInfo.getSearchContext());
                caseSensitive &= wordRequestInfo.isCaseSensitive();
                continue;
            }
            return null;
        }
        if (commonName == null) {
            return null;
        }
        TextIndexQuery commonNameQuery = TextIndexQuery.fromWord(commonName, caseSensitive, searchContext);
        HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>();
        Processor processor2 = Processors.cancelableCollectProcessor(hashSet);
        PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, (Processor<? super VirtualFile>)processor2, query2, commonNameQuery);
        return hashSet;
    }

    @NotNull
    private static Condition<Integer> matchContextCondition(short searchContext) {
        Condition condition = context2 -> (context2 & searchContext) != 0;
        if (condition == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(122);
        }
        return condition;
    }

    @NotNull
    private static GlobalSearchScope uniteScopes(@NotNull Collection<? extends WordRequestInfo> requests2) {
        if (requests2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(123);
        }
        Set scopes = ContainerUtil.map2LinkedSet(requests2, r -> (GlobalSearchScope)r.getSearchScope());
        GlobalSearchScope globalSearchScope = GlobalSearchScope.union((GlobalSearchScope[])scopes.toArray(GlobalSearchScope.EMPTY_ARRAY));
        if (globalSearchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(124);
        }
        return globalSearchScope;
    }

    private static void distributePrimitives(@NotNull Map<SearchRequestCollector, Processor<? super PsiReference>> collectors, @NotNull Set<RequestWithProcessor> locals, @NotNull Map<TextIndexQuery, Collection<RequestWithProcessor>> globals, @NotNull List<? super Computable<Boolean>> customs, @NotNull Map<RequestWithProcessor, Processor<? super PsiElement>> localProcessors) {
        if (collectors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(125);
        }
        if (locals == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(126);
        }
        if (globals == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(127);
        }
        if (customs == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(128);
        }
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(129);
        }
        for (Map.Entry<SearchRequestCollector, Processor<? super PsiReference>> entry2 : collectors.entrySet()) {
            ProgressManager.checkCanceled();
            Processor<? super PsiReference> processor2 = entry2.getValue();
            SearchRequestCollector collector = entry2.getKey();
            for (PsiSearchRequest primitive : collector.takeSearchRequests()) {
                ProgressManager.checkCanceled();
                SearchScope scope2 = primitive.searchScope;
                if (scope2 instanceof LocalSearchScope) {
                    PsiSearchHelperImpl.registerRequest(locals, primitive, processor2);
                    continue;
                }
                TextIndexQuery key = TextIndexQuery.fromWord(primitive.word, primitive.caseSensitive, null);
                PsiSearchHelperImpl.registerRequest(globals.computeIfAbsent(key, __ -> new SmartList()), primitive, processor2);
            }
            for (Processor customAction : collector.takeCustomSearchActions()) {
                ProgressManager.checkCanceled();
                customs.add((Computable<Boolean>)((Computable)() -> customAction.process((Object)processor2)));
            }
        }
        for (Map.Entry<Object, Object> entry3 : globals.entrySet()) {
            ProgressManager.checkCanceled();
            for (RequestWithProcessor singleRequest : (Collection)entry3.getValue()) {
                ProgressManager.checkCanceled();
                PsiSearchRequest primitive = singleRequest.request;
                StringSearcher searcher2 = new StringSearcher(primitive.word, primitive.caseSensitive, true, false);
                BulkOccurrenceProcessor adapted = PsiSearchHelperImpl.adaptProcessor(primitive, singleRequest.refProcessor);
                Processor<PsiElement> localProcessor = PsiSearchHelperImpl.localProcessor(searcher2, adapted);
                assert (!localProcessors.containsKey(singleRequest) || localProcessors.get(singleRequest) == localProcessor);
                localProcessors.put(singleRequest, localProcessor);
            }
        }
    }

    private static void registerRequest(@NotNull Collection<RequestWithProcessor> collection, @NotNull PsiSearchRequest primitive, @NotNull Processor<? super PsiReference> processor2) {
        if (collection == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(130);
        }
        if (primitive == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(131);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(132);
        }
        RequestWithProcessor singleRequest = new RequestWithProcessor(primitive, processor2);
        for (RequestWithProcessor existing : collection) {
            ProgressManager.checkCanceled();
            if (!existing.uniteWith(singleRequest)) continue;
            return;
        }
        collection.add(singleRequest);
    }

    private boolean processSingleRequest(@NotNull PsiSearchRequest single, @NotNull Processor<? super PsiReference> consumer2) {
        if (single == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(133);
        }
        if (consumer2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(134);
        }
        EnumSet<Options> options2 = PsiSearchHelperImpl.makeOptions(single.caseSensitive, PsiSearchHelperImpl.shouldProcessInjectedPsi(single.searchScope));
        return this.bulkProcessElementsWithWord(single.searchScope, single.word, single.searchContext, options2, single.containerName, single.getSearchSession(), PsiSearchHelperImpl.adaptProcessor(single, consumer2));
    }

    @NotNull
    public PsiSearchHelper.SearchCostResult isCheapEnoughToSearch(@NotNull String name2, @NotNull GlobalSearchScope scope2, final @Nullable PsiFile fileToIgnoreOccurrencesIn, @Nullable ProgressIndicator progress2) {
        if (name2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(135);
        }
        if (scope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(136);
        }
        if (!((Boolean)ReadAction.compute(() -> scope2.getUnloadedModulesBelongingToScope().isEmpty())).booleanValue()) {
            PsiSearchHelper.SearchCostResult searchCostResult = PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
            if (searchCostResult == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(137);
            }
            return searchCostResult;
        }
        final AtomicInteger filesCount = new AtomicInteger();
        final AtomicLong filesSizeToProcess = new AtomicLong();
        Processor<VirtualFile> processor2 = new Processor<VirtualFile>(){
            private final VirtualFile virtualFileToIgnoreOccurrencesIn;
            private final int maxFilesToProcess;
            private final int maxFilesSizeToProcess;
            {
                this.virtualFileToIgnoreOccurrencesIn = fileToIgnoreOccurrencesIn == null ? null : fileToIgnoreOccurrencesIn.getVirtualFile();
                this.maxFilesToProcess = Registry.intValue((String)"ide.unused.symbol.calculation.maxFilesToSearchUsagesIn", (int)10);
                this.maxFilesSizeToProcess = Registry.intValue((String)"ide.unused.symbol.calculation.maxFilesSizeToSearchUsagesIn", (int)524288);
            }

            public boolean process(VirtualFile file2) {
                ProgressManager.checkCanceled();
                if (Comparing.equal((Object)file2, (Object)this.virtualFileToIgnoreOccurrencesIn)) {
                    return true;
                }
                int currentFilesCount = filesCount.incrementAndGet();
                long accumulatedFileSizeToProcess = filesSizeToProcess.addAndGet(file2.isDirectory() ? 0L : file2.getLength());
                return currentFilesCount < this.maxFilesToProcess && accumulatedFileSizeToProcess < (long)this.maxFilesSizeToProcess;
            }
        };
        TextIndexQuery query2 = TextIndexQuery.fromWord(name2, true, null);
        boolean cheap = PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope2, (Processor<? super VirtualFile>)processor2, query2);
        if (!cheap) {
            PsiSearchHelper.SearchCostResult searchCostResult = PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
            if (searchCostResult == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(138);
            }
            return searchCostResult;
        }
        PsiSearchHelper.SearchCostResult searchCostResult = filesCount.get() == 0 ? PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES : PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES;
        if (searchCostResult == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(139);
        }
        return searchCostResult;
    }

    private static boolean processFilesContainingAllKeys(@NotNull Project project, @NotNull GlobalSearchScope scope2, @NotNull Processor<? super VirtualFile> processor2, TextIndexQuery ... textIndexQueries) {
        if (project == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(140);
        }
        if (scope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(141);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(142);
        }
        if (textIndexQueries == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(143);
        }
        if (ContainerUtil.find((Object[])textIndexQueries, query2 -> !query2.isEmpty()) == null) {
            return true;
        }
        if (LOG.isTraceEnabled()) {
            List words = ContainerUtil.map((Object[])textIndexQueries, q -> StringUtil.join(q.getInitialWords(), (String)" "));
            LOG.trace("searching for words " + words + " in " + scope2);
        }
        Computable query3 = () -> {
            List queries = ContainerUtil.flatMap(Arrays.asList(textIndexQueries), q -> q.toFileBasedIndexQueries());
            return FileBasedIndex.getInstance().processFilesContainingAllKeys((Collection)queries, scope2, processor2);
        };
        if (FileBasedIndex.isIndexAccessDuringDumbModeEnabled()) {
            if (ApplicationManager.getApplication().isReadAccessAllowed() && (!DumbService.isDumb((Project)project) || FileBasedIndex.getInstance().getCurrentDumbModeAccessType() != null)) {
                return (Boolean)query3.compute();
            }
            return (Boolean)ReadAction.compute(() -> (Boolean)DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE.ignoreDumbMode(() -> (Boolean)query3.compute()));
        }
        return (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(query3);
    }

    private static /* synthetic */ List lambda$computePriorities$6(Set allFiles, GlobalSearchScope directoryNearTargetScope, List targets2) throws RuntimeException {
        return ContainerUtil.filter((Collection)allFiles, f -> directoryNearTargetScope.contains(f) && !targets2.contains(f));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 12: 
            case 24: 
            case 28: 
            case 39: 
            case 51: 
            case 73: 
            case 96: 
            case 99: 
            case 100: 
            case 111: 
            case 122: 
            case 124: 
            case 137: 
            case 138: 
            case 139: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 12: 
            case 24: 
            case 28: 
            case 39: 
            case 51: 
            case 73: 
            case 96: 
            case 99: 
            case 100: 
            case 111: 
            case 122: 
            case 124: 
            case 137: 
            case 138: 
            case 139: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 12: 
            case 24: 
            case 28: 
            case 39: 
            case 51: 
            case 73: 
            case 96: 
            case 99: 
            case 100: 
            case 111: 
            case 122: 
            case 124: 
            case 137: 
            case 138: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/PsiSearchHelperImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optimizers";
                break;
            }
            case 9: 
            case 55: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 26: 
            case 29: 
            case 34: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 15: 
            case 16: 
            case 19: 
            case 25: 
            case 33: 
            case 38: 
            case 42: 
            case 47: 
            case 68: 
            case 71: 
            case 75: 
            case 78: 
            case 82: 
            case 85: 
            case 88: 
            case 91: 
            case 93: 
            case 95: 
            case 132: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 18: 
            case 21: 
            case 27: 
            case 30: 
            case 35: 
            case 64: 
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 23: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 32: 
            case 37: 
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 40: 
            case 43: 
            case 48: 
            case 63: 
            case 66: 
            case 69: 
            case 81: 
            case 84: 
            case 87: 
            case 90: 
            case 136: 
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 41: 
            case 44: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searcher";
                break;
            }
            case 46: 
            case 53: 
            case 57: 
            case 97: 
            case 102: 
            case 105: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 54: 
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localProcessor";
                break;
            }
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopped";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfile";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 72: 
            case 80: 
            case 83: 
            case 86: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 74: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialScope";
                break;
            }
            case 92: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 98: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectors";
                break;
            }
            case 101: 
            case 104: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singles";
                break;
            }
            case 103: 
            case 106: 
            case 107: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localProcessors";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateFiles";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allWords";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singleRequest";
                break;
            }
            case 113: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFiles";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nearDirectoryFiles";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerNameFiles";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restFiles";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonScope";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locals";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globals";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customs";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitive";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "single";
                break;
            }
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textIndexQueries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "restrictScope";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findCommentsContainingIdentifier";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "makeOptions";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "processElementsWithWordAsync";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateIndicator";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "computePriorities";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesWithPlainTextWords";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "processRequestsAsync";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "appendCollectorsFromQueryRequests";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "matchContextCondition";
                break;
            }
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteScopes";
                break;
            }
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "isCheapEnoughToSearch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUseScope";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCodeUsageScope";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 12: 
            case 24: 
            case 28: 
            case 39: 
            case 51: 
            case 73: 
            case 96: 
            case 99: 
            case 100: 
            case 111: 
            case 122: 
            case 124: 
            case 137: 
            case 138: 
            case 139: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "restrictScope";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findCommentsContainingIdentifier";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processCommentsContainingIdentifier";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithWord";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "hasIdentifierInFile";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithWordAsync";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "bulkProcessElementsWithWord";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessInjectedPsi";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "localProcessor";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithTextInGlobalScope";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "computePriorities";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "processPsiFileRoots";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "processFilesConcurrentlyDespiteWriteActions";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "processVirtualFile";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithText";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "processCandidateFilesForText";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "findFilesWithPlainTextWords";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "processUsagesInNonJavaFiles";
                break;
            }
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWord";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWordInText";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWordInComments";
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWordInLiterals";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "processRequests";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "processRequestsAsync";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "appendCollectorsFromQueryRequests";
                break;
            }
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalRequestsOptimized";
                break;
            }
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalRequests";
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "processCandidates";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "adaptProcessor";
                break;
            }
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "collectFiles";
                break;
            }
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "intersectionWithContainerNameFiles";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "uniteScopes";
                break;
            }
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "distributePrimitives";
                break;
            }
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "registerRequest";
                break;
            }
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "processSingleRequest";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "isCheapEnoughToSearch";
                break;
            }
            case 140: 
            case 141: 
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAllKeys";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 12: 
            case 24: 
            case 28: 
            case 39: 
            case 51: 
            case 73: 
            case 96: 
            case 99: 
            case 100: 
            case 111: 
            case 122: 
            case 124: 
            case 137: 
            case 138: 
            case 139: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public static final class TextIndexQuery {
        @NotNull
        private final Set<IdIndexEntry> myIdIndexEntries;
        @NotNull
        private final Set<Integer> myTrigrams;
        @Nullable
        private final Short myContext;
        private final boolean myUseOnlyWeakHashToSearch;
        @NotNull
        private final Collection<String> myInitialWords;

        private TextIndexQuery(@NotNull Set<IdIndexEntry> idIndexEntries, @NotNull Set<Integer> trigrams, @Nullable Short context2, boolean useOnlyWeakHashToSearch, @NotNull Collection<String> initialWords) {
            if (idIndexEntries == null) {
                TextIndexQuery.$$$reportNull$$$0(0);
            }
            if (trigrams == null) {
                TextIndexQuery.$$$reportNull$$$0(1);
            }
            if (initialWords == null) {
                TextIndexQuery.$$$reportNull$$$0(2);
            }
            this.myIdIndexEntries = idIndexEntries;
            this.myTrigrams = trigrams;
            this.myContext = context2;
            this.myUseOnlyWeakHashToSearch = useOnlyWeakHashToSearch;
            this.myInitialWords = initialWords;
        }

        @NotNull
        Collection<String> getInitialWords() {
            Collection<String> collection = this.myInitialWords;
            if (collection == null) {
                TextIndexQuery.$$$reportNull$$$0(3);
            }
            return collection;
        }

        public boolean isEmpty() {
            return this.myIdIndexEntries.isEmpty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextIndexQuery query2 = (TextIndexQuery)o;
            return this.myIdIndexEntries.equals(query2.myIdIndexEntries) && this.myTrigrams.equals(query2.myTrigrams) && Objects.equals(this.myContext, query2.myContext);
        }

        public int hashCode() {
            return Objects.hash(this.myIdIndexEntries, this.myTrigrams, this.myContext);
        }

        @NotNull
        public List<FileBasedIndex.AllKeysQuery<?, ?>> toFileBasedIndexQueries() {
            Condition<Integer> contextCondition = this.myContext == null ? null : PsiSearchHelperImpl.matchContextCondition(this.myContext);
            FileBasedIndex.AllKeysQuery idIndexQuery = new FileBasedIndex.AllKeysQuery(IdIndex.NAME, this.myIdIndexEntries, contextCondition);
            if (this.myUseOnlyWeakHashToSearch || this.myTrigrams.isEmpty()) {
                List<FileBasedIndex.AllKeysQuery<?, ?>> list2 = Collections.singletonList(idIndexQuery);
                if (list2 == null) {
                    TextIndexQuery.$$$reportNull$$$0(4);
                }
                return list2;
            }
            FileBasedIndex.AllKeysQuery trigramIndexQuery = new FileBasedIndex.AllKeysQuery(TrigramIndex.INDEX_ID, this.myTrigrams, null);
            List<FileBasedIndex.AllKeysQuery<?, ?>> list3 = Arrays.asList(idIndexQuery, trigramIndexQuery);
            if (list3 == null) {
                TextIndexQuery.$$$reportNull$$$0(5);
            }
            return list3;
        }

        @NotNull
        private static TextIndexQuery fromWord(@NotNull String word, boolean caseSensitively, boolean useOnlyWeakHashToSearch, @Nullable Short context2) {
            if (word == null) {
                TextIndexQuery.$$$reportNull$$$0(6);
            }
            return TextIndexQuery.fromWords(Collections.singleton(word), caseSensitively, useOnlyWeakHashToSearch, context2);
        }

        @NotNull
        public static TextIndexQuery fromWord(@NotNull String word, boolean caseSensitively, @Nullable Short context2) {
            if (word == null) {
                TextIndexQuery.$$$reportNull$$$0(7);
            }
            return TextIndexQuery.fromWord(word, caseSensitively, false, context2);
        }

        @NotNull
        public static TextIndexQuery fromWords(@NotNull Collection<String> words, boolean caseSensitively, boolean useOnlyWeakHashToSearch, @Nullable Short context2) {
            if (words == null) {
                TextIndexQuery.$$$reportNull$$$0(8);
            }
            Set keys2 = CollectionFactory.createSmallMemoryFootprintSet((Collection)ContainerUtil.flatMap(words, w -> TextIndexQuery.getWordEntries(w, caseSensitively)));
            IntOpenHashSet trigrams = new IntOpenHashSet();
            if (!useOnlyWeakHashToSearch) {
                for (String word : words) {
                    TrigramBuilder.processTrigrams((CharSequence)word, (TrigramBuilder.TrigramProcessor)new TrigramBuilder.TrigramProcessor((Set)trigrams){
                        final /* synthetic */ Set val$trigrams;
                        {
                            this.val$trigrams = set2;
                        }

                        public boolean test(int value2) {
                            this.val$trigrams.add(value2);
                            return true;
                        }
                    });
                }
            }
            return new TextIndexQuery(keys2, (Set<Integer>)trigrams, context2, useOnlyWeakHashToSearch, words);
        }

        @NotNull
        private static List<IdIndexEntry> getWordEntries(@NotNull String name2, boolean caseSensitively) {
            String trimmed;
            List<String> words;
            if (name2 == null) {
                TextIndexQuery.$$$reportNull$$$0(9);
            }
            if ((words = StringUtil.getWordsInStringLongestFirst((String)name2)).isEmpty() && StringUtil.isNotEmpty((String)(trimmed = name2.trim()))) {
                words = Collections.singletonList(trimmed);
            }
            if (words.isEmpty()) {
                List<IdIndexEntry> list2 = Collections.emptyList();
                if (list2 == null) {
                    TextIndexQuery.$$$reportNull$$$0(10);
                }
                return list2;
            }
            List list3 = ContainerUtil.map2List((Collection)words, word -> new IdIndexEntry((String)word, caseSensitively));
            if (list3 == null) {
                TextIndexQuery.$$$reportNull$$$0(11);
            }
            return list3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "idIndexEntries";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trigrams";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialWords";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$TextIndexQuery";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "word";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "words";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$TextIndexQuery";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInitialWords";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toFileBasedIndexQueries";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWordEntries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 10: 
                case 11: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "fromWord";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "fromWords";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getWordEntries";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum QueryRequestsRunResult {
        STOPPED,
        UNCHANGED,
        CHANGED;

    }

    private static final class RequestWithProcessor
    implements WordRequestInfo {
        @NotNull
        private final PsiSearchRequest request;
        @NotNull
        private Processor<? super PsiReference> refProcessor;

        private RequestWithProcessor(@NotNull PsiSearchRequest request2, @NotNull Processor<? super PsiReference> processor2) {
            if (request2 == null) {
                RequestWithProcessor.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                RequestWithProcessor.$$$reportNull$$$0(1);
            }
            this.request = request2;
            this.refProcessor = processor2;
        }

        private boolean uniteWith(@NotNull RequestWithProcessor another) {
            if (another == null) {
                RequestWithProcessor.$$$reportNull$$$0(2);
            }
            if (this.request.equals((Object)another.request)) {
                Processor<? super PsiReference> myProcessor = this.refProcessor;
                if (myProcessor != another.refProcessor) {
                    this.refProcessor = psiReference -> myProcessor.process(psiReference) && another.refProcessor.process(psiReference);
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return this.request.toString();
        }

        @Override
        @NotNull
        public String getWord() {
            String string = this.request.word;
            if (string == null) {
                RequestWithProcessor.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public SearchScope getSearchScope() {
            SearchScope searchScope2 = this.request.searchScope;
            if (searchScope2 == null) {
                RequestWithProcessor.$$$reportNull$$$0(4);
            }
            return searchScope2;
        }

        @Override
        public short getSearchContext() {
            return this.request.searchContext;
        }

        @Override
        public boolean isCaseSensitive() {
            return this.request.caseSensitive;
        }

        @Override
        @NotNull
        public SearchSession getSearchSession() {
            SearchSession searchSession = this.request.getSearchSession();
            if (searchSession == null) {
                RequestWithProcessor.$$$reportNull$$$0(5);
            }
            return searchSession;
        }

        @Override
        @Nullable
        public String getContainerName() {
            return this.request.containerName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "another";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$RequestWithProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$RequestWithProcessor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWord";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSearchScope";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSearchSession";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Options {
        PROCESS_INJECTED_PSI,
        CASE_SENSITIVE_SEARCH,
        PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE;

    }
}

