/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.json;

import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertiesUtil;
import com.intellij.application.options.codeStyle.properties.GeneralCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.LanguageCodeStylePropertyMapper;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CodeStyleSchemeJsonDescriptor {
    public static final String VERSION = "1.0";
    private final transient CodeStyleScheme myScheme;
    private final transient List<String> myLangDomainIds;
    public final String schemeName;
    public final String version = "1.0";
    public PropertyListHolder codeStyle;

    CodeStyleSchemeJsonDescriptor(CodeStyleScheme scheme2, List<String> ids) {
        this.myScheme = scheme2;
        this.schemeName = scheme2.getName();
        this.myLangDomainIds = ids;
        this.codeStyle = this.getPropertyListHolder();
    }

    private PropertyListHolder getPropertyListHolder() {
        PropertyListHolder holder = new PropertyListHolder();
        CodeStylePropertiesUtil.collectMappers((CodeStyleSettings)this.myScheme.getCodeStyleSettings(), mapper2 -> {
            if (this.myLangDomainIds == null || this.myLangDomainIds.contains(mapper2.getLanguageDomainId())) {
                holder.add(mapper2);
            }
        });
        holder.sort((m1, m2) -> {
            int result2 = Comparing.compare((Comparable)CodeStyleSchemeJsonDescriptor.getPriority(m1), (Comparable)CodeStyleSchemeJsonDescriptor.getPriority(m2));
            if (result2 == 0) {
                return Comparing.compare((Comparable)((Object)m1.getLanguageDomainId()), (Comparable)((Object)m2.getLanguageDomainId()));
            }
            return result2;
        });
        return holder;
    }

    private static DisplayPriority getPriority(@NotNull AbstractCodeStylePropertyMapper mapper2) {
        Language language2;
        LanguageCodeStyleSettingsProvider provider2;
        if (mapper2 == null) {
            CodeStyleSchemeJsonDescriptor.$$$reportNull$$$0(0);
        }
        if (mapper2 instanceof GeneralCodeStylePropertyMapper) {
            return DisplayPriority.GENERAL_SETTINGS;
        }
        if (mapper2 instanceof LanguageCodeStylePropertyMapper && (provider2 = LanguageCodeStyleSettingsProvider.forLanguage((Language)(language2 = ((LanguageCodeStylePropertyMapper)mapper2).getLanguage()))) != null) {
            return provider2.getDisplayPriority();
        }
        return DisplayPriority.OTHER_SETTINGS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/psi/impl/source/codeStyle/json/CodeStyleSchemeJsonDescriptor", "getPriority"));
    }

    static class PropertyListHolder
    extends ArrayList<AbstractCodeStylePropertyMapper> {
        PropertyListHolder() {
        }
    }
}

