/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.html;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.html.HtmlScriptInjectionBlockerExtension;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlScriptLanguageInjector
implements MultiHostInjector {
    @Nullable
    public static Language getScriptLanguageToInject(@NotNull XmlTag xmlTag) {
        Collection languages;
        if (xmlTag == null) {
            HtmlScriptLanguageInjector.$$$reportNull$$$0(0);
        }
        if (!HtmlUtil.isScriptTag(xmlTag)) {
            return null;
        }
        String mimeType = xmlTag.getAttributeValue("type");
        if (mimeType != null && mimeType.endsWith("+json")) {
            mimeType = "application/json";
        }
        return !(languages = Language.findInstancesByMimeType((String)mimeType)).isEmpty() ? (Language)languages.iterator().next() : Language.ANY;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            HtmlScriptLanguageInjector.$$$reportNull$$$0(1);
        }
        if (host == null) {
            HtmlScriptLanguageInjector.$$$reportNull$$$0(2);
        }
        if (!(host.isValid() && host instanceof XmlText && HtmlUtil.isHtmlTagContainingFile(host))) {
            return;
        }
        XmlTag scriptTag = ((XmlText)host).getParentTag();
        if (scriptTag == null) {
            return;
        }
        Language language2 = HtmlScriptLanguageInjector.getScriptLanguageToInject(scriptTag);
        if (language2 == null || HtmlScriptInjectionBlockerExtension.isInjectionBlocked(scriptTag, language2)) {
            return;
        }
        if (LanguageUtil.isInjectableLanguage((Language)language2)) {
            List elements = ContainerUtil.filter((Object[])host.getChildren(), child2 -> !(child2 instanceof OuterLanguageElement));
            if (elements.isEmpty()) {
                return;
            }
            registrar.startInjecting(language2);
            for (PsiElement child3 : elements) {
                registrar.addPlace(null, null, (PsiLanguageInjectionHost)host, child3.getTextRangeInParent());
            }
            registrar.doneInjecting();
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<XmlText>> list2 = Collections.singletonList(XmlText.class);
        if (list2 == null) {
            HtmlScriptLanguageInjector.$$$reportNull$$$0(3);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlTag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/html/HtmlScriptLanguageInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/html/HtmlScriptLanguageInjector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getScriptLanguageToInject";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

