/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.statistics.impl;

import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.psi.statistics.impl.WrongFormatException;
import com.intellij.util.io.IOUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class StatisticsUnit {
    private static final int FORMAT_VERSION_NUMBER = 6;
    private final int myNumber;
    private final Map<String, LinkedList<String>> myDataMap = new HashMap<String, LinkedList<String>>();
    private final Object2IntMap<String> myContextMaxStamps = new Object2IntOpenHashMap();
    private final Map<String, Object2IntMap<String>> myValueStamps = new HashMap<String, Object2IntMap<String>>();

    StatisticsUnit(int number) {
        this.myNumber = number;
    }

    int getRecency(String context2, String value2) {
        int stamp;
        Object2IntMap<String> perContext = this.myValueStamps.get(context2);
        int n = stamp = perContext == null ? -1 : perContext.getInt((Object)value2);
        if (stamp < 0) {
            return Integer.MAX_VALUE;
        }
        int diff = this.myContextMaxStamps.getInt((Object)context2) - stamp;
        return diff >= 10000 ? Integer.MAX_VALUE : diff;
    }

    public int getData(@NotNull String key1, @NotNull String key2) {
        List list2;
        if (key1 == null) {
            StatisticsUnit.$$$reportNull$$$0(0);
        }
        if (key2 == null) {
            StatisticsUnit.$$$reportNull$$$0(1);
        }
        if ((list2 = (List)this.myDataMap.get(key1)) == null) {
            return 0;
        }
        int result2 = 0;
        for (String s : list2) {
            if (!s.equals(key2)) continue;
            ++result2;
        }
        return result2;
    }

    public void incData(String key1, String key2) {
        LinkedList<String> list2 = this.myDataMap.get(key1);
        if (list2 == null) {
            list2 = new LinkedList();
            this.myDataMap.put(key1, list2);
        }
        list2.addFirst(key2);
        if (list2.size() > 7) {
            list2.removeLast();
        }
        this.advanceRecencyStamps(key1, key2);
    }

    private void advanceRecencyStamps(String context2, String value2) {
        int stamp = this.myContextMaxStamps.getInt((Object)context2) + 1;
        this.myContextMaxStamps.put((Object)context2, stamp);
        this.getValueStamps(context2).put((Object)value2, stamp);
        if (stamp > 20000) {
            this.trimAncientRecencyEntries(context2, 10000);
        }
    }

    @NotNull
    private Object2IntMap<String> getValueStamps(String context2) {
        Object2IntMap object2IntMap = this.myValueStamps.computeIfAbsent(context2, __ -> {
            Object2IntOpenHashMap result2 = new Object2IntOpenHashMap();
            result2.defaultReturnValue(-1);
            return result2;
        });
        if (object2IntMap == null) {
            StatisticsUnit.$$$reportNull$$$0(2);
        }
        return object2IntMap;
    }

    private void trimAncientRecencyEntries(String context2, int limit) {
        Object2IntOpenHashMap newStamps = new Object2IntOpenHashMap();
        newStamps.defaultReturnValue(-1);
        for (String o : this.getValueStamps(context2).keySet()) {
            int recency = this.getRecency(context2, o);
            if (recency == Integer.MAX_VALUE) continue;
            newStamps.put((Object)o, limit - recency);
        }
        this.myValueStamps.put(context2, (Object2IntMap<String>)newStamps);
        this.myContextMaxStamps.put((Object)context2, limit);
    }

    @NotNull
    Collection<String> getKeys2(@NotNull String key1) {
        List list2;
        if (key1 == null) {
            StatisticsUnit.$$$reportNull$$$0(3);
        }
        return (list2 = (List)this.myDataMap.get(key1)) == null ? Collections.emptyList() : new LinkedHashSet(list2);
    }

    int getNumber() {
        return this.myNumber;
    }

    void write(OutputStream out) throws IOException {
        DataOutputStream dataOut = new DataOutputStream(out);
        dataOut.writeInt(6);
        DataInputOutputUtilRt.writeSeq((DataOutput)dataOut, this.myDataMap.entrySet(), entry2 -> {
            IOUtil.writeUTF((DataOutput)dataOut, (String)((String)entry2.getKey()));
            DataInputOutputUtilRt.writeSeq((DataOutput)dataOut, (Collection)((Collection)entry2.getValue()), data2 -> IOUtil.writeUTF((DataOutput)dataOut, (String)data2));
        });
        StatisticsUnit.writeStringIntMap(dataOut, this.myContextMaxStamps);
        DataInputOutputUtilRt.writeSeq((DataOutput)dataOut, this.myValueStamps.entrySet(), entry2 -> {
            IOUtil.writeUTF((DataOutput)dataOut, (String)((String)entry2.getKey()));
            StatisticsUnit.writeStringIntMap(dataOut, (Object2IntMap<String>)((Object2IntMap)entry2.getValue()));
        });
    }

    void read(InputStream in) throws IOException, WrongFormatException {
        this.myDataMap.clear();
        this.myContextMaxStamps.clear();
        this.myValueStamps.clear();
        DataInputStream dataIn = new DataInputStream(in);
        int formatVersion = dataIn.readInt();
        if (formatVersion != 6) {
            throw new WrongFormatException();
        }
        DataInputOutputUtilRt.readSeq((DataInput)dataIn, () -> {
            this.myDataMap.put(IOUtil.readUTF((DataInput)dataIn), new LinkedList(DataInputOutputUtilRt.readSeq((DataInput)dataIn, () -> IOUtil.readUTF((DataInput)dataIn))));
            return null;
        });
        StatisticsUnit.readStringIntMap(dataIn, this.myContextMaxStamps);
        DataInputOutputUtilRt.readSeq((DataInput)dataIn, () -> {
            Object2IntOpenHashMap map2 = new Object2IntOpenHashMap();
            map2.defaultReturnValue(-1);
            this.myValueStamps.put(IOUtil.readUTF((DataInput)dataIn), (Object2IntMap<String>)map2);
            StatisticsUnit.readStringIntMap(dataIn, (Object2IntMap<String>)map2);
            return null;
        });
    }

    private static void writeStringIntMap(DataOutput dataOut, Object2IntMap<String> map2) throws IOException {
        DataInputOutputUtilRt.writeINT((DataOutput)dataOut, (int)map2.size());
        for (String context2 : map2.keySet()) {
            IOUtil.writeUTF((DataOutput)dataOut, (String)context2);
            DataInputOutputUtilRt.writeINT((DataOutput)dataOut, (int)map2.getInt((Object)context2));
        }
    }

    private static void readStringIntMap(DataInput dataIn, Object2IntMap<String> map2) throws IOException {
        int count = DataInputOutputUtilRt.readINT((DataInput)dataIn);
        for (int i2 = 0; i2 < count; ++i2) {
            map2.put((Object)IOUtil.readUTF((DataInput)dataIn), DataInputOutputUtilRt.readINT((DataInput)dataIn));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/statistics/impl/StatisticsUnit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/statistics/impl/StatisticsUnit";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueStamps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getKeys2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

