/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.BooleanStack;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance(DefaultStubBuilder.class);

    public StubElement buildStubTree(@NotNull PsiFile file2) {
        if (file2 == null) {
            DefaultStubBuilder.$$$reportNull$$$0(0);
        }
        return this.buildStubTreeFor((ASTNode)file2.getNode(), this.createStubForFile(file2));
    }

    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file2) {
        PsiFileStubImpl<PsiFile> stub;
        if (file2 == null) {
            DefaultStubBuilder.$$$reportNull$$$0(1);
        }
        PsiFileStubImpl<PsiFile> psiFileStubImpl = stub = new PsiFileStubImpl<PsiFile>(file2);
        if (psiFileStubImpl == null) {
            DefaultStubBuilder.$$$reportNull$$$0(2);
        }
        return psiFileStubImpl;
    }

    @NotNull
    protected final StubElement buildStubTreeFor(@NotNull ASTNode root2, @NotNull StubElement parentStub) {
        if (root2 == null) {
            DefaultStubBuilder.$$$reportNull$$$0(3);
        }
        if (parentStub == null) {
            DefaultStubBuilder.$$$reportNull$$$0(4);
        }
        new StubBuildingWalkingVisitor(root2, parentStub).buildStubTree();
        StubElement stubElement = parentStub;
        if (stubElement == null) {
            DefaultStubBuilder.$$$reportNull$$$0(5);
        }
        return stubElement;
    }

    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node2) {
        if (parent == null) {
            DefaultStubBuilder.$$$reportNull$$$0(6);
        }
        if (node2 == null) {
            DefaultStubBuilder.$$$reportNull$$$0(7);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/DefaultStubBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/DefaultStubBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStubForFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildStubTreeFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createStubForFile";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTreeFor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "skipChildProcessingWhenBuildingStubs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class StubBuildingWalkingVisitor {
        private final Stack<StubElement> parentStubs = new Stack();
        private final Stack<ASTNode> parentNodes = new Stack();
        private final BooleanStack parentNodesStubbed = new BooleanStack();

        protected StubBuildingWalkingVisitor(ASTNode root2, StubElement parentStub) {
            this.parentNodes.push((Object)root2);
            this.parentStubs.push((Object)parentStub);
            this.parentNodesStubbed.push(true);
        }

        public final void buildStubTree() {
            while (!this.parentStubs.isEmpty()) {
                this.visitNode((StubElement)this.parentStubs.pop(), (ASTNode)this.parentNodes.pop(), this.parentNodesStubbed.pop());
            }
        }

        protected void visitNode(StubElement parentStub, ASTNode node2, boolean immediateParentStubbed) {
            StubElement stub = this.createStub(parentStub, node2);
            if (stub != null && !immediateParentStubbed) {
                ((ObjectStubBase)stub).markDangling();
            }
            this.pushChildren(node2, node2 instanceof FileElement || stub != null, stub != null ? stub : parentStub);
        }

        @Nullable
        protected final ASTNode peekNextElement() {
            return this.parentNodes.isEmpty() ? null : (ASTNode)this.parentNodes.peek();
        }

        @Nullable
        protected StubElement createStub(StubElement parentStub, ASTNode node2) {
            IStubElementType type;
            IElementType nodeType = node2.getElementType();
            if (nodeType instanceof IStubElementType && (type = (IStubElementType)nodeType).shouldCreateStub(node2)) {
                PsiElement element2 = node2.getPsi();
                if (!(element2 instanceof StubBasedPsiElement)) {
                    LOG.error("Non-StubBasedPsiElement requests stub creation. Stub type: " + type + ", PSI: " + element2 + ", language: #" + type.getLanguage());
                }
                StubElement stub = type.createStub(element2, parentStub);
                LOG.assertTrue(stub != null, (Object)element2);
                return stub;
            }
            return null;
        }

        private void pushChildren(ASTNode node2, boolean hasStub, StubElement stub) {
            for (ASTNode childNode = node2.getLastChildNode(); childNode != null; childNode = childNode.getTreePrev()) {
                if (DefaultStubBuilder.this.skipChildProcessingWhenBuildingStubs(node2, childNode)) continue;
                this.parentNodes.push((Object)childNode);
                this.parentStubs.push((Object)stub);
                this.parentNodesStubbed.push(hasStub);
            }
        }
    }
}

